/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.client;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import org.netbeans.modules.tasklist.client.SuggestionAgent;
import org.netbeans.modules.tasklist.client.SuggestionPerformer;
import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;

public abstract class Suggestion {
    SuggestionAgent agent;
    private final PropertyChangeSupport supp = new PropertyChangeSupport(this);
    public static final String PROP_SUMMARY = "summary";
    public static final String PROP_ICON = "icon";
    public static final String PROP_DETAILS = "details";
    public static final String PROP_PRIORITY = "priority";
    public static final String PROP_VALID = "valid";
    private boolean valid;
    private Image icon = null;
    private String summary = null;
    private String details = null;
    private SuggestionPriority priority = SuggestionPriority.MEDIUM;
    private String type = null;
    private Line line = null;
    private SuggestionPerformer action = null;
    private FileObject fo;

    protected Suggestion(FileObject fo, String type, String summary, SuggestionPerformer action) {
        this.fo = fo;
        this.type = type;
        this.summary = summary;
        this.action = action;
        this.valid = true;
    }

    public FileObject getFileObject() {
        return this.fo;
    }

    protected void setFileObject(FileObject fo) {
        this.fo = fo;
    }

    protected void setSummary(String summary) {
        if (summary == null) {
            throw new NullPointerException();
        }
        String old = this.getSummary();
        if (old.equals(summary)) {
            return;
        }
        this.summary = summary;
        this.firePropertyChange(PROP_SUMMARY, old, summary);
    }

    public String getSummary() {
        if (this.summary == null) {
            this.summary = "";
        }
        return this.summary;
    }

    protected void setDetails(String details) {
        String old = this.getDetails();
        if (old.equals(details)) {
            return;
        }
        this.details = details;
        this.firePropertyChange(PROP_DETAILS, old, details);
    }

    public String getDetails() {
        if (this.details == null) {
            this.details = "";
        }
        return this.details;
    }

    protected void setPriority(SuggestionPriority priority) {
        SuggestionPriority old = this.getPriority();
        if (old == priority) {
            return;
        }
        this.priority = priority;
        this.firePropertyChange(PROP_PRIORITY, old, priority);
    }

    public SuggestionPriority getPriority() {
        return this.priority;
    }

    protected void setIcon(Image icon) {
        Image old = this.getIcon();
        if (old == icon) {
            return;
        }
        this.icon = icon;
        this.firePropertyChange(PROP_ICON, old, icon);
    }

    public Image getIcon() {
        return this.icon;
    }

    protected void setLine(Line line) {
        this.line = line;
    }

    public Line getLine() {
        return this.line;
    }

    protected final void setAction(SuggestionPerformer action) {
        this.action = action;
    }

    public SuggestionPerformer getAction() {
        return this.action;
    }

    protected void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public abstract Object getSeed();

    public boolean isValid() {
        return this.valid;
    }

    void invalidate() {
        if (!this.valid) {
            return;
        }
        this.valid = false;
        this.supp.firePropertyChange(PROP_VALID, true, false);
    }

    public final void addPropertyChangeListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
        this.supp.addPropertyChangeListener(l);
    }

    public final void removePropertyChangeListener(PropertyChangeListener l) {
        this.supp.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.supp.firePropertyChange(propertyName, oldValue, newValue);
    }
}

