/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.nbbuild;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class Arch
extends Task
implements ErrorHandler,
EntityResolver,
URIResolver {
    private Map answers;
    private Map questions;
    private SAXParseException parseException;
    private File questionsFile;
    private File output;
    private String stylesheet = null;
    private String overviewlink = null;
    private String footer = null;
    private File xsl = null;
    private File apichanges = null;
    private File project = null;
    private static Map publicIds = new HashMap();

    public void setAnswers(File f) {
        this.questionsFile = f;
    }

    public void setOutput(File f) {
        this.output = f;
    }

    public void setStylesheet(String s) {
        this.stylesheet = s;
    }

    public void setOverviewlink(String s) {
        this.overviewlink = s;
    }

    public void setFooter(String s) {
        this.footer = s;
    }

    public void setXSL(File xsl) {
        this.xsl = xsl;
    }

    public void setApichanges(File apichanges) {
        this.apichanges = apichanges;
    }

    public void setProject(File x) {
        this.project = x;
    }

    public void execute() throws BuildException {
        TreeSet s;
        Source qSource;
        Document q;
        DocumentBuilder builder;
        boolean generateTemplate;
        if (this.questionsFile == null) {
            throw new BuildException("questions file must be provided");
        }
        if (this.output == null) {
            throw new BuildException("output file must be specified");
        }
        boolean bl = generateTemplate = !this.questionsFile.exists();
        if (!generateTemplate && this.output.exists() && this.questionsFile.lastModified() <= this.output.lastModified() && this.getProject().getProperty("arch.generate") == null) {
            return;
        }
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(!generateTemplate && !"true".equals(this.getProject().getProperty("arch.private.disable.validation.for.test.purposes")));
            builder = factory.newDocumentBuilder();
            builder.setErrorHandler(this);
            builder.setEntityResolver(this);
            if (generateTemplate) {
                q = builder.parse(this.getClass().getResourceAsStream("Arch-api-questions.xml"));
                qSource = new DOMSource(q);
            } else {
                q = builder.parse(this.questionsFile);
                qSource = new DOMSource(q);
            }
            if (this.parseException != null) {
                throw this.parseException;
            }
        }
        catch (SAXParseException ex) {
            this.log(ex.getSystemId() + ":" + ex.getLineNumber() + ": " + ex.getLocalizedMessage(), 0);
            throw new BuildException(this.questionsFile.getAbsolutePath() + " is malformed or invalid", (Throwable)ex, this.getLocation());
        }
        catch (Exception ex) {
            throw new BuildException("File " + this.questionsFile + " cannot be parsed: " + ex.getLocalizedMessage(), (Throwable)ex, this.getLocation());
        }
        this.questions = Arch.readElements(q, "question");
        NodeList apiQuestions = q.getElementsByTagName("api-questions");
        if (apiQuestions.getLength() != 1) {
            throw new BuildException("No element api-questions");
        }
        String questionsVersion = ((Element)apiQuestions.item(0)).getAttribute("version");
        if (questionsVersion == null) {
            throw new BuildException("Element api-questions does not have attribute version");
        }
        if (this.questions.size() == 0) {
            throw new BuildException("There are no <question> elements in the file!");
        }
        if (generateTemplate) {
            this.log("Input file " + this.questionsFile + " does not exist. Generating it with skeleton answers.");
            try {
                s = new TreeSet(this.questions.keySet());
                this.generateTemplateFile(questionsVersion, s);
            }
            catch (IOException ex) {
                throw new BuildException((Throwable)ex);
            }
            return;
        }
        this.answers = Arch.readElements(q, "answer");
        NodeList apiAnswers = q.getElementsByTagName("api-answers");
        if (apiAnswers.getLength() != 1) {
            throw new BuildException("No element api-answers");
        }
        String answersVersion = ((Element)apiAnswers.item(0)).getAttribute("question-version");
        if (answersVersion == null) {
            throw new BuildException("Element api-answers does not have attribute question-version");
        }
        if (!answersVersion.equals(questionsVersion)) {
            String msg = this.questionsFile.getAbsolutePath() + ": answers were created for questions version \"" + answersVersion + "\" but current version of questions is \"" + questionsVersion + "\"";
            if ("false".equals(this.getProject().getProperty("arch.warn"))) {
                throw new BuildException(msg);
            }
            this.log(msg, 1);
        }
        s = new TreeSet(this.questions.keySet());
        s.removeAll(this.answers.keySet());
        if (!s.isEmpty()) {
            if ("true".equals(this.getProject().getProperty("arch.generate"))) {
                this.log("Missing answers to questions: " + s);
                this.log("Generating the answers to end of file " + this.questionsFile);
                try {
                    this.generateMissingQuestions(s);
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
                qSource = new StreamSource(this.questionsFile);
                try {
                    q = builder.parse(this.questionsFile);
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
                catch (SAXException ex) {
                    throw new BuildException((Throwable)ex);
                }
            }
            this.log(this.questionsFile.getAbsolutePath() + ": some questions have not been answered: " + s + "\n" + "Run with -Darch.generate=true to add missing questions into the end of question file", 1);
        }
        if (this.apichanges != null) {
            Document api;
            this.log("Reading apichanges from " + this.apichanges);
            try {
                api = builder.parse(this.apichanges);
            }
            catch (SAXParseException ex) {
                this.log(ex.getSystemId() + ":" + ex.getLineNumber() + ": " + ex.getLocalizedMessage(), 0);
                throw new BuildException(this.apichanges.getAbsolutePath() + " is malformed or invalid", (Throwable)ex, this.getLocation());
            }
            catch (Exception ex) {
                throw new BuildException("File " + this.apichanges + " cannot be parsed: " + ex.getLocalizedMessage(), (Throwable)ex, this.getLocation());
            }
            NodeList node = api.getElementsByTagName("apichanges");
            if (node.getLength() != 1) {
                throw new BuildException("Expected one element <apichanges/> in " + this.apichanges + "but was: " + node.getLength());
            }
            Node n = node.item(0);
            Node el = q.getElementsByTagName("api-answers").item(0);
            el.appendChild(q.importNode(n, true));
            qSource = new DOMSource(q);
            qSource.setSystemId(this.questionsFile.toURI().toString());
        }
        if (this.project != null) {
            Document prj;
            this.log("Reading project from " + this.project);
            try {
                DocumentBuilderFactory fack = DocumentBuilderFactory.newInstance();
                fack.setNamespaceAware(false);
                prj = fack.newDocumentBuilder().parse(this.project);
            }
            catch (SAXParseException ex) {
                this.log(ex.getSystemId() + ":" + ex.getLineNumber() + ": " + ex.getLocalizedMessage(), 0);
                throw new BuildException(this.project.getAbsolutePath() + " is malformed or invalid", (Throwable)ex, this.getLocation());
            }
            catch (Exception ex) {
                throw new BuildException("File " + this.project + " cannot be parsed: " + ex.getLocalizedMessage(), (Throwable)ex, this.getLocation());
            }
            NodeList deps = prj.getElementsByTagName("code-name-base");
            for (int i = 0; i < deps.getLength(); ++i) {
                String category;
                Node name = deps.item(i);
                String api = name.getChildNodes().item(0).getNodeValue();
                String human = this.getProject().getProperty("arch." + api + ".name");
                if (human != null) {
                    if (human.equals("")) {
                        throw new BuildException("Empty name for " + api + " from " + this.project);
                    }
                    Element e = prj.createElement("api-name");
                    e.appendChild(prj.createTextNode(human));
                    name.getParentNode().insertBefore(e, name);
                }
                if ((category = this.getProject().getProperty("arch." + api + ".category")) == null) continue;
                if (category.equals("")) {
                    throw new BuildException("Empty category for " + api + " from " + this.project);
                }
                Element e = prj.createElement("api-category");
                e.appendChild(prj.createTextNode(category));
                name.getParentNode().insertBefore(e, name);
            }
            File f = this.project;
            StringBuffer sb = new StringBuffer();
            String sep = "";
            while (!new File(f, "nbbuild").isDirectory()) {
                if (f.isDirectory() && !"nbproject".equals(f.getName())) {
                    sb.insert(0, sep);
                    sep = "/";
                    sb.insert(0, f.getName());
                }
                if ((f = f.getParentFile()) != null) continue;
                sb.setLength(0);
                break;
            }
            Element el = prj.createElement("cvs-location");
            el.appendChild(prj.createTextNode(sb.toString()));
            prj.getDocumentElement().appendChild(el);
            DOMSource prjSrc = new DOMSource(prj);
            NodeList node = prj.getElementsByTagName("project");
            if (node.getLength() != 1) {
                throw new BuildException("Expected one element <project/> in " + this.project + "but was: " + node.getLength());
            }
            NodeList list = q.getElementsByTagName("answer");
            for (int i = 0; i < list.getLength(); ++i) {
                Node n = list.item(i);
                String id = n.getAttributes().getNamedItem("id").getNodeValue();
                URL u = Arch.class.getResource("Arch-default-" + id + ".xsl");
                if (u == null) continue;
                this.log("Found default answer to " + id + " question", 3);
                Node defaultAnswer = Arch.findDefaultAnswer(n);
                if (defaultAnswer != null && "none".equals(defaultAnswer.getAttributes().getNamedItem("generate").getNodeValue())) {
                    this.log("Skipping answer as there is <defaultanswer generate='none'", 3);
                    continue;
                }
                DOMResult res = new DOMResult(q.createElement("p"));
                try {
                    StreamSource defXSL = new StreamSource(u.openStream());
                    TransformerFactory fack = TransformerFactory.newInstance();
                    Transformer t = fack.newTransformer(defXSL);
                    t.transform(prjSrc, res);
                }
                catch (IOException ex) {
                    throw new BuildException((Throwable)ex);
                }
                catch (TransformerException ex) {
                    throw new BuildException((Throwable)ex);
                }
                if (defaultAnswer != null) {
                    this.log("Replacing default answer", 3);
                    defaultAnswer.getParentNode().replaceChild(res.getNode(), defaultAnswer);
                    continue;
                }
                this.log("Adding default answer to the end of previous one", 3);
                Element para = q.createElement("p");
                para.appendChild(q.createTextNode("Default answer to this question is:"));
                para.appendChild(q.createComment("If you do not want default answer to be generated you can use <defaultanswer generate='none' /> here"));
                para.appendChild(q.createElement("br"));
                para.appendChild(res.getNode());
                n.appendChild(para);
            }
            qSource = new DOMSource(q);
            qSource.setSystemId(this.questionsFile.toURI().toString());
        }
        try {
            String archPref;
            StreamSource ss;
            String file;
            String string = file = this.xsl != null ? this.xsl.toString() : this.getProject().getProperty("arch.xsl");
            if (file != null) {
                this.log("Using " + file + " as the XSL stylesheet");
                ss = new StreamSource(file);
            } else {
                ss = new StreamSource(this.getClass().getResourceAsStream("Arch.xsl"));
            }
            this.log("Transforming " + this.questionsFile + " into " + this.output);
            TransformerFactory trans = TransformerFactory.newInstance();
            trans.setURIResolver(this);
            Transformer t = trans.newTransformer(ss);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(this.output));
            StreamResult r = new StreamResult(os);
            if (this.stylesheet == null) {
                this.stylesheet = this.getProject().getProperty("arch.stylesheet");
            }
            if (this.stylesheet != null) {
                t.setParameter("arch.stylesheet", this.stylesheet);
            }
            if (this.overviewlink != null) {
                t.setParameter("arch.overviewlink", this.overviewlink);
            }
            if (this.footer != null) {
                t.setParameter("arch.footer", this.footer);
            }
            t.setParameter("arch.answers.date", DateFormat.getDateInstance().format(new Date(this.questionsFile.lastModified())));
            String archTarget = this.output.toString();
            int slash = archTarget.lastIndexOf(File.separatorChar);
            if (slash > 0) {
                archTarget = archTarget.substring(slash + 1);
            }
            if ((archPref = this.getProject().getProperty("arch.target")) != null) {
                archTarget = archPref + File.separatorChar + archTarget;
            }
            t.setParameter("arch.target", archTarget);
            String when = this.getProject().getProperty("arch.when");
            if (when != null) {
                t.setParameter("arch.when", when);
            }
            t.transform(qSource, r);
            ((OutputStream)os).close();
        }
        catch (IOException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (TransformerConfigurationException ex) {
            throw new BuildException((Throwable)ex);
        }
        catch (TransformerException ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void generateMissingQuestions(Set missing) throws IOException, BuildException {
        int len;
        StringBuffer sb = new StringBuffer();
        InputStreamReader is = new InputStreamReader(new FileInputStream(this.questionsFile.toString()));
        char[] arr = new char[4096];
        while ((len = is.read(arr)) != -1) {
            sb.append(arr, 0, len);
        }
        int indx = sb.indexOf("</api-answers>");
        if (indx == -1) {
            throw new BuildException("There is no </api-answers> in " + this.questionsFile);
        }
        sb.delete(indx, indx + "</api-answers>".length());
        OutputStreamWriter w = new OutputStreamWriter(new FileOutputStream(this.questionsFile.toString()));
        w.write(sb.toString());
        this.writeQuestions(w, missing);
        w.write("</api-answers>\n");
        ((Writer)w).close();
    }

    private void writeQuestions(Writer w, Set missing) throws IOException {
        for (String s : missing) {
            Element n = (Element)this.questions.get(s);
            w.write("\n\n<!--\n        ");
            w.write(Arch.elementToString(n));
            w.write("\n-->\n");
            URL u = Arch.class.getResource("Arch-default-" + s + ".xsl");
            if (u != null) {
                w.write(" <answer id=\"" + s + "\">\n  <defaultanswer generate='here' />\n </answer>\n\n");
                continue;
            }
            w.write(" <answer id=\"" + s + "\">\n  <p>\n   XXX no answer for " + s + "\n  </p>\n </answer>\n\n");
        }
    }

    private static String findNbRoot(File f) {
        StringBuffer result = new StringBuffer();
        for (f = f.getParentFile(); f != null; f = f.getParentFile()) {
            File x = new File(f, "nbbuild" + File.separatorChar + "antsrc" + File.separatorChar + "org" + File.separatorChar + "netbeans" + File.separatorChar + "nbbuild" + File.separatorChar + "Arch.dtd");
            if (x.exists()) {
                return result.toString();
            }
            result.append("../");
        }
        return null;
    }

    private void generateTemplateFile(String versionOfQuestions, Set missing) throws IOException {
        String nbRoot = Arch.findNbRoot(this.questionsFile);
        if (nbRoot == null) {
            nbRoot = "http://www.netbeans.org/source/browse/~checkout~/";
        }
        FileWriter w = new FileWriter(this.questionsFile);
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- -*- sgml-indent-step: 1 -*- -->\n");
        w.write("<!--\n");
        w.write("The contents of this file are subject to the terms of the Common Development\n");
        w.write("and Distribution License (the License). You may not use this file except in\n");
        w.write("compliance with the License.\n");
        w.write("\n");
        w.write("You can obtain a copy of the License at http://www.netbeans.org/cddl.html\n");
        w.write("or http://www.netbeans.org/cddl.txt.\n");
        w.write("\n");
        w.write("When distributing Covered Code, include this CDDL Header Notice in each file\n");
        w.write("and include the License file at http://www.netbeans.org/cddl.txt.\n");
        w.write("If applicable, add the following below the CDDL Header, with the fields\n");
        w.write("enclosed by brackets [] replaced by your own identifying information:\n");
        w.write("\"Portions Copyrighted [year] [name of copyright owner]\"\n");
        w.write("\n");
        w.write("The Original Software is NetBeans. The Initial Developer of the Original\n");
        w.write("Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun\n");
        w.write("Microsystems, Inc. All Rights Reserved.\n");
        w.write("-->\n");
        w.write("<!DOCTYPE api-answers PUBLIC \"-//NetBeans//DTD Arch Answers//EN\" \"");
        w.write(nbRoot);
        w.write("nbbuild/antsrc/org/netbeans/nbbuild/Arch.dtd\" [\n");
        w.write("  <!ENTITY api-questions SYSTEM \"");
        w.write(nbRoot);
        w.write("nbbuild/antsrc/org/netbeans/nbbuild/Arch-api-questions.xml\">\n");
        w.write("]>\n");
        w.write("\n");
        w.write("<api-answers\n");
        w.write("  question-version=\"");
        w.write(versionOfQuestions);
        w.write("\"\n");
        w.write("  module=\"name of your module\"\n");
        w.write("  author=\"yourname@netbeans.org\"\n");
        w.write(">\n\n");
        w.write("  &api-questions;\n");
        this.writeQuestions(w, missing);
        w.write("</api-answers>\n");
        ((Writer)w).close();
    }

    private static HashMap readElements(Document q, String name) {
        HashMap<String, Node> map = new HashMap<String, Node>();
        NodeList list = q.getElementsByTagName(name);
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i).getAttributes().getNamedItem("id");
            if (n == null) {
                throw new BuildException("Question without id tag");
            }
            String id = n.getNodeValue();
            map.put(id, list.item(i));
        }
        return map;
    }

    public void error(SAXParseException exception) throws SAXException {
        if (this.parseException != null) {
            this.log(this.parseException.getSystemId() + ":" + this.parseException.getLineNumber() + ": " + this.parseException.getLocalizedMessage(), 0);
        }
        this.parseException = exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        if (exception.getLocalizedMessage().startsWith("Using original entity definition for")) {
            return;
        }
        this.log(exception.getSystemId() + ":" + exception.getLineNumber() + ": " + exception.getLocalizedMessage(), 1);
    }

    private static String elementToString(Element e) throws IOException {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "no");
            t.setOutputProperty("omit-xml-declaration", "yes");
            DOMSource source = new DOMSource(e);
            StringWriter w = new StringWriter();
            StreamResult result = new StreamResult(w);
            t.transform(source, result);
            return w.toString();
        }
        catch (Exception x) {
            throw (IOException)new IOException(x.toString()).initCause(x);
        }
    }

    private static Node findDefaultAnswer(Node n) {
        if (n.getNodeName().equals("defaultanswer")) {
            return n;
        }
        NodeList arr = n.getChildNodes();
        for (int i = 0; i < arr.getLength(); ++i) {
            Node found = Arch.findDefaultAnswer(arr.item(i));
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String replace;
        this.log("publicId: " + publicId + " systemId: " + systemId, 3);
        int idx = systemId.lastIndexOf(47);
        String last = systemId.substring(idx + 1);
        if (last.equals("xhtml1-strict.dtd")) {
            String dtd = "libs/external/dtds/xhtml1-20020801/DTD/xhtml1-strict.dtd".replace('/', File.separatorChar);
            for (File f = this.questionsFile.getParentFile(); f != null; f = f.getParentFile()) {
                File check = new File(f, dtd);
                if (!check.isFile()) continue;
                String r = check.toURI().toString();
                this.log("Replacing entity " + publicId + " at " + systemId + " with " + r);
                return new InputSource(r);
            }
        }
        if ((replace = (String)publicIds.get(last)) == null) {
            this.log("Not replacing id", 3);
            return null;
        }
        try {
            URL u = new URL(systemId);
            u.openStream();
            this.log("systemId " + systemId + " exists, leaving", 3);
            return null;
        }
        catch (IOException ex) {
            InputSource is;
            this.log("Replacing entity " + publicId + " at " + systemId + " with " + replace);
            if (replace.startsWith("http://")) {
                is = new InputSource(new URL(replace).openStream());
                is.setSystemId(replace);
            } else {
                is = new InputSource(Arch.class.getResourceAsStream(replace));
                is.setSystemId(replace);
            }
            return is;
        }
    }

    public Source resolve(String href, String base) throws TransformerException {
        return null;
    }

    static {
        publicIds.put("xhtml1-strict.dtd", "Arch-fake-xhtml.dtd");
        publicIds.put("Arch.dtd", "Arch.dtd");
        publicIds.put("Arch-api-questions.xml", "Arch-api-questions.xml");
    }
}

