/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.javacore.parser.ScopeMember;

public class MethodScope
implements ScopeMember {
    private MethodScope parentScope;
    private Map positiveCache;
    private Set negativeCache;
    private ArrayList members;

    MethodScope(MethodScope parent) {
        this.parentScope = parent;
        this.positiveCache = new HashMap();
        this.negativeCache = new HashSet();
        this.members = new ArrayList();
    }

    public Object lookup(Object key) {
        Object val = this.positiveCache.get(key);
        Object valParent = null;
        if (val != null) {
            return val;
        }
        if (this.negativeCache.contains(key)) {
            return null;
        }
        val = this.lookupMembers(key);
        if (this.parentScope != null) {
            valParent = this.parentScope.lookup(key);
        }
        if ((val = this.combine(val, valParent)) != null) {
            this.positiveCache.put(key, val);
        } else {
            this.negativeCache.add(key);
        }
        return val;
    }

    void addMember(ScopeMember member) {
        this.positiveCache.clear();
        this.negativeCache.clear();
        this.members.add(member);
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof MethodScope) {
            MethodScope sc = (MethodScope)obj;
            if (!this.members.equals(sc.members)) {
                return false;
            }
            if (this.parentScope == null) {
                return this.parentScope == sc.parentScope;
            }
            return this.parentScope.equals(sc.parentScope);
        }
        return false;
    }

    protected Object clone() {
        MethodScope cloned = new MethodScope(this.parentScope);
        cloned.members = (ArrayList)this.members.clone();
        return cloned;
    }

    private Object combine(Object val, Object val1) {
        ArrayList<Object> valList;
        if (val == null) {
            return val1;
        }
        if (val1 == null) {
            return val;
        }
        if (!(val instanceof List)) {
            valList = new ArrayList<Object>();
            valList.add(val);
        } else {
            valList = (ArrayList<Object>)val;
        }
        if (!(val1 instanceof List)) {
            valList.add(val1);
        } else {
            valList.addAll((Collection)val1);
        }
        return valList;
    }

    private Object lookupMembers(Object key) {
        Iterator it = this.members.iterator();
        Object value = null;
        while (it.hasNext()) {
            ScopeMember m = (ScopeMember)it.next();
            Object val = m.lookup(key);
            if (val == null) continue;
            if (value == null) {
                value = val;
                continue;
            }
            value = this.combine(value, val);
        }
        return value;
    }
}

