/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacore.jmiimpl.javamodel;

import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.jmi.reflect.DuplicateException;
import javax.jmi.reflect.RefObject;
import org.netbeans.mdr.handlers.BaseObjectHandler;
import org.netbeans.mdr.persistence.MOFID;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.storagemodel.StorableBaseObject;
import org.netbeans.mdr.storagemodel.StorableClass;
import org.netbeans.mdr.storagemodel.StorableFeatured;
import org.netbeans.mdr.util.DebugException;
import org.netbeans.modules.javacore.jmiimpl.javamodel.DeferredObject;
import org.netbeans.modules.javacore.jmiimpl.javamodel.SemiPersistentElement;
import org.openide.ErrorManager;

public class SemiPersistentAttrList
implements List {
    private List innerList;
    private final Set innerSet = new HashSet();
    private int modCount = 0;
    private final StorableFeatured mdrObject;
    private final StorableClass.AttributeDescriptor attrDesc;
    private final MOFID metaMofId;
    private final boolean isRefObject;
    private final SemiPersistentElement parent;
    private final int changeMask;

    public SemiPersistentAttrList(StorableFeatured mdrObject, StorableClass.AttributeDescriptor attrDesc, List innerList, SemiPersistentElement parent, int changeMask) {
        this.mdrObject = mdrObject;
        this.attrDesc = attrDesc;
        this.parent = parent;
        this.changeMask = changeMask;
        this.metaMofId = attrDesc.getMofId();
        this.isRefObject = RefObject.class.isAssignableFrom(attrDesc.getType());
        this.setInnerList(innerList);
    }

    public void setInnerList(List innerList) {
        ++this.modCount;
        this.innerList = innerList;
        this.innerSet.clear();
        Iterator iter = innerList.iterator();
        while (iter.hasNext()) {
            Object obj = iter.next();
            if (this.innerSet.contains(obj)) {
                throw new DuplicateException(obj, this.getMetaElement());
            }
            this.innerSet.add(obj);
            if (!this.isRefObject) continue;
            this.setAttribComposite((RefObject)obj);
        }
    }

    protected void objectChanged() {
        if (this.parent != null) {
            this.parent.objectChanged(this.changeMask);
        }
    }

    private void setAttribComposite(RefObject object) {
        try {
            DeferredObject storable = (DeferredObject)((BaseObjectHandler)object)._getDelegate();
            storable.setComposite((StorableBaseObject)this.mdrObject, storable.getMofId(), this.metaMofId);
        }
        catch (StorageException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private void clearAttribComposite(RefObject object) {
        try {
            DeferredObject storable = (DeferredObject)((BaseObjectHandler)object)._getDelegate();
            storable.clearComposite();
        }
        catch (StorageException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    private RefObject getMetaElement() {
        try {
            return (RefObject)this.mdrObject.getMdrStorage().getRepository().getHandler(this.mdrObject.getMdrStorage().getObject(this.metaMofId));
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean remove(Object obj) {
        boolean res = this.innerList.remove(obj);
        if (res) {
            this.innerSet.remove(obj);
            if (this.isRefObject) {
                this.clearAttribComposite((RefObject)obj);
            }
            this.objectChanged();
        }
        return res;
    }

    public Object set(int param, Object obj) {
        this.objectChanged();
        Object old = this.innerList.set(param, obj);
        if (this.isRefObject) {
            this.clearAttribComposite((RefObject)old);
            this.setAttribComposite((RefObject)obj);
        }
        this.innerSet.remove(old);
        if (!this.innerSet.add(obj)) {
            throw new DuplicateException(obj, this.getMetaElement());
        }
        return old;
    }

    public Object remove(int param) {
        this.objectChanged();
        Object old = this.innerList.remove(param);
        if (this.isRefObject) {
            this.clearAttribComposite((RefObject)old);
        }
        this.innerSet.remove(old);
        return old;
    }

    public void add(int param, Object obj) {
        this.objectChanged();
        this.innerList.add(param, obj);
        if (this.isRefObject) {
            this.setAttribComposite((RefObject)obj);
        }
        if (!this.innerSet.add(obj)) {
            throw new DuplicateException(obj, this.getMetaElement());
        }
    }

    public boolean add(Object obj) {
        this.objectChanged();
        boolean res = this.innerList.add(obj);
        if (this.isRefObject && res) {
            this.setAttribComposite((RefObject)obj);
        }
        if (!this.innerSet.add(obj)) {
            throw new DuplicateException(obj, this.getMetaElement());
        }
        return res;
    }

    public ListIterator listIterator(int param) {
        return new SemiPersistentAttrListIterator(this.innerList.listIterator(param));
    }

    public Iterator iterator() {
        return new SemiPersistentAttrListIterator(this.innerList.listIterator());
    }

    public ListIterator listIterator() {
        return new SemiPersistentAttrListIterator(this.innerList.listIterator());
    }

    public List subList(int param, int param1) {
        return this.innerList.subList(param, param1);
    }

    public boolean contains(Object obj) {
        return this.innerSet.contains(obj);
    }

    public boolean containsAll(Collection collection) {
        return this.innerSet.containsAll(collection);
    }

    public boolean addAll(Collection c) {
        throw new DebugException();
    }

    public void clear() {
        throw new DebugException();
    }

    public boolean isEmpty() {
        return this.innerList.isEmpty();
    }

    public boolean removeAll(Collection c) {
        throw new DebugException();
    }

    public boolean retainAll(Collection c) {
        throw new DebugException();
    }

    public int size() {
        return this.innerList.size();
    }

    public Object[] toArray() {
        return this.innerList.toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.innerList.toArray(a);
    }

    public boolean addAll(int index, Collection c) {
        throw new DebugException();
    }

    public Object get(int index) {
        return this.innerList.get(index);
    }

    public int indexOf(Object o) {
        return this.innerList.indexOf(o);
    }

    public int lastIndexOf(Object o) {
        return this.innerList.lastIndexOf(o);
    }

    class SemiPersistentAttrListIterator
    implements ListIterator {
        private Object lastRead;
        private ListIterator innerIterator;
        private final int modCount;

        SemiPersistentAttrListIterator(ListIterator iterator) {
            this.innerIterator = iterator;
            this.modCount = this.getParentModCount();
        }

        private int getParentModCount() {
            return SemiPersistentAttrList.this.modCount;
        }

        private void testModCount() throws ConcurrentModificationException {
            if (this.modCount != this.getParentModCount()) {
                throw new ConcurrentModificationException();
            }
        }

        public void remove() {
            this.testModCount();
            SemiPersistentAttrList.this.objectChanged();
            this.innerIterator.remove();
            SemiPersistentAttrList.this.innerSet.remove(this.lastRead);
            if (SemiPersistentAttrList.this.isRefObject) {
                SemiPersistentAttrList.this.clearAttribComposite((RefObject)this.lastRead);
            }
        }

        public void add(Object obj) {
            this.testModCount();
            SemiPersistentAttrList.this.objectChanged();
            this.innerIterator.add(obj);
            if (!SemiPersistentAttrList.this.innerSet.add(obj)) {
                throw new DuplicateException(obj, SemiPersistentAttrList.this.getMetaElement());
            }
            if (SemiPersistentAttrList.this.isRefObject) {
                SemiPersistentAttrList.this.setAttribComposite((RefObject)obj);
            }
        }

        public void set(Object obj) {
            this.testModCount();
            SemiPersistentAttrList.this.objectChanged();
            this.innerIterator.set(obj);
            SemiPersistentAttrList.this.innerSet.remove(this.lastRead);
            if (!SemiPersistentAttrList.this.innerSet.add(obj)) {
                throw new DuplicateException(obj, SemiPersistentAttrList.this.getMetaElement());
            }
            if (SemiPersistentAttrList.this.isRefObject) {
                SemiPersistentAttrList.this.clearAttribComposite((RefObject)this.lastRead);
                SemiPersistentAttrList.this.setAttribComposite((RefObject)obj);
            }
        }

        public boolean hasNext() {
            this.testModCount();
            return this.innerIterator.hasNext();
        }

        public boolean hasPrevious() {
            this.testModCount();
            return this.innerIterator.hasPrevious();
        }

        public Object next() {
            this.testModCount();
            this.lastRead = this.innerIterator.next();
            return this.lastRead;
        }

        public int nextIndex() {
            this.testModCount();
            return this.innerIterator.nextIndex();
        }

        public Object previous() {
            this.testModCount();
            this.lastRead = this.innerIterator.previous();
            return this.lastRead;
        }

        public int previousIndex() {
            this.testModCount();
            return this.innerIterator.previousIndex();
        }
    }
}

