/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ant;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.Transport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.MethodBreakpoint;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;

public class JPDAStart
extends Task
implements Runnable {
    private static final boolean verbose = System.getProperty("netbeans.debugger.debug") != null;
    private static final boolean startVerbose = System.getProperty("netbeans.debugger.start") != null;
    private String addressProperty;
    private String transport = "dt_socket";
    private String name;
    private Path sourcepath = null;
    private Path classpath = null;
    private Path bootclasspath = null;
    private Object[] lock = null;
    private String stopClassName = null;

    public void setAddressProperty(String propertyName) {
        this.addressProperty = propertyName;
    }

    private String getAddressProperty() {
        return this.addressProperty;
    }

    public void setTransport(String transport) {
        this.transport = transport;
    }

    private String getTransport() {
        return this.transport;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String getName() {
        return this.name;
    }

    public void setStopClassName(String stopClassName) {
        this.stopClassName = stopClassName;
    }

    private String getStopClassName() {
        return this.stopClassName;
    }

    public void addClasspath(Path path) {
        if (this.classpath != null) {
            throw new BuildException("Only one classpath subelement is supported");
        }
        this.classpath = path;
    }

    public void addBootclasspath(Path path) {
        if (this.bootclasspath != null) {
            throw new BuildException("Only one bootclasspath subelement is supported");
        }
        this.bootclasspath = path;
    }

    public void addSourcepath(Path path) {
        if (this.sourcepath != null) {
            throw new BuildException("Only one sourcepath subelement is supported");
        }
        this.sourcepath = path;
    }

    static void verifyPaths(Project project, Path path) {
        if (path == null) {
            return;
        }
        String[] paths = path.list();
        for (int i = 0; i < paths.length; ++i) {
            String pathName = project.replaceProperties(paths[i]);
            File file = FileUtil.normalizeFile((File)project.resolveFile(pathName));
            if (file.exists()) continue;
            project.log("Non-existing path \"" + pathName + "\" provided.", 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        JPDAStart.verifyPaths(this.getProject(), this.classpath);
        JPDAStart.verifyPaths(this.getProject(), this.bootclasspath);
        JPDAStart.verifyPaths(this.getProject(), this.sourcepath);
        try {
            if (startVerbose) {
                System.out.println("\nS JPDAStart ***************");
            }
            this.debug("Execute started");
            if (this.name == null) {
                throw new BuildException("name attribute must specify name of this debugging session", this.getLocation());
            }
            if (this.addressProperty == null) {
                throw new BuildException("addressproperty attribute must specify name of property to which address will be set", this.getLocation());
            }
            if (this.transport == null) {
                this.transport = "dt_socket";
            }
            this.debug("Entering synch lock");
            Object[] objectArray = this.lock = new Object[2];
            synchronized (this.lock) {
                this.debug("Entered synch lock");
                RequestProcessor.getDefault().post((Runnable)this);
                try {
                    this.debug("Entering wait");
                    this.lock.wait();
                    this.debug("Wait finished");
                    if (this.lock[1] != null) {
                        throw new BuildException((Throwable)this.lock[1]);
                    }
                }
                catch (InterruptedException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new BuildException(t);
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (startVerbose) {
            System.out.println("\nS JPDAStart2 ***************");
        }
        this.debug("Entering synch lock");
        Object[] objectArray = this.lock;
        synchronized (this.lock) {
            this.debug("Entered synch lock");
            try {
                Transport t;
                ListeningConnector lc = null;
                Iterator<ListeningConnector> i = Bootstrap.virtualMachineManager().listeningConnectors().iterator();
                while (i.hasNext() && ((t = (lc = i.next()).transport()) == null || !t.name().equals(this.transport))) {
                }
                if (lc == null) {
                    throw new BuildException("No trasports named " + this.transport + " found!");
                }
                Map<String, Connector.Argument> args = lc.defaultArguments();
                String address = lc.startListening(args);
                int port = -1;
                try {
                    port = Integer.parseInt(address.substring(address.indexOf(58) + 1));
                    this.getProject().setNewProperty(this.getAddressProperty(), "localhost:" + port);
                    Connector.IntegerArgument portArg = (Connector.IntegerArgument)args.get("port");
                    portArg.setValue(port);
                }
                catch (Exception e) {
                    this.getProject().setNewProperty(this.getAddressProperty(), address);
                }
                this.debug("Creating source path");
                ClassPath sourcePath = JPDAStart.createSourcePath(this.getProject(), this.classpath, this.sourcepath);
                ClassPath jdkSourcePath = JPDAStart.createJDKSourcePath(this.getProject(), this.bootclasspath);
                if (startVerbose) {
                    System.out.println("\nS Crete sourcepath: ***************");
                    System.out.println("    classpath : " + this.classpath);
                    System.out.println("    sourcepath : " + this.sourcepath);
                    System.out.println("    bootclasspath : " + this.bootclasspath);
                    System.out.println("    >> sourcePath : " + sourcePath);
                    System.out.println("    >> jdkSourcePath : " + jdkSourcePath);
                }
                if (this.stopClassName != null && this.stopClassName.length() > 0) {
                    if (startVerbose) {
                        System.out.println("\nS create method breakpoint, class name = " + this.stopClassName);
                    }
                    MethodBreakpoint b = this.createBreakpoint(this.stopClassName);
                    DebuggerManager.getDebuggerManager().addDebuggerListener("debuggerEngines", (DebuggerManagerListener)new Listener(b));
                }
                this.debug("Debugger started");
                if (startVerbose) {
                    System.out.println("\nS start listening on port " + port);
                }
                HashMap<String, Object> properties = new HashMap<String, Object>();
                properties.put("sourcepath", sourcePath);
                properties.put("name", this.getName());
                properties.put("jdksources", jdkSourcePath);
                JPDADebugger.startListening((ListeningConnector)lc, args, (Object[])new Object[]{properties});
            }
            catch (IOException ioex) {
                this.lock[1] = ioex;
            }
            catch (DebuggerStartException dsex) {
                this.lock[1] = dsex;
            }
            catch (IllegalConnectorArgumentsException icaex) {
                this.lock[1] = icaex;
            }
            finally {
                this.debug("Notifying");
                this.lock.notify();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private MethodBreakpoint createBreakpoint(String stopClassName) {
        MethodBreakpoint breakpoint = MethodBreakpoint.create((String)stopClassName, (String)"*");
        breakpoint.setHidden(true);
        DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)breakpoint);
        return breakpoint;
    }

    private void debug(String msg) {
        if (!verbose) {
            return;
        }
        System.out.println(new Date() + " [" + Thread.currentThread().getName() + "] - " + msg);
    }

    static ClassPath createSourcePath(Project project, Path classpath, Path sourcepath) {
        ClassPath cp = JPDAStart.convertToSourcePath(project, classpath);
        ClassPath sp = JPDAStart.convertToClassPath(project, sourcepath);
        ClassPath sourcePath = ClassPathSupport.createProxyClassPath((ClassPath[])new ClassPath[]{cp, sp});
        return sourcePath;
    }

    static ClassPath createJDKSourcePath(Project project, Path bootclasspath) {
        if (bootclasspath == null) {
            JavaPlatform jp = JavaPlatform.getDefault();
            if (jp != null) {
                return jp.getSourceFolders();
            }
            return ClassPathSupport.createClassPath((List)Collections.EMPTY_LIST);
        }
        return JPDAStart.convertToSourcePath(project, bootclasspath);
    }

    private static ClassPath convertToClassPath(Project project, Path path) {
        String[] paths = path == null ? new String[]{} : path.list();
        ArrayList<URL> l = new ArrayList<URL>();
        int k = paths.length;
        for (int i = 0; i < k; ++i) {
            String pathName = project.replaceProperties(paths[i]);
            File f = FileUtil.normalizeFile((File)project.resolveFile(pathName));
            if (!JPDAStart.isValid(f, project)) continue;
            URL url = JPDAStart.fileToURL(f);
            if (f == null) continue;
            l.add(url);
        }
        URL[] urls = l.toArray(new URL[l.size()]);
        return ClassPathSupport.createClassPath((URL[])urls);
    }

    private static ClassPath convertToSourcePath(Project project, Path path) {
        String[] paths = path == null ? new String[]{} : path.list();
        ArrayList<PathResourceImplementation> l = new ArrayList<PathResourceImplementation>();
        HashSet<URL> exist = new HashSet<URL>();
        int k = paths.length;
        for (int i = 0; i < k; ++i) {
            URL url;
            String pathName = project.replaceProperties(paths[i]);
            File file = FileUtil.normalizeFile((File)project.resolveFile(pathName));
            if (!JPDAStart.isValid(file, project) || (url = JPDAStart.fileToURL(file)) == null) continue;
            if (startVerbose) {
                System.out.println("class: " + url);
            }
            try {
                FileObject[] fos = SourceForBinaryQuery.findSourceRoots((URL)url).getRoots();
                int jj = fos.length;
                for (int j = 0; j < jj; ++j) {
                    if (startVerbose) {
                        System.out.println("source : " + fos[j]);
                    }
                    if (FileUtil.isArchiveFile((FileObject)fos[j])) {
                        fos[j] = FileUtil.getArchiveRoot((FileObject)fos[j]);
                    }
                    try {
                        url = fos[j].getURL();
                    }
                    catch (FileStateInvalidException ex) {
                        ErrorManager.getDefault().notify(4096, (Throwable)ex);
                        continue;
                    }
                    if (url == null || exist.contains(url)) continue;
                    l.add(ClassPathSupport.createResource((URL)url));
                    exist.add(url);
                }
                continue;
            }
            catch (IllegalArgumentException ex) {
                if (!startVerbose) continue;
                System.out.println("illegal url!");
            }
        }
        return ClassPathSupport.createClassPath(l);
    }

    private static URL fileToURL(File file) {
        try {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject == null) {
                return null;
            }
            if (FileUtil.isArchiveFile((FileObject)fileObject)) {
                fileObject = FileUtil.getArchiveRoot((FileObject)fileObject);
            }
            return fileObject.getURL();
        }
        catch (FileStateInvalidException e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            return null;
        }
    }

    private static boolean isValid(File f, Project project) {
        if (f.getPath().indexOf("${") != -1 && !f.exists()) {
            project.log("Classpath item " + f + " will be ignored.", 3);
            return false;
        }
        return true;
    }

    private static class Listener
    extends DebuggerManagerAdapter {
        private MethodBreakpoint breakpoint;
        private Set debuggers = new HashSet();

        Listener(MethodBreakpoint breakpoint) {
            this.breakpoint = breakpoint;
        }

        public void propertyChange(PropertyChangeEvent e) {
            int state;
            if (e.getPropertyName() == "state" && ((state = ((Integer)e.getNewValue()).intValue()) == 4 || state == 3)) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        if (Listener.this.breakpoint != null) {
                            DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)Listener.this.breakpoint);
                            Listener.this.breakpoint = null;
                        }
                    }
                });
                this.dispose();
            }
        }

        private void dispose() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("debuggerEngines", (DebuggerManagerListener)this);
            for (JPDADebugger d : this.debuggers) {
                d.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            }
        }

        public void engineAdded(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.addPropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            this.debuggers.add(debugger);
        }

        public void engineRemoved(DebuggerEngine engine) {
            JPDADebugger debugger = (JPDADebugger)engine.lookupFirst(null, JPDADebugger.class);
            if (debugger == null) {
                return;
            }
            debugger.removePropertyChangeListener("state", (PropertyChangeListener)((Object)this));
            this.debuggers.remove(debugger);
        }
    }
}

