/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.mimelookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.editor.mimelookup.LayerFolderObjectsProvider;
import org.netbeans.spi.editor.mimelookup.Class2LayerFolder;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.netbeans.spi.editor.mimelookup.MimeLookupInitializer;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakSet;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class LayerMimeLookupInitializer
implements MimeLookupInitializer {
    private static Map proxyChildResults = new HashMap();
    private static Map mimePath2lazyLookup = new HashMap();
    private static Map class2Provider = new HashMap();
    private static Lookup.Result class2LayerFolders;
    private static Map class2folder;
    private static Class2LayerFoldersLookupListener class2LayerFoldersLookupListener;
    private static final String[] EMPTY_STRING_ARRAY;
    private LayerMimeLookupInitializer parent;
    private String[] mimePath;

    public LayerMimeLookupInitializer() {
        this.parent = null;
        this.mimePath = EMPTY_STRING_ARRAY;
    }

    public LayerMimeLookupInitializer(LayerMimeLookupInitializer parent, String mimeType) {
        this.parent = parent;
        String[] parentMimePath = parent != null ? parent.mimePath : EMPTY_STRING_ARRAY;
        int parentMimePathLength = parentMimePath.length;
        this.mimePath = new String[parentMimePathLength + 1];
        System.arraycopy(parentMimePath, 0, this.mimePath, 0, parentMimePathLength);
        this.mimePath[parentMimePathLength] = mimeType;
        LayerMimeLookupInitializer.initClass2LayerFolders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup.Result child(String mimeType) {
        String parentPath = this.mimePath2String(this.mimePath);
        String path = parentPath.length() == 0 ? parentPath + mimeType : parentPath + "/" + mimeType;
        Map map = proxyChildResults;
        synchronized (map) {
            ProxyChildResult proxyChildResult = (ProxyChildResult)((Object)proxyChildResults.get(path));
            if (proxyChildResult == null) {
                proxyChildResult = new ProxyChildResult(this, mimeType);
                proxyChildResults.put(path, proxyChildResult);
            }
            return proxyChildResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup lookup() {
        Map map = mimePath2lazyLookup;
        synchronized (map) {
            Lookup lookup = (Lookup)mimePath2lazyLookup.get(this.mimePath);
            if (lookup == null) {
                lookup = new LazyLookup(this.mimePath);
                mimePath2lazyLookup.put(this.mimePath, lookup);
            }
            return lookup;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initClass2LayerFolders() {
        if (class2LayerFolders == null) {
            class2LayerFolders = Lookup.getDefault().lookup(new Lookup.Template(Class2LayerFolder.class));
            Iterator it = class2LayerFolders.allInstances().iterator();
            Map map = class2folder;
            synchronized (map) {
                while (it.hasNext()) {
                    Object obj = it.next();
                    Class2LayerFolder c2lf = (Class2LayerFolder)obj;
                    class2folder.put(c2lf.getClazz(), c2lf);
                }
            }
            if (class2LayerFoldersLookupListener == null) {
                class2LayerFoldersLookupListener = new Class2LayerFoldersLookupListener();
            }
            class2LayerFolders.addLookupListener((LookupListener)class2LayerFoldersLookupListener);
        }
    }

    private String mimePath2String(String[] mimePath) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < mimePath.length; ++i) {
            sb.append(mimePath[i]);
            if (i >= mimePath.length - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }

    static {
        class2folder = new HashMap();
        EMPTY_STRING_ARRAY = new String[0];
    }

    private class ProxyChildResult
    extends Lookup.Result {
        private LayerMimeLookupInitializer parent;
        private String mimeType;
        private Collection instances = null;
        private final Set listeners = new WeakSet(10);

        public ProxyChildResult(LayerMimeLookupInitializer parent, String mimeType) {
            this.parent = parent;
            this.mimeType = mimeType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addLookupListener(LookupListener l) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeLookupListener(LookupListener l) {
            Set set = this.listeners;
            synchronized (set) {
                this.listeners.remove(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged() {
            LookupListener[] _listeners;
            Set set = this.listeners;
            synchronized (set) {
                if (this.listeners.isEmpty()) {
                    return;
                }
                _listeners = this.listeners.toArray(new LookupListener[this.listeners.size()]);
            }
            LookupEvent ev = new LookupEvent((Lookup.Result)this);
            if (_listeners == null) {
                return;
            }
            for (int i = 0; i < _listeners.length; ++i) {
                LookupListener lst = _listeners[i];
                if (lst == null) continue;
                lst.resultChanged(ev);
            }
        }

        public synchronized Collection allInstances() {
            if (this.instances == null) {
                ArrayList<LayerMimeLookupInitializer> ret = new ArrayList<LayerMimeLookupInitializer>();
                ret.add(new LayerMimeLookupInitializer(this.parent, this.mimeType));
                this.instances = Collections.unmodifiableCollection(ret);
            }
            return this.instances;
        }
    }

    private static class Class2LayerFoldersLookupListener
    implements LookupListener {
        private Class2LayerFoldersLookupListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resultChanged(LookupEvent ev) {
            Iterator it = ((Lookup.Result)ev.getSource()).allInstances().iterator();
            Map map = class2folder;
            synchronized (map) {
                class2folder.clear();
                while (it.hasNext()) {
                    Class2LayerFolder c2lf = (Class2LayerFolder)it.next();
                    class2folder.put(c2lf.getClazz(), c2lf);
                }
            }
        }
    }

    private class LazyLookup
    extends Lookup {
        private String[] mimePath;
        private Map class2Lookup = new HashMap();
        private Map class2LookupObjects = new HashMap();

        private LazyLookup(String[] mimePath) {
            this.mimePath = mimePath;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lookupChanged() {
            ProxyChildResult proxyChildResult;
            Map map;
            Map map2 = mimePath2lazyLookup;
            synchronized (map2) {
                Object obj = mimePath2lazyLookup.remove(this.mimePath);
                map = null;
            }
            map = proxyChildResults;
            synchronized (map) {
                proxyChildResult = (ProxyChildResult)((Object)proxyChildResults.get(LayerMimeLookupInitializer.this.mimePath2String(this.mimePath)));
            }
            if (proxyChildResult != null) {
                proxyChildResult.resultChanged();
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("LazyLookup:");
            sb.append(LayerMimeLookupInitializer.this.mimePath2String(this.mimePath));
            sb.append(" - class2Lookup:");
            sb.append(this.class2Lookup);
            return sb.toString();
        }

        public Lookup.Result lookup(Lookup.Template template) {
            Lookup lookup = this.getLookup(template.getType());
            Lookup.Result res = this.mimePath != null && this.mimePath.length == 0 ? Lookup.EMPTY.lookup(template) : lookup.lookup(template);
            return res;
        }

        public Object lookup(Class clazz) {
            Lookup lookup = this.getLookup(clazz);
            Object obj = lookup.lookup(clazz);
            return obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Lookup getLookup(Class clazz) {
            Lookup lookup;
            Map map = this.class2Lookup;
            synchronized (map) {
                lookup = (Lookup)this.class2Lookup.get(clazz);
                if (lookup != null) {
                    return lookup;
                }
            }
            Lookup lookup2 = this.createLookup(clazz);
            Map map2 = this.class2Lookup;
            synchronized (map2) {
                lookup = (Lookup)this.class2Lookup.get(clazz);
                if (lookup != null) {
                    return lookup;
                }
                this.class2Lookup.put(clazz, lookup2);
                lookup = lookup2;
            }
            return lookup;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Lookup createLookup(Class clazz) {
            LayerFolderObjectsProvider provider;
            Object obj;
            InstanceContent ic = new InstanceContent();
            String subFolder = null;
            InstanceProvider instanceProvider = null;
            Map map = class2folder;
            synchronized (map) {
                obj = class2folder.get(clazz);
                Class2LayerFolder c2lf = (Class2LayerFolder)obj;
                if (c2lf != null) {
                    subFolder = c2lf.getLayerFolderName();
                    instanceProvider = c2lf.getInstanceProvider();
                }
            }
            obj = class2Provider;
            synchronized (obj) {
                provider = (LayerFolderObjectsProvider)class2Provider.get(clazz);
                if (provider == null) {
                    provider = new LayerFolderObjectsProvider(subFolder, clazz, instanceProvider);
                    class2Provider.put(clazz, provider);
                }
            }
            Lookup.Result lookupObjects = provider.folderObjects(this.mimePath);
            lookupObjects.addLookupListener((LookupListener)new LookupObjectsListener(clazz));
            this.class2LookupObjects.put(clazz, lookupObjects);
            Iterator it = lookupObjects.allInstances().iterator();
            while (it.hasNext()) {
                Object lookupObject = it.next();
                ic.add(lookupObject);
            }
            return new AbstractLookup((AbstractLookup.Content)ic);
        }

        private class LookupObjectsListener
        implements LookupListener {
            private Class clazz;

            public LookupObjectsListener(Class clazz) {
                this.clazz = clazz;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent ev) {
                Lookup.Result result = (Lookup.Result)ev.getSource();
                Collection newInstances = result.allInstances();
                boolean lookupObjectsChanged = false;
                Map map = LazyLookup.this.class2Lookup;
                synchronized (map) {
                    Lookup.Result oldResult;
                    Lookup oldLookup = (Lookup)LazyLookup.this.class2Lookup.get(this.clazz);
                    if (oldLookup != null && !((Object)newInstances).equals((oldResult = oldLookup.lookup(new Lookup.Template(this.clazz))).allInstances())) {
                        lookupObjectsChanged = true;
                    }
                    if (lookupObjectsChanged) {
                        LazyLookup.this.class2Lookup.remove(this.clazz);
                        oldLookup = null;
                    }
                }
                if (lookupObjectsChanged) {
                    Lookup.Result res = (Lookup.Result)LazyLookup.this.class2LookupObjects.get(this.clazz);
                    if (res != null) {
                        res.removeLookupListener((LookupListener)this);
                    }
                    result.removeLookupListener((LookupListener)this);
                    LazyLookup.this.lookupChanged();
                }
            }
        }
    }
}

