/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.core.syntax;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenContextPath;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.editor.ext.html.HTMLFormatter;
import org.netbeans.editor.ext.java.JavaFormatter;
import org.netbeans.editor.ext.java.JavaTokenContext;
import org.netbeans.modules.editor.java.JavaKit;
import org.netbeans.modules.web.core.syntax.JspJavaFormatter;
import org.netbeans.modules.web.core.syntax.JspMultiSyntax;
import org.netbeans.modules.web.core.syntax.JspSyntaxSupport;
import org.netbeans.modules.web.core.syntax.JspTagTokenContext;
import org.netbeans.modules.web.core.syntax.JspUtils;

public class JspFormatter
extends HTMLFormatter {
    private JavaFormatter jFormatter = new JspJavaFormatter(JavaKit.class);

    public JspFormatter(Class kitClass) {
        super(kitClass);
    }

    public Writer reformat(BaseDocument doc, int startOffset, int endOffset, boolean indentOnly) throws BadLocationException, IOException {
        super.reformat(doc, startOffset, endOffset, indentOnly);
        LinkedList<ScriptletBlock> scripletBlocks = new LinkedList<ScriptletBlock>();
        ExtSyntaxSupport sup = this.getSyntaxSupport(doc);
        TokenItem token = sup.getTokenChain(startOffset, startOffset + 1);
        if (token == null) {
            return null;
        }
        TokenItem lastNonWhiteScriptletToken = null;
        int scripletBlockStart = -1;
        int scripletBlockEnd = -1;
        while (token.getOffset() < endOffset) {
            if (token.getTokenContextPath().contains(JavaTokenContext.contextPath)) {
                if (token.getTokenID() != JavaTokenContext.WHITESPACE) {
                    if (scripletBlockStart == -1) {
                        scripletBlockStart = token.getOffset();
                    }
                    lastNonWhiteScriptletToken = token;
                }
            } else if (scripletBlockStart != -1) {
                scripletBlockEnd = lastNonWhiteScriptletToken.getOffset() + lastNonWhiteScriptletToken.getImage().length();
                scripletBlocks.add(new ScriptletBlock(doc, scripletBlockStart, scripletBlockEnd));
                scripletBlockStart = -1;
            }
            if ((token = token.getNext()) != null) continue;
        }
        for (ScriptletBlock sb : scripletBlocks) {
            this.extFormatterReformat(doc, sb.getStart(), Math.min(sb.getEnd(), endOffset), indentOnly);
        }
        return null;
    }

    protected void enterPressed(JTextComponent txtComponent, int dotPos) throws BadLocationException {
        BaseDocument doc = Utilities.getDocument((JTextComponent)txtComponent);
        JspSyntaxSupport sup = new JspSyntaxSupport(doc);
        TokenItem token = sup.getItemAtOrBefore(dotPos);
        if (token.getTokenContextPath().contains(JavaTokenContext.contextPath)) {
            try {
                this.extFormatterReformat(doc, dotPos, dotPos + 1, true);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        } else {
            super.enterPressed(txtComponent, dotPos);
        }
    }

    protected boolean isClosingTag(TokenItem token) {
        return token != null && this.isJSPTag(token) && token.getPrevious().getImage().equals("</") || super.isClosingTag(token);
    }

    protected boolean isOpeningTag(TokenItem token) {
        return token != null && this.isJSPTag(token) && token.getPrevious().getImage().equals("<") || super.isOpeningTag(token);
    }

    protected TokenItem getTagTokenEndingAtPosition(BaseDocument doc, int position) throws BadLocationException {
        JspSyntaxSupport sup;
        TokenItem token;
        TokenItem htmlEndingToken = super.getTagTokenEndingAtPosition(doc, position);
        if (htmlEndingToken != null) {
            return htmlEndingToken;
        }
        if (position >= 0 && (token = (sup = (JspSyntaxSupport)doc.getSyntaxSupport().get(JspSyntaxSupport.class)).getTokenChain(position, position + 1)).getTokenID() == JspTagTokenContext.SYMBOL && token.getImage().equals(">")) {
            while ((token = token.getPrevious()) != null && token.getTokenID() != JspTagTokenContext.TAG) {
            }
            return token;
        }
        return null;
    }

    protected int getTagEndOffset(TokenItem token) {
        TokenItem t;
        if (!this.isJSPTag(token)) {
            return super.getTagEndOffset(token);
        }
        for (t = token.getNext(); t != null && (t.getTokenID() != JspTagTokenContext.SYMBOL || !">".equals(t.getImage()) && !"/>".equals(t.getImage())); t = t.getNext()) {
        }
        return t == null ? -1 : t.getOffset();
    }

    protected int getOpeningSymbolOffset(TokenItem tknTag) {
        if (!this.isJSPTag(tknTag)) {
            return super.getOpeningSymbolOffset(tknTag);
        }
        TokenItem tkn = tknTag;
        while ((tkn = tkn.getPrevious()) != null && tkn.getTokenID() != JspTagTokenContext.SYMBOL) {
        }
        if (tkn != null) {
            return tkn.getOffset();
        }
        return -1;
    }

    private boolean isJSPTag(TokenItem tagToken) {
        return tagToken.getTokenID() == JspTagTokenContext.TAG;
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof JspMultiSyntax;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new SwitchLayer());
    }

    protected boolean isUnformattableToken(TokenItem token) {
        if (token.getTokenID() == JspTagTokenContext.COMMENT || token.getTokenID() == JspTagTokenContext.EOL) {
            return true;
        }
        return super.isUnformattableToken(token);
    }

    private class ScriptletBlock {
        private Position posStart;
        private Position posEnd;

        public ScriptletBlock(BaseDocument doc, int start, int end) throws BadLocationException {
            this.posStart = doc.createPosition(start);
            this.posEnd = doc.createPosition(end);
        }

        public int getStart() {
            return this.posStart.getOffset();
        }

        public int getEnd() {
            return this.posEnd.getOffset();
        }
    }

    private class SwitchLayer
    extends AbstractFormatLayer {
        public SwitchLayer() {
            super("Switch-line");
        }

        public void format(FormatWriter fw) {
            int offset = fw.getOffset();
            JspSyntaxSupport sup = new JspSyntaxSupport((BaseDocument)fw.getDocument());
            try {
                TokenItem item = sup.getItemAtOrBefore(offset);
                if (item == null) {
                    return;
                }
                TokenContextPath tcp = item.getTokenContextPath();
                if (tcp.contains(JavaTokenContext.contextPath) && JspUtils.getScriptingLanguage().equals("text/x-java")) {
                    JspFormatter.this.jFormatter.format(fw);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

