/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.clientproject.ui;

import java.io.IOException;
import java.util.HashSet;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

final class RemoveClassPathRootAction
extends NodeAction {
    RemoveClassPathRootAction() {
    }

    protected void performAction(final Node[] activatedNodes) {
        final HashSet changedProjectsSet = new HashSet();
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                for (int i = 0; i < activatedNodes.length; ++i) {
                    Project p;
                    Removable removable = (Removable)activatedNodes[i].getLookup().lookup(Removable.class);
                    if (removable == null || (p = removable.remove()) == null) continue;
                    changedProjectsSet.add(p);
                }
                for (Project p : changedProjectsSet) {
                    try {
                        ProjectManager.getDefault().saveProject(p);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            }
        });
    }

    protected boolean enable(Node[] activatedNodes) {
        for (int i = 0; i < activatedNodes.length; ++i) {
            Removable removable = (Removable)activatedNodes[i].getLookup().lookup(Removable.class);
            if (removable == null) {
                return false;
            }
            if (removable.canRemove()) continue;
            return false;
        }
        return true;
    }

    public String getName() {
        return NbBundle.getMessage(RemoveClassPathRootAction.class, (String)"CTL_RemoveProject");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(RemoveClassPathRootAction.class);
    }

    protected boolean asynchronous() {
        return false;
    }

    public static boolean isReferenced(EditableProperties[] props, String reference) {
        for (int i = 0; i < props.length; ++i) {
            for (String value : props[i].values()) {
                if (value == null || value.indexOf(reference) < 0) continue;
                return true;
            }
        }
        return false;
    }

    static interface Removable {
        public boolean canRemove();

        public Project remove();
    }
}

