/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.db;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.derby.api.DerbyDatabases;
import org.netbeans.modules.derby.spi.support.DerbySupport;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.sun.api.ServerLocationManager;
import org.netbeans.modules.j2ee.sun.ide.j2ee.db.AddPointBaseMenus;
import org.netbeans.modules.j2ee.sun.ide.j2ee.db.ExecSupport;
import org.netbeans.modules.j2ee.sun.ide.j2ee.db.StartAction;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.netbeans.spi.db.explorer.DatabaseRuntime;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RegisterPointbase
implements DatabaseRuntime {
    public static final String DRIVER_DISPLAY_NAME = NbBundle.getMessage(RegisterPointbase.class, (String)"LBL_DriverName");
    public static final String DRIVER_NAME = "pointbase";
    public static final String DRIVER = "com.pointbase.jdbc.jdbcUniversalDriver";
    public static final String USER_NAME = "pbpublic";
    public static final String SCHEMA_NAME = "PBPUBLIC";
    public static final String PASSWORD = "pbpublic";
    private static final String RELATIVE_DRIVER_PATH = "/pointbase/lib/pbembedded.jar";
    private static RegisterPointbase reg = null;
    private static Process process = null;
    private File appServerInstallationDirectory = null;
    private static final String POINTBASE_URL_PREFIX = "jdbc:pointbase:";
    private static final String LOCALHOST_URL_PREFIX = "jdbc:pointbase://localhost:";
    private static final String SAMPLE_NAME = "sample";
    private static final String SUN_APPSERV_SAMPLES_NAME = "sun-appserv-samples";
    private static final String DOT_DBN = ".dbn";
    private static final String SLASH = "/";

    private RegisterPointbase() {
    }

    public static RegisterPointbase getDefault() {
        if (reg == null) {
            reg = new RegisterPointbase();
        }
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file1, File file2) throws IOException {
        IOException ioe22;
        FilterOutputStream bos;
        FileOutputStream fos;
        FileInputStream fis;
        block22: {
            fis = null;
            BufferedInputStream bis = null;
            fos = null;
            bos = null;
            try {
                int b;
                fis = new FileInputStream(file1);
                bis = new BufferedInputStream(fis);
                fos = new FileOutputStream(file2);
                bos = new BufferedOutputStream(fos);
                while ((b = bis.read()) != -1) {
                    ((BufferedOutputStream)bos).write(b);
                }
                Object var8_7 = null;
                if (null == bis) break block22;
            }
            catch (Throwable throwable) {
                IOException ioe22;
                Object var8_8 = null;
                if (null != bis) {
                    try {
                        bis.close();
                    }
                    catch (IOException ioe22) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioe22);
                    }
                }
                if (null != bos) {
                    try {
                        bos.close();
                    }
                    catch (IOException ioe22) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioe22);
                    }
                }
                if (null != fis) {
                    try {
                        fis.close();
                    }
                    catch (IOException ioe22) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioe22);
                    }
                }
                if (null != fos) {
                    try {
                        fos.close();
                    }
                    catch (IOException ioe22) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioe22);
                    }
                }
                throw throwable;
            }
            try {
                bis.close();
            }
            catch (IOException ioe22) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe22);
            }
        }
        if (null != bos) {
            try {
                bos.close();
            }
            catch (IOException ioe22) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe22);
            }
        }
        if (null != fis) {
            try {
                fis.close();
            }
            catch (IOException ioe22) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe22);
            }
        }
        if (null != fos) {
            try {
                fos.close();
            }
            catch (IOException ioe22) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe22);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream source, File targetFolder) throws IOException {
        ZipInputStream zip = new ZipInputStream(source);
        try {
            ZipEntry ent;
            while ((ent = zip.getNextEntry()) != null) {
                File f = new File(targetFolder, ent.getName());
                if (ent.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                f.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(f);
                try {
                    FileUtil.copy((InputStream)zip, (OutputStream)out);
                }
                finally {
                    out.close();
                }
            }
        }
        finally {
            zip.close();
        }
    }

    private void createLocalInstallation() {
        String installRoot = this.appServerInstallationDirectory.getAbsolutePath();
        String dest = System.getProperty("netbeans.user");
        try {
            RegisterPointbase.unzip(this.getClass().getClassLoader().getResourceAsStream("org/netbeans/modules/j2ee/sun/ide/j2ee/db/pointbasescripts.zip"), new File(dest));
            RegisterPointbase.copyFile(new File(installRoot + "/pointbase/databases/sample.dbn"), new File(dest + "/pointbase/databases/sample.dbn"));
            RegisterPointbase.copyFile(new File(installRoot + "/pointbase/databases/sun-appserv-samples.dbn"), new File(dest + "/pointbase/databases/sun-appserv-samples.dbn"));
            try {
                RegisterPointbase.copyFile(new File(installRoot + "/pointbase/databases/sample$2.wal"), new File(dest + "/pointbase/databases/sample$2.wal"));
                RegisterPointbase.copyFile(new File(installRoot + "/pointbase/databases/sun-appserv-samples$2.wal"), new File(dest + "/pointbase/databases/sun-appserv-samples$2.wal"));
            }
            catch (FileNotFoundException e) {
                try {
                    RegisterPointbase.copyFile(new File(installRoot + "/pointbase/databases/sample$1.wal"), new File(dest + "/pointbase/databases/sample$1.wal"));
                    RegisterPointbase.copyFile(new File(installRoot + "/pointbase/databases/sun-appserv-samples$1.wal"), new File(dest + "/pointbase/databases/sun-appserv-samples$1.wal"));
                }
                catch (FileNotFoundException ee) {
                    ErrorManager.getDefault().notify(1, (Throwable)ee);
                }
            }
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(dest + "/pointbase/tools/serveroption/pbenv.bat"));
            PrintStream ps = new PrintStream(bos);
            ps.println("set AS_POINTBASE=" + installRoot + "\\pointbase");
            ps.println("set AS_POINTBASE_SAMPLESDB=" + dest + "\\pointbase");
            ps.println("set PB_CONFIGURED_JAVA_HOME=" + System.getProperty("java.home"));
            ps.println("exit /b 0");
            ps.close();
            BufferedOutputStream bos2 = new BufferedOutputStream(new FileOutputStream(dest + "/pointbase/tools/serveroption/pbenv.conf"));
            PrintStream ps2 = new PrintStream(bos2);
            ps2.println("AS_POINTBASE=" + installRoot + "/pointbase");
            ps2.println("AS_POINTBASE_SAMPLESDB=" + dest + "/pointbase");
            ps2.println("PB_CONFIGURED_JAVA_HOME=" + System.getProperty("java.home"));
            ps2.close();
            if (File.separator.equals(SLASH)) {
                String[] cmd = new String[]{"chmod", "+x", dest + "/pointbase/tools/serveroption/startserver.sh"};
                Runtime.getRuntime().exec(cmd);
                cmd[2] = dest + "/pointbase/tools/serveroption/startconsole.sh";
                Runtime.getRuntime().exec(cmd);
                cmd[2] = dest + "/pointbase/tools/serveroption/startconsole.sh";
                Runtime.getRuntime().exec(cmd);
                cmd[2] = dest + "/pointbase/tools/serveroption/stopserver.sh";
                Runtime.getRuntime().exec(cmd);
                cmd[2] = dest + "/pointbase/tools/serveroption/pbenv.conf";
                Runtime.getRuntime().exec(cmd);
            }
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public void register(File irf) {
        String installRoot;
        if (null != irf && irf.exists() && (installRoot = irf.getAbsolutePath()) != null) {
            File localInstall;
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            File derbyInstall = new File(irf, "derby");
            if (!derbyInstall.exists()) {
                derbyInstall = new File(irf, "javadb");
            }
            if (ServerLocationManager.isGlassFish((File)irf)) {
                this.registerDerbyLibrary(derbyInstall);
            }
            if (derbyInstall.exists()) {
                FileObject derb = fs.findResource("Databases/JDBCDrivers/org_apache_derby_jdbc_ClientDriver.xml");
                File installDir = derbyInstall;
                RequestProcessor.getDefault().post((Runnable)new ConfigureJavaDBSamples(installDir, derb));
            }
            if ((localInstall = new File(irf, DRIVER_NAME)).exists()) {
                this.configureForPointbaseSamples(installRoot, irf, localInstall, fs);
            }
        }
    }

    private void configureForPointbaseSamples(String installRoot, File irf, File localInstall, FileSystem fs) {
        this.appServerInstallationDirectory = irf;
        AddPointBaseMenus.execute();
        FileObject props = fs.findResource("Databases/JDBCDrivers/com_pointbase_jdbc_jdbcUniversalDriver.xml");
        if (props == null) {
            File dbFile = new File(installRoot + "/pointbase/databases/sample.dbn");
            if (dbFile.exists() && !dbFile.canWrite()) {
                this.createLocalInstallation();
            }
            try {
                String driverName = installRoot + RELATIVE_DRIVER_PATH;
                File f = new File(driverName);
                if (f.exists()) {
                    File dbDir = new File(localInstall, "databases");
                    int portVal = this.getPort(dbDir);
                    URL[] urls = new URL[]{f.toURI().toURL()};
                    JDBCDriver newDriver = JDBCDriver.create((String)DRIVER_NAME, (String)DRIVER_DISPLAY_NAME, (String)DRIVER, (URL[])urls);
                    JDBCDriverManager.getDefault().addDriver(newDriver);
                    File testFile = new File(dbDir, "sample.dbn");
                    if (testFile.exists()) {
                        DatabaseConnection dbconn = DatabaseConnection.create((JDBCDriver)newDriver, (String)(LOCALHOST_URL_PREFIX + portVal + SLASH + SAMPLE_NAME), (String)"pbpublic", (String)SCHEMA_NAME, (String)"pbpublic", (boolean)true);
                        ConnectionManager.getDefault().addConnection(dbconn);
                    }
                    if ((testFile = new File(dbDir, "sun-appserv-samples.dbn")).exists()) {
                        DatabaseConnection dbconn2 = DatabaseConnection.create((JDBCDriver)newDriver, (String)(LOCALHOST_URL_PREFIX + portVal + SLASH + SUN_APPSERV_SAMPLES_NAME), (String)"pbpublic", (String)SCHEMA_NAME, (String)"pbpublic", (boolean)true);
                        ConnectionManager.getDefault().addConnection(dbconn2);
                    }
                }
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (DatabaseException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (RuntimeException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    public String getJDBCDriverClass() {
        return DRIVER;
    }

    public boolean acceptsDatabaseURL(String url) {
        return url.startsWith(LOCALHOST_URL_PREFIX);
    }

    public boolean isRegisterable() {
        String[] instances;
        boolean retVal = false;
        if (null == this.appServerInstallationDirectory && null != (instances = InstanceProperties.getInstanceList())) {
            for (int i = 0; i < instances.length; ++i) {
                int end = instances[i].indexOf(93);
                if (instances[i].indexOf("deployer:Sun:AppServer::") <= -1 || end <= -1) continue;
                File irf = new File(instances[i].substring(1, end));
                this.register(irf);
                break;
            }
        }
        if (null != this.appServerInstallationDirectory && this.appServerInstallationDirectory.exists()) {
            retVal = true;
        }
        return retVal;
    }

    public boolean isRunning() {
        if (process != null) {
            try {
                process.exitValue();
                process = null;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                // empty catch block
            }
        }
        return process != null;
    }

    public boolean canStart() {
        return System.getProperty("com.sun.aas.installRoot") != null;
    }

    public void start() {
        this.start(5000);
    }

    public File getScriptsLocation() {
        File irf = this.appServerInstallationDirectory;
        File localInstall = null;
        if (null != irf && irf.exists()) {
            String installRoot = irf.getAbsolutePath();
            if (installRoot != null) {
                localInstall = new File(System.getProperty("netbeans.user") + "/pointbase/tools/serveroption");
                if (!localInstall.exists()) {
                    localInstall = new File(installRoot + "/pointbase/tools/serveroption");
                }
            } else {
                Util.showInformation(NbBundle.getMessage(StartAction.class, (String)"ERR_NotThere"));
            }
        }
        return localInstall;
    }

    public void start(int waitTime) {
        if (process != null) {
            this.stop();
        }
        String suffix = File.separator.equals("\\") ? ".bat" : ".sh";
        File loc = this.getScriptsLocation();
        if (loc == null) {
            return;
        }
        String script = null;
        script = File.separator.equals("\\") ? loc.getAbsolutePath() + "\\startserver" : loc.getAbsolutePath() + "/startserver";
        try {
            ExecSupport ee = new ExecSupport();
            process = Runtime.getRuntime().exec(script + suffix, null, loc);
            ee.displayProcessOutputs(process, NbBundle.getMessage(StartAction.class, (String)"LBL_outputtab"), "");
            if (waitTime > 0) {
                Thread.sleep(waitTime);
            }
        }
        catch (MissingResourceException ex) {
            Util.showInformation(ex.getLocalizedMessage());
        }
        catch (IOException ex) {
            Util.showInformation(ex.getLocalizedMessage());
        }
        catch (InterruptedException ex) {
            Util.showInformation(ex.getLocalizedMessage());
        }
        catch (RuntimeException ex) {
            Util.showInformation(ex.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        BufferedWriter processIn = null;
        try {
            if (process != null) {
                processIn = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
                processIn.write("q\ny\n");
                processIn.flush();
                process.destroy();
                process = null;
            }
        }
        catch (IOException e) {
            Util.showInformation(e.getMessage());
            process = null;
        }
        catch (RuntimeException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
            Util.showInformation(ex.getMessage());
            process = null;
        }
        finally {
            if (null != processIn) {
                try {
                    processIn.close();
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify(1, (Throwable)ioe);
                }
            }
        }
    }

    private int getPort(File databaseDir) throws IOException {
        File iniFile = new File(databaseDir, "pointbase.ini");
        int port = 9092;
        Properties iniProps = new Properties();
        iniProps.load(new FileInputStream(iniFile));
        port = Integer.parseInt(iniProps.getProperty("server.port", "9092"));
        return port;
    }

    private void registerDerbyLibrary(File location) {
        Repository rep = (Repository)Lookup.getDefault().lookup(Repository.class);
        FileObject libsFolder = rep.getDefaultFileSystem().findResource("/org-netbeans-api-project-libraries/Libraries");
        if (libsFolder != null) {
            try {
                libsFolder.getFileSystem().runAtomicAction((FileSystem.AtomicAction)new DerbyLibraryRegistrar(location, libsFolder));
            }
            catch (FileStateInvalidException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }

    static class DerbyLibraryRegistrar
    implements FileSystem.AtomicAction {
        private File location;
        private FileObject libsFolder;

        DerbyLibraryRegistrar(File location, FileObject libsFolder) {
            this.location = location;
            this.libsFolder = libsFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileLock ld = null;
            OutputStream outStreamd = null;
            Writer outd = null;
            OutputStreamWriter osw = null;
            try {
                FileObject derbyLib = null;
                derbyLib = this.libsFolder.getFileObject("JavaDB", "xml");
                if (null == derbyLib) {
                    derbyLib = this.libsFolder.createData("JavaDB", "xml");
                    ld = derbyLib.lock();
                    outStreamd = derbyLib.getOutputStream(ld);
                    osw = new OutputStreamWriter(outStreamd);
                    outd = new BufferedWriter(osw);
                    outd.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE library PUBLIC \"-//NetBeans//DTD Library Declaration 1.0//EN\" \"http://www.netbeans.org/dtds/library-declaration-1_0.dtd\">\n");
                    outd.write("<library version=\"1.0\">\n<name>JAVADB_DRIVER_LABEL</name>\n");
                    outd.write("<type>j2se</type>\n");
                    outd.write("<localizing-bundle>org.netbeans.modules.j2ee.sun.ide.j2ee.db.Bundle</localizing-bundle>\n");
                    outd.write("<volume>\n<type>classpath</type>\n");
                    outd.write("<resource>jar:" + new File(this.location.getAbsolutePath() + "/lib/derby.jar").toURI().toURL() + "!/</resource>\n");
                    outd.write("<resource>jar:" + new File(this.location.getAbsolutePath() + "/lib/derbyclient.jar").toURI().toURL() + "!/</resource>\n");
                    outd.write("<resource>jar:" + new File(this.location.getAbsolutePath() + "/lib/derbynet.jar").toURI().toURL() + "!/</resource>\n");
                    outd.write("</volume>\n<volume>\n<type>src</type>\n</volume>\n");
                    outd.write("<volume>\n<type>javadoc</type>\n");
                    outd.write("</volume>\n</library>");
                }
            }
            finally {
                if (null != outd) {
                    try {
                        outd.close();
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioe);
                    }
                }
                if (null != outStreamd) {
                    try {
                        outStreamd.close();
                    }
                    catch (IOException ioe) {
                        ErrorManager.getDefault().notify(1, (Throwable)ioe);
                    }
                }
                if (null != ld) {
                    ld.releaseLock();
                }
            }
        }
    }

    static class ConfigureJavaDBSamples
    implements Runnable {
        private Object derb;
        private File installDir;

        ConfigureJavaDBSamples(File installDir, Object derb) {
            this.installDir = installDir;
            this.derb = derb;
        }

        public void run() {
            try {
                if ("".equals(DerbySupport.getLocation())) {
                    DerbySupport.setLocation((String)this.installDir.getAbsolutePath());
                } else if (null == this.derb) {
                    DerbySupport.setLocation((String)this.installDir.getAbsolutePath());
                }
                if ("".equals(DerbySupport.getSystemHome())) {
                    File dbdir = new File(DerbySupport.getDefaultSystemHome());
                    if (!dbdir.exists()) {
                        dbdir.mkdirs();
                    }
                    DerbySupport.setSystemHome((String)dbdir.getAbsolutePath());
                }
                DerbyDatabases.createSampleDatabase();
            }
            catch (DatabaseException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
        }
    }
}

