/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectPanel;
import org.netbeans.modules.db.explorer.dlg.ConnectProgressDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;

public class ConnectAction
extends DatabaseAction {
    static final long serialVersionUID = -6822218300035053411L;
    ConnectionDialog dlg;
    boolean advancedPanel = false;
    boolean okPressed = false;

    protected boolean enable(Node[] activatedNodes) {
        DatabaseNodeInfo nfo;
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        Node node = activatedNodes[0];
        DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        if (info != null && (nfo = info.getParent("connection")) != null) {
            return nfo.getConnection() == null;
        }
        return false;
    }

    protected int mode() {
        return 4;
    }

    public void performAction(Node[] activatedNodes) {
        Node node = activatedNodes[0];
        DatabaseNodeInfo info = (DatabaseNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        ConnectionNodeInfo nfo = (ConnectionNodeInfo)info.getParent("connection");
        new ConnectionDialogDisplayer().showDialog(nfo, false);
    }

    public static final class ConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        ConnectionDialog dlg;
        boolean advancedPanel = false;
        boolean okPressed = false;

        public void showDialog(final ConnectionNodeInfo nfo, boolean showDialog) {
            String user = nfo.getUser();
            String pwd = nfo.getPassword();
            Boolean rpwd = (Boolean)nfo.get("rememberpwd");
            boolean remember = rpwd != null ? rpwd : false;
            final DatabaseConnection dbcon = nfo.getDatabaseConnection();
            ExceptionListener excListener = new ExceptionListener(){

                public void exceptionOccurred(Exception exc) {
                    if (exc instanceof DDLException) {
                        ErrorManager.getDefault().notify(1, exc.getCause());
                    } else {
                        ErrorManager.getDefault().notify(1, (Throwable)exc);
                    }
                    String message = null;
                    if (exc instanceof ClassNotFoundException) {
                        message = MessageFormat.format(DatabaseAction.bundle().getString("EXC_ClassNotFound"), exc.getMessage());
                    } else {
                        StringBuffer buffer = new StringBuffer();
                        buffer.append(MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToConnect"), exc.getMessage()));
                        if (exc instanceof DDLException && exc.getCause() instanceof SQLException) {
                            for (SQLException sqlEx = ((SQLException)exc.getCause()).getNextException(); sqlEx != null; sqlEx = sqlEx.getNextException()) {
                                buffer.append("\n\n" + sqlEx.getMessage());
                            }
                        }
                        message = buffer.toString();
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                }
            };
            dbcon.addExceptionListener(excListener);
            if (user == null || pwd == null || !remember) {
                final ConnectPanel basePanel = new ConnectPanel(this, dbcon);
                final SchemaPanel schemaPanel = new SchemaPanel(this, dbcon);
                PropertyChangeListener argumentListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getPropertyName().equals("argumentChanged")) {
                            schemaPanel.setSchemas(new Vector(), "");
                            schemaPanel.resetProgress();
                            try {
                                Connection conn = dbcon.getConnection();
                                if (conn != null && !conn.isClosed()) {
                                    conn.close();
                                }
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                        }
                    }
                };
                basePanel.addPropertyChangeListener(argumentListener);
                PropertyChangeListener connectionListener = new PropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        if (event.getPropertyName().equals("connecting")) {
                            ConnectionDialogDisplayer.this.fireConnectionStarted();
                        }
                        if (event.getPropertyName().equals("failed")) {
                            ConnectionDialogDisplayer.this.fireConnectionFailed();
                        }
                        if (event.getPropertyName().equals("connected")) {
                            if (ConnectionDialogDisplayer.this.advancedPanel && !ConnectionDialogDisplayer.this.okPressed) {
                                if (ConnectionDialogDisplayer.this.retrieveSchemas(schemaPanel, dbcon, nfo.getSchema())) {
                                    dbcon.setSchema(nfo.getSchema());
                                }
                                ConnectionDialogDisplayer.this.dlg.setSelectedComponent(schemaPanel);
                                ConnectionDialogDisplayer.this.fireConnectionFinished();
                                return;
                            }
                            ConnectionDialogDisplayer.this.fireConnectionFinished();
                            dbcon.setSchema(nfo.getSchema());
                            try {
                                nfo.finishConnect(null, dbcon, dbcon.getConnection());
                            }
                            catch (DatabaseException exc) {
                                ErrorManager.getDefault().notify(1, (Throwable)exc);
                                String message = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToInitializeConnection"), exc.getMessage());
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                                return;
                            }
                            DatabaseConnection realDbcon = ConnectionList.getDefault().getConnection(dbcon);
                            if (realDbcon != null) {
                                realDbcon.setPassword(dbcon.getPassword());
                            }
                            if (basePanel.rememberPassword()) {
                                nfo.put("rememberpwd", Boolean.TRUE);
                            }
                            if (ConnectionDialogDisplayer.this.dlg != null) {
                                ConnectionDialogDisplayer.this.dlg.close();
                            }
                        } else {
                            ConnectionDialogDisplayer.this.okPressed = false;
                        }
                    }
                };
                dbcon.addPropertyChangeListener(connectionListener);
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent event) {
                        if (event.getSource() == DialogDescriptor.OK_OPTION) {
                            block9: {
                                ConnectionDialogDisplayer.this.okPressed = true;
                                nfo.setUser(basePanel.getUser());
                                nfo.setPassword(basePanel.getPassword());
                                dbcon.setUser(basePanel.getUser());
                                dbcon.setPassword(basePanel.getPassword());
                                try {
                                    if (dbcon.getConnection() == null || dbcon.getConnection().isClosed()) {
                                        dbcon.connect();
                                        break block9;
                                    }
                                    dbcon.setSchema(schemaPanel.getSchema());
                                    nfo.setSchema(schemaPanel.getSchema());
                                    try {
                                        nfo.finishConnect(null, dbcon, dbcon.getConnection());
                                    }
                                    catch (DatabaseException exc) {
                                        ErrorManager.getDefault().notify(1, (Throwable)exc);
                                        String message = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToInitializeConnection"), exc.getMessage());
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                                        return;
                                    }
                                    DatabaseConnection realDbcon = ConnectionList.getDefault().getConnection(dbcon);
                                    if (realDbcon != null) {
                                        realDbcon.setPassword(dbcon.getPassword());
                                    }
                                    if (basePanel.rememberPassword()) {
                                        nfo.put("rememberpwd", Boolean.TRUE);
                                    }
                                    if (ConnectionDialogDisplayer.this.dlg != null) {
                                        ConnectionDialogDisplayer.this.dlg.close();
                                    }
                                }
                                catch (SQLException exc) {
                                    dbcon.connect();
                                }
                            }
                            return;
                        }
                    }
                };
                ChangeListener changeTabListener = new ChangeListener(){

                    public void stateChanged(ChangeEvent e) {
                        if (((JTabbedPane)e.getSource()).getSelectedComponent().equals(schemaPanel)) {
                            ConnectionDialogDisplayer.this.advancedPanel = true;
                            nfo.setUser(basePanel.getUser());
                            nfo.setPassword(basePanel.getPassword());
                            dbcon.setPassword(basePanel.getPassword());
                        } else {
                            ConnectionDialogDisplayer.this.advancedPanel = false;
                        }
                    }
                };
                this.dlg = new ConnectionDialog(this, basePanel, schemaPanel, basePanel.getTitle(), actionListener, changeTabListener);
                this.dlg.setVisible(true);
            } else {
                try {
                    DialogDescriptor descriptor = null;
                    ProgressHandle progress = null;
                    if (showDialog) {
                        progress = ProgressHandleFactory.createHandle((String)"handle");
                        JComponent progressComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progress);
                        progressComponent.setPreferredSize(new Dimension(250, 20));
                        ConnectProgressDialog panel = new ConnectProgressDialog();
                        panel.add(progressComponent);
                        descriptor = new DialogDescriptor((Object)panel, DatabaseAction.bundle().getString("ConnectDialogTitle"), true, new Object[]{DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.CANCEL_OPTION, 0, null, null);
                    }
                    final Dialog dialog = showDialog ? DialogDisplayer.getDefault().createDialog(descriptor) : null;
                    PropertyChangeListener connectionListener = new PropertyChangeListener(){

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public void propertyChange(PropertyChangeEvent event) {
                            if (event.getPropertyName().equals("connected")) {
                                try {
                                    nfo.finishConnect(null, dbcon, dbcon.getConnection());
                                    if (dialog == null) return;
                                    dialog.setVisible(false);
                                    return;
                                }
                                catch (DatabaseException exc) {
                                    ErrorManager.getDefault().notify(1, (Throwable)exc);
                                    String message = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToInitializeConnection"), exc.getMessage());
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                                    return;
                                }
                            } else {
                                if (!event.getPropertyName().equals("failed") || dialog == null) return;
                                dialog.setVisible(false);
                            }
                        }
                    };
                    dbcon.addPropertyChangeListener(connectionListener);
                    dbcon.connect();
                    if (showDialog) {
                        progress.start();
                        progress.switchToIndeterminate();
                        dialog.setVisible(true);
                        progress.finish();
                        dialog.dispose();
                    }
                }
                catch (Exception exc) {
                    String message = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableToConnect"), exc.getMessage());
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
                }
            }
        }

        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection dbcon, String defaultSchema) {
            this.fireConnectionStep(DatabaseAction.bundle().getString("ConnectionProgress_Schemas"));
            Vector<String> schemas = new Vector<String>();
            try {
                ResultSet rs = dbcon.getConnection().getMetaData().getSchemas();
                if (rs != null) {
                    while (rs.next()) {
                        schemas.add(rs.getString(1).trim());
                    }
                }
            }
            catch (SQLException exc) {
                String message = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableObtainSchemas"), exc.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
            return schemaPanel.setSchemas(schemas, defaultSchema);
        }
    }
}

