/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.DbURLClassLoader;
import org.openide.ErrorManager;

public class DbDriverManager {
    private static final ErrorManager LOGGER = ErrorManager.getDefault().getInstance("org.netbeans.modules.db.explorer.DbDriverManager");
    private static final boolean LOG = LOGGER.isLoggable(1);
    private static final DbDriverManager DEFAULT = new DbDriverManager();
    private Set registeredDrivers;
    private Map conn2Driver = new WeakHashMap();
    private Map driver2Loader = new WeakHashMap();

    private DbDriverManager() {
    }

    public static DbDriverManager getDefault() {
        return DEFAULT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(String databaseURL, Properties props, JDBCDriver jdbcDriver) throws SQLException {
        Driver driver;
        if (LOG) {
            LOGGER.log(1, "Attempting to connect to '" + databaseURL + "'");
        }
        if ((driver = this.getDriverInternal(databaseURL, jdbcDriver, false)) != null) {
            Connection conn = driver.connect(databaseURL, props);
            if (conn == null) {
                if (LOG) {
                    LOGGER.log(1, driver.getClass().getName() + ".connect() returned null");
                }
                throw this.createDriverNotFoundException();
            }
            Map map = this.conn2Driver;
            synchronized (map) {
                this.conn2Driver.put(conn, driver);
            }
            return conn;
        }
        try {
            Connection conn = DriverManager.getConnection(databaseURL, props);
            Map map = this.conn2Driver;
            synchronized (map) {
                this.conn2Driver.put(conn, driver);
            }
            return conn;
        }
        catch (SQLException e) {
            throw this.createDriverNotFoundException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getSameDriverConnection(Connection existingConn, String databaseURL, Properties props) throws SQLException {
        if (existingConn == null) {
            throw new NullPointerException();
        }
        Driver driver = null;
        Map map = this.conn2Driver;
        synchronized (map) {
            if (!this.conn2Driver.containsKey(existingConn)) {
                throw new IllegalArgumentException("A connection not obtained through DbDriverManager was passed.");
            }
            driver = (Driver)this.conn2Driver.get(existingConn);
        }
        if (driver != null) {
            Connection newConn = driver.connect(databaseURL, props);
            if (newConn == null) {
                throw new SQLException("Unable to connect using existingConn's original driver", "08001");
            }
            this.conn2Driver.put(newConn, driver);
            return newConn;
        }
        return DriverManager.getConnection(databaseURL, props);
    }

    public synchronized void registerDriver(Driver driver) {
        if (this.registeredDrivers == null) {
            this.registeredDrivers = new HashSet();
        }
        this.registeredDrivers.add(driver);
    }

    public synchronized void deregisterDriver(Driver driver) {
        if (this.registeredDrivers == null) {
            return;
        }
        this.registeredDrivers.remove(driver);
    }

    public Driver getDriver(String databaseURL, JDBCDriver jdbcDriver) throws SQLException {
        Driver d = this.getDriverInternal(databaseURL, jdbcDriver, true);
        if (d == null) {
            throw this.createDriverNotFoundException();
        }
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Driver getDriverInternal(String databaseURL, JDBCDriver jdbcDriver, boolean lookInDriverManager) throws SQLException {
        DbDriverManager dbDriverManager = this;
        synchronized (dbDriverManager) {
            if (this.registeredDrivers != null) {
                Iterator i = this.registeredDrivers.iterator();
                while (i.hasNext()) {
                    Driver d = (Driver)i.next();
                    try {
                        if (!d.acceptsURL(databaseURL)) continue;
                        return d;
                    }
                    catch (SQLException e) {
                    }
                }
            }
        }
        if (jdbcDriver != null) {
            ClassLoader l = this.getClassLoader(jdbcDriver);
            try {
                return (Driver)Class.forName(jdbcDriver.getClassName(), true, l).newInstance();
            }
            catch (Exception e) {
                SQLException sqlex = this.createDriverNotFoundException();
                sqlex.initCause(e);
                throw sqlex;
            }
        }
        if (lookInDriverManager) {
            try {
                return DriverManager.getDriver(databaseURL);
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getClassLoader(JDBCDriver driver) {
        ClassLoader loader = null;
        Map map = this.driver2Loader;
        synchronized (map) {
            loader = (ClassLoader)this.driver2Loader.get(driver);
            if (loader == null) {
                loader = new DbURLClassLoader(driver.getURLs());
                if (LOG) {
                    LOGGER.log(1, "Creating " + loader);
                }
                this.driver2Loader.put(driver, loader);
            } else if (LOG) {
                LOGGER.log(1, "Reusing " + loader);
            }
        }
        return loader;
    }

    private SQLException createDriverNotFoundException() {
        return new SQLException("Unable to find a suitable driver", "08001");
    }
}

