/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard.fromdb;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ChangeSupport {
    private final Object source;
    private List<ChangeListener> listeners = Collections.emptyList();

    public ChangeSupport(Object source) {
        this.source = source;
    }

    public synchronized void addChangeListener(ChangeListener listener) {
        LinkedList<ChangeListener> newListeners = new LinkedList<ChangeListener>(this.listeners);
        newListeners.add(listener);
        this.listeners = newListeners;
    }

    public synchronized void removeChangeListener(ChangeListener listener) {
        LinkedList<ChangeListener> newListeners = new LinkedList<ChangeListener>(this.listeners);
        newListeners.remove(listener);
        this.listeners = newListeners;
    }

    public void fireChange() {
        this.fireChange(new ChangeEvent(this.source));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChange(ChangeEvent event) {
        List<ChangeListener> listenersCopy;
        ChangeSupport changeSupport = this;
        synchronized (changeSupport) {
            listenersCopy = this.listeners;
        }
        for (ChangeListener listener : listenersCopy) {
            listener.stateChanged(event);
        }
    }

    public synchronized int getListenerCount() {
        return this.listeners.size();
    }
}

