/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.persistence.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.ORMMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.Persistence;
import org.netbeans.modules.j2ee.persistence.dd.persistence.model_1_0.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.EntityClosure;
import org.netbeans.modules.j2ee.persistence.wizard.Util;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ChangeSupport;
import org.netbeans.modules.j2ee.persistence.wizard.unit.PersistenceUnitWizardPanel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class PersistenceClientEntitySelectionVisual
extends JPanel {
    private WizardDescriptor wizard;
    private ChangeSupport changeSupport = new ChangeSupport(this);
    private Project project;
    boolean waitingForScan;
    boolean waitingForEntities;
    private List<EntityMappings> waitForMappings = new ArrayList<EntityMappings>();
    private PersistenceUnit persistenceUnit;
    private EntityClosure entityClosure;
    private JButton buttonAdd;
    private JButton buttonAddAll;
    private JButton buttonRemove;
    private JButton buttonRemoveAll;
    private JCheckBox cbAddRelated;
    private JButton createPUButton;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel labelAvailableEntities;
    private JLabel labelSelectedEntities;
    private JList listAvailable;
    private JList listSelected;
    private JPanel panelButtons;
    private static final EntityComparator ENTITY_COMPARATOR = new EntityComparator();
    private final ListCellRenderer ENTITY_LIST_RENDERER = new EntityListCellRenderer();

    public PersistenceClientEntitySelectionVisual(String name, WizardDescriptor wizard) {
        this.setName(name);
        this.wizard = wizard;
        this.initComponents();
        ListSelectionListener selectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                PersistenceClientEntitySelectionVisual.this.updateButtons();
            }
        };
        this.listAvailable.getSelectionModel().addListSelectionListener(selectionListener);
        this.listSelected.getSelectionModel().addListSelectionListener(selectionListener);
    }

    public PersistenceUnit getPersistenceUnit() {
        return this.persistenceUnit;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.listAvailable = new JList();
        this.jScrollPane2 = new JScrollPane();
        this.listSelected = new JList();
        this.cbAddRelated = new JCheckBox();
        this.labelAvailableEntities = new JLabel();
        this.panelButtons = new JPanel();
        this.buttonRemove = new JButton();
        this.buttonAdd = new JButton();
        this.buttonAddAll = new JButton();
        this.buttonRemoveAll = new JButton();
        this.labelSelectedEntities = new JLabel();
        this.createPUButton = new JButton();
        this.listAvailable.setCellRenderer(this.ENTITY_LIST_RENDERER);
        this.jScrollPane1.setViewportView(this.listAvailable);
        this.listAvailable.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("LBL_AvailableEntitiesList"));
        this.listAvailable.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("ACSD_AvailableEntitiesList"));
        this.listSelected.setCellRenderer(this.ENTITY_LIST_RENDERER);
        this.jScrollPane2.setViewportView(this.listSelected);
        this.listSelected.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("LBL_SelectedEntitiesList"));
        this.listSelected.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("ACSD_SelectedEntitiesList"));
        this.cbAddRelated.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_InludeRelated").charAt(0));
        this.cbAddRelated.setSelected(true);
        this.cbAddRelated.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("LBL_IncludeReferenced"));
        this.cbAddRelated.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbAddRelated.setMargin(new Insets(0, 0, 0, 0));
        this.cbAddRelated.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.cbAddRelatedActionPerformed(evt);
            }
        });
        this.cbAddRelated.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("LBL_IncludeReferencedCheckbox"));
        this.cbAddRelated.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("ACSD_IncludeReferencedCheckbox"));
        this.labelAvailableEntities.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("MNE_AvailableEntityClasses").charAt(0));
        this.labelAvailableEntities.setLabelFor(this.listAvailable);
        this.labelAvailableEntities.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("LBL_AvailableEntities"));
        this.buttonRemove.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_Remove").charAt(0));
        this.buttonRemove.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("LBL_Remove"));
        this.buttonRemove.setActionCommand("< &Remove");
        this.buttonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.buttonRemoveActionPerformed(evt);
            }
        });
        this.buttonAdd.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_Add").charAt(0));
        this.buttonAdd.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_Add"));
        this.buttonAdd.setActionCommand("&Add >");
        this.buttonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.buttonAddActionPerformed(evt);
            }
        });
        this.buttonAddAll.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_AddAll").charAt(0));
        this.buttonAddAll.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("LBL_AddAll"));
        this.buttonAddAll.setActionCommand("Add A&ll >>");
        this.buttonAddAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.buttonAddAllActionPerformed(evt);
            }
        });
        this.buttonRemoveAll.setMnemonic(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MNE_RemoveAll").charAt(0));
        this.buttonRemoveAll.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("LBL_RemoveAll"));
        this.buttonRemoveAll.setActionCommand("<< Re&moveAll");
        this.buttonRemoveAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.buttonRemoveAllActionPerformed(evt);
            }
        });
        GroupLayout panelButtonsLayout = new GroupLayout((Container)this.panelButtons);
        this.panelButtons.setLayout((LayoutManager)panelButtonsLayout);
        panelButtonsLayout.setHorizontalGroup((GroupLayout.Group)panelButtonsLayout.createParallelGroup(1).add((GroupLayout.Group)panelButtonsLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)panelButtonsLayout.createParallelGroup(1).add(2, (Component)this.buttonAdd, -1, 124, Short.MAX_VALUE).add(2, (Component)this.buttonRemove, -1, 124, Short.MAX_VALUE).add(2, (Component)this.buttonRemoveAll, -1, 124, Short.MAX_VALUE).add(2, (Component)this.buttonAddAll, -1, 124, Short.MAX_VALUE)).addContainerGap()));
        panelButtonsLayout.setVerticalGroup((GroupLayout.Group)panelButtonsLayout.createParallelGroup(1).add((GroupLayout.Group)panelButtonsLayout.createSequentialGroup().add(67, 67, 67).add((Component)this.buttonAdd).addPreferredGap(0).add((Component)this.buttonRemove).add(20, 20, 20).add((Component)this.buttonAddAll).addPreferredGap(0).add((Component)this.buttonRemoveAll).addContainerGap(103, Short.MAX_VALUE)));
        this.labelSelectedEntities.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("MNE_SelectedEntityClasses").charAt(0));
        this.labelSelectedEntities.setLabelFor(this.listSelected);
        this.labelSelectedEntities.setText(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("LBL_SelectedEntities"));
        this.createPUButton.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("MNE_CreatePersistenceUnit").charAt(0));
        this.createPUButton.setText(NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"LBL_CreatePersistenceUnit"));
        this.createPUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PersistenceClientEntitySelectionVisual.this.createPUButtonActionPerformed(evt);
            }
        });
        this.createPUButton.getAccessibleContext().setAccessibleName(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("LBL_CreatePersistenceUnitButton"));
        this.createPUButton.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/j2ee/persistence/wizard/Bundle").getString("ACSD_CreatePersistenceUnitButton"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.labelAvailableEntities).add((Component)this.jScrollPane1, -1, 206, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.panelButtons, -2, -1, -2).add(0, 0, 0)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.createPUButton).addPreferredGap(0))).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.cbAddRelated).add((Component)this.labelSelectedEntities).add((Component)this.jScrollPane2, -1, 198, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.labelSelectedEntities).add((Component)this.labelAvailableEntities)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 294, Short.MAX_VALUE).add((Component)this.panelButtons, -1, -1, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 294, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.cbAddRelated).add(31, 31, 31)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.createPUButton).addContainerGap()))));
    }

    private void cbAddRelatedActionPerformed(ActionEvent evt) {
        this.listSelected.clearSelection();
        this.listAvailable.clearSelection();
        this.entityClosure.setClosureEnabled(this.cbAddRelated.isSelected());
        this.changeSupport.fireChange();
    }

    private void createPUButtonActionPerformed(ActionEvent evt) {
        this.persistenceUnit = Util.buildPersistenceUnitUsingWizard(this.project, null, PersistenceUnitWizardPanel.TableGeneration.CREATE);
        if (this.persistenceUnit != null) {
            this.updatePersistenceUnitButton();
            this.waitForMappings.add(PersistenceUtils.getAnnotationEntityMappings(this.project));
            this.changeSupport.fireChange();
        }
    }

    private void buttonRemoveAllActionPerformed(ActionEvent evt) {
        this.entityClosure.removeAllEntities();
        this.listSelected.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void buttonAddAllActionPerformed(ActionEvent evt) {
        this.entityClosure.addAllEntities();
        this.listAvailable.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void buttonRemoveActionPerformed(ActionEvent evt) {
        Object[] selected = this.listSelected.getSelectedValues();
        HashSet<Entity> sel = new HashSet<Entity>();
        for (int i = 0; i < selected.length; ++i) {
            sel.add((Entity)((Object)selected[i]));
        }
        this.entityClosure.removeEntities(sel);
        this.listSelected.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    private void buttonAddActionPerformed(ActionEvent evt) {
        Object[] selected = this.listAvailable.getSelectedValues();
        HashSet<Entity> sel = new HashSet<Entity>();
        for (int i = 0; i < selected.length; ++i) {
            sel.add((Entity)((Object)selected[i]));
        }
        this.entityClosure.addEntities(sel);
        this.listAvailable.clearSelection();
        this.updateButtons();
        this.changeSupport.fireChange();
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean valid(WizardDescriptor wizard) {
        if (this.createPUButton.isVisible()) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"ERR_NoPersistenceUnit"));
            return false;
        }
        if (JavaMetamodel.getManager().isScanInProgress()) {
            if (!this.waitingForScan) {
                this.waitingForScan = true;
                RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

                    public void run() {
                        JavaMetamodel.getManager().waitScanFinished();
                        PersistenceClientEntitySelectionVisual.this.waitingForScan = false;
                        PersistenceClientEntitySelectionVisual.this.changeSupport.fireChange();
                        PersistenceClientEntitySelectionVisual.this.updateButtons();
                    }
                });
                wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"scanning-in-progress"));
                task.schedule(0);
            }
            return false;
        }
        if (ORMMetadata.getDefault().isScanInProgress()) {
            if (!this.waitingForEntities) {
                this.waitingForEntities = true;
                RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        ORMMetadata.getDefault().waitScanFinished();
                        9 var1_1 = this;
                        synchronized (var1_1) {
                            PersistenceClientEntitySelectionVisual.this.entityClosure.addAvaliableEntities(PersistenceUtils.getEntityClasses(PersistenceClientEntitySelectionVisual.this.waitForMappings));
                            PersistenceClientEntitySelectionVisual.this.waitForMappings.clear();
                        }
                        PersistenceClientEntitySelectionVisual.this.waitingForEntities = false;
                        PersistenceClientEntitySelectionVisual.this.changeSupport.fireChange();
                        PersistenceClientEntitySelectionVisual.this.updateButtons();
                    }
                });
                wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"scanning-in-progress"));
                task.schedule(0);
            }
            return false;
        }
        PersistenceClientEntitySelectionVisual persistenceClientEntitySelectionVisual = this;
        synchronized (persistenceClientEntitySelectionVisual) {
            if (this.waitForMappings.size() > 0) {
                this.entityClosure.addAvaliableEntities(PersistenceUtils.getEntityClasses(this.waitForMappings));
                this.waitForMappings.clear();
                this.updateButtons();
            }
        }
        if (this.listSelected.getModel().getSize() == 0) {
            wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PersistenceClientEntitySelectionVisual.class, (String)"MSG_NoEntityClassesSelected"));
            return false;
        }
        wizard.putProperty("WizardPanel_errorMessage", (Object)" ");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void read(WizardDescriptor settings) {
        this.project = Templates.getProject((WizardDescriptor)settings);
        try {
            PersistenceClientEntitySelectionVisual persistenceClientEntitySelectionVisual = this;
            synchronized (persistenceClientEntitySelectionVisual) {
                this.waitForMappings.clear();
                if (this.getPersistenceUnit() == null) {
                    this.waitForMappings.addAll(PersistenceUtils.getEntityMappings(this.project));
                } else {
                    this.waitForMappings.add(PersistenceUtils.getAnnotationEntityMappings(this.project));
                }
            }
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        this.entityClosure = new EntityClosure(Collections.<Entity>emptySet());
        this.entityClosure.setClosureEnabled(this.cbAddRelated.isSelected());
        this.listAvailable.setModel(new EntityListModel(this.entityClosure, true));
        this.listSelected.setModel(new EntityListModel(this.entityClosure, false));
        ArrayList entites = (ArrayList)settings.getProperty("EntityClass");
        if (entites == null) {
            entites = new ArrayList();
        }
        this.entityClosure.addEntities(new HashSet<Entity>(entites));
        this.updateButtons();
        this.updatePersistenceUnitButton();
    }

    void store(WizardDescriptor settings) {
        ListModel model = this.listSelected.getModel();
        if (model instanceof EntityListModel) {
            EntityListModel elm = (EntityListModel)model;
            settings.putProperty("EntityClass", elm.getEntityClasses());
        }
    }

    private void updateButtons() {
        this.buttonAdd.setEnabled(this.listAvailable.getSelectedValues().length > 0);
        this.buttonAddAll.setEnabled(this.entityClosure.getAvailableEntities().size() > 0);
        this.buttonRemove.setEnabled(this.listSelected.getSelectedValues().length > 0);
        this.buttonRemoveAll.setEnabled(this.entityClosure.getSelectedEntities().size() > 0);
    }

    public void updatePersistenceUnitButton() {
        boolean visible;
        boolean bl = visible = this.getPersistenceUnit() == null;
        if (ProviderUtil.isValidServerInstanceOrNone(this.project) && visible) {
            PersistenceScope[] scopes = PersistenceUtils.getPersistenceScopes(this.project);
            for (int i = 0; i < scopes.length; ++i) {
                FileObject persistenceXml = scopes[i].getPersistenceXml();
                if (persistenceXml == null) continue;
                try {
                    Persistence persistence = PersistenceMetadata.getDefault().getRoot(persistenceXml);
                    if (persistence.getPersistenceUnit().length <= 0) continue;
                    visible = false;
                    break;
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        this.createPUButton.setVisible(visible);
    }

    private final class EntityListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public EntityListCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = null;
            if (value instanceof Entity) {
                text = ((Entity)((Object)value)).getClass2();
                if (text != null) {
                    String simpleName = Util.simpleClassName(text);
                    String packageName = text.length() > simpleName.length() ? text.substring(0, text.length() - simpleName.length() - 1) : "<default package>";
                    text = simpleName + " (" + packageName + ")";
                } else {
                    ErrorManager.getDefault().log(1, "Entity:" + value + " returns null from getClass2(); see IZ 80024");
                }
            }
            if (text == null) {
                text = value.toString();
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(PersistenceClientEntitySelectionVisual.this.entityClosure.getAvailableEntities().contains(value) || PersistenceClientEntitySelectionVisual.this.entityClosure.getWantedEntities().contains(value));
            this.setFont(list.getFont());
            this.setText(text);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntityListModel
    extends AbstractListModel
    implements ChangeListener {
        private EntityClosure entityClosure;
        private List<Entity> entities = new ArrayList<Entity>();
        private boolean available;

        EntityListModel(EntityClosure entityClosure, boolean available) {
            this.entityClosure = entityClosure;
            this.available = available;
            entityClosure.addChangeListener(this);
            this.refresh();
        }

        @Override
        public int getSize() {
            return this.entities.size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.entities.get(index);
        }

        public List<Entity> getEntityClasses() {
            return this.entities;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.refresh();
        }

        private void refresh() {
            int oldSize = this.getSize();
            this.entities = new ArrayList<Entity>(this.available ? this.entityClosure.getAvailableEntities() : this.entityClosure.getSelectedEntities());
            Collections.sort(this.entities, ENTITY_COMPARATOR);
            this.fireContentsChanged(this, 0, Math.max(oldSize, this.getSize()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EntityComparator
    implements Comparator<Entity> {
        private EntityComparator() {
        }

        @Override
        public int compare(Entity o1, Entity o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }
}

