/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.config.Configuration;
import com.sun.xml.rpc.processor.generator.GeneratorBase;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.generator.GeneratorUtil;
import com.sun.xml.rpc.processor.generator.LiteralEncoding;
import com.sun.xml.rpc.processor.generator.Names;
import com.sun.xml.rpc.processor.generator.SOAPEncoding;
import com.sun.xml.rpc.processor.generator.SimpleToBoxedUtil;
import com.sun.xml.rpc.processor.generator.writer.SerializerWriter;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.HeaderFault;
import com.sun.xml.rpc.processor.model.Message;
import com.sun.xml.rpc.processor.model.Model;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Parameter;
import com.sun.xml.rpc.processor.model.Port;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaStructureType;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPArrayType;
import com.sun.xml.rpc.processor.model.soap.SOAPEnumerationType;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureMember;
import com.sun.xml.rpc.processor.model.soap.SOAPStructureType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.IndentingWriter;
import com.sun.xml.rpc.soap.SOAPConstantsFactory;
import com.sun.xml.rpc.soap.SOAPEncodingConstants;
import com.sun.xml.rpc.soap.SOAPNamespaceConstants;
import com.sun.xml.rpc.soap.SOAPVersion;
import com.sun.xml.rpc.soap.SOAPWSDLConstants;
import com.sun.xml.rpc.wsdl.document.soap.SOAPStyle;
import com.sun.xml.rpc.wsdl.document.soap.SOAPUse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public abstract class StubTieGeneratorBase
extends GeneratorBase {
    protected Port port;
    protected HashSet operations = null;
    protected Set types;
    protected Map portTypes;
    private String prefix;
    protected File srcFile;
    protected SOAPVersion soapVer = SOAPVersion.SOAP_11;
    protected SOAPEncodingConstants soapEncodingConstants = null;
    protected SOAPNamespaceConstants soapNamespaceConstants = null;
    protected SOAPWSDLConstants soapWSDLConstants = null;
    private boolean genAddAttachmentMethod = false;
    private boolean genGetAttachmentMethod = false;

    public StubTieGeneratorBase() {
        this(SOAPVersion.SOAP_11);
    }

    private void closeSrcFile() throws IOException {
        if (this.out != null) {
            this.out.pOln("}");
            this.out.close();
            this.out = null;
        }
    }

    protected void writeClass() {
        String remoteClassName = this.port.getJavaInterface().getName();
        String className = this.getClassName();
        if (this.donotOverride && GeneratorUtil.classExists(this.env, className)) {
            this.log("Class " + className + " exists. Not overriding.");
            return;
        }
        this.srcFile = this.env.getNames().sourceFileForClass(className, className, this.sourceDir, this.env);
        try {
            this.out = new IndentingWriter(new OutputStreamWriter(new FileOutputStream(this.srcFile)));
            this.writePackage(this.out, className);
            this.writeImports(this.out);
            this.out.pln();
            this.writeClassDecl(this.out, className);
            this.out.pln();
            this.writeStatic(this.out);
            this.out.pln();
            this.writeConstructor(this.out, className);
            this.out.pln();
            this.writeOperations(this.out, remoteClassName);
            this.out.pln();
            this.writePeekFirstBodyElementMethod(this.out);
            this.out.pln();
            this.writeReadFirstBodyElement(this.out);
            this.out.pln();
            Map headerMap = this.writeReadHeaderElementMethod(this.out);
            this.out.pln();
            this.writeHeaderDeserializeMethods(this.out, headerMap.values().iterator());
            this.out.pln();
            this.writeOperationDeserializeMethods(this.out);
            this.out.pln();
            this.writeReadBodyFaultElement(this.out);
            this.out.pln();
            this.writeProcessingHookMethod(this.out);
            this.out.pln();
            this.writeGenericMethods(this.out);
            this.out.pln();
            this.writeUsesSOAPActionForDispatching(this.out);
            this.out.pln();
            this.writeGetOpcodeForFirstBodyElementName(this.out);
            this.out.pln();
            this.writeGetOpcodeForSOAPAction(this.out);
            this.out.pln();
            this.writeGetMethodForOpcode(this.out);
            this.out.pln();
            this.writeGetNamespaceDeclarationsMethod(this.out);
            this.out.pln();
            this.writeGetUnderstoodHeadersMethod(this.out);
            this.out.pln();
            if (this.genAddAttachmentMethod) {
                this.writeAddAttachmentMethod(this.out);
                this.out.pln();
            }
            if (this.genGetAttachmentMethod) {
                this.writeGetAttachmentMethod(this.out);
                this.out.pln();
            }
            this.writeHooks(this.out);
            this.writeAttachmentHooks(this.out);
            this.writeInitialize(this.out);
            this.out.pln();
            this.writeStaticMembers(this.out, headerMap);
            this.out.pln();
            this.writeUnderstoodHeadersMember(this.out, headerMap);
            this.closeSrcFile();
        }
        catch (IOException e) {
            GeneratorBase.fail("generator.cant.write", this.port.getName().getLocalPart());
        }
        catch (ClassNotFoundException c) {
            GeneratorBase.fail("generator.cant.find Class");
        }
    }

    protected boolean getAddAttachmentMethodFlag() {
        return this.genAddAttachmentMethod;
    }

    protected boolean getGetAttachmentMethodFlag() {
        return this.genGetAttachmentMethod;
    }

    protected abstract boolean superClassHasInitialize();

    protected void setAddAttachmentMethodFlag(boolean value) {
        this.genAddAttachmentMethod = value;
    }

    protected void setGetAttachmentMethodFlag(boolean value) {
        this.genGetAttachmentMethod = value;
    }

    private void registerType(AbstractType type) {
        this.types.add(type);
    }

    private boolean isRegistered(AbstractType type) {
        return this.types.contains(type);
    }

    private void registerBlock(Block block) {
        String key = null;
        if (block.getType().isSOAPType()) {
            key = block.getType().getJavaType().getRealName();
        } else if (block.getType().isLiteralType()) {
            key = block.getType().getName().toString() + block.getType().getJavaType().getRealName();
        }
        if (!this.portTypes.containsKey(key)) {
            this.portTypes.put(key, block);
        }
    }

    protected void requestBodyBlock(Block block) throws Exception {
        this.registerBlock(block);
    }

    protected void requestHeaderBlock(Block block) throws Exception {
        this.registerBlock(block);
    }

    protected void responseBodyBlock(Block block) throws Exception {
        this.registerBlock(block);
    }

    protected void responseHeaderBlock(Block block) throws Exception {
        this.registerBlock(block);
    }

    protected void postVisitModel(Model model) throws Exception {
        this.types = null;
    }

    protected void preVisitModel(Model model) throws Exception {
        this.types = new HashSet();
    }

    protected void postVisitOperation(Operation operation) throws Exception {
        this.operations.add(operation);
    }

    protected boolean needsReadFirstBodyElementFor(Operation operation) {
        return true;
    }

    protected void postVisitPort(Port port) throws Exception {
        this.writeClass();
        this.port = null;
        this.portTypes = null;
        this.operations = null;
        super.postVisitPort(port);
    }

    protected void preVisitPort(Port port) throws Exception {
        super.preVisitPort(port);
        this.operations = new HashSet();
        this.portTypes = new HashMap();
        this.port = port;
    }

    protected void preVisitLiteralFragmentType(LiteralFragmentType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    protected void preVisitSOAPArrayType(SOAPArrayType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    protected void preVisitSOAPEnumerationType(SOAPEnumerationType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    protected void preVisitSOAPStructureType(SOAPStructureType type) throws Exception {
        if (this.isRegistered(type)) {
            return;
        }
        this.registerType(type);
    }

    protected void writeAddAttachmentMethod(IndentingWriter p) throws IOException {
        p.plnI("private void addAttachment(javax.xml.soap.SOAPMessage message, Object value, java.lang.String mimeType, java.lang.String part) throws Exception{");
        p.pln("java.lang.String contentId = java.net.URLEncoder.encode(part, \"UTF-8\")+\"=\"+com.sun.xml.rpc.util.JAXRPCUtils.getUUID()+\"@jaxrpc.sun.com\";");
        p.pln("javax.xml.soap.AttachmentPart _attPart = null;");
        p.plnI("if(value == null || mimeType == null) {");
        p.pln("return;");
        p.pOln("}");
        p.plnI("if(value instanceof javax.activation.DataHandler) {");
        p.pln("_attPart = message.createAttachmentPart((javax.activation.DataHandler)value);");
        p.pOln("}");
        p.plnI("else if(value instanceof javax.mail.internet.MimeMultipart) {");
        p.pln("java.lang.String contentType = ((javax.mail.internet.MimeMultipart) value).getContentType();");
        p.pln("javax.activation.DataHandler dataHandler = new javax.activation.DataHandler(value, contentType);");
        p.pln("_attPart = message.createAttachmentPart(dataHandler);");
        p.pOln("}");
        p.plnI("else {");
        p.pln("_attPart = message.createAttachmentPart(value, mimeType);");
        p.pOln("}");
        p.pln("_attPart.setContentId(\"<\"+contentId+\">\");");
        p.pln("message.addAttachmentPart(_attPart);");
        p.pOln("}");
    }

    protected void writeAttachmentHooks(IndentingWriter p) throws IOException {
    }

    public void writeGenericMethods(IndentingWriter p) throws IOException {
        this.writeGetDefaultEnvelopeEncodingStyle(p);
        p.pln();
        p.plnI("public java.lang.String " + this.prefix + "getImplicitEnvelopeEncodingStyle() {");
        p.pln("return \"\";");
        p.pOln("}");
    }

    protected void writeGetAttachmentMethod(IndentingWriter p) throws IOException {
        p.plnI("private Object getAttachment(javax.xml.soap.SOAPMessage message, java.lang.String[] mimeTypes, java.lang.String partName, boolean isDataHandler) throws Exception{");
        p.pln("javax.xml.soap.AttachmentPart _attPart = null;");
        p.plnI("for(int i = 0; i < mimeTypes.length; i++) {");
        p.pln("java.lang.String mimeType = mimeTypes[i];");
        p.pln("javax.xml.soap.MimeHeaders mimeHeaders = new javax.xml.soap.MimeHeaders();");
        p.pln("mimeHeaders.addHeader(\"Content-Type\", mimeType);");
        p.pln("java.util.Iterator attachments = null;");
        p.plnI("if(mimeType.endsWith(\"/*\") || mimeType.startsWith(\"multipart/\")) {");
        p.pln("attachments = message.getAttachments();");
        p.pOln("}");
        p.plnI("else {");
        p.pln("attachments = message.getAttachments(mimeHeaders);");
        p.pOln("}");
        p.plnI("if(attachments == null) {");
        p.pln("continue;");
        p.pOln("}");
        p.plnI("while (attachments.hasNext()) {");
        p.pln("_attPart = (javax.xml.soap.AttachmentPart)attachments.next();");
        p.pln("java.lang.String cId = _attPart.getContentId();");
        p.pln("int index = cId.lastIndexOf('@', cId.length());");
        p.plnI("if(index == -1){");
        p.pln("continue;");
        p.pOln("}");
        p.pln("java.lang.String localPart = cId.substring(0, index);");
        p.pln("index = localPart.lastIndexOf('=', localPart.length());");
        p.plnI("if(index == -1){");
        p.pln("continue;");
        p.pOln("}");
        p.pln("java.lang.String part = java.net.URLDecoder.decode(localPart.substring(0, index), \"UTF-8\");");
        p.plnI("if(part.equals(partName) || part.equals(\"<\"+partName)) {");
        p.plnI("if(isDataHandler) {");
        p.pln("return _attPart.getDataHandler();");
        p.pOln("}");
        p.plnI("else {");
        p.pln("return _attPart.getContent();");
        p.pOln("}");
        p.pOln("}");
        p.pOln("}");
        p.pOln("}");
        p.pln("throw new DeserializationException(\"soap.missing.attachment.for.id\", partName);");
        p.pOln("}");
    }

    protected void writeGetDefaultEnvelopeEncodingStyle(IndentingWriter p) throws IOException {
        boolean useLiteral = false;
        Iterator iter = this.operations.iterator();
        while (iter.hasNext()) {
            Operation operation = (Operation)iter.next();
            if (operation.getRequest().isBodyEncoded()) continue;
            useLiteral = true;
            break;
        }
        if (useLiteral) {
            p.plnI("protected java.lang.String " + this.prefix + "getDefaultEnvelopeEncodingStyle() {");
            p.pln("return null;");
            p.pOln("}");
        } else {
            p.plnI("public java.lang.String " + this.prefix + "getDefaultEnvelopeEncodingStyle() {");
            p.pln("return " + this.getEncodingStyle() + ";");
            p.pOln("}");
        }
    }

    protected void writeGetMethodForOpcode(IndentingWriter p) throws IOException, ClassNotFoundException {
    }

    private void writeGetNamespaceDeclarationsMethod(IndentingWriter p) throws IOException {
        p.pln("/*");
        p.pln(" * This method returns an array containing (prefix, nsURI) pairs.");
        p.pln(" */");
        p.plnI("protected java.lang.String[] " + this.prefix + "getNamespaceDeclarations() {");
        p.pln("return myNamespace_declarations;");
        p.pOln("}");
    }

    protected void writeGetOpcodeForFirstBodyElementName(IndentingWriter p) throws IOException {
    }

    protected void writeGetOpcodeForSOAPAction(IndentingWriter p) throws IOException {
    }

    protected void writeGetUnderstoodHeadersMethod(IndentingWriter p) throws IOException {
        p.pln("/*");
        p.pln(" * This method returns an array containing the names of the headers we understand.");
        p.pln(" */");
        p.plnI("public javax.xml.namespace.QName[] " + this.prefix + "getUnderstoodHeaders() {");
        p.pln("return understoodHeaderNames;");
        p.pOln("}");
    }

    protected void writeHooks(IndentingWriter p) throws IOException {
    }

    protected void writeImports(IndentingWriter p) throws IOException {
        p.pln("import com.sun.xml.rpc.server.http.MessageContextProperties;");
        p.pln("import com.sun.xml.rpc.streaming.*;");
        p.pln("import com.sun.xml.rpc.encoding.*;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAPConstants;");
        p.pln("import com.sun.xml.rpc.encoding.soap.SOAP12Constants;");
        p.pln("import com.sun.xml.rpc.encoding.literal.*;");
        p.pln("import com.sun.xml.rpc.soap.streaming.*;");
        p.pln("import com.sun.xml.rpc.soap.message.*;");
        p.pln("import com.sun.xml.rpc.soap.SOAPVersion;");
        p.pln("import com.sun.xml.rpc.soap.SOAPEncodingConstants;");
        p.pln("import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;");
        p.pln("import javax.xml.namespace.QName;");
        p.pln("import java.rmi.RemoteException;");
        p.pln("import java.util.Iterator;");
        p.pln("import java.lang.reflect.*;");
        p.pln("import java.lang.Class;");
    }

    protected void writeInitialize(IndentingWriter p) throws IOException {
        AbstractType type;
        Iterator types = this.portTypes.entrySet().iterator();
        String access = this.getInitializeAccess();
        p.plnI(access + " void " + this.prefix + "initialize(InternalTypeMappingRegistry registry) throws Exception {");
        if (this.superClassHasInitialize()) {
            p.pln("super." + this.prefix + "initialize(registry);");
        }
        while (types.hasNext()) {
            Map.Entry entry = types.next();
            Block block = (Block)entry.getValue();
            type = block.getType();
            SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, type);
            writer.initializeSerializer(p, this.env.getNames().getTypeQName(type.getName()), "registry");
        }
        Iterator operationsIter = this.operations.iterator();
        int i = 0;
        while (operationsIter.hasNext()) {
            Operation operation = (Operation)operationsIter.next();
            if (operation.getFaults().hasNext()) {
                String serName = this.env.getNames().getClassMemberName(this.env.getNames().faultSerializerClassName(this.servicePackage, this.port, operation));
                p.pln("((Initializable)" + serName + ").initialize(registry);");
            }
            Iterator iter = operation.getFaults();
            while (iter.hasNext()) {
                Fault fault = (Fault)iter.next();
                if (!(fault instanceof HeaderFault)) continue;
                type = fault.getBlock().getType();
                SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, type);
                writer.initializeSerializer(p, this.env.getNames().getTypeQName(type.getName()), "registry");
            }
            ++i;
        }
        p.pOln("}");
    }

    private void writeOperationDeserializeMethods(IndentingWriter p) throws IOException {
        Iterator operationsIter = this.operations.iterator();
        int i = 0;
        while (operationsIter.hasNext()) {
            if (i > 0) {
                p.pln();
            }
            Operation operation = (Operation)operationsIter.next();
            this.writeOperationDeserializeMethod(p, operation);
            ++i;
        }
    }

    protected void writePeekFirstBodyElementMethod(IndentingWriter p) throws IOException {
    }

    protected void writeProcessingHookMethod(IndentingWriter p) throws IOException {
    }

    protected void writeReadBodyFaultElement(IndentingWriter p) throws IOException {
    }

    protected void writeReadFirstBodyElement(IndentingWriter p) throws IOException {
        Operation operationWithEmptyBody = null;
        String stateType = this.getStateType();
        p.pln("/*");
        p.pln(" *  this method deserializes the request/response structure in the body");
        p.pln(" */");
        p.plnI("protected void " + this.prefix + "readFirstBodyElement(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, " + stateType + "  state) throws Exception {");
        p.pln("int opcode = state.getRequest().getOperationCode();");
        p.plnI("switch (opcode) {");
        Iterator operationsIter = this.operations.iterator();
        while (operationsIter.hasNext()) {
            Operation operation = (Operation)operationsIter.next();
            if (!this.needsReadFirstBodyElementFor(operation)) continue;
            p.plnI("case " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + ":");
            p.pln(this.prefix + "deserialize_" + this.env.getNames().validInternalJavaIdentifier(operation.getUniqueName()) + "(bodyReader, deserializationContext, state);");
            p.pln("break;");
            p.pO();
            if (operationWithEmptyBody != null) continue;
            operationWithEmptyBody = this.operationHasEmptyBody(operation);
        }
        p.plnI("default:");
        this.writeReadFirstBodyElementDefault(p, "opcode");
        p.pO();
        p.pOln("}");
        p.pOln("}");
        if (operationWithEmptyBody != null) {
            this.writeHandleEmptyBody(p, operationWithEmptyBody);
        }
    }

    protected void writeStatic(IndentingWriter p) throws IOException {
    }

    protected void writeUsesSOAPActionForDispatching(IndentingWriter p) throws IOException {
    }

    public StubTieGeneratorBase(SOAPVersion ver) {
        this.init(ver);
    }

    private void init(SOAPVersion ver) {
        this.soapEncodingConstants = SOAPConstantsFactory.getSOAPEncodingConstants(ver);
        this.soapNamespaceConstants = SOAPConstantsFactory.getSOAPNamespaceConstants(ver);
        this.soapWSDLConstants = SOAPConstantsFactory.getSOAPWSDLConstants(ver);
        this.soapVer = ver;
    }

    protected abstract String getClassName();

    public String getEncodingStyle() {
        if (this.port.getSOAPVersion().equals(SOAPVersion.SOAP_12.toString())) {
            return "SOAP12NamespaceConstants.ENCODING";
        }
        return "SOAPNamespaceConstants.ENCODING";
    }

    protected abstract String getInitializeAccess();

    protected String getPrefix() {
        return "";
    }

    protected abstract String getStateGetRequestResponseString();

    protected abstract String getStateType();

    private void writeHeaderDeserializeMethod(IndentingWriter p, Block header) throws IOException {
        String javaType = header.getType().getJavaType().getName();
        String serializer = this.writerFactory.createWriter(this.servicePackage, header.getType()).serializerMemberName();
        String qname = this.env.getNames().getBlockQNameName(null, header);
        String uname = this.env.getNames().getBlockUniqueName(null, header);
        String stateType = this.getStateType();
        p.pln("/*");
        p.pln(" *  This method does the actual deserialization for the header: " + header.getName().getLocalPart() + ".");
        p.pln(" */");
        p.plnI("private void " + this.prefix + "deserialize_" + uname + "(SOAPHeaderBlockInfo headerInfo, XMLReader bodyReader, SOAPDeserializationContext deserializationContext, " + stateType + " state) throws Exception {");
        p.pln("QName elementName = bodyReader.getName();");
        p.plnI("if (elementName.equals(" + qname + ")) {");
        String boxName = null;
        boxName = SimpleToBoxedUtil.isPrimitive(javaType) ? SimpleToBoxedUtil.getBoxedClassName(javaType) : javaType;
        p.plnI(boxName + " obj =");
        p.pln("(" + boxName + ")" + serializer + ".deserialize(" + qname + ", bodyReader, deserializationContext);");
        p.pOln("headerInfo.setValue(obj);");
        p.pln("state." + this.getStateGetRequestResponseString() + "().add(headerInfo);");
        p.pOlnI("} else {");
        p.pln("// the QName of the header is not what we expected and not a fault either");
        p.pln("throw new SOAPProtocolViolationException(\"soap.unexpectedHeaderBlock\", elementName.getLocalPart());");
        p.pOln("}");
        p.pOln("}");
    }

    protected abstract Message getMessageToDeserialize(Operation var1);

    protected Operation operationHasEmptyBody(Operation operation) {
        return null;
    }

    protected void writeHandleEmptyBody(IndentingWriter p, Operation operation) throws IOException {
    }

    private void writeOperationDeserializeMethod(IndentingWriter p, Operation operation) throws IOException {
        String stateType = this.getStateType();
        String messageName = operation.getName().getLocalPart();
        Message message = this.getMessageToDeserialize(operation);
        if (message == null) {
            return;
        }
        p.pln("/*");
        p.pln(" * This method deserializes the body of the " + messageName + " operation.");
        p.pln(" */");
        p.plnI("private void " + this.prefix + "deserialize_" + this.env.getNames().validInternalJavaIdentifier(operation.getUniqueName()) + "(XMLReader bodyReader, SOAPDeserializationContext deserializationContext, " + stateType + " state) throws Exception {");
        if (!message.getBodyBlocks().hasNext()) {
            p.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(null);");
            p.pln("state." + this.getStateGetRequestResponseString() + "().setBody(bodyBlock);");
        } else {
            Block bodyBlock = (Block)message.getBodyBlocks().next();
            AbstractType type = bodyBlock.getType();
            String objName = this.env.getNames().getTypeMemberName(type.getJavaType());
            SerializerWriter writer = this.writerFactory.createWriter(this.servicePackage, type);
            String serializer = writer.serializerMemberName();
            p.plnI("java.lang.Object " + objName + "Obj =");
            p.plnI(serializer + ".deserialize(" + this.env.getNames().getBlockQNameName(operation, bodyBlock) + ",");
            p.pln("bodyReader, deserializationContext);");
            p.pO();
            p.pO();
            objName = this.env.getNames().getTypeMemberName(type.getJavaType()) + "Obj";
            p.pln();
            p.pln("SOAPBlockInfo bodyBlock = new SOAPBlockInfo(" + this.env.getNames().getBlockQNameName(operation, bodyBlock) + ");");
            p.pln("bodyBlock.setValue(" + objName + ");");
            p.pln("state." + this.getStateGetRequestResponseString() + "().setBody(bodyBlock);");
        }
        p.pOln("}");
    }

    public static JavaStructureMember getJavaMember(Parameter parameter) {
        Block block = parameter.getBlock();
        JavaType type = block.getType().getJavaType();
        JavaStructureMember member = null;
        if (type instanceof JavaStructureType) {
            member = ((JavaStructureType)type).getMemberByName(parameter.getName());
            return member;
        }
        return null;
    }

    protected void writeClassDecl(IndentingWriter p, String className) throws IOException {
        p.pln("public class " + Names.stripQualifier(className));
        p.pln(" {");
        p.pln();
    }

    protected void writeConstructor(IndentingWriter p, String stubClassName) throws IOException {
        p.pln("/*");
        p.pln(" *  public constructor");
        p.pln(" */");
        p.plnI("public " + Names.stripQualifier(stubClassName) + "() {");
        p.pOln("}");
    }

    protected void writeOperations(IndentingWriter p, String remoteClassName) throws IOException {
        Iterator iter = this.operations.iterator();
        int i = 0;
        while (iter.hasNext()) {
            Operation operation;
            if (i > 0) {
                p.pln();
            }
            if ((operation = (Operation)iter.next()).getStyle() == SOAPStyle.DOCUMENT) {
                this.writeDocumentLiteralOperation(p, remoteClassName, operation);
            } else if (operation.getUse() == SOAPUse.LITERAL) {
                this.writeRpcLiteralOperation(p, remoteClassName, operation);
            } else {
                this.writeRpcEncodedOperation(p, remoteClassName, operation);
            }
            ++i;
        }
    }

    protected void writeReadFirstBodyElementDefault(IndentingWriter p, String state) throws IOException {
    }

    private void writeHeaderDeserializeMethods(IndentingWriter p, Iterator headers) throws IOException {
        int i = 0;
        while (headers.hasNext()) {
            if (i > 0) {
                p.pln();
            }
            Block header = (Block)headers.next();
            this.writeHeaderDeserializeMethod(p, header);
            ++i;
        }
    }

    protected void writePostEnvelopeReadingHook(IndentingWriter p, List operations) throws IOException {
    }

    protected void writePostSendingHook(IndentingWriter p, List operations) throws IOException {
    }

    protected void writePreResponseWritingHook(IndentingWriter p, List operations) throws IOException {
    }

    protected void writePreSendingHookMethod(IndentingWriter p, List operations) throws IOException {
    }

    protected Map writeReadHeaderElementMethod(IndentingWriter p) throws IOException {
        Message message;
        Operation operation;
        Iterator ops = this.operations.iterator();
        boolean hasHeaders = false;
        while (!hasHeaders && ops.hasNext()) {
            operation = (Operation)ops.next();
            message = operation.getRequest();
            Iterator headers = message.getHeaderBlocks();
            hasHeaders = !hasHeaders && headers.hasNext() ? true : hasHeaders;
            message = operation.getResponse();
            headers = message != null ? message.getHeaderBlocks() : null;
            boolean bl = hasHeaders = !hasHeaders && headers != null && headers.hasNext() ? true : hasHeaders;
        }
        HashMap headerMap = new HashMap();
        if (!hasHeaders) {
            return headerMap;
        }
        String stateType = this.getStateType();
        p.pln("/*");
        p.pln(" * This method must deserialize headers. It dispatches to a read method based on the name");
        p.pln(" * of the header.");
        p.pln(" */");
        p.plnI("protected boolean " + this.prefix + "readHeaderElement(SOAPHeaderBlockInfo headerInfo, XMLReader headerReader, SOAPDeserializationContext deserializationContext, " + stateType + " state) throws Exception {");
        ops = this.operations.iterator();
        boolean first = true;
        ArrayList list = new ArrayList();
        while (ops.hasNext()) {
            Iterator iter;
            operation = (Operation)ops.next();
            message = operation.getRequest();
            list.clear();
            Iterator iter2 = message.getHeaderBlocks();
            while (iter2.hasNext()) {
                list.add(iter2.next());
            }
            Iterator iter3 = operation.getFaults();
            while (iter3.hasNext()) {
                list.add(((Fault)iter3.next()).getBlock());
            }
            this.writeHeaderChecks(p, list.iterator(), first, headerMap);
            first = first && message.getHeaderBlocks().hasNext() ? false : first;
            message = operation.getResponse();
            list.clear();
            if (message != null) {
                iter = message.getHeaderBlocks();
                while (iter.hasNext()) {
                    list.add(iter.next());
                }
            }
            iter = operation.getFaults();
            while (iter.hasNext()) {
                list.add(((Fault)iter.next()).getBlock());
            }
            this.writeHeaderChecks(p, list.iterator(), first, headerMap);
            boolean bl = first = first && message.getHeaderBlocks().hasNext() ? false : first;
        }
        p.pln();
        p.pln("headerReader.skipElement();");
        p.pln("return false;");
        p.pOln("}");
        return headerMap;
    }

    protected void writeStaticMembers(IndentingWriter p, Map headerMap) throws IOException {
        Operation operation;
        ArrayList list = new ArrayList();
        ArrayList visited = new ArrayList();
        Iterator operationsIter = this.operations.iterator();
        p.p("private static final javax.xml.namespace.QName " + this.prefix + "portName = ");
        GeneratorUtil.writeNewQName(p, this.port.getName());
        p.pln(";");
        int i = 0;
        while (operationsIter.hasNext()) {
            operation = (Operation)operationsIter.next();
            p.pln("private static final int " + this.env.getNames().getOPCodeName(operation.getUniqueName()) + " = " + i + ";");
            ++i;
        }
        operationsIter = this.operations.iterator();
        int i2 = 0;
        while (operationsIter.hasNext()) {
            operation = (Operation)operationsIter.next();
            TreeSet faultSet = new TreeSet(new GeneratorUtil.FaultComparator());
            faultSet.addAll(operation.getFaultsSet());
            Iterator faults = faultSet.iterator();
            if (faults.hasNext()) {
                this.declareStaticFaultSerializerForOperation(p, this.port, operation, this.encodeTypes, this.multiRefEncoding);
            }
            while (faults.hasNext()) {
                StubTieGeneratorBase.collectNamespaces(((Fault)faults.next()).getBlock().getType(), list, visited);
            }
            Iterator iter = operation.getFaults();
            while (iter.hasNext()) {
                Fault fault = (Fault)iter.next();
                if (!(fault instanceof HeaderFault)) continue;
                HashSet processedTypes = new HashSet();
                HashSet faultNames = new HashSet();
            }
            ++i2;
        }
        HashSet processedTypes = new HashSet();
        operationsIter = this.operations.iterator();
        Iterator blocks = headerMap.values().iterator();
        this.declareBlockTypes(p, null, blocks, processedTypes, list, visited);
        int i3 = 0;
        while (operationsIter.hasNext()) {
            operation = (Operation)operationsIter.next();
            blocks = operation.getRequest().getHeaderBlocks();
            this.declareBlockTypes(p, operation, blocks, processedTypes, list, visited);
            blocks = operation.getRequest().getBodyBlocks();
            this.declareBlockTypes(p, operation, blocks, processedTypes, list, visited);
            if (operation.getResponse() != null) {
                blocks = operation.getResponse().getHeaderBlocks();
                this.declareBlockTypes(p, operation, blocks, processedTypes, list, visited);
                blocks = operation.getResponse().getBodyBlocks();
                this.declareBlockTypes(p, operation, blocks, processedTypes, list, visited);
            }
            ++i3;
        }
        list.remove(this.soapNamespaceConstants.getXSD());
        list.remove(this.soapNamespaceConstants.getEncoding());
        Iterator namespaces = list.iterator();
        p.plnI("private static final java.lang.String[] myNamespace_declarations =");
        p.pI(8);
        p.plnI("new java.lang.String[] {");
        int j = 0;
        while (namespaces.hasNext()) {
            if (j > 0) {
                p.pln(",");
            }
            p.p("\"ns" + j + "\", ");
            p.p("\"" + (String)namespaces.next() + "\"");
            ++j;
        }
        p.pln();
        p.pOln("};");
        p.pO(8);
        p.pO();
    }

    protected abstract void writeUnderstoodHeadersMember(IndentingWriter var1, Map var2) throws IOException;

    private void declareStaticFaultSerializerForOperation(IndentingWriter p, Port port, Operation operation, boolean encodeTypesNow, boolean multiRefEncodingNow) throws IOException {
        String nillable = "NOT_NULLABLE";
        String referenceable = "REFERENCEABLE";
        String multiRef = "DONT_SERIALIZE_AS_REF";
        String encodeType = encodeTypesNow ? "ENCODE_TYPE" : "DONT_ENCODE_TYPE";
        String serializerClassName = this.env.getNames().faultSerializerClassName(this.servicePackage, port, operation);
        String memberName = this.env.getNames().getClassMemberName(serializerClassName);
        p.plnI("private final CombinedSerializer " + memberName + " = new ReferenceableSerializerImpl(" + multiRef + ",");
        p.pln("new " + serializerClassName + "(" + encodeType + ", " + nillable + "));");
        p.pO();
    }

    protected void writeDocumentLiteralOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException, GeneratorException {
    }

    protected void writeRpcEncodedOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException, GeneratorException {
    }

    protected void writeRpcLiteralOperation(IndentingWriter p, String remoteClassName, Operation operation) throws IOException, GeneratorException {
    }

    protected static void collectNamespaces(AbstractType type, List list, List visited) {
        if (visited.contains(type.getJavaType().getRealName())) {
            return;
        }
        visited.add(type.getJavaType().getRealName());
        if (type.getName().getNamespaceURI().length() > 0 && !list.contains(type.getName().getNamespaceURI())) {
            list.add(type.getName().getNamespaceURI());
        }
        if (type instanceof SOAPStructureType) {
            Iterator members = ((SOAPStructureType)type).getMembers();
            while (members.hasNext()) {
                SOAPStructureMember member = (SOAPStructureMember)members.next();
                if (member.getName().getNamespaceURI().length() > 0 && !list.contains(member.getName().getNamespaceURI())) {
                    list.add(member.getName().getNamespaceURI());
                }
                StubTieGeneratorBase.collectNamespaces(member.getType(), list, visited);
            }
        } else if (type instanceof SOAPArrayType) {
            StubTieGeneratorBase.collectNamespaces(((SOAPArrayType)type).getElementType(), list, visited);
        }
    }

    private void writeHeaderChecks(IndentingWriter p, Iterator headers, boolean first, Map headerMap) throws IOException {
        while (headers.hasNext()) {
            Block header = (Block)headers.next();
            if (headerMap.containsKey(header.getName())) continue;
            headerMap.put(header.getName(), header);
            if (!first) {
                p.p(" else ");
            }
            first = false;
            String qname = this.env.getNames().getBlockQNameName(null, header);
            String uname = this.env.getNames().getBlockUniqueName(null, header);
            p.plnI("if (headerInfo.getName().equals(" + qname + ")) {");
            p.pln(this.prefix + "deserialize_" + uname + "(headerInfo, headerReader, deserializationContext, state);");
            p.pln("return true;");
            p.pO("}");
        }
    }

    protected StubTieGeneratorBase(Model model, Configuration config, Properties properties) {
        super(model, config, properties);
        this.prefix = this.getPrefix();
        this.srcFile = null;
        this.init(SOAPVersion.SOAP_11);
    }

    protected StubTieGeneratorBase(Model model, Configuration config, Properties properties, SOAPVersion ver) {
        super(model, config, properties);
        this.init(ver);
        this.prefix = this.getPrefix();
        this.srcFile = null;
    }

    private void declareBlockTypes(IndentingWriter p, Operation operation, Iterator blocks, Set processedTypes, List list, List visited) throws IOException {
        while (blocks.hasNext()) {
            Block block = (Block)blocks.next();
            StubTieGeneratorBase.collectNamespaces(block.getType(), list, visited);
            if (!processedTypes.contains(this.env.getNames().getBlockQNameName(operation, block))) {
                GeneratorUtil.writeBlockQNameDeclaration(p, operation, block, this.env.getNames());
                processedTypes.add(this.env.getNames().getBlockQNameName(operation, block));
            }
            if (block.getType().isSOAPType()) {
                SOAPEncoding.writeStaticSerializer(p, this.servicePackage, (SOAPType)block.getType(), processedTypes, this.writerFactory, this.env.getNames());
                continue;
            }
            if (!block.getType().isLiteralType()) continue;
            LiteralEncoding.writeStaticSerializer(p, this.servicePackage, (LiteralType)block.getType(), processedTypes, this.writerFactory, this.env.getNames());
        }
    }
}

