/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.ui;

import java.awt.Component;
import java.awt.HeadlessException;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.web.project.ui.FoldersListSettings;
import org.openide.filesystems.FileUtil;

public class FileChooser
extends JFileChooser {
    private String key;
    protected String initialPath;

    public FileChooser(String key, String currentDirectoryPath) {
        super(FileChooser.getInitialDirectory(key, currentDirectoryPath));
        this.key = key;
    }

    public FileChooser(String key) {
        this(key, (String)null);
        this.key = key;
    }

    private static File getInitialDirectory(String key, String currentDirectoryPath) {
        return FileChooser.getInitialDirectory(key, currentDirectoryPath == null ? null : new File(currentDirectoryPath));
    }

    private static File getInitialDirectory(String key, File f) {
        File file;
        while (f != null) {
            if (f.exists() && f.isDirectory()) {
                return f;
            }
            f = f.getParentFile();
        }
        File lastChooserLocation = FileChooser.getLastChooserLocation(key);
        if (lastChooserLocation != null && lastChooserLocation.exists()) {
            return lastChooserLocation;
        }
        String pathname = System.getProperty("user.home");
        if (pathname != null && (file = new File(pathname).getAbsoluteFile()).exists()) {
            return file;
        }
        file = new File("").getAbsoluteFile();
        assert (file.exists()) : "Default directory '" + file.getAbsolutePath() + "' does not exist";
        return f;
    }

    public int showDialog(Component parent, String approveButtonText) throws HeadlessException {
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)this, (File)FileChooser.getInitialDirectory(this.key, this.getCurrentDirectory()));
        return super.showDialog(parent, approveButtonText);
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("SelectedFileChangedProperty".equals(propertyName)) {
            newValue = FileChooser.correctFile((File)newValue);
        }
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void approveSelection() {
        this.saveCurrentLocation();
        super.approveSelection();
    }

    public void cancelSelection() {
        super.cancelSelection();
    }

    private static File correctFile(File f) {
        while (f != null && ".".equals(f.getName())) {
            f = f.getParentFile();
        }
        return f;
    }

    private void saveCurrentLocation() {
        if (!this.isMultiSelectionEnabled() && this.isDirectorySelectionEnabled() && this.saveLocation(this.getSelectedFile())) {
            return;
        }
        this.saveLocation(this.getCurrentDirectory());
    }

    private boolean saveLocation(File f) {
        if (f != null && f.isDirectory()) {
            FileChooser.setLastChooserLocation(this.key, f);
            return true;
        }
        return false;
    }

    public static File getLastChooserLocation(String key) {
        Map map = FoldersListSettings.getDefault().getLastUsedChooserLocations();
        if (map != null) {
            return (File)map.get(key);
        }
        return null;
    }

    public static void setLastChooserLocation(String key, File folder) {
        FoldersListSettings foldersListSettings = FoldersListSettings.getDefault();
        HashMap<String, File> map = foldersListSettings.getLastUsedChooserLocations();
        map = map == null ? new HashMap<String, File>() : new HashMap(map);
        map.put(key, folder);
        foldersListSettings.setLastUsedChooserLocations(map);
    }

    public static FileChooser createDirectoryChooser(String key) {
        return FileChooser.createDirectoryChooser(key, null);
    }

    public static FileChooser createDirectoryChooser(String key, String initialPath) {
        FileChooser chooser = new FileChooser(key, initialPath);
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        chooser.setAcceptAllFileFilterUsed(false);
        return chooser;
    }

    public static FileChooser createFileChooser(String key, String dialogTitle, FileFilter fileFilter) {
        FileChooser chooser = new FileChooser(key);
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(true);
        chooser.setDialogTitle(dialogTitle);
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(fileFilter);
        return chooser;
    }
}

