/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

final class JspSourcePathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    private List resources;
    private AntProjectHelper helper;
    private PropertyEvaluator evaluator;
    private ProjectDirectoryListener projectDirListener;

    public JspSourcePathImplementation(AntProjectHelper helper, PropertyEvaluator eval) {
        assert (helper != null);
        assert (eval != null);
        this.helper = helper;
        this.evaluator = eval;
        eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)eval));
        FileObject projectDir = helper.getProjectDirectory();
        this.projectDirListener = new ProjectDirectoryListener();
        projectDir.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.projectDirListener, (Object)projectDir));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getResources() {
        FileObject webDocbaseDirFO;
        JspSourcePathImplementation jspSourcePathImplementation = this;
        synchronized (jspSourcePathImplementation) {
            if (this.resources != null) {
                return this.resources;
            }
        }
        PathResourceImplementation webDocbaseDirRes = null;
        String webDocbaseDir = this.evaluator.getProperty("web.docbase.dir");
        if (webDocbaseDir != null && (webDocbaseDirFO = this.helper.resolveFileObject(webDocbaseDir)) != null) {
            try {
                webDocbaseDirRes = ClassPathSupport.createResource((URL)webDocbaseDirFO.getURL());
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        JspSourcePathImplementation jspSourcePathImplementation2 = this;
        synchronized (jspSourcePathImplementation2) {
            if (this.resources == null) {
                Object result = null;
                this.resources = webDocbaseDirRes != null ? Collections.singletonList(webDocbaseDirRes) : Collections.EMPTY_LIST;
            }
        }
        return this.resources;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("web.docbase.dir".equals(evt.getPropertyName())) {
            this.fireChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireChange() {
        JspSourcePathImplementation jspSourcePathImplementation = this;
        synchronized (jspSourcePathImplementation) {
            this.resources = null;
        }
        this.support.firePropertyChange("resources", null, null);
    }

    private final class ProjectDirectoryListener
    implements FileChangeListener {
        private ProjectDirectoryListener() {
        }

        public void fileAttributeChanged(FileAttributeEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
        }

        public void fileDataCreated(FileEvent fe) {
        }

        public void fileDeleted(FileEvent fe) {
            if (this.isWatchedFile(this.getFileName(fe))) {
                JspSourcePathImplementation.this.fireChange();
            }
        }

        public void fileFolderCreated(FileEvent fe) {
            if (this.isWatchedFile(this.getFileName(fe))) {
                JspSourcePathImplementation.this.fireChange();
            }
        }

        public void fileRenamed(FileRenameEvent fe) {
            if (this.isWatchedFile(this.getFileName((FileEvent)fe)) || this.isWatchedFile(this.getOldFileName(fe))) {
                JspSourcePathImplementation.this.fireChange();
            }
        }

        private boolean isWatchedFile(String fileName) {
            String webDir = JspSourcePathImplementation.this.evaluator.getProperty("web.docbase.dir");
            return fileName.equals(webDir);
        }

        private String getFileName(FileEvent fe) {
            return fe.getFile().getNameExt();
        }

        private String getOldFileName(FileRenameEvent fe) {
            String result = fe.getName();
            if (fe.getExt() != "") {
                result = result + "." + fe.getExt();
            }
            return result;
        }
    }
}

