/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.viewmodel;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.viewmodel.TreeTable;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.NodeModelFilter;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TableModelFilter;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.TreeModelFilter;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;

public final class Models {
    public static CompoundModel EMPTY_MODEL = Models.createCompoundModel(new ArrayList());
    public static int MULTISELECTION_TYPE_EXACTLY_ONE = 1;
    public static int MULTISELECTION_TYPE_ALL = 2;
    public static int MULTISELECTION_TYPE_ANY = 3;
    private static boolean verbose = System.getProperty("netbeans.debugger.models") != null;
    static /* synthetic */ Class class$java$lang$Object;

    public static JComponent createView(CompoundModel compoundModel) {
        TreeTable tt = new TreeTable();
        tt.setModel(compoundModel);
        return tt;
    }

    public static void setModelsToView(final JComponent view, final CompoundModel compoundModel) {
        if (!(view instanceof TreeTable)) {
            throw new IllegalArgumentException("Expecting an instance of " + TreeTable.class.getName() + ", which can be obtained from Models.createView().");
        }
        if (verbose) {
            System.out.println(compoundModel);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((TreeTable)view).setModel(compoundModel);
            }
        });
    }

    public static CompoundModel createCompoundModel(List models) {
        return Models.createCompoundModel(models, null);
    }

    public static CompoundModel createCompoundModel(List models, String propertiesHelpID) {
        List otherModels;
        List columnModels;
        List nodeActionsProviderFilters;
        List nodeActionsProviders;
        List tableModelFilters;
        List tableModels;
        List nodeModelFilters;
        List nodeModels;
        List treeExpansionModels;
        List treeModelFilters;
        List<EmptyTreeModel> treeModels;
        Iterator it;
        boolean hasLists = false;
        if (models.size() == 11) {
            it = models.iterator();
            while (it.hasNext() && it.next() instanceof List) {
            }
            if (!it.hasNext()) {
                hasLists = true;
            }
        }
        if (hasLists) {
            treeModels = (List)models.get(0);
            treeModelFilters = (List)models.get(1);
            Models.revertOrder(treeModelFilters);
            treeExpansionModels = (List)models.get(2);
            nodeModels = (List)models.get(3);
            nodeModelFilters = (List)models.get(4);
            Models.revertOrder(nodeModelFilters);
            tableModels = (List)models.get(5);
            tableModelFilters = (List)models.get(6);
            Models.revertOrder(tableModelFilters);
            nodeActionsProviders = (List)models.get(7);
            nodeActionsProviderFilters = (List)models.get(8);
            Models.revertOrder(nodeActionsProviderFilters);
            columnModels = (List)models.get(9);
            otherModels = (List)models.get(10);
        } else {
            treeModels = new LinkedList();
            treeModelFilters = new LinkedList();
            treeExpansionModels = new LinkedList();
            nodeModels = new LinkedList();
            nodeModelFilters = new LinkedList();
            tableModels = new LinkedList();
            tableModelFilters = new LinkedList();
            nodeActionsProviders = new LinkedList();
            nodeActionsProviderFilters = new LinkedList();
            columnModels = new LinkedList();
            otherModels = models;
        }
        it = otherModels.iterator();
        while (it.hasNext()) {
            Object model = it.next();
            boolean first = model.getClass().getName().endsWith("First");
            if (model instanceof TreeModel) {
                treeModels.add((EmptyTreeModel)model);
            }
            if (model instanceof TreeModelFilter) {
                if (first) {
                    treeModelFilters.add(model);
                } else {
                    treeModelFilters.add(0, model);
                }
            }
            if (model instanceof TreeExpansionModel) {
                treeExpansionModels.add(model);
            }
            if (model instanceof NodeModel) {
                nodeModels.add(model);
            }
            if (model instanceof NodeModelFilter) {
                if (first) {
                    nodeModelFilters.add(model);
                } else {
                    nodeModelFilters.add(0, model);
                }
            }
            if (model instanceof TableModel) {
                tableModels.add(model);
            }
            if (model instanceof TableModelFilter) {
                if (first) {
                    tableModelFilters.add(model);
                } else {
                    tableModelFilters.add(0, model);
                }
            }
            if (model instanceof NodeActionsProvider) {
                nodeActionsProviders.add(model);
            }
            if (model instanceof NodeActionsProviderFilter) {
                if (first) {
                    nodeActionsProviderFilters.add(model);
                } else {
                    nodeActionsProviderFilters.add(0, model);
                }
            }
            if (!(model instanceof ColumnModel)) continue;
            columnModels.add(model);
        }
        if (treeModels.isEmpty()) {
            treeModels.add(new EmptyTreeModel());
        }
        return new CompoundModel(Models.createCompoundTreeModel(new DelegatingTreeModel(treeModels), treeModelFilters), new DelegatingTreeExpansionModel(treeExpansionModels), Models.createCompoundNodeModel(new DelegatingNodeModel(nodeModels), nodeModelFilters), Models.createCompoundNodeActionsProvider(new DelegatingNodeActionsProvider(nodeActionsProviders), nodeActionsProviderFilters), columnModels, Models.createCompoundTableModel(new DelegatingTableModel(tableModels), tableModelFilters), propertiesHelpID);
    }

    private static void revertOrder(List filters) {
        int n = filters.size();
        int i = 0;
        while (i < n) {
            Object filter = filters.remove(i);
            boolean first = filter.getClass().getName().endsWith("First");
            if (first) {
                filters.add(filter);
                --n;
                continue;
            }
            filters.add(0, filter);
            ++i;
        }
    }

    public static Action createAction(String displayName, ActionPerformer performer, int multiselectionType) {
        return new ActionSupport(displayName, performer, multiselectionType);
    }

    public static TreeFeatures treeFeatures(JComponent view) throws UnsupportedOperationException {
        return new TreeFeatures(view);
    }

    private static TreeModel createCompoundTreeModel(TreeModel originalTreeModel, List treeModelFilters) {
        TreeModel tm = originalTreeModel;
        int k = treeModelFilters.size();
        for (int i = 0; i < k; ++i) {
            tm = new CompoundTreeModel(tm, (TreeModelFilter)treeModelFilters.get(i));
        }
        return tm;
    }

    private static NodeModel createCompoundNodeModel(NodeModel originalNodeModel, List treeNodeModelFilters) {
        NodeModel nm = originalNodeModel;
        int k = treeNodeModelFilters.size();
        for (int i = 0; i < k; ++i) {
            nm = new CompoundNodeModel(nm, (NodeModelFilter)treeNodeModelFilters.get(i));
        }
        return nm;
    }

    private static TableModel createCompoundTableModel(TableModel originalTableModel, List tableModelFilters) {
        TableModel tm = originalTableModel;
        int k = tableModelFilters.size();
        for (int i = 0; i < k; ++i) {
            tm = new CompoundTableModel(tm, (TableModelFilter)tableModelFilters.get(i));
        }
        return tm;
    }

    private static NodeActionsProvider createCompoundNodeActionsProvider(NodeActionsProvider originalNodeActionsProvider, List nodeActionsProviderFilters) {
        NodeActionsProvider nap = originalNodeActionsProvider;
        int k = nodeActionsProviderFilters.size();
        for (int i = 0; i < k; ++i) {
            nap = new CompoundNodeActionsProvider(nap, (NodeActionsProviderFilter)nodeActionsProviderFilters.get(i));
        }
        return nap;
    }

    private static ModelEvent translateEvent(ModelEvent event, Object newSource) {
        ModelEvent newEvent = event instanceof ModelEvent.NodeChanged ? new ModelEvent.NodeChanged(newSource, ((ModelEvent.NodeChanged)event).getNode(), ((ModelEvent.NodeChanged)event).getChange()) : (event instanceof ModelEvent.TableValueChanged ? new ModelEvent.TableValueChanged(newSource, ((ModelEvent.TableValueChanged)event).getNode(), ((ModelEvent.TableValueChanged)event).getColumnID()) : (event instanceof ModelEvent.TreeChanged ? new ModelEvent.TreeChanged(newSource) : event));
        return newEvent;
    }

    public static final class CompoundModel
    implements TreeModel,
    NodeModel,
    NodeActionsProvider,
    TableModel,
    TreeExpansionModel {
        private TreeModel treeModel;
        private NodeModel nodeModel;
        private NodeActionsProvider nodeActionsProvider;
        private ColumnModel[] columnModels;
        private TableModel tableModel;
        private TreeExpansionModel treeExpansionModel;
        private String propertiesHelpID = null;

        private CompoundModel(TreeModel treeModel, TreeExpansionModel treeExpansionModel, NodeModel nodeModel, NodeActionsProvider nodeActionsProvider, List columnModels, TableModel tableModel, String propertiesHelpID) {
            if (treeModel == null) {
                throw new NullPointerException();
            }
            if (treeModel == null) {
                throw new NullPointerException();
            }
            if (nodeModel == null) {
                throw new NullPointerException();
            }
            if (tableModel == null) {
                throw new NullPointerException();
            }
            if (nodeActionsProvider == null) {
                throw new NullPointerException();
            }
            this.treeModel = treeModel;
            this.treeExpansionModel = treeExpansionModel;
            this.nodeModel = nodeModel;
            this.tableModel = tableModel;
            this.nodeActionsProvider = nodeActionsProvider;
            this.columnModels = columnModels.toArray(new ColumnModel[columnModels.size()]);
            this.propertiesHelpID = propertiesHelpID;
        }

        public String getHelpId() {
            return this.propertiesHelpID;
        }

        public Object getRoot() {
            return this.treeModel.getRoot();
        }

        public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
            return this.treeModel.getChildren(parent, from, to);
        }

        public int getChildrenCount(Object node) throws UnknownTypeException {
            return this.treeModel.getChildrenCount(node);
        }

        public boolean isLeaf(Object node) throws UnknownTypeException {
            return this.treeModel.isLeaf(node);
        }

        public String getDisplayName(Object node) throws UnknownTypeException {
            NodeModel[] subModels;
            if (this.nodeModel instanceof DelegatingNodeModel && (subModels = ((DelegatingNodeModel)this.nodeModel).getModels()).length == 0) {
                return "";
            }
            return this.nodeModel.getDisplayName(node);
        }

        public String getShortDescription(Object node) throws UnknownTypeException {
            return this.nodeModel.getShortDescription(node);
        }

        public String getIconBase(Object node) throws UnknownTypeException {
            NodeModel[] subModels;
            if (this.nodeModel instanceof DelegatingNodeModel && (subModels = ((DelegatingNodeModel)this.nodeModel).getModels()).length == 0) {
                return null;
            }
            return this.nodeModel.getIconBase(node);
        }

        public void performDefaultAction(Object node) throws UnknownTypeException {
            this.nodeActionsProvider.performDefaultAction(node);
        }

        public Action[] getActions(Object node) throws UnknownTypeException {
            return this.nodeActionsProvider.getActions(node);
        }

        public ColumnModel[] getColumns() {
            return this.columnModels;
        }

        public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
            return this.tableModel.getValueAt(node, columnID);
        }

        public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
            return this.tableModel.isReadOnly(node, columnID);
        }

        public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
            this.tableModel.setValueAt(node, columnID, value);
        }

        public boolean isExpanded(Object node) throws UnknownTypeException {
            if (this.treeExpansionModel == null) {
                return false;
            }
            return this.treeExpansionModel.isExpanded(node);
        }

        public void nodeExpanded(Object node) {
            if (this.treeExpansionModel != null) {
                this.treeExpansionModel.nodeExpanded(node);
            }
        }

        public void nodeCollapsed(Object node) {
            if (this.treeExpansionModel != null) {
                this.treeExpansionModel.nodeCollapsed(node);
            }
        }

        public void addModelListener(ModelListener l) {
            this.treeModel.addModelListener(l);
            if (this.nodeModel != this.treeModel) {
                this.nodeModel.addModelListener(l);
            }
            if (this.tableModel != this.treeModel && this.tableModel != this.nodeModel) {
                this.tableModel.addModelListener(l);
            }
        }

        public void removeModelListener(ModelListener l) {
            this.treeModel.removeModelListener(l);
            if (this.nodeModel != this.treeModel) {
                this.nodeModel.removeModelListener(l);
            }
            if (this.tableModel != this.treeModel && this.tableModel != this.nodeModel) {
                this.tableModel.removeModelListener(l);
            }
        }

        public String toString() {
            return super.toString() + "\n  TreeModel = " + this.treeModel + "\n  NodeModel = " + this.nodeModel + "\n  TableModel = " + this.tableModel + "\n  NodeActionsProvider = " + this.nodeActionsProvider + "\n  ColumnsModel = " + Arrays.asList(this.columnModels);
        }
    }

    public static final class TreeFeatures {
        private JComponent view;

        private TreeFeatures(JComponent view) {
            this.view = view;
        }

        public boolean isExpanded(Object node) {
            return ((TreeTable)this.view).isExpanded(node);
        }

        public void expandNode(Object node) {
            ((TreeTable)this.view).expandNode(node);
        }

        public void collapseNode(Object node) {
            ((TreeTable)this.view).collapseNode(node);
        }
    }

    static final class DelegatingNodeActionsProvider
    implements NodeActionsProvider {
        private NodeActionsProvider[] models;
        private HashMap classNameToModel = new HashMap();

        public DelegatingNodeActionsProvider(List models) {
            this(DelegatingNodeActionsProvider.convert(models));
        }

        private static NodeActionsProvider[] convert(List l) {
            NodeActionsProvider[] models = new NodeActionsProvider[l.size()];
            return l.toArray(models);
        }

        public DelegatingNodeActionsProvider(NodeActionsProvider[] models) {
            this.models = models;
        }

        public Action[] getActions(Object node) throws UnknownTypeException {
            NodeActionsProvider model = (NodeActionsProvider)this.classNameToModel.get(node.getClass().getName());
            if (model != null) {
                try {
                    return model.getActions(node);
                }
                catch (UnknownTypeException e) {
                    // empty catch block
                }
            }
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                try {
                    Action[] dn = this.models[i].getActions(node);
                    this.classNameToModel.put(node.getClass().getName(), this.models[i]);
                    return dn;
                }
                catch (UnknownTypeException e) {
                    continue;
                }
            }
            throw new UnknownTypeException(node);
        }

        public void performDefaultAction(Object node) throws UnknownTypeException {
            NodeActionsProvider model = (NodeActionsProvider)this.classNameToModel.get(node.getClass().getName());
            if (model != null) {
                try {
                    model.performDefaultAction(node);
                    return;
                }
                catch (UnknownTypeException e) {
                    // empty catch block
                }
            }
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                try {
                    this.models[i].performDefaultAction(node);
                    this.classNameToModel.put(node.getClass().getName(), this.models[i]);
                    return;
                }
                catch (UnknownTypeException e) {
                    continue;
                }
            }
            throw new UnknownTypeException(node);
        }

        public String toString() {
            return super.toString() + "\n" + this.toString("    ");
        }

        public String toString(String n) {
            int i;
            int k = this.models.length - 1;
            if (k == -1) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < k; ++i) {
                sb.append(n);
                sb.append(this.models[i]);
                sb.append('\n');
            }
            sb.append(n);
            sb.append(this.models[i]);
            return new String(sb);
        }
    }

    private static final class EmptyNodeActionsProvider
    implements NodeActionsProvider {
        private EmptyNodeActionsProvider() {
        }

        public void performDefaultAction(Object node) throws UnknownTypeException {
            throw new UnknownTypeException(node);
        }

        public Action[] getActions(Object node) throws UnknownTypeException {
            throw new UnknownTypeException(node);
        }
    }

    private static final class EmptyTableModel
    implements TableModel {
        private EmptyTableModel() {
        }

        public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
            throw new UnknownTypeException(node);
        }

        public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
            throw new UnknownTypeException(node);
        }

        public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
            throw new UnknownTypeException(node);
        }

        public void addModelListener(ModelListener l) {
        }

        public void removeModelListener(ModelListener l) {
        }
    }

    private static final class EmptyNodeModel
    implements NodeModel {
        private EmptyNodeModel() {
        }

        public String getDisplayName(Object node) throws UnknownTypeException {
            throw new UnknownTypeException(node);
        }

        public String getIconBase(Object node) throws UnknownTypeException {
            throw new UnknownTypeException(node);
        }

        public String getShortDescription(Object node) throws UnknownTypeException {
            throw new UnknownTypeException(node);
        }

        public void addModelListener(ModelListener l) {
        }

        public void removeModelListener(ModelListener l) {
        }
    }

    private static final class EmptyTreeModel
    implements TreeModel {
        private EmptyTreeModel() {
        }

        public Object getRoot() {
            return "Root";
        }

        public Object[] getChildren(Object parent, int from, int to) {
            return new Object[0];
        }

        public int getChildrenCount(Object node) {
            return 0;
        }

        public boolean isLeaf(Object node) {
            return false;
        }

        public void addModelListener(ModelListener l) {
        }

        public void removeModelListener(ModelListener l) {
        }
    }

    static final class DelegatingNodeModel
    implements NodeModel {
        private NodeModel[] models;
        private HashMap classNameToModel = new HashMap();

        DelegatingNodeModel(List models) {
            this(DelegatingNodeModel.convert(models));
        }

        private static NodeModel[] convert(List l) {
            NodeModel[] models = new NodeModel[l.size()];
            return l.toArray(models);
        }

        DelegatingNodeModel(NodeModel[] models) {
            this.models = models;
        }

        NodeModel[] getModels() {
            return this.models;
        }

        public String getDisplayName(Object node) throws UnknownTypeException {
            NodeModel model = (NodeModel)this.classNameToModel.get(node.getClass().getName());
            if (model != null) {
                try {
                    return model.getDisplayName(node);
                }
                catch (UnknownTypeException e) {
                    // empty catch block
                }
            }
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                try {
                    String dn = this.models[i].getDisplayName(node);
                    this.classNameToModel.put(node.getClass().getName(), this.models[i]);
                    return dn;
                }
                catch (UnknownTypeException e) {
                    continue;
                }
            }
            throw new UnknownTypeException(node);
        }

        public String getShortDescription(Object node) throws UnknownTypeException {
            NodeModel model = (NodeModel)this.classNameToModel.get(node.getClass().getName());
            if (model != null) {
                try {
                    return model.getShortDescription(node);
                }
                catch (UnknownTypeException e) {
                    // empty catch block
                }
            }
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                try {
                    String dn = this.models[i].getShortDescription(node);
                    this.classNameToModel.put(node.getClass().getName(), this.models[i]);
                    return dn;
                }
                catch (UnknownTypeException e) {
                    continue;
                }
            }
            throw new UnknownTypeException(node);
        }

        public String getIconBase(Object node) throws UnknownTypeException {
            NodeModel model = (NodeModel)this.classNameToModel.get(node.getClass().getName());
            if (model != null) {
                try {
                    return model.getIconBase(node);
                }
                catch (UnknownTypeException e) {
                    // empty catch block
                }
            }
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                try {
                    String dn = this.models[i].getIconBase(node);
                    this.classNameToModel.put(node.getClass().getName(), this.models[i]);
                    return dn;
                }
                catch (UnknownTypeException e) {
                    continue;
                }
            }
            throw new UnknownTypeException(node);
        }

        public void addModelListener(ModelListener l) {
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                this.models[i].addModelListener(l);
            }
        }

        public void removeModelListener(ModelListener l) {
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                this.models[i].removeModelListener(l);
            }
        }

        public String toString() {
            return this.toString("    ");
        }

        public String toString(String n) {
            int i;
            int k = this.models.length - 1;
            if (k == -1) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < k; ++i) {
                sb.append(n);
                sb.append(this.models[i]);
                sb.append('\n');
            }
            sb.append(n);
            sb.append(this.models[i]);
            return new String(sb);
        }
    }

    private static class DefaultTreeExpansionModel
    implements TreeExpansionModel {
        private Set expandedNodes = new WeakSet();
        private Set collapsedNodes = new WeakSet();

        private DefaultTreeExpansionModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isExpanded(Object node) throws UnknownTypeException {
            DefaultTreeExpansionModel defaultTreeExpansionModel = this;
            synchronized (defaultTreeExpansionModel) {
                if (this.expandedNodes.contains(node)) {
                    return true;
                }
                if (this.collapsedNodes.contains(node)) {
                    return false;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeExpanded(Object node) {
            DefaultTreeExpansionModel defaultTreeExpansionModel = this;
            synchronized (defaultTreeExpansionModel) {
                this.expandedNodes.add(node);
                this.collapsedNodes.remove(node);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void nodeCollapsed(Object node) {
            DefaultTreeExpansionModel defaultTreeExpansionModel = this;
            synchronized (defaultTreeExpansionModel) {
                this.collapsedNodes.add(node);
                this.expandedNodes.remove(node);
            }
        }
    }

    static final class DelegatingTreeExpansionModel
    implements TreeExpansionModel {
        private TreeExpansionModel[] models;
        private HashMap classNameToModel = new HashMap();

        DelegatingTreeExpansionModel(List models) {
            this(DelegatingTreeExpansionModel.convert(models));
        }

        private static TreeExpansionModel[] convert(List l) {
            int size = l.size();
            if (size == 0) {
                return new TreeExpansionModel[]{new DefaultTreeExpansionModel()};
            }
            TreeExpansionModel[] models = new TreeExpansionModel[size];
            return l.toArray(models);
        }

        private DelegatingTreeExpansionModel(TreeExpansionModel[] models) {
            this.models = models;
        }

        public boolean isExpanded(Object node) throws UnknownTypeException {
            TreeExpansionModel model = (TreeExpansionModel)this.classNameToModel.get(node.getClass().getName());
            if (model != null) {
                try {
                    return model.isExpanded(node);
                }
                catch (UnknownTypeException e) {
                    // empty catch block
                }
            }
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                try {
                    boolean result = this.models[i].isExpanded(node);
                    this.classNameToModel.put(node.getClass().getName(), this.models[i]);
                    return result;
                }
                catch (UnknownTypeException e) {
                    continue;
                }
            }
            throw new UnknownTypeException(node);
        }

        public void nodeExpanded(Object node) {
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                this.models[i].nodeExpanded(node);
            }
        }

        public void nodeCollapsed(Object node) {
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                this.models[i].nodeCollapsed(node);
            }
        }

        public String toString() {
            return super.toString() + "\n" + this.toString("    ");
        }

        public String toString(String n) {
            int i;
            int k = this.models.length - 1;
            if (k == -1) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < k; ++i) {
                sb.append(n);
                sb.append(this.models[i]);
                sb.append('\n');
            }
            sb.append(n);
            sb.append(this.models[i]);
            return new String(sb);
        }
    }

    static final class DelegatingTableModel
    implements TableModel {
        private TableModel[] models;
        private HashMap classNameToModel = new HashMap();

        DelegatingTableModel(List models) {
            this(DelegatingTableModel.convert(models));
        }

        private static TableModel[] convert(List l) {
            TableModel[] models = new TableModel[l.size()];
            return l.toArray(models);
        }

        DelegatingTableModel(TableModel[] models) {
            this.models = models;
        }

        public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
            TableModel model = (TableModel)this.classNameToModel.get(node.getClass().getName());
            if (model != null) {
                try {
                    return model.getValueAt(node, columnID);
                }
                catch (UnknownTypeException e) {
                    // empty catch block
                }
            }
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                try {
                    Object v = this.models[i].getValueAt(node, columnID);
                    this.classNameToModel.put(node.getClass().getName(), this.models[i]);
                    return v;
                }
                catch (UnknownTypeException e) {
                    continue;
                }
            }
            throw new UnknownTypeException(node);
        }

        public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
            TableModel model = (TableModel)this.classNameToModel.get(node.getClass().getName());
            if (model != null) {
                try {
                    return model.isReadOnly(node, columnID);
                }
                catch (UnknownTypeException e) {
                    // empty catch block
                }
            }
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                try {
                    boolean ro = this.models[i].isReadOnly(node, columnID);
                    this.classNameToModel.put(node.getClass().getName(), this.models[i]);
                    return ro;
                }
                catch (UnknownTypeException e) {
                    continue;
                }
            }
            throw new UnknownTypeException(node);
        }

        public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
            TableModel model = (TableModel)this.classNameToModel.get(node.getClass().getName());
            if (model != null) {
                try {
                    model.setValueAt(node, columnID, value);
                    return;
                }
                catch (UnknownTypeException e) {
                    // empty catch block
                }
            }
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                try {
                    this.models[i].setValueAt(node, columnID, value);
                    this.classNameToModel.put(node.getClass().getName(), this.models[i]);
                    return;
                }
                catch (UnknownTypeException e) {
                    continue;
                }
            }
            throw new UnknownTypeException(node);
        }

        public void addModelListener(ModelListener l) {
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                this.models[i].addModelListener(l);
            }
        }

        public void removeModelListener(ModelListener l) {
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                this.models[i].removeModelListener(l);
            }
        }

        public String toString() {
            return super.toString() + "\n" + this.toString("    ");
        }

        public String toString(String n) {
            int i;
            int k = this.models.length - 1;
            if (k == -1) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < k; ++i) {
                sb.append(n);
                sb.append(this.models[i]);
                sb.append('\n');
            }
            sb.append(n);
            sb.append(this.models[i]);
            return new String(sb);
        }
    }

    static final class CompoundNodeActionsProvider
    implements NodeActionsProvider {
        private NodeActionsProvider model;
        private NodeActionsProviderFilter filter;

        CompoundNodeActionsProvider(NodeActionsProvider model, NodeActionsProviderFilter filter) {
            this.model = model;
            this.filter = filter;
        }

        public void performDefaultAction(Object node) throws UnknownTypeException {
            this.filter.performDefaultAction(this.model, node);
        }

        public Action[] getActions(Object node) throws UnknownTypeException {
            return this.filter.getActions(this.model, node);
        }

        public String toString() {
            return super.toString() + "\n" + this.toString("    ");
        }

        public String toString(String n) {
            if (this.model instanceof CompoundNodeActionsProvider) {
                return n + this.filter + "\n" + ((CompoundNodeActionsProvider)this.model).toString(n + "  ");
            }
            if (this.model instanceof DelegatingNodeActionsProvider) {
                return n + this.filter + "\n" + ((DelegatingNodeActionsProvider)this.model).toString(n + "  ");
            }
            return n + this.filter + "\n" + n + "  " + this.model;
        }
    }

    static final class DelegatingTreeModel
    implements TreeModel {
        private TreeModel[] models;
        private HashMap classNameToModel = new HashMap();

        DelegatingTreeModel(List models) {
            this(DelegatingTreeModel.convert(models));
        }

        private static TreeModel[] convert(List l) {
            TreeModel[] models = new TreeModel[l.size()];
            return l.toArray(models);
        }

        DelegatingTreeModel(TreeModel[] models) {
            this.models = models;
        }

        public Object getRoot() {
            return this.models[0].getRoot();
        }

        public Object[] getChildren(Object node, int from, int to) throws UnknownTypeException {
            TreeModel model = (TreeModel)this.classNameToModel.get(node.getClass().getName());
            if (model != null) {
                try {
                    return model.getChildren(node, from, to);
                }
                catch (UnknownTypeException e) {
                    // empty catch block
                }
            }
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                try {
                    Object[] v = this.models[i].getChildren(node, from, to);
                    this.classNameToModel.put(node.getClass().getName(), this.models[i]);
                    return v;
                }
                catch (UnknownTypeException e) {
                    continue;
                }
            }
            throw new UnknownTypeException(node);
        }

        public int getChildrenCount(Object node) throws UnknownTypeException {
            TreeModel model = (TreeModel)this.classNameToModel.get(node.getClass().getName());
            if (model != null) {
                try {
                    return model.getChildrenCount(node);
                }
                catch (UnknownTypeException e) {
                    // empty catch block
                }
            }
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                try {
                    int result = this.models[i].getChildrenCount(node);
                    this.classNameToModel.put(node.getClass().getName(), this.models[i]);
                    return result;
                }
                catch (UnknownTypeException e) {
                    continue;
                }
            }
            throw new UnknownTypeException(node);
        }

        public boolean isLeaf(Object node) throws UnknownTypeException {
            TreeModel model = (TreeModel)this.classNameToModel.get(node.getClass().getName());
            if (model != null) {
                try {
                    return model.isLeaf(node);
                }
                catch (UnknownTypeException e) {
                    // empty catch block
                }
            }
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                try {
                    boolean result = this.models[i].isLeaf(node);
                    this.classNameToModel.put(node.getClass().getName(), this.models[i]);
                    return result;
                }
                catch (UnknownTypeException e) {
                    continue;
                }
            }
            throw new UnknownTypeException(node);
        }

        public void addModelListener(ModelListener l) {
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                this.models[i].addModelListener(l);
            }
        }

        public void removeModelListener(ModelListener l) {
            int k = this.models.length;
            for (int i = 0; i < k; ++i) {
                this.models[i].removeModelListener(l);
            }
        }

        public String toString() {
            return super.toString() + "\n" + this.toString("    ");
        }

        public String toString(String n) {
            int i;
            int k = this.models.length - 1;
            if (k == -1) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < k; ++i) {
                sb.append(n);
                sb.append(this.models[i]);
                sb.append('\n');
            }
            sb.append(n);
            sb.append(this.models[i]);
            return new String(sb);
        }
    }

    static final class CompoundTableModel
    implements TableModel,
    ModelListener {
        private TableModel model;
        private TableModelFilter filter;
        private Collection modelListeners = new HashSet();

        CompoundTableModel(TableModel model, TableModelFilter filter) {
            this.model = model;
            this.filter = filter;
        }

        public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
            return this.filter.getValueAt(this.model, node, columnID);
        }

        public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
            return this.filter.isReadOnly(this.model, node, columnID);
        }

        public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
            this.filter.setValueAt(this.model, node, columnID, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addModelListener(ModelListener l) {
            Collection collection = this.modelListeners;
            synchronized (collection) {
                if (this.modelListeners.size() == 0) {
                    this.filter.addModelListener(this);
                    this.model.addModelListener(this);
                }
                this.modelListeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeModelListener(ModelListener l) {
            Collection collection = this.modelListeners;
            synchronized (collection) {
                this.modelListeners.remove(l);
                if (this.modelListeners.size() == 0) {
                    this.filter.removeModelListener(this);
                    this.model.removeModelListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(ModelEvent event) {
            ArrayList listeners;
            ModelEvent newEvent = Models.translateEvent(event, this);
            Collection collection = this.modelListeners;
            synchronized (collection) {
                listeners = new ArrayList(this.modelListeners);
            }
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                ((ModelListener)it.next()).modelChanged(newEvent);
            }
        }

        public String toString() {
            return super.toString() + "\n" + this.toString("    ");
        }

        public String toString(String n) {
            if (this.model instanceof CompoundTableModel) {
                return n + this.filter + "\n" + ((CompoundTableModel)this.model).toString(n + "  ");
            }
            if (this.model instanceof DelegatingTableModel) {
                return n + this.filter + "\n" + ((DelegatingTableModel)this.model).toString(n + "  ");
            }
            return n + this.filter + "\n" + n + "  " + this.model;
        }
    }

    static final class CompoundNodeModel
    implements NodeModel,
    ModelListener {
        private NodeModel model;
        private NodeModelFilter filter;
        private Collection modelListeners = new HashSet();

        CompoundNodeModel(NodeModel model, NodeModelFilter filter) {
            this.model = model;
            this.filter = filter;
        }

        public String getDisplayName(Object node) throws UnknownTypeException {
            return this.filter.getDisplayName(this.model, node);
        }

        public String getIconBase(Object node) throws UnknownTypeException {
            return this.filter.getIconBase(this.model, node);
        }

        public String getShortDescription(Object node) throws UnknownTypeException {
            return this.filter.getShortDescription(this.model, node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addModelListener(ModelListener l) {
            Collection collection = this.modelListeners;
            synchronized (collection) {
                if (this.modelListeners.size() == 0) {
                    this.filter.addModelListener(this);
                    this.model.addModelListener(this);
                }
                this.modelListeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeModelListener(ModelListener l) {
            Collection collection = this.modelListeners;
            synchronized (collection) {
                this.modelListeners.remove(l);
                if (this.modelListeners.size() == 0) {
                    this.filter.removeModelListener(this);
                    this.model.removeModelListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(ModelEvent event) {
            ArrayList listeners;
            ModelEvent newEvent = Models.translateEvent(event, this);
            Collection collection = this.modelListeners;
            synchronized (collection) {
                listeners = new ArrayList(this.modelListeners);
            }
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                ((ModelListener)it.next()).modelChanged(newEvent);
            }
        }

        public String toString() {
            return super.toString() + "\n" + this.toString("    ");
        }

        public String toString(String n) {
            if (this.model instanceof CompoundNodeModel) {
                return n + this.filter + "\n" + ((CompoundNodeModel)this.model).toString(n + "  ");
            }
            if (this.model instanceof DelegatingNodeModel) {
                return n + this.filter + "\n" + ((DelegatingNodeModel)this.model).toString(n + "  ");
            }
            return n + this.filter + "\n" + n + "  " + this.model;
        }
    }

    static final class CompoundTreeModel
    implements TreeModel,
    ModelListener {
        private TreeModel model;
        private TreeModelFilter filter;
        private Collection modelListeners = new HashSet();

        CompoundTreeModel(TreeModel model, TreeModelFilter filter) {
            this.model = model;
            this.filter = filter;
        }

        public Object getRoot() {
            return this.filter.getRoot(this.model);
        }

        public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
            return this.filter.getChildren(this.model, parent, from, to);
        }

        public int getChildrenCount(Object node) throws UnknownTypeException {
            return this.filter.getChildrenCount(this.model, node);
        }

        public boolean isLeaf(Object node) throws UnknownTypeException {
            return this.filter.isLeaf(this.model, node);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addModelListener(ModelListener l) {
            Collection collection = this.modelListeners;
            synchronized (collection) {
                if (this.modelListeners.size() == 0) {
                    this.filter.addModelListener(this);
                    this.model.addModelListener(this);
                }
                this.modelListeners.add(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeModelListener(ModelListener l) {
            Collection collection = this.modelListeners;
            synchronized (collection) {
                this.modelListeners.remove(l);
                if (this.modelListeners.size() == 0) {
                    this.filter.removeModelListener(this);
                    this.model.removeModelListener(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void modelChanged(ModelEvent event) {
            ArrayList listeners;
            ModelEvent newEvent = Models.translateEvent(event, this);
            Collection collection = this.modelListeners;
            synchronized (collection) {
                listeners = new ArrayList(this.modelListeners);
            }
            Iterator it = listeners.iterator();
            while (it.hasNext()) {
                ((ModelListener)it.next()).modelChanged(newEvent);
            }
        }

        public String toString() {
            return super.toString() + "\n" + this.toString("    ");
        }

        public String toString(String n) {
            if (this.model instanceof CompoundTreeModel) {
                return n + this.filter + "\n" + ((CompoundTreeModel)this.model).toString(n + "  ");
            }
            return n + this.filter + "\n" + n + "  " + this.model;
        }
    }

    public static interface ActionPerformer {
        public boolean isEnabled(Object var1);

        public void perform(Object[] var1);
    }

    private static class ActionSupport
    extends AbstractAction {
        private ActionPerformer performer;
        private int multiselectionType;
        private String displayName;

        ActionSupport(String displayName, ActionPerformer performer, int multiselectionType) {
            super(displayName);
            this.performer = performer;
            this.displayName = displayName;
            this.multiselectionType = multiselectionType;
        }

        public boolean isEnabled() {
            if (this.multiselectionType == MULTISELECTION_TYPE_ANY) {
                return true;
            }
            Node[] ns = TopComponent.getRegistry().getActivatedNodes();
            if (this.multiselectionType == MULTISELECTION_TYPE_EXACTLY_ONE) {
                if (ns.length != 1) {
                    return false;
                }
                return this.performer.isEnabled(ns[0].getLookup().lookup(class$java$lang$Object == null ? (class$java$lang$Object = Models.class$("java.lang.Object")) : class$java$lang$Object));
            }
            int k = ns.length;
            for (int i = 0; i < k; ++i) {
                if (this.performer.isEnabled(ns[i].getLookup().lookup(class$java$lang$Object == null ? Models.class$("java.lang.Object") : class$java$lang$Object))) continue;
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            Node[] ns = TopComponent.getRegistry().getActivatedNodes();
            int k = ns.length;
            IdentityHashMap<Action, ArrayList<Object>> h = new IdentityHashMap<Action, ArrayList<Object>>();
            for (int i = 0; i < k; ++i) {
                Object node = ns[i].getLookup().lookup(class$java$lang$Object == null ? Models.class$("java.lang.Object") : class$java$lang$Object);
                Action[] as = ns[i].getActions(false);
                int jj = as.length;
                for (int j = 0; j < jj; ++j) {
                    if (!this.equals(as[j])) continue;
                    ArrayList<Object> l = (ArrayList<Object>)h.get(as[j]);
                    if (l == null) {
                        l = new ArrayList<Object>();
                        h.put(as[j], l);
                    }
                    l.add(node);
                }
            }
            Iterator it = h.keySet().iterator();
            while (it.hasNext()) {
                ActionSupport a = (ActionSupport)it.next();
                a.performer.perform(((ArrayList)h.get(a)).toArray());
            }
        }

        public int hashCode() {
            return this.displayName.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof ActionSupport && this.displayName.equals(((ActionSupport)o).displayName);
        }
    }
}

