/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import java.util.Iterator;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointsReader;

public abstract class ClassBasedBreakpoint
extends BreakpointImpl {
    private static boolean verbose = System.getProperty("netbeans.debugger.breakpoints") != null;

    public ClassBasedBreakpoint(JPDABreakpoint breakpoint, JPDADebuggerImpl debugger, Session session) {
        super(breakpoint, null, debugger, session);
    }

    public ClassBasedBreakpoint(JPDABreakpoint breakpoint, BreakpointsReader reader, JPDADebuggerImpl debugger, Session session) {
        super(breakpoint, reader, debugger, session);
    }

    protected void setClassRequests(String[] classFilters, String[] classExclusionFilters, int breakpointType) {
        try {
            int i;
            int k;
            if ((breakpointType & 1) != 0) {
                ClassPrepareRequest cpr;
                k = classFilters.length;
                for (i = 0; i < k; ++i) {
                    cpr = this.getEventRequestManager().createClassPrepareRequest();
                    cpr.addClassFilter(classFilters[i]);
                    if (verbose) {
                        System.out.println("B     set class load request: " + classFilters[i]);
                    }
                    this.addEventRequest(cpr);
                }
                k = classExclusionFilters.length;
                for (i = 0; i < k; ++i) {
                    cpr = this.getEventRequestManager().createClassPrepareRequest();
                    cpr.addClassExclusionFilter(classExclusionFilters[i]);
                    if (verbose) {
                        System.out.println("B     set class load exclusion request: " + classExclusionFilters[i]);
                    }
                    this.addEventRequest(cpr);
                }
            }
            if ((breakpointType & 2) != 0) {
                ClassUnloadRequest cur;
                k = classFilters.length;
                for (i = 0; i < k; ++i) {
                    cur = this.getEventRequestManager().createClassUnloadRequest();
                    cur.addClassFilter(classFilters[i]);
                    if (verbose) {
                        System.out.println("B     set class unload request: " + classFilters[i]);
                    }
                    this.addEventRequest(cur);
                }
                k = classExclusionFilters.length;
                for (i = 0; i < k; ++i) {
                    cur = this.getEventRequestManager().createClassUnloadRequest();
                    cur.addClassExclusionFilter(classExclusionFilters[i]);
                    if (verbose) {
                        System.out.println("B     set class unload exclusion request: " + classExclusionFilters[i]);
                    }
                    this.addEventRequest(cur);
                }
            }
        }
        catch (VMDisconnectedException e) {
            // empty catch block
        }
    }

    protected boolean checkLoadedClasses(String className, boolean all) {
        VirtualMachine vm;
        if (verbose) {
            System.out.println("B   check loaded classes: " + className + " : " + all);
        }
        if ((vm = this.getVirtualMachine()) == null) {
            return false;
        }
        boolean matched = false;
        try {
            Iterator<ReferenceType> i = null;
            i = all ? vm.allClasses().iterator() : vm.classesByName(className).iterator();
            while (i.hasNext()) {
                String name;
                ReferenceType referenceType = i.next();
                if (i == null || !ClassBasedBreakpoint.match(name = referenceType.name(), className)) continue;
                if (verbose) {
                    System.out.println("B       cls loaded! " + referenceType);
                }
                this.classLoaded(referenceType);
                matched = true;
            }
        }
        catch (VMDisconnectedException e) {
            // empty catch block
        }
        return matched;
    }

    public boolean exec(Event event) {
        if (event instanceof ClassPrepareEvent) {
            this.classLoaded(((ClassPrepareEvent)event).referenceType());
        } else {
            this.classUnloaded(((ClassUnloadEvent)event).className());
        }
        return true;
    }

    protected void classLoaded(ReferenceType referenceType) {
    }

    protected void classUnloaded(String className) {
    }
}

