/*
 * Decompiled with CFR 0.152.
 */
package org.openide.src;

import java.io.Serializable;

public final class Identifier
implements Serializable {
    public static final int NOT_YET_RESOLVED = 0;
    public static final int RESOLVED = 1;
    public static final int UNRESOLVED = 2;
    private String fullName;
    private String sourceName;
    private int namePos;
    private transient Resolver resolver;
    private int status;
    static final long serialVersionUID = -2614114568575211024L;

    private Identifier(Resolver resolver, String sourceName) {
        this.fullName = null;
        this.sourceName = sourceName;
        this.resolver = resolver;
        this.status = 0;
    }

    Identifier(String fullName, String sourceName, int status) {
        if (sourceName == null) {
            throw new IllegalArgumentException();
        }
        this.sourceName = sourceName;
        this.fullName = fullName;
        this.status = status;
    }

    private void initNamePos() {
        this.setFullName();
        this.namePos = this.fullName.lastIndexOf(".");
        if (this.namePos != -1) {
            ++this.namePos;
        }
        if (this.fullName.startsWith(".") || this.fullName.endsWith(".")) {
            throw new IllegalArgumentException(this.fullName);
        }
    }

    private void setFullName() {
        if (this.fullName == null) {
            this.fullName = this.resolver == null ? this.sourceName : this.resolver.resolve().intern();
            this.resolver = null;
            if (this.fullName == null) {
                this.fullName = this.sourceName;
            }
        }
    }

    private Object readResolve() {
        if (this.fullName == null) {
            return Identifier.create(this.sourceName);
        }
        return Identifier.create(this.fullName, this.sourceName);
    }

    public static Identifier create(String name) {
        String n = name.intern();
        return new Identifier(null, n);
    }

    public static Identifier create(String fullName, String sourceName) {
        Identifier ret = new Identifier(null, sourceName.intern());
        ret.fullName = fullName.intern();
        ret.initNamePos();
        return ret;
    }

    public static Identifier create(String full, String sourceName, int status) {
        Identifier id = Identifier.create(full, sourceName);
        id.status = status;
        return id;
    }

    public static Identifier create(Resolver resolver, String name) {
        return new Identifier(resolver, name.intern());
    }

    public String getName() {
        int pos = this.sourceName.lastIndexOf(".");
        return pos == -1 ? this.sourceName : this.sourceName.substring(pos + 1);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getQualifier() {
        if (this.fullName == null) {
            this.initNamePos();
        }
        return this.namePos == -1 ? "" : this.fullName.substring(0, this.namePos - 1);
    }

    public boolean isQualified() {
        if (this.fullName == null) {
            this.initNamePos();
        }
        return this.namePos != -1;
    }

    public String getFullName() {
        if (this.fullName == null) {
            this.initNamePos();
        }
        return this.fullName;
    }

    public int getResolutionStatus() {
        return this.status;
    }

    public String toString() {
        return this.getSourceName();
    }

    public boolean compareTo(Identifier id, boolean source) {
        if (this.fullName == null) {
            this.initNamePos();
        }
        if (id.fullName == null) {
            id.initNamePos();
        }
        if (id.fullName == this.fullName) {
            return source ? id.sourceName == this.sourceName : true;
        }
        return false;
    }

    public boolean equals(Object o) {
        return o instanceof Identifier ? this.compareTo((Identifier)o, false) : false;
    }

    public int hashCode() {
        if (this.fullName == null) {
            this.initNamePos();
        }
        return this.fullName.hashCode();
    }

    public static interface Resolver {
        public String resolve();
    }
}

