/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.freeform.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.ant.freeform.spi.ProjectPropertiesPanel;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.modules.java.freeform.JavaProjectGenerator;
import org.netbeans.modules.java.freeform.ui.ProjectModel;
import org.netbeans.modules.java.freeform.ui.SourceFoldersPanel;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ClasspathPanel
extends JPanel
implements HelpCtx.Provider {
    private DefaultListModel listModel;
    private File lastChosenFile = null;
    private boolean isSeparateClasspath = true;
    private List compUnitsKeys;
    private boolean ignoreEvent;
    private ProjectModel model;
    private JButton addClasspath;
    private JList classpath;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JButton moveDown;
    private JButton moveUp;
    private JButton removeClasspath;
    private JCheckBox separateClasspath;
    private JComboBox sourceFolder;

    public ClasspathPanel() {
        this(true);
    }

    public ClasspathPanel(boolean isWizard) {
        this.initComponents();
        this.jTextArea1.setBackground(this.getBackground());
        this.listModel = new DefaultListModel();
        this.classpath.setModel(this.listModel);
        if (!isWizard) {
            this.jTextArea1.setText(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ClasspathPanel_Explanation"));
        }
        this.jTextArea1.setDisabledTextColor(this.jLabel2.getForeground());
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ClasspathPanel.class);
    }

    private void updateControls() {
        this.sourceFolder.removeAllItems();
        this.compUnitsKeys = this.model.createCompilationUnitKeys();
        this.isSeparateClasspath = !ProjectModel.isSingleCompilationUnit(this.compUnitsKeys);
        List names = ClasspathPanel.createComboContent(this.compUnitsKeys, this.model.getEvaluator(), this.model.getNBProjectFolder());
        Iterator it = names.iterator();
        while (it.hasNext()) {
            String nm = (String)it.next();
            this.sourceFolder.addItem(nm);
        }
        if (names.size() > 0) {
            this.ignoreEvent = true;
            this.sourceFolder.setSelectedIndex(0);
            this.ignoreEvent = false;
        }
        this.loadClasspath();
        boolean sepClasspath = this.model.canHaveSeparateClasspath();
        this.separateClasspath.setEnabled(sepClasspath);
        if (sepClasspath && this.isSeparateClasspath && !this.model.canCreateSingleCompilationUnit()) {
            this.separateClasspath.setEnabled(false);
        }
        this.jLabel2.setEnabled(sepClasspath && this.isSeparateClasspath);
        this.sourceFolder.setEnabled(sepClasspath && this.isSeparateClasspath);
        this.ignoreEvent = true;
        this.separateClasspath.setSelected(this.isSeparateClasspath);
        this.ignoreEvent = false;
        this.addClasspath.setEnabled(this.compUnitsKeys.size() > 0);
        this.classpath.setEnabled(this.compUnitsKeys.size() > 0);
    }

    static List createComboContent(List compilationUnitKeys, PropertyEvaluator evaluator, File nbProjectFolder) {
        ArrayList<String> l = new ArrayList<String>();
        Iterator it = compilationUnitKeys.iterator();
        while (it.hasNext()) {
            ProjectModel.CompilationUnitKey cul = (ProjectModel.CompilationUnitKey)it.next();
            String name = cul.locations.size() == 1 ? (cul.label != null ? cul.label + " [" + SourceFoldersPanel.getLocationDisplayName(evaluator, nbProjectFolder, (String)cul.locations.get(0)) + "]" : ClasspathPanel.convertListToString(cul.locations)) : ClasspathPanel.convertListToString(cul.locations);
            l.add(name);
        }
        return l;
    }

    private static String convertListToString(List l) {
        StringBuffer sb = new StringBuffer();
        Iterator it = l.iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            sb.append(s);
            if (!it.hasNext()) continue;
            sb.append(File.pathSeparatorChar + " ");
        }
        return sb.toString();
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.addClasspath = new JButton();
        this.removeClasspath = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.classpath = new JList();
        this.jPanel1 = new JPanel();
        this.sourceFolder = new JComboBox();
        this.moveUp = new JButton();
        this.moveDown = new JButton();
        this.jTextArea1 = new JTextArea();
        this.separateClasspath = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(275, 202));
        this.jLabel2.setLabelFor(this.sourceFolder);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ClasspathPanel_jLabel2"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel2.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSD_ClasspathPanel_jLabel2"));
        this.jLabel3.setLabelFor(this.classpath);
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ClasspathPanel_jLabel3"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel3.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSD_ClasspathPanel_jLabel3"));
        Mnemonics.setLocalizedText((AbstractButton)this.addClasspath, (String)NbBundle.getMessage((Class)ClasspathPanel.class, (String)"BTN_ClasspathPanel_addClasspath"));
        this.addClasspath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.addClasspathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.addClasspath, gridBagConstraints);
        this.addClasspath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSD_ClasspathPanel_addClasspath"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeClasspath, (String)NbBundle.getMessage((Class)ClasspathPanel.class, (String)"BTN_ClasspathPanel_removeClasspath"));
        this.removeClasspath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.removeClasspathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.removeClasspath, gridBagConstraints);
        this.removeClasspath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSD_ClasspathPanel_removeClasspath"));
        this.classpath.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                ClasspathPanel.this.classpathValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.classpath);
        this.classpath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSD_ClasspathPanel_classpath"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.sourceFolder.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ClasspathPanel.this.sourceFolderItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.sourceFolder, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.moveUp.setText(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ClasspathPanel_Move_Up"));
        this.moveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.moveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 6, 0);
        this.add((Component)this.moveUp, gridBagConstraints);
        this.moveUp.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_ClasspathPanel_noveUp"));
        this.moveDown.setText(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ClasspathPanel_Move_Down"));
        this.moveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.moveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.moveDown, gridBagConstraints);
        this.moveDown.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_ClasspathPanel_moveDown"));
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setText(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"MSG_ClasspathPanel_jTextArea"));
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.add((Component)this.jTextArea1, gridBagConstraints);
        this.jTextArea1.getAccessibleContext().setAccessibleName(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSN_ClasspathPanel_jTextArea"));
        this.jTextArea1.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"ACSD_ClasspathPanel_jTextArea"));
        this.separateClasspath.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.separateClasspath, (String)NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ClasspathPanel_sepatateClasspath"));
        this.separateClasspath.setMargin(new Insets(0, 0, 0, 0));
        this.separateClasspath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClasspathPanel.this.separateClasspathActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.separateClasspath, gridBagConstraints);
        this.separateClasspath.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/java/freeform/ui/Bundle").getString("AD_ClasspathPanel_separateClasspath"));
    }

    private void classpathValueChanged(ListSelectionEvent evt) {
        this.updateButtons();
    }

    private void separateClasspathActionPerformed(ActionEvent evt) {
        if (this.ignoreEvent) {
            return;
        }
        this.applyChanges();
        this.isSeparateClasspath = this.separateClasspath.isSelected();
        this.model.updateCompilationUnits(this.isSeparateClasspath);
        this.updateControls();
    }

    private void moveDownActionPerformed(ActionEvent evt) {
        int[] indices = this.classpath.getSelectedIndices();
        if (indices.length == 0 || indices[indices.length - 1] == this.listModel.getSize() - 1) {
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            Object o = this.listModel.remove(index);
            this.listModel.add(++index, o);
            indices[i] = index;
        }
        this.classpath.setSelectedIndices(indices);
        this.applyChanges();
        this.updateButtons();
    }

    private void moveUpActionPerformed(ActionEvent evt) {
        int[] indices = this.classpath.getSelectedIndices();
        if (indices.length == 0 || indices[0] == 0) {
            return;
        }
        for (int i = 0; i < indices.length; ++i) {
            int index = indices[i];
            Object o = this.listModel.remove(index);
            this.listModel.add(--index, o);
            indices[i] = index;
        }
        this.classpath.setSelectedIndices(indices);
        this.applyChanges();
        this.updateButtons();
    }

    private void sourceFolderItemStateChanged(ItemEvent evt) {
        if (this.ignoreEvent) {
            return;
        }
        if (evt.getStateChange() == 2) {
            int index = this.findIndex(evt.getItem());
            if (index != -1) {
                this.saveClasspath(index);
            }
        } else {
            this.loadClasspath();
        }
        this.updateButtons();
    }

    private int findIndex(Object o) {
        for (int i = 0; i < this.sourceFolder.getModel().getSize(); ++i) {
            if (!this.sourceFolder.getModel().getElementAt(i).equals(o)) continue;
            return i;
        }
        return -1;
    }

    private void saveClasspath(int index) {
        ProjectModel.CompilationUnitKey key = (ProjectModel.CompilationUnitKey)this.compUnitsKeys.get(index);
        JavaProjectGenerator.JavaCompilationUnit cu = this.model.getCompilationUnit(key, this.model.isTestSourceFolder(index));
        this.updateCompilationUnitCompileClasspath(cu);
    }

    private void loadClasspath() {
        int index;
        if (this.isSeparateClasspath) {
            index = this.sourceFolder.getSelectedIndex();
            if (index == -1) {
                return;
            }
        } else {
            index = 0;
        }
        ProjectModel.CompilationUnitKey key = (ProjectModel.CompilationUnitKey)this.compUnitsKeys.get(index);
        JavaProjectGenerator.JavaCompilationUnit cu = this.model.getCompilationUnit(key, this.model.isTestSourceFolder(index));
        this.updateJListClassPath(cu.classpath);
    }

    private void updateCompilationUnitCompileClasspath(JavaProjectGenerator.JavaCompilationUnit cu) {
        ArrayList<JavaProjectGenerator.JavaCompilationUnit.CP> cps = cu.classpath;
        if (cps != null) {
            Iterator it = cps.iterator();
            while (it.hasNext()) {
                JavaProjectGenerator.JavaCompilationUnit.CP cp = (JavaProjectGenerator.JavaCompilationUnit.CP)it.next();
                if (!cp.mode.equals("compile")) continue;
                it.remove();
            }
        }
        if (this.classpath.getModel().getSize() == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.classpath.getModel().getSize(); ++i) {
            File f = new File((String)this.classpath.getModel().getElementAt(i));
            String path = Util.relativizeLocation((File)this.model.getBaseFolder(), (File)this.model.getNBProjectFolder(), (File)f);
            sb.append(path);
            if (i + 1 >= this.classpath.getModel().getSize()) continue;
            sb.append(File.pathSeparatorChar);
        }
        if (sb.length() > 0) {
            if (cps == null) {
                cu.classpath = cps = new ArrayList<JavaProjectGenerator.JavaCompilationUnit.CP>();
            }
            JavaProjectGenerator.JavaCompilationUnit.CP cp = new JavaProjectGenerator.JavaCompilationUnit.CP();
            cp.mode = "compile";
            cp.classpath = sb.toString();
            cps.add(cp);
        }
    }

    private void updateJListClassPath(List cps) {
        this.listModel.removeAllElements();
        if (cps == null) {
            return;
        }
        Iterator it = cps.iterator();
        while (it.hasNext()) {
            JavaProjectGenerator.JavaCompilationUnit.CP cp = (JavaProjectGenerator.JavaCompilationUnit.CP)it.next();
            if (!cp.mode.equals("compile")) continue;
            String[] cpa = PropertyUtils.tokenizePath((String)this.model.getEvaluator().evaluate(cp.classpath));
            for (int i = 0; i < cpa.length; ++i) {
                String path = cpa[i];
                path = PropertyUtils.resolveFile((File)this.model.getNBProjectFolder(), (String)path).getAbsolutePath();
                if (path == null) continue;
                this.listModel.addElement(path);
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        int[] indices = this.classpath.getSelectedIndices();
        this.removeClasspath.setEnabled(this.listModel.getSize() > 0 && indices.length != 0);
        this.moveUp.setEnabled(indices.length > 0 && indices[0] != 0);
        this.moveDown.setEnabled(indices.length > 0 && indices[indices.length - 1] != this.listModel.getSize() - 1);
    }

    private void removeClasspathActionPerformed(ActionEvent evt) {
        int[] entries = this.classpath.getSelectedIndices();
        for (int i = 0; i < entries.length; ++i) {
            this.listModel.remove(entries[i] - i);
        }
        this.applyChanges();
        this.updateButtons();
    }

    private void addClasspathActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, null);
        chooser.setFileSelectionMode(2);
        chooser.setMultiSelectionEnabled(true);
        if (this.lastChosenFile != null) {
            chooser.setSelectedFile(this.lastChosenFile);
        } else {
            File[] files = this.model.getBaseFolder().listFiles();
            if (files != null && files.length > 0) {
                chooser.setSelectedFile(files[0]);
            } else {
                chooser.setSelectedFile(this.model.getBaseFolder());
            }
        }
        chooser.setDialogTitle(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_Browse_Classpath"));
        SimpleFileFilter fileFilter = new SimpleFileFilter(NbBundle.getMessage((Class)ClasspathPanel.class, (String)"LBL_ZipJarFolderFilter"), new String[]{"ZIP", "JAR"});
        chooser.setFileFilter(fileFilter);
        chooser.setAcceptAllFileFilterUsed(false);
        if (0 == chooser.showOpenDialog(this)) {
            File[] files = chooser.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = FileUtil.normalizeFile((File)files[i]);
                if (!((FileFilter)fileFilter).accept(file)) continue;
                this.listModel.addElement(file.getAbsolutePath());
                this.lastChosenFile = file;
            }
            this.applyChanges();
            this.updateButtons();
        }
    }

    private void applyChanges() {
        if (this.isSeparateClasspath) {
            if (this.sourceFolder.getSelectedIndex() != -1) {
                this.saveClasspath(this.sourceFolder.getSelectedIndex());
            }
        } else {
            this.saveClasspath(0);
        }
    }

    public void setModel(ProjectModel model) {
        this.model = model;
        this.updateControls();
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private Collection extensions;

        public SimpleFileFilter(String description, String[] extensions) {
            this.description = description;
            this.extensions = Arrays.asList(extensions);
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            try {
                return FileUtil.isArchiveFile((URL)f.toURI().toURL());
            }
            catch (MalformedURLException mue) {
                ErrorManager.getDefault().notify((Throwable)mue);
                return false;
            }
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static class Panel
    implements ProjectPropertiesPanel,
    ChangeListener {
        private ClasspathPanel panel;
        private ProjectModel model;

        public Panel(ProjectModel model) {
            this.model = model;
        }

        public void storeValues() {
        }

        public String getDisplayName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$java$freeform$ui$ClasspathPanel == null ? (class$org$netbeans$modules$java$freeform$ui$ClasspathPanel = ClasspathPanel.class$("org.netbeans.modules.java.freeform.ui.ClasspathPanel")) : class$org$netbeans$modules$java$freeform$ui$ClasspathPanel), (String)"LBL_ProjectCustomizer_Category_Classpath");
        }

        public JComponent getComponent() {
            if (this.panel == null) {
                this.panel = new ClasspathPanel(false);
                this.panel.setModel(this.model);
                this.model.addChangeListener(this);
            }
            return this.panel;
        }

        public void stateChanged(ChangeEvent e) {
            this.panel.updateControls();
        }

        public int getPreferredPosition() {
            return 200;
        }
    }
}

