/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.form.layoutdesign.LayoutAligner;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutDragger;
import org.netbeans.modules.form.layoutdesign.LayoutEvent;
import org.netbeans.modules.form.layoutdesign.LayoutFeeder;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.LayoutOperations;
import org.netbeans.modules.form.layoutdesign.LayoutRegion;
import org.netbeans.modules.form.layoutdesign.LayoutTestUtils;
import org.netbeans.modules.form.layoutdesign.LayoutUtils;
import org.netbeans.modules.form.layoutdesign.VisualMapper;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;

public class LayoutDesigner
implements LayoutConstants {
    private LayoutModel layoutModel;
    private VisualMapper visualMapper;
    private LayoutDragger dragger;
    private LayoutOperations operations;
    private Listener modelListener;
    private boolean imposeSize = true;
    private boolean optimizeStructure = true;
    private boolean visualStateUpToDate;
    private Image linkBadgeBoth = null;
    private Image linkBadgeHorizontal = null;
    private Image linkBadgeVertical = null;
    private static final int BOTH_DIMENSIONS = 2;
    private int[] cursorPos = new int[]{0, 0};
    private boolean[][] resizability = new boolean[][]{{true, true}, {true, true}};
    static final String TEST_SWITCH = "netbeans.form.layout_test";
    public List testCode = new ArrayList();
    private List testCode0 = new ArrayList();
    private List beforeMove = new ArrayList();
    private List move1 = new ArrayList();
    private List move2 = new ArrayList();
    private boolean isMoving = false;
    private int modelCounter = -1;
    private Point lastMovePoint = new Point(0, 0);

    public LayoutDesigner(LayoutModel model, VisualMapper mapper) {
        this.layoutModel = model;
        this.visualMapper = mapper;
        this.operations = new LayoutOperations(model, mapper);
        this.modelListener = new Listener();
        this.modelListener.activate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateCurrentState() {
        if (this.logTestCode()) {
            this.testCode.add("// > UPDATE CURRENT STATE");
        }
        Object changeMark = this.layoutModel.getChangeMark();
        boolean changeRequired = this.imposeSize || this.optimizeStructure;
        HashSet updatedContainers = changeRequired ? new HashSet() : null;
        try {
            if (changeRequired) {
                this.modelListener.deactivate();
                this.destroyRedundantGroups(updatedContainers);
                this.operations.mergeAdjacentGaps(updatedContainers);
            }
            this.updatePositions(updatedContainers);
        }
        finally {
            if (changeRequired) {
                this.modelListener.activate();
            }
        }
        if (changeRequired) {
            this.optimizeStructure = false;
            this.imposeSize = false;
            if (updatedContainers != null) {
                for (LayoutComponent cont : updatedContainers) {
                    this.visualMapper.rebuildLayout(cont.getId());
                }
                this.updatePositions(null);
            }
        }
        if (this.logTestCode()) {
            this.testCode.add("ld.updateCurrentState();");
            this.testCode.add("// < UPDATE CURRENT STATE");
        }
        this.visualStateUpToDate = true;
        return !changeMark.equals(this.layoutModel.getChangeMark());
    }

    public void externalSizeChangeHappened() {
        this.imposeSize = true;
        this.visualStateUpToDate = false;
        if (this.logTestCode()) {
            this.testCode.add("ld.externalSizeChangeHappened();");
        }
    }

    void requireStructureOptimization() {
        this.optimizeStructure = true;
        this.visualStateUpToDate = false;
        Iterator it = this.layoutModel.getAllComponents();
        while (it.hasNext()) {
            LayoutComponent comp = (LayoutComponent)it.next();
            if (!comp.isLayoutContainer()) continue;
            for (int i = 0; i < 2; ++i) {
                LayoutDesigner.cleanDesignAttrs(comp.getLayoutRoot(i));
            }
        }
    }

    private void updatePositions(Set updatedContainers) {
        Iterator it = this.layoutModel.getAllComponents();
        while (it.hasNext()) {
            LayoutComponent comp = (LayoutComponent)it.next();
            if (!comp.isLayoutContainer()) continue;
            if (this.optimizeStructure || this.imposeSize) {
                if (!this.imposeCurrentContainerSize(comp, null, false)) continue;
                updatedContainers.add(comp);
                for (int i = 0; i < 2; ++i) {
                    LayoutInterval root = comp.getLayoutRoot(i);
                    if (this.optimizeStructure) {
                        this.optimizeGaps(root, i, true);
                        this.destroyRedundantGroups(root);
                    }
                    this.updateDesignModifications(root, i);
                }
                continue;
            }
            Rectangle bounds = this.visualMapper.getContainerInterior(comp.getId());
            if (bounds == null) continue;
            comp.setCurrentInterior(bounds);
            Iterator it2 = comp.getSubcomponents();
            while (it2.hasNext()) {
                LayoutComponent subComp = (LayoutComponent)it2.next();
                bounds = this.visualMapper.getComponentBounds(subComp.getId());
                int baseline = this.visualMapper.getBaselinePosition(subComp.getId(), bounds.width, bounds.height);
                subComp.setCurrentBounds(bounds, baseline);
            }
            for (int i = 0; i < 2; ++i) {
                this.updateLayoutStructure(comp.getLayoutRoot(i), i, false);
            }
        }
    }

    void updateLayoutStructure(LayoutInterval interval, int dimension, boolean imposeGaps) {
        LayoutRegion space = interval.getCurrentSpace();
        boolean baseline = interval.getGroupAlignment() == 3;
        boolean first = true;
        boolean firstResizingSpace = false;
        int leadingSpace = 0;
        boolean skipNext = false;
        Iterator it = interval.getSubIntervals();
        while (it.hasNext()) {
            int baselinePos;
            LayoutInterval sub = (LayoutInterval)it.next();
            if (sub.isEmptySpace()) {
                if (!interval.isSequential()) {
                    assert (interval.getParent() == null);
                    if (imposeGaps && space.isSet(dimension)) {
                        this.imposeCurrentGapSize(sub, space.size(dimension), dimension);
                    }
                } else if (first || !it.hasNext()) {
                    int min = sub.getMinimumSize(true);
                    int pref = sub.getPreferredSize(true);
                    int max = sub.getMaximumSize(true);
                    if (!(min != pref && min != -2 || pref != max && max != -2 || pref == -1)) {
                        if (first) {
                            leadingSpace = pref;
                        } else {
                            space.reshape(dimension, 1, pref);
                        }
                    } else {
                        LayoutRegion sibSpace;
                        int currentPref = Integer.MIN_VALUE;
                        LayoutInterval sibling = LayoutInterval.getNeighbor(sub, 102, first ? 0 : 1);
                        if (sibling == null) {
                            LayoutRegion rootSpace = LayoutInterval.getRoot(interval).getCurrentSpace();
                            if (first) {
                                firstResizingSpace = true;
                                leadingSpace = -rootSpace.positions[dimension][0];
                            } else {
                                currentPref = rootSpace.positions[dimension][1] - space.positions[dimension][1];
                                space.reshape(dimension, 1, currentPref);
                            }
                        } else if (sibling.isEmptySpace()) {
                            int align;
                            LayoutInterval parent;
                            LayoutInterval alignedParent = parent = interval.getParent();
                            int n = align = first ? 0 : 1;
                            while (parent != null && LayoutInterval.isAlignedAtBorder(interval, parent, align)) {
                                alignedParent = parent;
                                parent = parent.getParent();
                            }
                            LayoutInterval parComp = LayoutUtils.getOutermostComponent(alignedParent, dimension, align);
                            LayoutRegion parSpace = parComp.getCurrentSpace();
                            if (first) {
                                firstResizingSpace = true;
                                leadingSpace = -parSpace.positions[dimension][0];
                            } else {
                                currentPref = parSpace.positions[dimension][1] - space.positions[dimension][1];
                                space.reshape(dimension, 1, currentPref);
                            }
                        } else if (first) {
                            firstResizingSpace = true;
                            sibSpace = sibling.getCurrentSpace();
                            leadingSpace = -sibSpace.positions[dimension][1];
                        } else {
                            int sibPos;
                            sibSpace = sibling.getCurrentSpace();
                            if (!sibling.isComponent()) {
                                sibSpace.reset();
                                this.updateLayoutStructure(sibling, dimension, imposeGaps);
                                skipNext = true;
                            }
                            if ((sibPos = sibSpace.positions[dimension][0]) != Integer.MIN_VALUE) {
                                currentPref = sibPos - space.positions[dimension][1];
                                space.reshape(dimension, 1, currentPref);
                            }
                        }
                        if (imposeGaps && currentPref != Integer.MIN_VALUE) {
                            this.imposeCurrentGapSize(sub, currentPref, dimension);
                        }
                    }
                } else if (imposeGaps) {
                    LayoutInterval sibling = LayoutInterval.getDirectNeighbor(sub, 1, false);
                    assert (!sibling.isEmptySpace());
                    LayoutRegion sibSpace = sibling.getCurrentSpace();
                    if (!sibling.isComponent()) {
                        sibSpace.reset();
                        this.updateLayoutStructure(sibling, dimension, imposeGaps);
                        skipNext = true;
                    }
                    int currentSize = LayoutRegion.distance(space, sibSpace, dimension, 1, 0);
                    this.imposeCurrentGapSize(sub, currentSize, dimension);
                }
                first = false;
                continue;
            }
            LayoutRegion subSpace = sub.getCurrentSpace();
            if (skipNext) {
                skipNext = false;
            } else if (sub.isGroup()) {
                assert (sub.getSubIntervalCount() > 0);
                subSpace.reset();
                this.updateLayoutStructure(sub, dimension, imposeGaps);
            }
            space.expand(subSpace);
            if (baseline && sub.isComponent() && (baselinePos = subSpace.positions[dimension][3]) != Integer.MIN_VALUE) {
                space.positions[dimension][3] = baselinePos;
                baseline = false;
            }
            if (firstResizingSpace) {
                leadingSpace += space.positions[dimension][0];
                firstResizingSpace = false;
                if (imposeGaps) {
                    this.imposeCurrentGapSize(interval.getSubInterval(0), leadingSpace, dimension);
                }
            }
            first = false;
        }
        if (leadingSpace != 0) {
            space.reshape(dimension, 0, -leadingSpace);
        }
    }

    public void dumpTestcode(DataObject form) {
        LayoutTestUtils.dumpTestcode(this.testCode, form, this.getModelCounter());
        this.testCode = new ArrayList();
        this.testCode0 = new ArrayList();
        this.beforeMove = new ArrayList();
        this.move1 = new ArrayList();
        this.move2 = new ArrayList();
        this.isMoving = false;
    }

    public void startAdding(LayoutComponent[] comps, Rectangle[] bounds, Point hotspot, String defaultContId) {
        if (this.logTestCode()) {
            this.testCode.add("// > START ADDING");
        }
        this.prepareDragger(comps, bounds, hotspot, LayoutDragger.ALL_EDGES);
        if (this.logTestCode()) {
            this.testCode.add("{");
            LayoutTestUtils.writeLayoutComponentArray(this.testCode, "comps", "lc");
            LayoutTestUtils.writeRectangleArray(this.testCode, "bounds", bounds);
            LayoutTestUtils.writeString(this.testCode, "defaultContId", defaultContId);
            this.testCode.add("Point hotspot = new Point(" + new Double(hotspot.getX()).intValue() + "," + new Double(hotspot.getY()).intValue() + ");");
            this.testCode.add("ld.startAdding(comps, bounds, hotspot, defaultContId);");
            this.testCode.add("}");
        }
        if (defaultContId != null) {
            this.dragger.setTargetContainer(this.layoutModel.getLayoutComponent(defaultContId));
        }
        if (this.logTestCode()) {
            this.testCode.add("// < START ADDING");
        }
    }

    public void startMoving(String[] compIds, Rectangle[] bounds, Point hotspot) {
        if (this.logTestCode()) {
            this.testCode.add("// > START MOVING");
        }
        LayoutComponent[] comps = new LayoutComponent[compIds.length];
        for (int i = 0; i < compIds.length; ++i) {
            comps[i] = this.layoutModel.getLayoutComponent(compIds[i]);
        }
        this.prepareDragger(comps, bounds, hotspot, LayoutDragger.ALL_EDGES);
        if (this.logTestCode()) {
            this.testCode.add("{");
            LayoutTestUtils.writeStringArray(this.testCode, "compIds", compIds);
            LayoutTestUtils.writeRectangleArray(this.testCode, "bounds", bounds);
            this.testCode.add("Point hotspot = new Point(" + new Double(hotspot.getX()).intValue() + "," + new Double(hotspot.getY()).intValue() + ");");
            this.testCode.add("ld.startMoving(compIds, bounds, hotspot);");
            this.testCode.add("}");
        }
        this.dragger.setTargetContainer(comps[0].getParent());
        if (this.logTestCode()) {
            this.testCode.add("// < START MOVING");
        }
    }

    public void startResizing(String[] compIds, Rectangle[] bounds, Point hotspot, int[] resizeEdges, boolean inLayout) {
        if (this.logTestCode()) {
            this.testCode.add("// > START RESIZING");
        }
        LayoutComponent[] comps = new LayoutComponent[compIds.length];
        for (int i = 0; i < compIds.length; ++i) {
            comps[i] = this.layoutModel.getLayoutComponent(compIds[i]);
        }
        int[] edges = new int[2];
        for (int i = 0; i < 2; ++i) {
            edges[i] = resizeEdges[i] == 0 || resizeEdges[i] == 1 ? resizeEdges[i] : Integer.MIN_VALUE;
        }
        this.prepareDragger(comps, bounds, hotspot, edges);
        if (this.logTestCode()) {
            this.testCode.add("{");
            LayoutTestUtils.writeStringArray(this.testCode, "compIds", compIds);
            LayoutTestUtils.writeRectangleArray(this.testCode, "bounds", bounds);
            this.testCode.add("Point hotspot = new Point(" + new Double(hotspot.getX()).intValue() + "," + new Double(hotspot.getY()).intValue() + ");");
            LayoutTestUtils.writeIntArray(this.testCode, "resizeEdges", resizeEdges);
            this.testCode.add("boolean inLayout = " + inLayout + ";");
            this.testCode.add("ld.startResizing(compIds, bounds, hotspot, resizeEdges, inLayout);");
            this.testCode.add("}");
        }
        this.dragger.setTargetContainer(inLayout ? comps[0].getParent() : null);
        if (this.logTestCode()) {
            this.testCode.add("// < START RESIZING");
        }
    }

    private void prepareDragger(LayoutComponent[] comps, Rectangle[] bounds, Point hotspot, int[] edges) {
        if (comps.length != bounds.length) {
            throw new IllegalArgumentException();
        }
        LayoutRegion[] movingFormation = new LayoutRegion[bounds.length];
        for (int i = 0; i < bounds.length; ++i) {
            int baseline = this.visualMapper.getBaselinePosition(comps[i].getId(), bounds[i].width, bounds[i].height);
            int baselinePos = baseline > 0 ? bounds[i].y + baseline : Integer.MIN_VALUE;
            movingFormation[i] = new LayoutRegion();
            movingFormation[i].set(bounds[i], baselinePos);
        }
        this.dragger = new LayoutDragger(comps, movingFormation, new int[]{hotspot.x, hotspot.y}, edges, this.visualMapper);
    }

    public void move(Point p, String containerId, boolean autoPositioning, boolean lockDimension, Rectangle[] bounds) {
        int y;
        int x = p != null ? p.x : 0;
        int n = y = p != null ? p.y : 0;
        if (this.logTestCode()) {
            if (!this.isMoving) {
                this.isMoving = true;
                this.beforeMove = new ArrayList();
                this.beforeMove.addAll(this.testCode);
                this.testCode = new ArrayList();
                this.lastMovePoint = new Point(0, 0);
            }
            if (x != this.lastMovePoint.x || y != this.lastMovePoint.y) {
                this.lastMovePoint = new Point(x, y);
                this.move1 = this.move2;
                this.testCode0 = this.testCode;
            }
            this.move2 = new ArrayList();
            this.move2.add("// > MOVE");
            this.testCode = new ArrayList();
        }
        if (!this.visualStateUpToDate || this.dragger == null) {
            return;
        }
        if (!(this.dragger.isResizing() || lockDimension && this.dragger.getTargetContainer() != null)) {
            this.dragger.setTargetContainer(this.layoutModel.getLayoutComponent(containerId));
        }
        this.cursorPos[0] = p.x;
        this.cursorPos[1] = p.y;
        this.dragger.move(this.cursorPos, autoPositioning, lockDimension);
        p.x = this.cursorPos[0];
        p.y = this.cursorPos[1];
        if (bounds != null) {
            LayoutRegion[] current = this.dragger.getMovingBounds();
            for (int i = 0; i < current.length; ++i) {
                current[i].toRectangle(bounds[i]);
            }
        }
        if (this.logTestCode()) {
            this.move2.add("{");
            this.move2.add("Point p = new Point(" + x + "," + y + ");");
            LayoutTestUtils.writeString(this.move2, "containerId", containerId);
            this.move2.add("boolean autoPositioning = " + autoPositioning + ";");
            this.move2.add("boolean lockDimension = " + lockDimension + ";");
            LayoutTestUtils.writeRectangleArray(this.move2, "bounds", bounds);
            this.move2.add("ld.move(p, containerId, autoPositioning, lockDimension, bounds);");
            this.move2.add("}");
            this.move2.add("// < MOVE");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endMoving(boolean committed) {
        if (!committed && this.dragger == null) {
            return;
        }
        if (this.logTestCode()) {
            if (committed) {
                this.beforeMove.addAll(this.testCode0);
                this.beforeMove.addAll(this.move1);
                this.beforeMove.addAll(this.testCode);
                this.beforeMove.addAll(this.move2);
                this.testCode = this.beforeMove;
            }
            this.testCode.add("// > END MOVING");
            this.isMoving = false;
        }
        try {
            if (committed) {
                LayoutComponent[] components = this.dragger.getMovingComponents();
                LayoutComponent targetContainer = this.dragger.getTargetContainer();
                if (targetContainer != null) {
                    int i;
                    boolean newComponent = components[0].getParent() == null;
                    LayoutInterval[] addingInts = new LayoutInterval[2];
                    LayoutRegion origSpace = null;
                    for (int dim = 0; dim < 2; ++dim) {
                        if (components.length > 1) {
                            if (newComponent) {
                                for (i = 0; i < components.length; ++i) {
                                    this.layoutModel.addComponent(components[i], targetContainer, -1);
                                }
                                addingInts = this.layoutModel.createIntervalsFromBounds(this.dragger.getMovingSpace(), components, this.dragger.getMovingBounds());
                                break;
                            }
                            if (origSpace == null) {
                                origSpace = new LayoutRegion();
                                for (int i2 = 0; i2 < components.length; ++i2) {
                                    origSpace.expand(components[i2].getLayoutInterval(0).getCurrentSpace());
                                }
                            }
                            LayoutInterval[] children = new LayoutInterval[components.length];
                            for (int i3 = 0; i3 < components.length; ++i3) {
                                children[i3] = components[i3].getLayoutInterval(dim);
                            }
                            LayoutInterval parent = LayoutInterval.getCommonParent(children);
                            addingInts[dim] = this.restrictedCopy(parent, components, origSpace, dim, null);
                            continue;
                        }
                        addingInts[dim] = components[0].getLayoutInterval(dim);
                        if (!newComponent) continue;
                        Dimension preferred = this.visualMapper.getComponentPreferredSize(components[0].getId());
                        int size = this.dragger.getMovingBounds()[0].size(dim);
                        if (size == (dim == 0 ? preferred.width : preferred.height)) continue;
                        LayoutInterval intr = addingInts[dim];
                        this.layoutModel.setIntervalSize(intr, intr.getMinimumSize(), size, intr.getMaximumSize());
                    }
                    LayoutFeeder layoutFeeder = new LayoutFeeder(this.operations, this.dragger, addingInts);
                    for (i = 0; i < components.length; ++i) {
                        if (components[i].getParent() == null) continue;
                        LayoutComponent comp = components[i];
                        if (components[i].getParent() != null) {
                            if (this.dragger.isResizing(0)) {
                                this.layoutModel.removeComponentFromLinkSizedGroup(components[i], 0);
                            }
                            if (this.dragger.isResizing(1)) {
                                this.layoutModel.removeComponentFromLinkSizedGroup(components[i], 1);
                            }
                        }
                        if (components.length == 1) {
                            this.layoutModel.removeComponentAndIntervals(comp, false);
                            continue;
                        }
                        this.layoutModel.removeComponent(comp, false);
                    }
                    this.modelListener.deactivate();
                    for (i = 0; i < components.length; ++i) {
                        this.layoutModel.addComponent(components[i], targetContainer, -1);
                    }
                    layoutFeeder.add();
                    if (layoutFeeder.imposeSize) {
                        this.imposeSize = true;
                    }
                    if (layoutFeeder.optimizeStructure) {
                        this.optimizeStructure = true;
                    }
                    for (int dim = 0; dim < 2; ++dim) {
                        this.destroyGroupIfRedundant(addingInts[dim], addingInts[dim].getParent());
                    }
                    if (components[0].isLayoutContainer() && (this.dragger.isResizing() || newComponent)) {
                        this.imposeCurrentContainerSize(components[0], this.dragger.getSizes(), true);
                    } else if (this.dragger.isResizing() && !components[0].isLayoutContainer()) {
                        for (i = 0; i < 2; ++i) {
                            if (!this.dragger.snappedToDefaultSize(i)) continue;
                            this.operations.resizeInterval(components[0].getLayoutInterval(i), -1);
                        }
                    }
                    this.updateDesignModifications(targetContainer);
                } else {
                    assert (this.dragger.isResizing());
                    this.modelListener.deactivate();
                    LayoutRegion space = this.dragger.getMovingBounds()[0];
                    for (int dim = 0; dim < 2; ++dim) {
                        components[0].getLayoutInterval(dim).setCurrentSpace(space);
                    }
                    if (components[0].isLayoutContainer()) {
                        this.imposeCurrentContainerSize(components[0], this.dragger.getSizes(), true);
                    }
                }
                if (this.dragger.isResizing() && components[0].isLayoutContainer()) {
                    this.updateDesignModifications(components[0]);
                }
                this.visualStateUpToDate = false;
            }
        }
        finally {
            this.modelListener.activate();
            this.dragger = null;
            if (this.logTestCode()) {
                this.testCode.add("ld.endMoving(" + committed + ");");
                this.testCode.add("// < END MOVING");
            }
        }
    }

    private LayoutInterval restrictedCopy(LayoutInterval interval, LayoutComponent[] components, LayoutRegion space, int dimension, List temp) {
        boolean processTemp;
        boolean bl = processTemp = temp == null;
        if (temp == null) {
            temp = new LinkedList<Object>();
        }
        if (interval.isGroup()) {
            LayoutInterval subCopy;
            boolean parallel = interval.isParallel();
            LayoutInterval copy = new LayoutInterval(parallel ? 103 : 102);
            copy.setAlignment(interval.getAlignment());
            copy.setAttributes(interval.getAttributes());
            copy.setSizes(interval.getMinimumSize(), interval.getPreferredSize(), interval.getMaximumSize());
            if (parallel) {
                copy.setGroupAlignment(interval.getGroupAlignment());
            }
            Iterator iter = interval.getSubIntervals();
            int compCount = 0;
            boolean includeGap = false;
            int firstGapToInclude = 0;
            int gapStart = interval.getCurrentSpace().positions[dimension][0];
            while (iter.hasNext()) {
                LayoutInterval sub = (LayoutInterval)iter.next();
                subCopy = this.restrictedCopy(sub, components, space, dimension, temp);
                if (subCopy != null) {
                    if (!sub.isEmptySpace()) {
                        if (includeGap) {
                            gapStart = Math.max(space.positions[dimension][0], gapStart);
                            int size = sub.getCurrentSpace().positions[dimension][0] - gapStart;
                            this.integrateGap(copy, size, firstGapToInclude);
                            includeGap = false;
                        }
                        gapStart = sub.getCurrentSpace().positions[dimension][1];
                        firstGapToInclude = copy.getSubIntervalCount();
                    }
                    if (sub.isComponent()) {
                        temp.add(subCopy);
                        temp.add(copy);
                        temp.add(new Integer(subCopy.getRawAlignment()));
                        temp.add(new Integer(copy.getSubIntervalCount() + compCount));
                        ++compCount;
                        continue;
                    }
                    this.layoutModel.addInterval(subCopy, copy, -1);
                    continue;
                }
                if (parallel) continue;
                includeGap = true;
            }
            if (includeGap) {
                gapStart = Math.max(space.positions[dimension][0], gapStart);
                int gapEnd = Math.min(space.positions[dimension][1], interval.getCurrentSpace().positions[dimension][1]);
                this.integrateGap(copy, gapEnd - gapStart, firstGapToInclude);
            }
            if (copy.getSubIntervalCount() + compCount > 0) {
                if (processTemp) {
                    iter = temp.iterator();
                    while (iter.hasNext()) {
                        LayoutInterval comp = (LayoutInterval)iter.next();
                        LayoutInterval parent = (LayoutInterval)iter.next();
                        int alignment = (Integer)iter.next();
                        int index = (Integer)iter.next();
                        this.layoutModel.removeInterval(comp);
                        this.layoutModel.setIntervalAlignment(comp, alignment);
                        this.layoutModel.addInterval(comp, parent, index);
                    }
                    boolean active = this.modelListener.isActive();
                    if (active) {
                        this.modelListener.deactivate();
                    }
                    iter = temp.iterator();
                    while (iter.hasNext()) {
                        iter.next();
                        LayoutInterval group = (LayoutInterval)iter.next();
                        iter.next();
                        iter.next();
                        while (group.getSubIntervalCount() == 1) {
                            LayoutInterval sub = group.getSubInterval(0);
                            LayoutInterval parent = group.getParent();
                            this.layoutModel.removeInterval(sub);
                            int alignment = group.getAlignment();
                            int index = this.layoutModel.removeInterval(group);
                            this.layoutModel.setIntervalAlignment(sub, alignment);
                            this.layoutModel.addInterval(sub, parent, index);
                            group = sub;
                        }
                    }
                    compCount = 0;
                    if (active) {
                        this.modelListener.activate();
                    }
                }
                if (copy.getSubIntervalCount() == 1 && compCount == 0) {
                    boolean active = this.modelListener.isActive();
                    if (active) {
                        this.modelListener.deactivate();
                    }
                    subCopy = copy.getSubInterval(0);
                    this.layoutModel.removeInterval(subCopy);
                    this.layoutModel.setIntervalAlignment(subCopy, copy.getAlignment());
                    copy = copy.isSequential() && subCopy.isEmptySpace() ? null : subCopy;
                    if (active) {
                        this.modelListener.activate();
                    }
                }
                return copy;
            }
            return null;
        }
        if (interval.isComponent()) {
            LayoutComponent comp = interval.getComponent();
            if (Arrays.asList(components).contains(comp)) {
                return interval;
            }
            return null;
        }
        assert (interval.isEmptySpace());
        int[] bounds = this.emptySpaceBounds(interval, dimension);
        int rangeStart = space.positions[dimension][0];
        int rangeEnd = space.positions[dimension][1];
        if (bounds[0] < rangeEnd && bounds[1] > rangeStart) {
            LayoutInterval gap = new LayoutInterval(101);
            gap.setAttributes(interval.getAttributes());
            if (bounds[0] < rangeStart || bounds[1] > rangeEnd) {
                int min = interval.getMinimumSize();
                if (min >= 0) {
                    min = -2;
                }
                int pref = Math.min(bounds[1], rangeEnd) - Math.max(bounds[0], rangeStart);
                int max = interval.getMaximumSize();
                if (max >= 0) {
                    max = -2;
                }
                gap.setSizes(min, pref, max);
            } else {
                gap.setSizes(interval.getMinimumSize(), interval.getPreferredSize(), interval.getMaximumSize());
            }
            return gap;
        }
        return null;
    }

    private void integrateGap(LayoutInterval seqGroup, int size, int boundary) {
        while (seqGroup.getSubIntervalCount() > boundary && seqGroup.getSubInterval(seqGroup.getSubIntervalCount() - 1).isEmptySpace()) {
            this.layoutModel.removeInterval(seqGroup.getSubInterval(seqGroup.getSubIntervalCount() - 1));
        }
        if (size > 0) {
            LayoutInterval gap = new LayoutInterval(101);
            gap.setSize(size);
            this.layoutModel.addInterval(gap, seqGroup, -1);
        }
    }

    private int[] emptySpaceBounds(LayoutInterval emptySpace, int dimension) {
        assert (emptySpace.isEmptySpace());
        LayoutInterval parent = emptySpace.getParent();
        int index = parent.indexOf(emptySpace);
        int leading = index == 0 ? parent.getCurrentSpace().positions[dimension][0] : parent.getSubInterval((int)(index - 1)).getCurrentSpace().positions[dimension][1];
        int trailing = index + 1 == parent.getSubIntervalCount() ? parent.getCurrentSpace().positions[dimension][1] : parent.getSubInterval((int)(index + 1)).getCurrentSpace().positions[dimension][0];
        return new int[]{leading, trailing};
    }

    public void removeDraggedComponents() {
        if (this.dragger != null) {
            LayoutComponent[] components = this.dragger.getMovingComponents();
            for (int i = 0; i < components.length; ++i) {
                this.layoutModel.removeComponentAndIntervals(components[i], !components[i].isLayoutContainer());
            }
            this.endMoving(false);
        }
    }

    public void paintMoveFeedback(Graphics2D g) {
        if (this.dragger != null) {
            this.dragger.paintMoveFeedback(g);
        }
    }

    public void paintSelection(Graphics2D g, String componentId) {
        LayoutComponent comp = this.layoutModel.getLayoutComponent(componentId);
        if (comp != null && comp.getParent() != null) {
            this.paintSelection(g, comp, 0);
            this.paintSelection(g, comp, 1);
        }
    }

    private void paintSelection(Graphics2D g, LayoutComponent component, int dimension) {
        LayoutInterval interval = component.getLayoutInterval(dimension);
        if (component.isLinkSized(0) || component.isLinkSized(1)) {
            this.paintLinks(g, component);
        }
        if (interval.getAlignment() == 3) {
            LayoutInterval alignedParent = interval.getParent();
            int oppDimension = dimension == 0 ? 1 : 0;
            LayoutRegion region = alignedParent.getCurrentSpace();
            int x = region.positions[dimension][3];
            int y1 = region.positions[oppDimension][0];
            int y2 = region.positions[oppDimension][1];
            if (y1 != Integer.MIN_VALUE && y2 != Integer.MIN_VALUE) {
                if (dimension == 0) {
                    g.drawLine(x, y1, x, y2);
                } else {
                    g.drawLine(y1, x, y2, x);
                }
            }
        }
        int lastAlignment = -1;
        while (interval.getParent() != null) {
            int alignment;
            LayoutInterval parent = interval.getParent();
            if (parent.getType() == 102) {
                int end;
                alignment = LayoutInterval.getEffectiveAlignment(interval);
                int index = parent.indexOf(interval);
                block0 : switch (alignment) {
                    case 0: {
                        int start = 0;
                        end = index;
                        lastAlignment = 0;
                        break;
                    }
                    case 1: {
                        int start = index + 1;
                        end = parent.getSubIntervalCount();
                        lastAlignment = 1;
                        break;
                    }
                    default: {
                        int start;
                        switch (lastAlignment) {
                            case 0: {
                                start = 0;
                                end = index;
                                break block0;
                            }
                            case 1: {
                                start = index + 1;
                                end = parent.getSubIntervalCount();
                                break block0;
                            }
                        }
                        start = 0;
                        end = parent.getSubIntervalCount();
                    }
                }
                for (int i = start; i < end; ++i) {
                    LayoutInterval candidate = parent.getSubInterval(i);
                    if (!candidate.isEmptySpace()) continue;
                    this.paintAlignment(g, candidate, dimension, LayoutInterval.getEffectiveAlignment(candidate));
                }
            } else {
                alignment = interval.getAlignment();
                if (!LayoutInterval.wantResizeInLayout(interval)) {
                    lastAlignment = alignment;
                }
                this.paintAlignment(g, interval, dimension, lastAlignment);
            }
            interval = interval.getParent();
        }
    }

    private void paintLinks(Graphics2D g, LayoutComponent component) {
        if (component.isLinkSized(0) && component.isLinkSized(1)) {
            int i;
            Map linkGroupsH = this.layoutModel.getLinkSizeGroups(0);
            Map linkGroupsV = this.layoutModel.getLinkSizeGroups(1);
            Integer linkIdH = new Integer(component.getLinkSizeId(0));
            Integer linkIdV = new Integer(component.getLinkSizeId(1));
            List lH = (List)linkGroupsH.get(linkIdH);
            List lV = (List)linkGroupsV.get(linkIdV);
            HashSet merged = new HashSet();
            for (i = 0; i < lH.size(); ++i) {
                merged.add(lH.get(i));
            }
            for (i = 0; i < lV.size(); ++i) {
                merged.add(lV.get(i));
            }
            for (String id : merged) {
                LayoutComponent lc = this.layoutModel.getLayoutComponent(id);
                LayoutInterval interval = lc.getLayoutInterval(0);
                LayoutRegion region = interval.getCurrentSpace();
                Image badge = null;
                if (lV.contains(id) && lH.contains(id)) {
                    badge = this.getLinkBadge(2);
                } else {
                    if (lH.contains(lc.getId())) {
                        badge = this.getLinkBadge(0);
                    }
                    if (lV.contains(lc.getId())) {
                        badge = this.getLinkBadge(1);
                    }
                }
                int x = region.positions[0][1] - region.size(0) / 4 - badge.getWidth(null) / 2;
                int y = region.positions[1][0] - badge.getHeight(null);
                g.drawImage(badge, x, y, null);
            }
        } else {
            int dimension = component.isLinkSized(0) ? 0 : 1;
            Map map = this.layoutModel.getLinkSizeGroups(dimension);
            Integer linkId = new Integer(component.getLinkSizeId(dimension));
            List l = (List)map.get(linkId);
            for (String id : l) {
                LayoutComponent lc = this.layoutModel.getLayoutComponent(id);
                LayoutInterval interval = lc.getLayoutInterval(dimension);
                LayoutRegion region = interval.getCurrentSpace();
                Image badge = this.getLinkBadge(dimension);
                int x = region.positions[0][1] - region.size(0) / 4 - badge.getWidth(null) / 2;
                int y = region.positions[1][0] - badge.getHeight(null);
                g.drawImage(badge, x, y, null);
            }
        }
    }

    private Image getLinkBadge(int dimension) {
        if (dimension == 2) {
            if (this.linkBadgeBoth == null) {
                this.linkBadgeBoth = Utilities.loadImage((String)"org/netbeans/modules/form/resources/sameboth.png");
            }
            return this.linkBadgeBoth;
        }
        if (dimension == 0) {
            if (this.linkBadgeHorizontal == null) {
                this.linkBadgeHorizontal = Utilities.loadImage((String)"org/netbeans/modules/form/resources/samewidth.png");
            }
            return this.linkBadgeHorizontal;
        }
        if (dimension == 1) {
            if (this.linkBadgeVertical == null) {
                this.linkBadgeVertical = Utilities.loadImage((String)"org/netbeans/modules/form/resources/sameheight.png");
            }
            return this.linkBadgeVertical;
        }
        return null;
    }

    private void paintAlignment(Graphics2D g, LayoutInterval interval, int dimension, int alignment) {
        int y;
        int x2;
        int x1;
        int opposite;
        LayoutInterval parent = interval.getParent();
        boolean baseline = parent.isParallel() && parent.getGroupAlignment() == 3;
        LayoutRegion group = parent.getCurrentSpace();
        int n = opposite = dimension == 0 ? 1 : 0;
        if (interval.isEmptySpace()) {
            boolean x2group;
            int[] yb;
            boolean x1group;
            int[] ya;
            int index = parent.indexOf(interval);
            if (index == 0) {
                x1 = group.positions[dimension][baseline ? 3 : 0];
                ya = this.visualIntervalPosition(parent, opposite, 0);
                x1group = LayoutInterval.getFirstParent(interval, 103).getParent() != null;
            } else {
                LayoutInterval x1int = parent.getSubInterval(index - 1);
                if (x1int.isParallel() && x1int.getGroupAlignment() == 3) {
                    x1 = x1int.getCurrentSpace().positions[dimension][3];
                } else {
                    if (x1int.isEmptySpace()) {
                        return;
                    }
                    x1 = x1int.getCurrentSpace().positions[dimension][1];
                }
                ya = this.visualIntervalPosition(x1int, opposite, 1);
                x1group = x1int.isGroup();
            }
            if (index + 1 == parent.getSubIntervalCount()) {
                x2 = group.positions[dimension][baseline ? 3 : 1];
                yb = this.visualIntervalPosition(parent, opposite, 1);
                x2group = LayoutInterval.getFirstParent(interval, 103).getParent() != null;
            } else {
                LayoutInterval x2int = parent.getSubInterval(index + 1);
                if (x2int.isParallel() && x2int.getGroupAlignment() == 3) {
                    x2 = x2int.getCurrentSpace().positions[dimension][3];
                } else {
                    if (x2int.isEmptySpace()) {
                        return;
                    }
                    x2 = x2int.getCurrentSpace().positions[dimension][0];
                }
                yb = this.visualIntervalPosition(x2int, opposite, 0);
                x2group = x2int.isGroup();
            }
            if (x1 == Integer.MIN_VALUE || x2 == Integer.MIN_VALUE) {
                return;
            }
            int y1 = Math.min(ya[1], yb[1]);
            int y2 = Math.max(ya[0], yb[0]);
            y = (y1 + y2) / 2;
            if (ya[1] < yb[0] || yb[1] < ya[0]) {
                if (dimension == 0) {
                    g.drawLine(x1, ya[0], x1, y);
                    g.drawLine(x1, ya[0], x1, ya[1]);
                    g.drawLine(x2, yb[0], x2, y);
                    g.drawLine(x2, yb[0], x2, yb[1]);
                } else {
                    g.drawLine(ya[0], x1, y, x1);
                    g.drawLine(ya[0], x1, ya[1], x1);
                    g.drawLine(yb[0], x2, y, x2);
                    g.drawLine(yb[0], x2, yb[1], x2);
                }
            } else if (dimension == 0) {
                if (x1group) {
                    g.drawLine(x1, ya[0], x1, ya[1]);
                }
                if (x2group) {
                    g.drawLine(x2, yb[0], x2, yb[1]);
                }
            } else {
                if (x1group) {
                    g.drawLine(ya[0], x1, ya[1], x1);
                }
                if (x2group) {
                    g.drawLine(yb[0], x2, yb[1], x2);
                }
            }
        } else {
            LayoutRegion child = interval.getCurrentSpace();
            if (alignment == 0 || alignment == 1) {
                x1 = group.positions[dimension][baseline ? 3 : alignment];
                x2 = interval.isParallel() && interval.getAlignment() == 3 ? child.positions[dimension][3] : child.positions[dimension][alignment];
            } else {
                return;
            }
            if (x1 == Integer.MIN_VALUE || x2 == Integer.MIN_VALUE) {
                return;
            }
            int[] pos = this.visualIntervalPosition(parent, opposite, alignment);
            y = (pos[0] + pos[1]) / 2;
            int xa = group.positions[dimension][0];
            int xb = group.positions[dimension][1];
            if (parent.getParent() != null) {
                if (dimension == 0) {
                    if (alignment == 0) {
                        g.drawLine(xa, pos[0], xa, pos[1]);
                    } else if (alignment == 1) {
                        g.drawLine(xb, pos[0], xb, pos[1]);
                    }
                } else if (alignment == 0) {
                    g.drawLine(pos[0], xa, pos[1], xa);
                } else if (alignment == 1) {
                    g.drawLine(pos[0], xb, pos[1], xb);
                }
            }
        }
        if (x2 - x1 > 1 && Math.abs(y) <= Short.MAX_VALUE && Math.abs(x1) <= Short.MAX_VALUE && Math.abs(x2) <= Short.MAX_VALUE) {
            int angle;
            int x;
            if (alignment == 0) {
                x = x1;
                angle = 180;
            } else {
                x = x2;
                angle = 0;
            }
            int diam = Math.min(4, --x2 - x1);
            BasicStroke stroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{1.0f, 1.0f}, 0.0f);
            Stroke oldStroke = g.getStroke();
            g.setStroke(stroke);
            if (dimension == 0) {
                g.drawLine(x1, y, x2, y);
                angle += 90;
            } else {
                g.drawLine(y, x1, y, x2);
                int temp = x;
                x = y;
                y = temp;
            }
            g.setStroke(oldStroke);
            if (alignment == 0 || alignment == 1) {
                Object hint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g.fillArc(x - diam, y - diam, 2 * diam, 2 * diam, angle, 180);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, hint);
            }
        }
    }

    private int[] visualIntervalPosition(LayoutInterval interval, int dimension, int alignment) {
        int min = Short.MAX_VALUE;
        int max = Short.MIN_VALUE;
        if (interval.isParallel() && interval.getGroupAlignment() != 3) {
            Iterator iter = interval.getSubIntervals();
            while (iter.hasNext()) {
                int imax;
                int imin;
                int oppDim;
                LayoutInterval subInterval = (LayoutInterval)iter.next();
                int n = oppDim = dimension == 0 ? 1 : 0;
                if (LayoutInterval.isPlacedAtBorder(subInterval, oppDim, alignment)) {
                    if (subInterval.isParallel()) {
                        int[] ipos = this.visualIntervalPosition(subInterval, dimension, alignment);
                        imin = ipos[0];
                        imax = ipos[1];
                    } else if (!subInterval.isEmptySpace()) {
                        LayoutRegion region = subInterval.getCurrentSpace();
                        imin = region.positions[dimension][0];
                        imax = region.positions[dimension][1];
                    } else {
                        imin = min;
                        imax = max;
                    }
                } else {
                    imin = min;
                    imax = max;
                }
                if (min > imin) {
                    min = imin;
                }
                if (max >= imax) continue;
                max = imax;
            }
        }
        if (!interval.isParallel() || min == Short.MAX_VALUE) {
            LayoutRegion region = interval.getCurrentSpace();
            min = region.positions[dimension][0];
            max = region.positions[dimension][1];
        }
        return new int[]{min, max};
    }

    private void layoutChanged(LayoutEvent ev) {
        LayoutInterval interval;
        LayoutComponent comp;
        if (ev.getType() == 4 && (comp = (interval = ev.getInterval()).getComponent()) != null) {
            int dim = -1;
            for (int i = 0; i < 2; ++i) {
                if (comp.getLayoutInterval(i) != interval) continue;
                dim = i;
                break;
            }
            assert (dim > -1);
            this.intervalRemoved(ev.getParentInterval(), ev.getIndex(), true, LayoutInterval.wantResize(ev.getInterval()), dim);
            if (comp.getParent() != null) {
                this.updateDesignModifications(comp.getParent().getLayoutRoot(dim), dim);
                this.visualStateUpToDate = false;
            }
        }
    }

    private boolean isComponentResizable(LayoutComponent comp, int dimension) {
        boolean[] res = comp.getResizability();
        if (res == null) {
            res = this.visualMapper.getComponentResizability(comp.getId(), new boolean[2]);
            comp.setResizability(res);
        }
        return res[dimension];
    }

    public void adjustComponentAlignment(LayoutComponent comp, int dimension, int alignment) {
        LayoutInterval parent;
        if (this.logTestCode()) {
            this.testCode.add("// > ADJUST COMPONENT ALIGNMENT");
            this.testCode.add("{");
            this.testCode.add("LayoutComponent comp = model.getLayoutComponent(\"" + comp.getId() + "\");");
            this.testCode.add("int dimension = " + dimension);
            this.testCode.add("int alignment = " + alignment);
            this.testCode.add("ld.adjustComponentAlignment(comp, dimension, alignment);");
            this.testCode.add("}");
        }
        this.modelListener.deactivate();
        LayoutInterval interval = comp.getLayoutInterval(dimension);
        for (parent = interval.getParent(); parent != null; parent = parent.getParent()) {
            if (LayoutInterval.canResize(parent)) continue;
            interval = parent;
        }
        assert (!LayoutInterval.wantResize(interval));
        boolean changed = false;
        for (parent = interval.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.isParallel()) {
                if (LayoutInterval.wantResize(parent) && !LayoutInterval.wantResize(interval)) {
                    int alg = interval.getAlignment();
                    if (alg != alignment) {
                        int size = LayoutInterval.getIntervalCurrentSize(parent, dimension) - LayoutInterval.getIntervalCurrentSize(interval, dimension);
                        if (size > 0) {
                            if (!interval.isSequential()) {
                                LayoutInterval seq = new LayoutInterval(102);
                                this.layoutModel.setIntervalAlignment(interval, -1);
                                int i = this.layoutModel.removeInterval(interval);
                                this.layoutModel.addInterval(interval, seq, -1);
                                this.layoutModel.addInterval(seq, parent, i);
                                interval = seq;
                            }
                            int index = alg == 0 ? -1 : 0;
                            LayoutInterval gap = new LayoutInterval(101);
                            gap.setSize(size);
                            this.layoutModel.addInterval(gap, interval, index);
                        }
                        this.layoutModel.setIntervalAlignment(interval, alignment);
                    }
                    changed = true;
                }
            } else {
                boolean before = true;
                boolean seqChanged = false;
                for (int i = 0; i < parent.getSubIntervalCount(); ++i) {
                    LayoutInterval li = parent.getSubInterval(i);
                    if (li == interval) {
                        before = false;
                        continue;
                    }
                    if (!LayoutInterval.wantResize(li) || (!before || alignment != 0) && (before || alignment != 1)) continue;
                    assert (li.isEmptySpace());
                    this.setIntervalResizing(li, false);
                    if (li.getPreferredSize() == 0) {
                        this.layoutModel.removeInterval(li);
                        --i;
                    }
                    seqChanged = true;
                }
                if (!changed && seqChanged) {
                    LayoutInterval candidate;
                    boolean insertGap = false;
                    int index = parent.indexOf(interval);
                    if (alignment == 0) {
                        if (parent.getSubIntervalCount() <= index + 1) {
                            insertGap = true;
                            index = -1;
                        } else if ((candidate = parent.getSubInterval(++index)).isEmptySpace()) {
                            this.setIntervalResizing(candidate, true);
                        } else {
                            insertGap = true;
                        }
                    } else {
                        assert (alignment == 1);
                        if (index == 0) {
                            insertGap = true;
                        } else {
                            candidate = parent.getSubInterval(index - 1);
                            if (candidate.isEmptySpace()) {
                                this.setIntervalResizing(candidate, true);
                            } else {
                                insertGap = true;
                            }
                        }
                    }
                    if (insertGap) {
                        LayoutInterval gap = new LayoutInterval(101);
                        this.setIntervalResizing(gap, true);
                        this.layoutModel.setIntervalSize(gap, 0, 0, gap.getMaximumSize());
                        this.layoutModel.addInterval(gap, parent, index);
                    }
                    changed = true;
                }
            }
            interval = parent;
        }
        this.updateDesignModifications(interval, dimension);
        this.modelListener.activate();
        this.visualStateUpToDate = false;
        if (this.logTestCode()) {
            this.testCode.add("// < ADJUST COMPONENT ALIGNMENT");
        }
    }

    public int[] getAdjustableComponentAlignment(LayoutComponent comp, int dimension) {
        LayoutInterval interval = comp.getLayoutInterval(dimension);
        boolean leadingFixed = true;
        boolean trailingFixed = true;
        boolean leadingAdjustable = true;
        boolean trailingAdjustable = true;
        if (LayoutInterval.wantResize(interval)) {
            trailingAdjustable = false;
            leadingAdjustable = false;
            trailingFixed = false;
            leadingFixed = false;
        }
        for (LayoutInterval parent = interval.getParent(); parent != null; parent = parent.getParent()) {
            block9: {
                block10: {
                    int alignment;
                    block11: {
                        block8: {
                            if (LayoutInterval.canResize(parent)) break block8;
                            trailingAdjustable = true;
                            leadingAdjustable = true;
                            trailingFixed = true;
                            leadingFixed = true;
                            break block9;
                        }
                        if (!parent.isParallel()) break block10;
                        if (!LayoutInterval.wantResize(parent) || LayoutInterval.wantResize(interval)) break block9;
                        alignment = interval.getAlignment();
                        if (alignment != 0) break block11;
                        trailingFixed = false;
                        break block9;
                    }
                    if (alignment != 1) break block9;
                    leadingFixed = false;
                    break block9;
                }
                boolean before = true;
                Iterator iter = parent.getSubIntervals();
                while (iter.hasNext()) {
                    LayoutInterval li = (LayoutInterval)iter.next();
                    if (li == interval) {
                        before = false;
                        continue;
                    }
                    if (!LayoutInterval.wantResize(li)) continue;
                    boolean space = li.isEmptySpace();
                    if (before) {
                        leadingFixed = false;
                        if (space) continue;
                        leadingAdjustable = false;
                        continue;
                    }
                    trailingFixed = false;
                    if (space) continue;
                    trailingAdjustable = false;
                }
            }
            interval = parent;
        }
        int adjustable = (leadingAdjustable ? 1 : 0) + (trailingAdjustable ? 2 : 0);
        if (leadingFixed && trailingFixed) {
            if (0 == interval.getGroupAlignment()) {
                trailingFixed = false;
            } else {
                leadingFixed = false;
            }
        }
        int alignment = leadingFixed ? 0 : (trailingFixed ? 1 : -1);
        return new int[]{alignment, adjustable};
    }

    public boolean isComponentResizing(LayoutComponent comp, int dimension) {
        LayoutInterval interval = comp.getLayoutInterval(dimension);
        boolean fill = interval.hasAttribute(1);
        return fill ? false : LayoutInterval.wantResizeInLayout(interval);
    }

    private int prefSizeOfInterval(LayoutInterval interval) {
        int prefSize;
        block11: {
            int dimension = -1;
            if (interval.isComponent()) {
                LayoutComponent comp = interval.getComponent();
                int n = dimension = interval == comp.getLayoutInterval(0) ? 0 : 1;
                if (comp.isLinkSized(dimension)) {
                    Collection linked = (Collection)this.layoutModel.getLinkSizeGroups(dimension).get(new Integer(comp.getLinkSizeId(dimension)));
                    Iterator iter = linked.iterator();
                    int prefSize2 = 0;
                    while (iter.hasNext()) {
                        String compId = (String)iter.next();
                        LayoutComponent component = this.layoutModel.getLayoutComponent(compId);
                        LayoutInterval intr = component.getLayoutInterval(dimension);
                        int pref = intr.getPreferredSize();
                        if (pref == -1) {
                            Dimension prefDim = this.visualMapper.getComponentPreferredSize(compId);
                            pref = dimension == 0 ? prefDim.width : prefDim.height;
                        }
                        prefSize2 = Math.max(pref, prefSize2);
                    }
                    return prefSize2;
                }
            }
            if ((prefSize = interval.getPreferredSize()) != -1) break block11;
            if (interval.isComponent()) {
                LayoutComponent comp = interval.getComponent();
                Dimension pref = this.visualMapper.getComponentPreferredSize(comp.getId());
                return dimension == 0 ? pref.width : pref.height;
            }
            if (interval.isEmptySpace()) {
                return this.sizeOfEmptySpace(interval);
            }
            assert (interval.isGroup());
            prefSize = 0;
            Iterator iter = interval.getSubIntervals();
            if (interval.isSequential()) {
                while (iter.hasNext()) {
                    LayoutInterval subInterval = (LayoutInterval)iter.next();
                    prefSize += this.prefSizeOfInterval(subInterval);
                }
            } else {
                while (iter.hasNext()) {
                    LayoutInterval subInterval = (LayoutInterval)iter.next();
                    prefSize = Math.max(prefSize, this.prefSizeOfInterval(subInterval));
                }
            }
        }
        return prefSize;
    }

    private int sizeOfEmptySpace(LayoutInterval interval) {
        return LayoutUtils.getSizeOfDefaultGap(interval, this.visualMapper);
    }

    public void setComponentResizing(LayoutComponent comp, int dimension, boolean resizing) {
        int prefSize;
        int currSize;
        if (this.logTestCode()) {
            this.testCode.add("// > SET COMPONENT RESIZING");
            this.testCode.add("{");
            this.testCode.add("LayoutComponent comp = lm.getLayoutComponent(\"" + comp.getId() + "\");");
            this.testCode.add("int dimension = " + dimension + ";");
            this.testCode.add("boolean resizing = " + resizing + ";");
            this.testCode.add("ld.setComponentResizing(comp, dimension, resizing);");
            this.testCode.add("}");
        }
        this.modelListener.deactivate();
        LayoutInterval interval = comp.getLayoutInterval(dimension);
        if (resizing && comp.isLinkSized(dimension)) {
            List<String> linked = (List<String>)this.layoutModel.getLinkSizeGroups(dimension).get(new Integer(comp.getLinkSizeId(dimension)));
            List<String> toChange = linked.size() == 2 ? linked : Collections.singletonList(comp.getId());
            for (String compId : toChange) {
                LayoutComponent component = this.layoutModel.getLayoutComponent(compId);
                LayoutInterval intr = component.getLayoutInterval(dimension);
                Dimension prefDim = this.visualMapper.getComponentPreferredSize(compId);
                int prefSize2 = dimension == 0 ? prefDim.width : prefDim.height;
                int currSize2 = intr.getCurrentSpace().size(dimension);
                if (currSize2 == prefSize2) {
                    currSize2 = -1;
                }
                this.layoutModel.setIntervalSize(intr, intr.getMinimumSize(), currSize2, intr.getMaximumSize());
            }
        }
        LayoutInterval parent = interval.getParent();
        boolean fill = interval.hasAttribute(1);
        boolean formerFill = interval.hasAttribute(2);
        if (fill || formerFill) {
            this.switchFillAttribute(interval, resizing);
        } else {
            this.setIntervalResizing(interval, resizing);
        }
        int delta = 0;
        if (!resizing && (delta = (currSize = LayoutInterval.getIntervalCurrentSize(interval, dimension)) - (prefSize = this.prefSizeOfInterval(interval))) != 0) {
            this.layoutModel.setIntervalSize(interval, interval.getMinimumSize(), currSize, interval.getMaximumSize());
        }
        LayoutInterval intr = interval;
        for (LayoutInterval par = parent; par != null; par = par.getParent()) {
            if (par.isParallel() && resizing) {
                int currSize3;
                int groupCurrSize = LayoutInterval.getIntervalCurrentSize(par, dimension);
                if (groupCurrSize != (currSize3 = LayoutInterval.getIntervalCurrentSize(intr, dimension))) {
                    int index;
                    LayoutInterval seqGroup = intr;
                    LayoutInterval space = new LayoutInterval(101);
                    space.setSize(groupCurrSize - currSize3);
                    int alignment = intr.getAlignment();
                    int n = index = alignment == 0 ? -1 : 0;
                    if (intr.isSequential()) {
                        int spaceIndex = alignment == 0 ? intr.getSubIntervalCount() - 1 : 0;
                        LayoutInterval adjacentSpace = intr.getSubInterval(spaceIndex);
                        if (adjacentSpace.isEmptySpace()) {
                            int spaceSize = LayoutInterval.getIntervalCurrentSize(adjacentSpace, dimension);
                            this.layoutModel.removeInterval(adjacentSpace);
                            space.setSize(groupCurrSize - currSize3 + spaceSize);
                        }
                    } else {
                        seqGroup = new LayoutInterval(102);
                        this.layoutModel.setIntervalAlignment(intr, -1);
                        seqGroup.setAlignment(alignment);
                        int i = this.layoutModel.removeInterval(intr);
                        this.layoutModel.addInterval(intr, seqGroup, -1);
                        this.layoutModel.addInterval(seqGroup, par, i);
                    }
                    this.layoutModel.addInterval(space, seqGroup, index);
                    seqGroup.getCurrentSpace().set(dimension, par.getCurrentSpace());
                }
            } else if (par.isSequential()) {
                int currSize4;
                LayoutInterval candidate;
                boolean parentSeq = parent == par;
                LinkedList<LayoutInterval> resizableList = new LinkedList<LayoutInterval>();
                int alignment = parentSeq ? LayoutInterval.getEffectiveAlignment(interval) : 0;
                LayoutInterval leadingGap = null;
                LayoutInterval trailingGap = null;
                boolean afterDefining = false;
                Iterator iter = par.getSubIntervals();
                while (iter.hasNext()) {
                    candidate = (LayoutInterval)iter.next();
                    if (candidate == interval) {
                        afterDefining = true;
                    }
                    if (candidate.isEmptySpace()) {
                        boolean glue;
                        if (resizing) {
                            int prefSize3;
                            this.setIntervalResizing(candidate, false);
                            currSize4 = LayoutInterval.getIntervalCurrentSize(candidate, dimension);
                            if (currSize4 == (prefSize3 = this.prefSizeOfInterval(candidate))) continue;
                            this.layoutModel.setIntervalSize(candidate, candidate.getMinimumSize(), currSize4, candidate.getMaximumSize());
                            delta += currSize4 - prefSize3;
                            continue;
                        }
                        if (!parentSeq) continue;
                        boolean wasFill = candidate.hasAttribute(2);
                        boolean bl = glue = candidate.getPreferredSize() != -1;
                        if (wasFill) {
                            trailingGap = candidate;
                        } else if (trailingGap == null || !trailingGap.hasAttribute(2)) {
                            if (glue) {
                                trailingGap = candidate;
                            } else if (afterDefining && (trailingGap == null || trailingGap.getPreferredSize() == -1)) {
                                trailingGap = candidate;
                            }
                        }
                        if (leadingGap == null && !afterDefining) {
                            leadingGap = candidate;
                            continue;
                        }
                        if ((!wasFill || leadingGap != null && leadingGap.hasAttribute(2)) && (!glue || leadingGap != null && (leadingGap.hasAttribute(2) || leadingGap.getPreferredSize() != -1))) continue;
                        leadingGap = candidate;
                        continue;
                    }
                    if (candidate.getMaximumSize() != Short.MAX_VALUE) continue;
                    resizableList.add(candidate);
                }
                if (resizableList.size() > 0) {
                    iter = resizableList.iterator();
                    delta = (LayoutInterval.getIntervalCurrentSize(par, dimension) - this.prefSizeOfInterval(par) + delta) / resizableList.size();
                    while (iter.hasNext()) {
                        candidate = (LayoutInterval)iter.next();
                        if (candidate.isGroup()) continue;
                        if (candidate == interval) {
                            if (delta == 0) continue;
                            int prefSize4 = this.prefSizeOfInterval(candidate);
                            this.layoutModel.setIntervalSize(candidate, candidate.getMinimumSize(), Math.max(0, prefSize4 - delta), candidate.getMaximumSize());
                            continue;
                        }
                        currSize4 = LayoutInterval.getIntervalCurrentSize(candidate, dimension);
                        this.layoutModel.setIntervalSize(candidate, candidate.getMinimumSize(), Math.max(0, currSize4 - delta), candidate.getMaximumSize());
                    }
                }
                if (parentSeq) {
                    if (!LayoutInterval.wantResize(par)) {
                        LayoutInterval gap = null;
                        if (alignment == 1 && leadingGap != null) {
                            gap = leadingGap;
                            this.setIntervalResizing(leadingGap, !resizing);
                            this.layoutModel.changeIntervalAttribute(leadingGap, 1, true);
                        }
                        if (alignment == 0 && trailingGap != null) {
                            gap = trailingGap;
                            this.setIntervalResizing(trailingGap, !resizing);
                            this.layoutModel.changeIntervalAttribute(trailingGap, 1, true);
                        }
                        if (gap != null && delta != 0 && gap.getPreferredSize() != -1) {
                            this.layoutModel.setIntervalSize(gap, gap.getMinimumSize(), Math.max(0, gap.getPreferredSize() - delta), gap.getMaximumSize());
                        }
                    }
                    parent = par.getParent();
                }
            }
            intr = par;
        }
        if (resizing) {
            this.layoutModel.unsetSameSize(Collections.singletonList(comp.getId()), dimension);
        }
        this.modelListener.activate();
        if (resizing) {
            while (parent != null) {
                if (!LayoutInterval.canResize(parent)) {
                    this.operations.enableGroupResizing(parent);
                }
                parent = parent.getParent();
            }
        } else {
            while (parent != null && this.fillResizable(parent)) {
                this.operations.suppressGroupResizing(parent);
                parent = parent.getParent();
            }
        }
        this.updateDesignModifications(comp.getParent());
        this.visualStateUpToDate = false;
        if (this.logTestCode()) {
            this.testCode.add("// < SET COMPONENT RESIZING");
        }
    }

    private boolean fillResizable(LayoutInterval interval) {
        if (!LayoutInterval.canResize(interval)) {
            return false;
        }
        if (interval.isGroup()) {
            boolean subres = true;
            Iterator it = interval.getSubIntervals();
            while (it.hasNext()) {
                LayoutInterval li = (LayoutInterval)it.next();
                if (!LayoutInterval.wantResize(li) || this.fillResizable(li)) continue;
                subres = false;
                break;
            }
            return subres;
        }
        return interval.hasAttribute(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void align(Collection componentIds, boolean closed, int dimension, int alignment) {
        if (this.logTestCode()) {
            this.testCode.add("// > ALIGN");
            this.testCode.add("{");
            LayoutTestUtils.writeCollection(this.testCode, "componentIds", componentIds);
            this.testCode.add("boolean closed = " + closed + ";");
            this.testCode.add("int dimension = " + dimension + ";");
            this.testCode.add("int alignment = " + alignment + ";");
            this.testCode.add("ld.align(componentIds, closed, dimension, alignment);");
            this.testCode.add("}");
        }
        LayoutInterval[] intervals = new LayoutInterval[componentIds.size()];
        int counter = 0;
        for (String id : componentIds) {
            LayoutComponent component = this.layoutModel.getLayoutComponent(id);
            intervals[counter++] = component.getLayoutInterval(dimension);
        }
        this.modelListener.deactivate();
        try {
            new LayoutAligner(this, this.layoutModel, this.operations).alignIntervals(intervals, closed, dimension, alignment);
        }
        finally {
            this.modelListener.activate();
        }
        this.requireStructureOptimization();
        if (this.logTestCode()) {
            this.testCode.add("// < ALIGN");
        }
    }

    private void destroyRedundantGroups(Set updatedContainers) {
        Iterator it = this.layoutModel.getAllComponents();
        while (it.hasNext()) {
            LayoutComponent comp = (LayoutComponent)it.next();
            if (!comp.isLayoutContainer()) continue;
            boolean updated = false;
            for (int dim = 0; dim < 2; ++dim) {
                LayoutInterval interval = comp.getLayoutRoot(dim);
                updated = updated || this.destroyRedundantGroups(interval);
            }
            if (!updated) continue;
            updatedContainers.add(comp);
        }
    }

    private boolean destroyRedundantGroups(LayoutInterval interval) {
        boolean updated = false;
        for (int i = interval.getSubIntervalCount() - 1; i >= 0; --i) {
            LayoutInterval subInterval;
            if (i >= interval.getSubIntervalCount() || !(subInterval = interval.getSubInterval(i)).isGroup()) continue;
            this.destroyRedundantGroups(subInterval);
            this.destroyGroupIfRedundant(subInterval, interval);
            updated |= subInterval.getParent() == null;
        }
        return updated;
    }

    void destroyGroupIfRedundant(LayoutInterval group, LayoutInterval boundary) {
        if (group == null || !group.isGroup() || group == boundary) {
            return;
        }
        LayoutInterval parent = group.getParent();
        if (parent == null) {
            return;
        }
        if (group.getSubIntervalCount() == 0) {
            this.takeOutInterval(group, boundary);
            return;
        }
        if (this.operations.dissolveRedundantGroup(group)) {
            this.destroyGroupIfRedundant(parent, boundary);
        }
    }

    void takeOutInterval(LayoutInterval interval, LayoutInterval boundary) {
        LayoutInterval parent = interval.getParent();
        int index = parent.indexOf(interval);
        LinkedList<LayoutInterval> toRemove = new LinkedList<LayoutInterval>();
        toRemove.add(interval);
        if (parent.isSequential()) {
            LayoutInterval li;
            if (index > 0 && (li = parent.getSubInterval(index - 1)).isEmptySpace()) {
                toRemove.add(li);
            }
            if (index + 1 < parent.getSubIntervalCount() && (li = parent.getSubInterval(index + 1)).isEmptySpace()) {
                toRemove.add(li);
            }
            if (toRemove.size() == 3 && parent.getSubIntervalCount() > 3) {
                LayoutInterval gap = new LayoutInterval(101);
                if (interval.isComponent() && interval.getComponent().getLayoutInterval(1) == interval) {
                    int alignment = LayoutInterval.getEffectiveAlignment(interval);
                    int size = 0;
                    for (int i = 0; i < 3; ++i) {
                        size += LayoutInterval.getIntervalCurrentSize((LayoutInterval)toRemove.get(i), 1);
                    }
                    gap.setSizes(-1, size, alignment == 1 ? Short.MAX_VALUE : -2);
                }
                this.layoutModel.addInterval(gap, parent, index);
            }
        }
        for (LayoutInterval remove : toRemove) {
            this.layoutModel.removeInterval(remove);
        }
        this.destroyGroupIfRedundant(parent, boundary);
    }

    void createRemainderGroup(List list, LayoutInterval seq, int index, int position, int mainAlignment, int dimension) {
        assert (seq.isSequential() && (position == 0 || position == 1));
        if (position == 1) {
            ++index;
        }
        LayoutInterval gap = null;
        LayoutInterval leadingGap = null;
        LayoutInterval trailingGap = null;
        boolean onlyGaps = true;
        boolean gapLeads = true;
        boolean gapTrails = true;
        for (int i = list.size() - 1; i >= 0; --i) {
            List subList = (List)list.get(i);
            if (subList.size() != 2) continue;
            int alignment = (Integer)subList.get(0);
            LayoutInterval li = (LayoutInterval)subList.get(1);
            if (li.isEmptySpace()) {
                if (gap == null || li.getMaximumSize() > gap.getMaximumSize()) {
                    gap = li;
                }
                if (LayoutDesigner.isFixedPadding(li)) {
                    if (alignment == 0) {
                        leadingGap = li;
                        gapTrails = false;
                    } else if (alignment == 1) {
                        trailingGap = li;
                        gapLeads = false;
                    }
                } else {
                    gapLeads = false;
                    gapTrails = false;
                }
                list.remove(i);
                continue;
            }
            onlyGaps = false;
        }
        if (list.size() == 1) {
            List subList = (List)list.get(0);
            Iterator itr = subList.iterator();
            itr.next();
            do {
                LayoutInterval li = (LayoutInterval)itr.next();
                this.layoutModel.addInterval(li, seq, index++);
            } while (itr.hasNext());
            return;
        }
        for (List subList : list) {
            if (subList.size() == 2) continue;
            onlyGaps = false;
            boolean first = true;
            Iterator itr = subList.iterator();
            itr.next();
            do {
                LayoutInterval li = (LayoutInterval)itr.next();
                if (first) {
                    first = false;
                    if (LayoutDesigner.isFixedPadding(li)) {
                        leadingGap = li;
                        continue;
                    }
                    gapLeads = false;
                    continue;
                }
                if (itr.hasNext()) continue;
                if (LayoutDesigner.isFixedPadding(li)) {
                    trailingGap = li;
                    continue;
                }
                gapTrails = false;
            } while (itr.hasNext());
        }
        if (onlyGaps) {
            this.operations.insertGapIntoSequence(gap, seq, index, dimension);
            return;
        }
        LayoutInterval group = new LayoutInterval(103);
        if (position == mainAlignment) {
            group.setMinimumSize(-2);
            group.setMaximumSize(-2);
        }
        for (List subList : list) {
            LayoutInterval interval;
            if (gapLeads) {
                subList.remove(1);
            }
            if (gapTrails) {
                subList.remove(subList.size() - 1);
            }
            if (subList.size() == 2) {
                int alignment = (Integer)subList.get(0);
                interval = (LayoutInterval)subList.get(1);
                if (alignment == 0 || alignment == 1) {
                    this.layoutModel.setIntervalAlignment(interval, alignment);
                }
            } else {
                interval = new LayoutInterval(102);
                Iterator itr = subList.iterator();
                int alignment = (Integer)itr.next();
                if (alignment == 0 || alignment == 1) {
                    interval.setAlignment(alignment);
                }
                do {
                    LayoutInterval li = (LayoutInterval)itr.next();
                    this.layoutModel.addInterval(li, interval, -1);
                } while (itr.hasNext());
            }
            this.layoutModel.addInterval(interval, group, -1);
        }
        if (gapLeads) {
            this.layoutModel.addInterval(leadingGap, seq, index++);
        }
        this.layoutModel.addInterval(group, seq, index++);
        if (gapTrails) {
            this.layoutModel.addInterval(trailingGap, seq, index);
        }
    }

    static boolean isFixedPadding(LayoutInterval interval) {
        return !(!interval.isEmptySpace() || interval.getMinimumSize() != -1 && interval.getMinimumSize() != -2 || interval.getPreferredSize() != -1 || interval.getMaximumSize() != -1 && interval.getMaximumSize() != -2);
    }

    private int optimizeGaps(LayoutInterval group, int dimension, boolean recursive) {
        assert (group.isParallel());
        if (recursive) {
            for (int i = 0; i < group.getSubIntervalCount(); ++i) {
                LayoutInterval li = group.getSubInterval(i);
                if (li.isParallel()) {
                    this.optimizeGaps(li, dimension, recursive);
                    continue;
                }
                if (!li.isSequential()) continue;
                for (int ii = 0; ii < li.getSubIntervalCount(); ++ii) {
                    int idx;
                    LayoutInterval llii = li.getSubInterval(ii);
                    if (!llii.isParallel() || (idx = this.optimizeGaps(llii, dimension, recursive)) < 0) continue;
                    ii = idx;
                }
            }
        }
        if (group.getGroupAlignment() == 2 || group.getGroupAlignment() == 3) {
            return -1;
        }
        int nonEmptyCount = LayoutInterval.getCount(group, Integer.MAX_VALUE, true);
        if (nonEmptyCount <= 1) {
            if (group.getParent() == null) {
                if (group.getSubIntervalCount() > 1) {
                    for (int i = group.getSubIntervalCount() - 1; i >= 0; --i) {
                        if (!group.getSubInterval(i).isEmptySpace()) continue;
                        this.layoutModel.removeInterval(group, i);
                        break;
                    }
                } else if (group.getSubIntervalCount() == 0) {
                    this.propEmptyContainer(group, dimension);
                }
            } else {
                assert (nonEmptyCount == 1);
                assert (group.getSubIntervalCount() == 1);
                LayoutInterval interval = group.getSubInterval(0);
                int alignment = interval.getAlignment();
                this.layoutModel.removeInterval(interval);
                this.layoutModel.setIntervalAlignment(interval, group.getAlignment());
                LayoutInterval parent = group.getParent();
                int index = this.layoutModel.removeInterval(group);
                if (parent.isSequential() && interval.isSequential()) {
                    for (int i = interval.getSubIntervalCount() - 1; i >= 0; --i) {
                        LayoutInterval subInterval = interval.getSubInterval(i);
                        this.layoutModel.removeInterval(subInterval);
                        this.layoutModel.addInterval(subInterval, parent, index);
                    }
                    this.eliminateConsecutiveGaps(parent, 0, dimension);
                } else {
                    this.layoutModel.addInterval(interval, parent, index);
                }
            }
            return -1;
        }
        return this.operations.optimizeGaps(group, dimension);
    }

    void setIntervalResizing(LayoutInterval interval, boolean resizable) {
        this.switchFillAttribute(interval, resizable);
        this.layoutModel.setIntervalSize(interval, resizable ? -1 : -2, interval.getPreferredSize(), resizable ? Short.MAX_VALUE : -2);
    }

    private void switchFillAttribute(LayoutInterval interval, boolean resizable) {
        if (resizable) {
            if (interval.hasAttribute(1)) {
                this.layoutModel.changeIntervalAttribute(interval, 2, true);
                this.layoutModel.changeIntervalAttribute(interval, 1, false);
            }
        } else if (interval.hasAttribute(2)) {
            this.layoutModel.changeIntervalAttribute(interval, 2, false);
            this.layoutModel.changeIntervalAttribute(interval, 1, true);
        }
    }

    public void setDefaultSize(String compId) {
        LayoutComponent component;
        if (this.logTestCode()) {
            this.testCode.add("// > SET DEFAULT SIZE");
            this.testCode.add("{");
            this.testCode.add("String compId = \"${" + compId + "}\";");
            this.testCode.add("ld.setDefaultSize(compId);");
            this.testCode.add("}");
        }
        if ((component = this.layoutModel.getLayoutComponent(compId)) != null) {
            this.setDefaultSize(component);
        }
        if (this.logTestCode()) {
            this.testCode.add("// < SET DEFAULT SIZE");
        }
    }

    private void setDefaultSize(LayoutComponent component) {
        this.imposeSize = true;
        if (component.isLayoutContainer()) {
            Iterator it = component.getSubcomponents();
            while (it.hasNext()) {
                LayoutComponent comp = (LayoutComponent)it.next();
                if (!comp.isLayoutContainer()) continue;
                this.setDefaultSize(comp);
            }
            this.setDefaultSizeInContainer(component.getLayoutRoot(0));
            this.setDefaultSizeInContainer(component.getLayoutRoot(1));
            this.updateDesignModifications(component);
        } else {
            this.operations.resizeInterval(component.getLayoutInterval(0), -1);
            this.operations.resizeInterval(component.getLayoutInterval(1), -1);
        }
    }

    private void setDefaultSizeInContainer(LayoutInterval interval) {
        if (!interval.isGroup()) {
            if (LayoutInterval.canResize(interval)) {
                this.operations.resizeInterval(interval, interval.getMinimumSize() != -2 ? interval.getMinimumSize() : -1);
            }
        } else {
            Iterator it = interval.getSubIntervals();
            while (it.hasNext()) {
                this.setDefaultSizeInContainer((LayoutInterval)it.next());
            }
        }
    }

    private void updateDesignModifications(LayoutComponent container) {
        if (this.imposeSize || this.optimizeStructure) {
            LayoutDesigner.cleanDesignAttrs(container.getLayoutRoot(0));
            LayoutDesigner.cleanDesignAttrs(container.getLayoutRoot(1));
        } else {
            this.updateDesignModifications(container.getLayoutRoot(0), 0);
            this.updateDesignModifications(container.getLayoutRoot(1), 1);
        }
    }

    private void updateDesignModifications(LayoutInterval root, int dimension) {
        LayoutDesigner.cleanDesignAttrs(root);
        this.findContainerResizingGap(root, dimension);
    }

    private static void cleanDesignAttrs(LayoutInterval group) {
        group.unsetAttribute(220);
        int n = group.getSubIntervalCount();
        for (int i = 0; i < n; ++i) {
            LayoutInterval li = group.getSubInterval(i);
            if (li.isGroup()) {
                LayoutDesigner.cleanDesignAttrs(li);
                continue;
            }
            li.unsetAttribute(220);
        }
    }

    private void findContainerResizingGap(LayoutInterval rootInterval, int dimension) {
        if (!LayoutInterval.wantResize(rootInterval) && LayoutInterval.getIntervalCurrentSize(rootInterval, dimension) != this.prefSizeOfInterval(rootInterval)) {
            return;
        }
        int gapPosition = 1;
        LayoutInterval resGap = LayoutDesigner.findContainerResizingGap(rootInterval, dimension, gapPosition);
        if (resGap == null) {
            gapPosition = 0;
            resGap = LayoutDesigner.findContainerResizingGap(rootInterval, dimension, gapPosition);
            if (resGap == null && (resGap = LayoutDesigner.findContainerResizingGap(rootInterval, dimension, gapPosition = -1)) == null) {
                return;
            }
        } else if (!LayoutInterval.canResize(resGap)) {
            LayoutInterval gap = LayoutDesigner.findContainerResizingGap(rootInterval, dimension, 0);
            if (gap != null && LayoutInterval.canResize(gap)) {
                resGap = gap;
                gapPosition = 0;
            } else {
                gap = LayoutDesigner.findContainerResizingGap(rootInterval, dimension, -1);
                if (gap != null && LayoutInterval.canResize(gap)) {
                    resGap = gap;
                    gapPosition = -1;
                }
            }
        }
        resGap.setAttribute(12);
        LayoutInterval sub = resGap;
        LayoutInterval parent = resGap.getParent();
        do {
            Iterator it;
            if (parent.isSequential()) {
                it = parent.getSubIntervals();
                while (it.hasNext()) {
                    LayoutInterval li = (LayoutInterval)it.next();
                    if (li == sub) continue;
                    li.setAttribute(16);
                }
                continue;
            }
            it = parent.getSubIntervals();
            while (it.hasNext()) {
                LayoutInterval interval = (LayoutInterval)it.next();
                if (interval == sub) continue;
                assert (interval.isSequential());
                if (interval.isSequential()) {
                    int n = interval.getSubIntervalCount();
                    for (int i = 0; i < n; ++i) {
                        LayoutInterval li = interval.getSubInterval(i);
                        if ((i == 0 && gapPosition == 0 || i + 1 == n && gapPosition == 1) && LayoutDesigner.canBeContainerResizingGap(li)) {
                            li.setAttribute(8);
                            continue;
                        }
                        li.setAttribute(16);
                    }
                    continue;
                }
                interval.setAttribute(16);
            }
        } while ((parent = (sub = parent).getParent()) != null);
    }

    private static LayoutInterval findContainerResizingGap(LayoutInterval group, int dimension, int alignment) {
        assert (group.isParallel());
        LayoutInterval theGap = null;
        int gapSize = Integer.MAX_VALUE;
        Iterator it = group.getSubIntervals();
        while (it.hasNext()) {
            LayoutInterval seq = (LayoutInterval)it.next();
            if (!seq.isSequential()) {
                return null;
            }
            int n = seq.getSubIntervalCount();
            if (alignment == 0 || alignment == 1) {
                LayoutInterval li = seq.getSubInterval(alignment == 0 ? 0 : n - 1);
                LayoutInterval gap = LayoutDesigner.canBeContainerResizingGap(li) && (LayoutInterval.wantResize(seq) || LayoutInterval.getEffectiveAlignment(li) == (alignment ^ 1)) ? li : (li.isParallel() ? LayoutDesigner.findContainerResizingGap(li, dimension, alignment) : null);
                if (gap == null) {
                    return null;
                }
                LayoutInterval neighbor = LayoutInterval.getDirectNeighbor(gap, alignment ^ 1, false);
                int p1 = neighbor.getCurrentSpace().positions[dimension][alignment];
                int p2 = group.getCurrentSpace().positions[dimension][alignment];
                int size = Math.abs(p2 - p1);
                if (theGap != null && size >= gapSize) continue;
                theGap = gap;
                gapSize = size;
                continue;
            }
            for (int i = n - 2; i > 0; --i) {
                LayoutInterval li = seq.getSubInterval(i);
                if (!LayoutDesigner.canBeContainerResizingGap(li) || !LayoutInterval.canResize(li)) continue;
                return group.getSubIntervalCount() == 1 ? li : null;
            }
            return null;
        }
        return theGap;
    }

    private static boolean canBeContainerResizingGap(LayoutInterval li) {
        return li.isEmptySpace() && (li.getPreferredSize() != -1 || li.getMaximumSize() >= Short.MAX_VALUE);
    }

    private boolean imposeCurrentContainerSize(LayoutComponent component, LayoutDragger.SizeDef[] resizingDef, boolean recursive) {
        assert (component.isLayoutContainer());
        Rectangle interior = this.visualMapper.getContainerInterior(component.getId());
        if (interior == null) {
            return false;
        }
        component.setCurrentInterior(interior);
        if (component.getParent() != null) {
            Rectangle bounds = this.visualMapper.getComponentBounds(component.getId());
            component.setCurrentBounds(bounds, this.visualMapper.getBaselinePosition(component.getId(), bounds.width, bounds.height));
        }
        Iterator it = component.getSubcomponents();
        while (it.hasNext()) {
            LayoutComponent subComp = (LayoutComponent)it.next();
            Rectangle bounds = this.visualMapper.getComponentBounds(subComp.getId());
            subComp.setCurrentBounds(bounds, this.visualMapper.getBaselinePosition(subComp.getId(), bounds.width, bounds.height));
            if (subComp.isLayoutContainer()) {
                if (!recursive) continue;
                this.imposeCurrentContainerSize(subComp, null, true);
                continue;
            }
            this.imposeCurrentComponentSize(subComp);
        }
        Dimension minimum = null;
        Dimension preferred = null;
        for (int i = 0; i < 2; ++i) {
            int min;
            LayoutInterval outer = component.getLayoutInterval(i);
            int currentSize = outer.getCurrentSpace().size(i);
            LayoutInterval root = component.getLayoutRoot(i);
            if (root.getSubIntervalCount() == 0) {
                this.propEmptyContainer(root, i);
            } else {
                if (resizingDef != null && resizingDef[i] != null) {
                    LayoutInterval resGap = resizingDef[i].getResizingGap();
                    if (resGap != null) {
                        int size = resizingDef[i].getResizingGapSize(currentSize);
                        if (size == 0) {
                            LayoutInterval otherGap;
                            LayoutInterval gapParent = resGap.getParent();
                            assert (gapParent.isSequential());
                            int index = this.layoutModel.removeInterval(resGap);
                            assert (index == 0 || index == gapParent.getSubIntervalCount());
                            if (gapParent.getSubIntervalCount() == 1) {
                                LayoutInterval last = this.layoutModel.removeInterval(gapParent, 0);
                                this.operations.addContent(last, gapParent.getParent(), this.layoutModel.removeInterval(gapParent));
                            } else if (LayoutInterval.canResize(resGap) && !LayoutInterval.wantResize(root) && (otherGap = gapParent.getSubInterval(index = index == 0 ? gapParent.getSubIntervalCount() - 1 : 0)).isEmptySpace()) {
                                this.layoutModel.setIntervalSize(otherGap, -1, otherGap.getPreferredSize(), Short.MAX_VALUE);
                            }
                        } else {
                            this.operations.resizeInterval(resGap, size);
                            if (size == -1 && LayoutInterval.canResize(resGap)) {
                                resGap.setMaximumSize(-2);
                                boolean layoutResizing = LayoutInterval.wantResize(root);
                                resGap.setMaximumSize(Short.MAX_VALUE);
                                if (layoutResizing) {
                                    this.layoutModel.setIntervalSize(resGap, -1, -1, -2);
                                }
                            }
                        }
                    } else if (!LayoutInterval.wantResize(root)) {
                        int minLayoutSize = this.computeMinimumDesignSize(root);
                        int growth = root.getCurrentSpace().size(i) - minLayoutSize;
                        if (growth > 0) {
                            LayoutInterval endGap = new LayoutInterval(101);
                            endGap.setSizes(-1, growth, Short.MAX_VALUE);
                            this.operations.insertGap(endGap, root, minLayoutSize, i, 1);
                        }
                    }
                }
                this.updateLayoutStructure(root, i, true);
            }
            if (component.getParent() == null) continue;
            if (minimum == null) {
                minimum = this.visualMapper.getComponentMinimumSize(component.getId());
                preferred = this.visualMapper.getComponentPreferredSize(component.getId());
            }
            int n = min = i == 0 ? minimum.width : minimum.height;
            boolean externalSize = this.visualMapper.hasExplicitPreferredSize(component.getId()) && currentSize != (i == 0 ? preferred.width : preferred.height) || currentSize < min || currentSize > min && !LayoutInterval.wantResize(root);
            this.operations.resizeInterval(outer, externalSize ? currentSize : -1);
        }
        return true;
    }

    private void imposeCurrentComponentSize(LayoutComponent component) {
        Dimension preferred = this.visualMapper.getComponentPreferredSize(component.getId());
        for (int i = 0; i < 2; ++i) {
            int pref;
            LayoutInterval li = component.getLayoutInterval(i);
            int defPref = li.getPreferredSize();
            if (!LayoutInterval.wantResizeInLayout(li) || defPref == 0) continue;
            int current = li.getCurrentSpace().size(i);
            int n = pref = i == 0 ? preferred.width : preferred.height;
            if (defPref == -1) {
                defPref = pref;
            }
            if (defPref == current) continue;
            this.operations.resizeInterval(li, current != pref ? current : -1);
        }
    }

    private void imposeCurrentGapSize(LayoutInterval gap, int currentSize, int dimension) {
        int pad = -1;
        int min = gap.getMinimumSize();
        int pref = gap.getPreferredSize();
        if (pref == -1) {
            if (!LayoutInterval.wantResizeInLayout(gap)) {
                return;
            }
            pref = pad = LayoutUtils.getSizeOfDefaultGap(gap, this.visualMapper);
        }
        if (currentSize != pref) {
            if (min == -1) {
                if (pad < 0) {
                    pad = LayoutUtils.getSizeOfDefaultGap(gap, this.visualMapper);
                }
                min = pad;
            } else if (min == -2) {
                min = pref;
            }
            if (currentSize < min) {
                currentSize = min;
            }
            this.operations.resizeInterval(gap, currentSize == pad ? -1 : currentSize);
        }
    }

    private void propEmptyContainer(LayoutInterval root, int dimension) {
        assert (root.getParent() == null && root.getSubIntervalCount() == 0);
        LayoutInterval gap = new LayoutInterval(101);
        gap.setSizes(0, root.getCurrentSpace().size(dimension), Short.MAX_VALUE);
        this.layoutModel.addInterval(gap, root, 0);
    }

    private int computeMinimumDesignSize(LayoutInterval interval) {
        int size;
        block7: {
            block6: {
                size = 0;
                if (!interval.isSingle()) break block6;
                int min = interval.getMinimumSize(true);
                int n = size = min == -2 ? interval.getPreferredSize(true) : min;
                if (size != -1) break block7;
                if (interval.isComponent()) {
                    LayoutComponent comp = interval.getComponent();
                    Dimension dim = min == -2 ? this.visualMapper.getComponentPreferredSize(comp.getId()) : this.visualMapper.getComponentMinimumSize(comp.getId());
                    size = interval == comp.getLayoutInterval(0) ? dim.width : dim.height;
                } else {
                    size = LayoutUtils.getSizeOfDefaultGap(interval, this.visualMapper);
                }
                break block7;
            }
            if (interval.isSequential()) {
                int n = interval.getSubIntervalCount();
                for (int i = 0; i < n; ++i) {
                    size += this.computeMinimumDesignSize(interval.getSubInterval(i));
                }
            } else {
                int n = interval.getSubIntervalCount();
                for (int i = 0; i < n; ++i) {
                    size = Math.max(size, this.computeMinimumDesignSize(interval.getSubInterval(i)));
                }
            }
        }
        return size;
    }

    private void intervalRemoved(LayoutInterval parent, int index, boolean primary, boolean wasResizing, int dimension) {
        if (parent.isSequential()) {
            LayoutInterval trailingNeighbor;
            LayoutInterval trailingGap;
            LayoutInterval leadingNeighbor;
            LayoutInterval leadingGap;
            if (index > 0) {
                LayoutInterval li = parent.getSubInterval(index - 1);
                if (li.isEmptySpace()) {
                    leadingGap = li;
                    this.layoutModel.removeInterval(li);
                    leadingNeighbor = --index > 0 ? parent.getSubInterval(index - 1) : null;
                } else {
                    leadingGap = null;
                    leadingNeighbor = li;
                }
            } else {
                leadingGap = null;
                leadingNeighbor = null;
            }
            if (index < parent.getSubIntervalCount()) {
                LayoutInterval li = parent.getSubInterval(index);
                if (li.isEmptySpace()) {
                    trailingGap = li;
                    this.layoutModel.removeInterval(li);
                    trailingNeighbor = index < parent.getSubIntervalCount() ? parent.getSubInterval(index) : null;
                } else {
                    trailingGap = null;
                    trailingNeighbor = li;
                }
            } else {
                trailingGap = null;
                trailingNeighbor = null;
            }
            if (!wasResizing && (leadingGap != null && LayoutInterval.canResize(leadingGap) || trailingGap != null && LayoutInterval.canResize(trailingGap))) {
                wasResizing = true;
            }
            LayoutInterval superParent = parent.getParent();
            if (parent.getSubIntervalCount() == 0) {
                int idx = this.layoutModel.removeInterval(parent);
                if (superParent.getParent() != null) {
                    this.intervalRemoved(superParent, idx, false, wasResizing, dimension);
                } else if (superParent.getSubIntervalCount() == 0) {
                    this.propEmptyContainer(superParent, dimension);
                }
            } else {
                boolean restResizing = LayoutInterval.contentWantResize(parent);
                if (wasResizing && !restResizing) {
                    if (leadingNeighbor == null && parent.getAlignment() == 0) {
                        this.layoutModel.setIntervalAlignment(parent, 1);
                    }
                    if (trailingNeighbor == null && parent.getAlignment() == 1) {
                        this.layoutModel.setIntervalAlignment(parent, 0);
                    }
                }
                int cutSize = LayoutRegion.distance((leadingNeighbor != null ? leadingNeighbor : parent).getCurrentSpace(), (trailingNeighbor != null ? trailingNeighbor : parent).getCurrentSpace(), dimension, leadingNeighbor != null ? 1 : 0, trailingNeighbor != null ? 0 : 1);
                if (leadingNeighbor != null && trailingNeighbor != null || superParent.getParent() == null || leadingNeighbor != null && LayoutInterval.getEffectiveAlignment(leadingNeighbor, 1) == 1 || trailingNeighbor != null && LayoutInterval.getEffectiveAlignment(trailingNeighbor, 0) == 0) {
                    int max;
                    int min;
                    if (wasResizing && !restResizing) {
                        min = -1;
                        max = Short.MAX_VALUE;
                    } else {
                        max = -2;
                        min = -2;
                    }
                    LayoutInterval gap = new LayoutInterval(101);
                    gap.setSizes(min, cutSize, max);
                    this.layoutModel.addInterval(gap, parent, index);
                } else {
                    if (parent.getSubIntervalCount() == 1) {
                        LayoutInterval last = this.layoutModel.removeInterval(parent, 0);
                        this.layoutModel.addInterval(last, superParent, this.layoutModel.removeInterval(parent));
                        this.layoutModel.setIntervalAlignment(last, parent.getRawAlignment());
                    } else {
                        int l = (trailingNeighbor != null && leadingNeighbor == null ? trailingNeighbor : parent).getCurrentSpace().positions[dimension][0];
                        int t = (leadingNeighbor != null && trailingNeighbor == null ? leadingNeighbor : parent).getCurrentSpace().positions[dimension][1];
                        parent.getCurrentSpace().set(dimension, l, t);
                    }
                    this.maintainSize(superParent, wasResizing || restResizing, dimension, parent, parent.getCurrentSpace().size(dimension) - cutSize);
                }
                if (wasResizing && !restResizing) {
                    this.operations.enableGroupResizing(superParent);
                }
            }
        } else {
            if (parent.getParent() == null) {
                return;
            }
            assert (parent.isParallel() && parent.getSubIntervalCount() > 0);
            int groupAlign = parent.getGroupAlignment();
            if (primary && (groupAlign == 0 || groupAlign == 1)) {
                this.maintainSize(parent, wasResizing, dimension, null, 0);
            }
            if (parent.getSubIntervalCount() == 1 && parent.getParent() != null) {
                LayoutInterval remaining = parent.getSubInterval(0);
                this.layoutModel.removeInterval(remaining);
                this.layoutModel.setIntervalAlignment(remaining, parent.getAlignment());
                if (LayoutInterval.wantResize(remaining) && !LayoutInterval.canResize(parent)) {
                    if (remaining.isGroup()) {
                        this.operations.suppressGroupResizing(remaining);
                    } else {
                        this.layoutModel.setIntervalSize(remaining, -2, remaining.getPreferredSize(), -2);
                    }
                }
                LayoutInterval superParent = parent.getParent();
                int i = this.layoutModel.removeInterval(parent);
                this.operations.addContent(remaining, superParent, i);
                if (remaining.isSequential() && superParent.isSequential()) {
                    this.eliminateConsecutiveGaps(superParent, i, dimension);
                }
            } else if (wasResizing && !LayoutInterval.contentWantResize(parent)) {
                this.operations.enableGroupResizing(parent);
            }
        }
    }

    private void eliminateConsecutiveGaps(LayoutInterval group, int index, int dimension) {
        assert (group.isSequential());
        if (index > 0) {
            --index;
        }
        while (index < group.getSubIntervalCount() - 1) {
            LayoutInterval current = group.getSubInterval(index);
            LayoutInterval next = group.getSubInterval(index + 1);
            if (current.isEmptySpace() && next.isEmptySpace()) {
                LayoutRegion tr;
                int ta;
                LayoutRegion lr;
                int la;
                if (index > 0) {
                    la = 1;
                    lr = group.getSubInterval(index - 1).getCurrentSpace();
                } else {
                    la = 0;
                    lr = group.getCurrentSpace();
                }
                if (index + 2 < group.getSubIntervalCount()) {
                    ta = 0;
                    tr = group.getSubInterval(index + 2).getCurrentSpace();
                } else {
                    ta = 1;
                    tr = group.getCurrentSpace();
                }
                this.operations.eatGap(current, next, LayoutRegion.distance(lr, tr, dimension, la, ta));
                continue;
            }
            ++index;
        }
    }

    private void maintainSize(LayoutInterval group, boolean wasResizing, int dimension, LayoutInterval excluded, int excludedSize) {
        assert (group.isParallel());
        int groupSize = group.getCurrentSpace().size(dimension);
        int[] groupPos = group.getCurrentSpace().positions[dimension];
        boolean leadAlign = false;
        boolean trailAlign = false;
        int leadCompPos = Integer.MAX_VALUE;
        int trailCompPos = Integer.MIN_VALUE;
        int subSize = Integer.MIN_VALUE;
        Iterator it = group.getSubIntervals();
        while (it.hasNext()) {
            int t;
            int l;
            LayoutInterval li = (LayoutInterval)it.next();
            int align = li.getAlignment();
            if (li != excluded) {
                int size = li.getCurrentSpace().size(dimension);
                if (size >= groupSize) {
                    return;
                }
                if (size > subSize) {
                    subSize = size;
                }
                l = LayoutUtils.getOutermostComponent((LayoutInterval)li, (int)dimension, (int)0).getCurrentSpace().positions[dimension][0];
                t = LayoutUtils.getOutermostComponent((LayoutInterval)li, (int)dimension, (int)1).getCurrentSpace().positions[dimension][1];
            } else {
                if (excludedSize > subSize) {
                    subSize = excludedSize;
                }
                if (align == 0) {
                    l = groupPos[0];
                    t = groupPos[0] + excludedSize;
                } else {
                    l = groupPos[1] - excludedSize;
                    t = groupPos[1];
                }
            }
            if (l < leadCompPos) {
                leadCompPos = l;
            }
            if (t > trailCompPos) {
                trailCompPos = t;
            }
            if (align == 0) {
                leadAlign = true;
                continue;
            }
            trailAlign = true;
        }
        if (leadAlign && trailAlign) {
            this.optimizeGaps(group, dimension, false);
        } else {
            if (!LayoutInterval.canResize(group)) {
                wasResizing = false;
            }
            boolean resizing = LayoutInterval.wantResize(group);
            LayoutInterval parent = group.getParent();
            if (parent != null && parent.isParallel() && group.getAlignment() == (leadAlign ? 0 : 1)) {
                this.maintainSize(parent, wasResizing && !resizing, dimension, group, subSize);
                if (leadAlign) {
                    groupPos[1] = trailCompPos;
                }
                if (trailAlign) {
                    groupPos[0] = leadCompPos;
                }
                groupPos[2] = (groupPos[0] + groupPos[0]) / 2;
            } else {
                int max;
                int min;
                int increment = groupSize - subSize;
                assert (increment > 0);
                LayoutInterval gap = new LayoutInterval(101);
                if (!resizing && (wasResizing || parent == null)) {
                    min = -1;
                    max = Short.MAX_VALUE;
                } else {
                    max = -2;
                    min = -2;
                }
                gap.setSizes(min, increment, max);
                this.operations.insertGap(gap, group, leadAlign ? trailCompPos : leadCompPos, dimension, leadAlign ? 1 : 0);
                if (leadAlign) {
                    groupPos[1] = trailCompPos;
                }
                if (trailAlign) {
                    groupPos[0] = leadCompPos;
                }
                groupPos[2] = (groupPos[0] + groupPos[0]) / 2;
                if (parent != null) {
                    if (parent.isSequential()) {
                        parent = parent.getParent();
                    }
                    this.optimizeGaps(parent, dimension, false);
                }
            }
        }
    }

    public int getModelCounter() {
        return this.modelCounter;
    }

    public void setModelCounter(int modelCounter) {
        this.modelCounter = modelCounter;
    }

    public static boolean testMode() {
        return Boolean.getBoolean(TEST_SWITCH);
    }

    public boolean logTestCode() {
        return this.modelCounter > -1 && Boolean.getBoolean(TEST_SWITCH);
    }

    class Listener
    implements LayoutModel.Listener {
        private boolean active = false;

        Listener() {
        }

        public void layoutChanged(LayoutEvent ev) {
            if (!LayoutDesigner.this.layoutModel.isUndoRedoInProgress()) {
                this.deactivate();
                LayoutDesigner.this.layoutChanged(ev);
                this.activate();
            }
        }

        void activate() {
            LayoutDesigner.this.layoutModel.addListener(this);
            this.active = true;
        }

        void deactivate() {
            LayoutDesigner.this.layoutModel.removeListener(this);
            this.active = false;
        }

        boolean isActive() {
            return this.active;
        }
    }
}

