/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.jmi.javamodel.Array;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.ParameterizedType;
import org.netbeans.jmi.javamodel.PrimitiveType;
import org.netbeans.jmi.javamodel.PrimitiveTypeKind;
import org.netbeans.jmi.javamodel.PrimitiveTypeKindEnum;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.modules.form.FormDataObject;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.java.JavaEditor;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

public class FormJavaSource {
    private final FormDataObject formDataObject;
    private List fields = null;
    private static final String[] PROPERTY_PREFIXES = new String[]{"get", "is"};

    public FormJavaSource(FormDataObject formDataObject) {
        this.formDataObject = formDataObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        JavaModel.getJavaRepository().beginTrans(false);
        JavaModel.setClassPath((FileObject)this.formDataObject.getPrimaryFile());
        try {
            this.fields = this.getFieldNames();
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    public boolean containsField(String name, boolean refresh) {
        if (refresh) {
            this.refresh();
        }
        return this.fields != null && this.fields.contains(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMethodNames(Class returnType) {
        MethodChildrenFilter cf = new MethodChildrenFilter(returnType){

            protected String getName(Element child) {
                return ((Method)child).getName();
            }
        };
        JavaModel.getJavaRepository().beginTrans(false);
        JavaModel.setClassPath((FileObject)this.formDataObject.getPrimaryFile());
        try {
            String[] stringArray = FormJavaSource.toArray(cf.getNames());
            return stringArray;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPropertyReadMethodNames(Class returnType) {
        MethodChildrenFilter cf = new MethodChildrenFilter(returnType){

            public boolean accept(Element child) {
                Method method = (Method)child;
                if (FormJavaSource.extractPropertyName(method.getName()).equals("")) {
                    return false;
                }
                return super.accept((Element)method);
            }

            protected String getName(Element child) {
                return ((Method)child).getName();
            }
        };
        JavaModel.getJavaRepository().beginTrans(false);
        JavaModel.setClassPath((FileObject)this.formDataObject.getPrimaryFile());
        try {
            String[] stringArray = FormJavaSource.toArray(cf.getNames());
            return stringArray;
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
    }

    public static String extractPropertyName(String methodName) {
        for (int i = 0; i < PROPERTY_PREFIXES.length; ++i) {
            if (!methodName.startsWith(PROPERTY_PREFIXES[i]) || methodName.length() <= PROPERTY_PREFIXES[i].length()) continue;
            return Introspector.decapitalize(methodName.substring(PROPERTY_PREFIXES[i].length()));
        }
        return "";
    }

    private List getFieldNames() {
        JavaEditor.SimpleSection variablesSection = this.formDataObject.getFormEditorSupport().getVariablesSection();
        if (variablesSection == null) {
            return null;
        }
        String variablesText = variablesSection.getText();
        final int genVariablesStartOffset = variablesSection.getPositionBefore().getOffset();
        final int genVariablesEndOffset = variablesSection.getPositionAfter().getOffset();
        ChildrenFilter cf = new ChildrenFilter(){

            protected boolean accept(Element child) {
                int startOffset = child.getStartOffset();
                return startOffset >= genVariablesEndOffset || startOffset <= genVariablesStartOffset;
            }

            protected Class getChildType() {
                return Field.class;
            }

            protected String getName(Element child) {
                return ((Field)child).getName();
            }
        };
        return cf.getNames();
    }

    private ClassDefinition getClassDefinition() {
        try {
            FileObject javaFileObject = this.formDataObject.getPrimaryFile();
            ClassPath classPath = ClassPath.getClassPath((FileObject)javaFileObject, (String)"classpath/source");
            Resource resource = JavaModel.getResource((FileObject)classPath.findOwnerRoot(javaFileObject), (String)classPath.getResourceName(javaFileObject));
            List classifiers = resource.getClassifiers();
            for (ClassDefinition javaClass : classifiers) {
                String className = javaClass.getName();
                int dotIndex = className.lastIndexOf(46);
                className = dotIndex == -1 ? className : className.substring(dotIndex + 1);
                if (!className.equals(javaFileObject.getName())) continue;
                return javaClass;
            }
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return null;
    }

    private boolean isAssignableFrom(String typeName, Class returnType) {
        Class clazz = this.getClassByName(typeName);
        return clazz != null ? returnType.isAssignableFrom(clazz) : false;
    }

    private Class getClassByName(String className) {
        Class clazz = null;
        try {
            clazz = ClassPathUtils.loadClass(className, this.formDataObject.getPrimaryFile());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        catch (LinkageError ex) {
            ex.printStackTrace();
        }
        return clazz;
    }

    private static String[] toArray(List list) {
        return list.toArray(new String[list.size()]);
    }

    private static String getVMName(Type type) {
        if (type instanceof Array) {
            return FormJavaSource.getVMName((Array)type);
        }
        if (type instanceof ParameterizedType) {
            return FormJavaSource.getVMName((ParameterizedType)type);
        }
        return type.getName();
    }

    private static String getVMName(ParameterizedType paramType) {
        String name = paramType.getName();
        if (!paramType.isInner()) {
            return name;
        }
        ClassDefinition cd = paramType.getDefinition().getDeclaringClass();
        StringBuffer sb = new StringBuffer(name);
        String pkgName = FormJavaSource.getPackageName(cd);
        int index = sb.lastIndexOf(".");
        while (index > pkgName.length()) {
            sb.setCharAt(index, '$');
            index = sb.lastIndexOf(".");
        }
        return sb.toString();
    }

    private static String getPackageName(ClassDefinition jc) {
        String result;
        Resource res;
        if (jc instanceof UnresolvedClass) {
            String name = jc.getName();
            int index = name.lastIndexOf(46);
            return index < 0 ? "" : name.substring(0, index);
        }
        if (jc instanceof JavaClass && (res = jc.getResource()) != null && (result = res.getPackageName()) != null) {
            return result;
        }
        return "";
    }

    private static String getVMName(Array array) {
        Type type = array.getType();
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        if (type instanceof PrimitiveType) {
            sb.append(FormJavaSource.getPrimitiveCode(((PrimitiveType)type).getKind()));
        } else {
            sb.append('L');
            sb.append(FormJavaSource.getVMName(type));
            sb.append(';');
        }
        return sb.toString();
    }

    private static String getPrimitiveCode(PrimitiveTypeKind kind) {
        if (PrimitiveTypeKindEnum.BOOLEAN.equals((Object)kind)) {
            return "Z";
        }
        if (PrimitiveTypeKindEnum.INT.equals((Object)kind)) {
            return "I";
        }
        if (PrimitiveTypeKindEnum.CHAR.equals((Object)kind)) {
            return "C";
        }
        if (PrimitiveTypeKindEnum.BYTE.equals((Object)kind)) {
            return "B";
        }
        if (PrimitiveTypeKindEnum.SHORT.equals((Object)kind)) {
            return "S";
        }
        if (PrimitiveTypeKindEnum.LONG.equals((Object)kind)) {
            return "J";
        }
        if (PrimitiveTypeKindEnum.FLOAT.equals((Object)kind)) {
            return "F";
        }
        if (PrimitiveTypeKindEnum.DOUBLE.equals((Object)kind)) {
            return "D";
        }
        return "V";
    }

    private abstract class MethodChildrenFilter
    extends ChildrenFilter {
        private final Class returnType;

        public MethodChildrenFilter(Class returnType) {
            this.returnType = returnType;
        }

        protected Class getChildType() {
            return Method.class;
        }

        public boolean accept(Element child) {
            return this.acceptReturnType(((Method)child).getType());
        }

        protected boolean acceptReturnType(Type type) {
            if (this.returnType.isPrimitive() || type instanceof PrimitiveType) {
                return type instanceof PrimitiveType && this.acceptPrimitiveType((PrimitiveType)type);
            }
            String typeName = FormJavaSource.getVMName(type);
            return typeName != null && !typeName.equals("") && FormJavaSource.this.isAssignableFrom(typeName, this.returnType);
        }

        private boolean acceptPrimitiveType(PrimitiveType type) {
            return this.returnType.isPrimitive() && !type.getKind().equals(PrimitiveTypeKindEnum.VOID) && type.getKind().equals(PrimitiveTypeKindEnum.forName((String)this.returnType.getName()));
        }
    }

    private abstract class ChildrenFilter {
        private ChildrenFilter() {
        }

        public List getNames() {
            ArrayList<String> values = new ArrayList<String>();
            ClassDefinition classDefinition = FormJavaSource.this.getClassDefinition();
            if (classDefinition == null) {
                return values;
            }
            List children = classDefinition.getChildren();
            for (Element child : children) {
                if (!this.getChildType().isAssignableFrom(child.getClass()) || !this.accept(child)) continue;
                String name = this.getName(child);
                values.add(name);
            }
            return values;
        }

        protected abstract String getName(Element var1);

        protected abstract boolean accept(Element var1);

        protected abstract Class getChildType();
    }
}

