/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.EventQueue;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.form.ComponentContainer;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.MetaComponentCreator;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADComponentNode;
import org.netbeans.modules.form.RADVisualComponent;
import org.netbeans.modules.form.RADVisualContainer;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.project.ClassPathUtils;
import org.netbeans.modules.form.project.ClassSource;
import org.openide.ErrorManager;
import org.openide.cookies.SourceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.NodeTransfer;
import org.openide.src.ClassElement;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.PasteType;

class CopySupport {
    private static final String flavorMimeType = "application/x-form-metacomponent;class=java.lang.Object";
    private static DataFlavor copyFlavor;
    private static DataFlavor cutFlavor;

    CopySupport() {
    }

    static DataFlavor getComponentCopyFlavor() {
        if (copyFlavor == null) {
            copyFlavor = new DataFlavor(flavorMimeType, "COMPONENT_COPY_FLAVOR");
        }
        return copyFlavor;
    }

    static DataFlavor getComponentCutFlavor() {
        if (cutFlavor == null) {
            cutFlavor = new DataFlavor(flavorMimeType, "COMPONENT_CUT_FLAVOR");
        }
        return cutFlavor;
    }

    public static boolean canPasteCut(RADComponent sourceComponent, FormModel targetForm, RADComponent targetComponent) {
        if (!sourceComponent.isInModel()) {
            return false;
        }
        if (sourceComponent.getFormModel() != targetForm) {
            return true;
        }
        if (targetComponent == null) {
            return targetForm.getModelContainer().getIndexOf(sourceComponent) < 0;
        }
        return sourceComponent != targetComponent && sourceComponent.getParentComponent() != targetComponent && !sourceComponent.isParentComponent(targetComponent);
    }

    static String getCopiedBeanClassName(Transferable t) {
        ClassElement clsElem = (ClassElement)NodeTransfer.cookie((Transferable)t, (int)1, ClassElement.class);
        if (clsElem == null) {
            SourceCookie source = (SourceCookie)NodeTransfer.cookie((Transferable)t, (int)1, SourceCookie.class);
            DataObject dobj = (DataObject)NodeTransfer.cookie((Transferable)t, (int)1, DataObject.class);
            if (source != null && dobj != null) {
                ClassElement[] classes = source.getSource().getClasses();
                for (int i = 0; i < classes.length; ++i) {
                    if (!classes[i].getName().getName().equals(dobj.getName()) || !classes[i].isDeclaredAsJavaBean()) continue;
                    clsElem = classes[i];
                    break;
                }
            }
        }
        return clsElem != null ? clsElem.getVMName() : null;
    }

    static ClassSource getCopiedBeanClassSource(Transferable t) {
        FileObject fo;
        DataObject dobj = (DataObject)NodeTransfer.cookie((Transferable)t, (int)1, DataObject.class);
        FileObject fileObject = fo = dobj != null ? dobj.getPrimaryFile() : null;
        if (fo == null) {
            return null;
        }
        String clsName = CopySupport.getCopiedBeanClassName(t);
        if (clsName == null) {
            return null;
        }
        return ClassPathUtils.getProjectClassSource(fo, clsName);
    }

    static class ClassPaste
    extends PasteType
    implements Mutex.ExceptionAction {
        private Transferable transferable;
        private ClassSource classSource;
        private FormModel targetForm;
        private RADComponent targetComponent;

        public ClassPaste(Transferable t, ClassSource classSource, FormModel targetForm, RADComponent targetComponent) {
            this.transferable = t;
            this.classSource = classSource;
            this.targetForm = targetForm;
            this.targetComponent = targetComponent;
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException ex) {
                Exception e = ex.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return this.transferable;
            }
        }

        public Object run() throws Exception {
            return this.doPaste();
        }

        private Transferable doPaste() throws IOException {
            this.targetForm.getComponentCreator().createComponent(this.classSource, this.targetComponent, null);
            return this.transferable;
        }
    }

    static class RADPaste
    extends PasteType
    implements Mutex.ExceptionAction {
        private Transferable transferable;
        private FormModel targetForm;
        private RADComponent targetComponent;

        public RADPaste(Transferable t, FormModel targetForm, RADComponent targetComponent) {
            this.transferable = t;
            this.targetForm = targetForm;
            this.targetComponent = targetComponent;
        }

        public String getName() {
            return FormUtils.getBundleString(this.isComponentCut() ? "CTL_CutPaste" : "CTL_CopyPaste");
        }

        public Transferable paste() throws IOException {
            if (EventQueue.isDispatchThread()) {
                return this.doPaste();
            }
            try {
                return (Transferable)Mutex.EVENT.readAccess((Mutex.ExceptionAction)this);
            }
            catch (MutexException ex) {
                Exception e = ex.getException();
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return ExTransferable.EMPTY;
            }
        }

        public Object run() throws Exception {
            return this.doPaste();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Transferable doPaste() throws IOException {
            boolean fromCut = this.isComponentCut();
            RADComponent sourceComponent = this.getSourceComponent(fromCut);
            if (sourceComponent == null) {
                return null;
            }
            if (!fromCut || sourceComponent.getCodeExpression() == null) {
                this.targetForm.getComponentCreator().copyComponent(sourceComponent, this.targetComponent);
                return null;
            }
            FormModel sourceForm = sourceComponent.getFormModel();
            if (sourceForm != this.targetForm || this.targetComponent != null && !sourceComponent.getClass().isAssignableFrom(this.targetComponent.getClass())) {
                if (this.targetForm.getComponentCreator().copyComponent(sourceComponent, this.targetComponent) == null) return null;
                RADComponentNode sourceNode = sourceComponent.getNodeReference();
                if (sourceNode == null) throw new IllegalStateException();
                sourceNode.destroy();
                return ExTransferable.EMPTY;
            }
            if (!CopySupport.canPasteCut(sourceComponent, this.targetForm, this.targetComponent) || !MetaComponentCreator.canAddComponent(sourceComponent.getBeanClass(), this.targetComponent)) {
                return null;
            }
            sourceForm.startCompoundEdit(true);
            boolean resetConstraintProperties = false;
            LayoutModel layoutModel = sourceForm.getLayoutModel();
            LayoutComponent layoutComponent = null;
            if (layoutModel != null && (layoutComponent = layoutModel.getLayoutComponent(sourceComponent.getId())) != null) {
                resetConstraintProperties = true;
                Object layoutUndoMark = layoutModel.getChangeMark();
                UndoableEdit ue = layoutModel.getUndoableEdit();
                boolean autoUndo = true;
                boolean fromModel = (!(this.targetComponent instanceof RADVisualContainer) || ((RADVisualContainer)this.targetComponent).getLayoutSupport() != null) && !layoutComponent.isLayoutContainer();
                try {
                    layoutModel.removeComponent(sourceComponent.getId(), fromModel);
                    autoUndo = false;
                }
                finally {
                    if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                        sourceForm.addUndoableEdit(ue);
                    }
                    if (autoUndo) {
                        sourceForm.forceUndoOfCompoundEdit();
                    }
                }
            }
            sourceForm.removeComponent(sourceComponent, false);
            if (sourceComponent instanceof RADVisualComponent && this.targetComponent instanceof RADVisualContainer) {
                RADVisualComponent visualComp = (RADVisualComponent)sourceComponent;
                RADVisualContainer visualCont = (RADVisualContainer)this.targetComponent;
                if (visualCont.getLayoutSupport() == null) {
                    this.targetForm.addComponent(visualComp, visualCont, false);
                    LayoutComponent parent = layoutModel.getLayoutComponent(visualCont.getId());
                    Object layoutUndoMark = layoutModel.getChangeMark();
                    UndoableEdit ue = layoutModel.getUndoableEdit();
                    boolean autoUndo = true;
                    if (layoutComponent == null) {
                        layoutComponent = new LayoutComponent(visualComp.getId(), MetaComponentCreator.shouldBeLayoutContainer(visualComp));
                    }
                    resetConstraintProperties = true;
                    try {
                        layoutModel.addNewComponent(layoutComponent, parent, null);
                        autoUndo = false;
                    }
                    finally {
                        if (!layoutUndoMark.equals(layoutModel.getChangeMark())) {
                            sourceForm.addUndoableEdit(ue);
                        }
                        if (autoUndo) {
                            sourceForm.forceUndoOfCompoundEdit();
                        }
                    }
                } else {
                    try {
                        this.targetForm.addVisualComponent(visualComp, visualCont, visualCont.getLayoutSupport().getStoredConstraints(visualComp), false);
                    }
                    catch (RuntimeException ex) {
                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                        return this.transferable;
                    }
                }
            } else {
                ComponentContainer targetContainer = this.targetComponent instanceof ComponentContainer ? (ComponentContainer)((Object)this.targetComponent) : null;
                this.targetForm.addComponent(sourceComponent, targetContainer, false);
            }
            if (!resetConstraintProperties) return ExTransferable.EMPTY;
            ((RADVisualComponent)sourceComponent).resetConstraintsProperties();
            return ExTransferable.EMPTY;
        }

        boolean isComponentCut() {
            return this.transferable.isDataFlavorSupported(CopySupport.getComponentCutFlavor());
        }

        RADComponent getSourceComponent(boolean fromCut) throws IOException {
            RADComponent sourceComponent = null;
            try {
                Object obj = this.transferable.getTransferData(fromCut ? CopySupport.getComponentCutFlavor() : CopySupport.getComponentCopyFlavor());
                if (obj instanceof RADComponent) {
                    sourceComponent = (RADComponent)obj;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                // empty catch block
            }
            return sourceComponent;
        }
    }

    static class RADTransferable
    implements Transferable {
        private RADComponent radComponent;
        private DataFlavor[] flavors;

        RADTransferable(DataFlavor flavor, RADComponent radComponent) {
            this(new DataFlavor[]{flavor}, radComponent);
        }

        RADTransferable(DataFlavor[] flavors, RADComponent radComponent) {
            this.flavors = flavors;
            this.radComponent = radComponent;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (int i = 0; i < this.flavors.length; ++i) {
                if (this.flavors[i] != flavor) continue;
                return true;
            }
            return false;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if ("x-form-metacomponent".equals(flavor.getSubType())) {
                return this.radComponent;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

