/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.diff;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.update.UpdateCommand;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorGroup;
import org.netbeans.modules.versioning.system.cvss.FileInformation;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitAction;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffExecutor;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.DiffSetupSource;
import org.netbeans.modules.versioning.system.cvss.ui.actions.diff.Setup;
import org.netbeans.modules.versioning.system.cvss.ui.actions.update.UpdateExecutor;
import org.netbeans.modules.versioning.system.cvss.util.Context;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class DiffMainPanel
extends JPanel
implements ActionListener,
VersioningListener,
DiffSetupSource {
    private Setup[] setups;
    private final Context context;
    private int displayStatuses;
    private final String contextName;
    private int currentType;
    private int currentDifferenceIndex;
    private int currentIndex = -1;
    private RequestProcessor.Task prepareTask;
    private DiffPrepareTask dpt;
    private AbstractAction nextAction;
    private AbstractAction prevAction;
    private static final RequestProcessor rp = new RequestProcessor("CVS-VersioningView", 1);
    private RequestProcessor.Task refreshTask;
    private ExecutorGroup group;
    private volatile boolean executed;
    private JComponent diffView;
    private JToggleButton allToggle;
    private JButton commitButton;
    private JToolBar controlsToolbar;
    private JPanel jPanel1;
    private JToggleButton localToggle;
    private JComboBox navigationCombo;
    private JButton nextButton;
    private JButton prevButton;
    private JButton refreshButton;
    private JToggleButton remoteToggle;
    private JButton updateButton;

    public DiffMainPanel(Context context, int initialType, String contextName, ExecutorGroup group) {
        this.context = context;
        this.contextName = contextName;
        this.group = group;
        this.currentType = initialType;
        this.initComponents();
        this.setupComponents();
        this.refreshSetups();
        this.refreshComponents();
        this.refreshTask = rp.create((Runnable)new RefreshViewTask());
    }

    public DiffMainPanel(File file, String rev1, String rev2) {
        this.context = null;
        this.contextName = file.getName();
        this.initComponents();
        this.setupComponents();
        this.localToggle.setVisible(false);
        this.remoteToggle.setVisible(false);
        this.allToggle.setVisible(false);
        this.navigationCombo.setVisible(false);
        this.refreshButton.setVisible(false);
        this.updateButton.setVisible(false);
        this.commitButton.setVisible(false);
        this.setups = new Setup[]{new Setup(file, rev1, rev2)};
        this.setDiffIndex(0, 0);
        this.dpt = new DiffPrepareTask(this.setups);
        this.prepareTask = RequestProcessor.getDefault().post((Runnable)this.dpt);
    }

    void componentClosed() {
        this.setups = null;
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
    }

    public synchronized void setGroup(ExecutorGroup group) {
        this.group = group;
        if (this.executed) {
            group.executed();
        }
    }

    void requestActive() {
        if (this.diffView != null) {
            this.diffView.requestFocusInWindow();
        }
    }

    private void setupComponents() {
        this.controlsToolbar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.controlsToolbar.setLayout(new ToolbarLayout());
        this.navigationCombo.addActionListener(this);
        this.navigationCombo.setRenderer(new ColoredComboRenderer());
        this.refreshButton.addActionListener(this);
        this.updateButton.addActionListener(this);
        this.commitButton.addActionListener(this);
        this.localToggle.addActionListener(this);
        this.remoteToggle.addActionListener(this);
        this.allToggle.addActionListener(this);
        this.refreshButton.setToolTipText(NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_RefreshDiff_Tooltip"));
        this.updateButton.setToolTipText(NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_UpdateDiff_Tooltip", (Object)this.contextName));
        this.commitButton.setToolTipText(NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_CommitDiff_Tooltip", (Object)this.contextName));
        ButtonGroup grp = new ButtonGroup();
        grp.add(this.localToggle);
        grp.add(this.remoteToggle);
        grp.add(this.allToggle);
        if (this.currentType == 0) {
            this.localToggle.setSelected(true);
        } else if (this.currentType == 1) {
            this.remoteToggle.setSelected(true);
        } else if (this.currentType == 2) {
            this.allToggle.setSelected(true);
        }
        this.nextAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
            }

            public void actionPerformed(ActionEvent e) {
                DiffMainPanel.this.onNextButton();
            }
        };
        this.prevAction = new AbstractAction(null, new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png"))){
            {
                this.putValue("ShortDescription", ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
            }

            public void actionPerformed(ActionEvent e) {
                DiffMainPanel.this.onPrevButton();
            }
        };
        this.nextButton.setAction(this.nextAction);
        this.prevButton.setAction(this.prevAction);
    }

    private void refreshComponents() {
        DiffView view;
        DiffView diffView = view = this.setups != null ? this.setups[this.currentIndex].getView() : null;
        if (view != null) {
            this.nextAction.setEnabled(this.currentIndex < this.setups.length - 1 || this.currentDifferenceIndex < view.getDifferenceCount() - 1);
        } else {
            this.nextAction.setEnabled(false);
        }
        this.prevAction.setEnabled(this.currentIndex > 0 || this.currentDifferenceIndex > 0);
    }

    public void addNotify() {
        super.addNotify();
        if (this.refreshTask != null) {
            CvsVersioningSystem.getInstance().getStatusCache().addVersioningListener(this);
        }
        JComponent parent = (JComponent)this.getParent();
        parent.getActionMap().put("jumpNext", this.nextAction);
        parent.getActionMap().put("jumpPrev", this.prevAction);
    }

    public void removeNotify() {
        CvsVersioningSystem.getInstance().getStatusCache().removeVersioningListener(this);
        super.removeNotify();
    }

    public void versioningEvent(VersioningEvent event) {
        if (event.getId() == FileStatusCache.EVENT_FILE_STATUS_CHANGED) {
            if (!this.affectsView(event)) {
                return;
            }
            if (CvsVersioningSystem.getInstance().getParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) != null) {
                this.refreshTask.schedule(1000);
            } else {
                this.refreshTask.schedule(200);
            }
        } else if (event.getId() == CvsVersioningSystem.EVENT_PARAM_CHANGED && event.getParams()[0].equals(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) && CvsVersioningSystem.getInstance().getParameter(CvsVersioningSystem.PARAM_BATCH_REFRESH_RUNNING) == null) {
            this.refreshTask.schedule(0);
        }
    }

    private boolean affectsView(VersioningEvent event) {
        File file = (File)event.getParams()[0];
        FileInformation oldInfo = (FileInformation)event.getParams()[1];
        FileInformation newInfo = (FileInformation)event.getParams()[2];
        if (oldInfo == null ? (newInfo.getStatus() & this.displayStatuses) == 0 : (oldInfo.getStatus() & this.displayStatuses) + (newInfo.getStatus() & this.displayStatuses) == 0) {
            return false;
        }
        return this.context.contains(file);
    }

    private void setDiffIndex(int idx, int location) {
        this.currentIndex = idx;
        DiffView view = this.setups[this.currentIndex].getView();
        TopComponent tc = (TopComponent)this.getClientProperty(TopComponent.class);
        if (tc != null) {
            FileObject fo;
            Node node = Node.EMPTY;
            File baseFile = this.setups[this.currentIndex].getBaseFile();
            if (baseFile != null && (fo = FileUtil.toFileObject((File)baseFile)) != null) {
                node = new AbstractNode(Children.LEAF, Lookups.singleton((Object)fo));
            }
            tc.setActivatedNodes(new Node[]{node});
        }
        boolean focus = false;
        this.removeDiffComponent();
        if (view != null) {
            if (location == -1) {
                location = view.getDifferenceCount() - 1;
            }
            if (location >= 0 && location < view.getDifferenceCount()) {
                view.setCurrentDifference(location);
            }
            this.diffView = (JComponent)view.getComponent();
            this.diffView.getActionMap().put("jumpNext", this.nextAction);
            this.diffView.getActionMap().put("jumpPrev", this.prevAction);
            TopComponent toc = WindowManager.getDefault().getRegistry().getActivated();
            if (SwingUtilities.isDescendingFrom(this, (Component)toc)) {
                focus = true;
            }
        } else {
            this.diffView = new SourcesUnavailableComponent(NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_DiffPanel_NoContent"));
        }
        this.add(this.diffView);
        this.currentDifferenceIndex = location;
        if (this.navigationCombo.isVisible()) {
            this.navigationCombo.setSelectedIndex(this.currentIndex);
        }
        this.refreshComponents();
        this.revalidate();
        this.repaint();
        if (focus) {
            this.diffView.requestFocusInWindow();
        }
    }

    private void removeDiffComponent() {
        if (this.diffView != null) {
            this.remove(this.diffView);
            this.diffView = null;
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.navigationCombo) {
            this.onNavigationCombo();
        } else if (source == this.refreshButton) {
            this.onRefreshButton();
        } else if (source == this.updateButton) {
            this.onUpdateButton();
        } else if (source == this.commitButton) {
            this.onCommitButton();
        } else if (source == this.localToggle || source == this.remoteToggle || source == this.allToggle) {
            this.onDiffTypeChanged();
        }
    }

    private void onRefreshButton() {
        LifecycleManager.getDefault().saveAll();
        this.refreshSetups();
        this.executeUpdateCommand(true);
    }

    private void onUpdateButton() {
        this.executeUpdateCommand(false);
    }

    private void onCommitButton() {
        CommitAction.invokeCommit(this.contextName, this.context, null);
    }

    private void executeUpdateCommand(boolean doNoChanges) {
        if (this.context == null || this.context.getRoots().size() == 0) {
            return;
        }
        UpdateCommand cmd = new UpdateCommand();
        String msg = doNoChanges ? NbBundle.getMessage((Class)DiffMainPanel.class, (String)"BK0001") : NbBundle.getMessage((Class)DiffMainPanel.class, (String)"BK0002");
        cmd.setDisplayName(msg);
        GlobalOptions options = CvsVersioningSystem.createGlobalOptions();
        if (this.context.getExclusions().size() > 0) {
            options.setExclusions(this.context.getExclusions().toArray(new File[this.context.getExclusions().size()]));
        }
        cmd.setFiles(this.context.getRootFiles());
        cmd.setBuildDirectories(true);
        cmd.setPruneDirectories(true);
        options.setDoNoChanges(doNoChanges);
        ExecutorGroup group = new ExecutorGroup(msg);
        group.addExecutors(UpdateExecutor.splitCommand(cmd, CvsVersioningSystem.getInstance(), options));
        group.execute();
    }

    private void onNextButton() {
        DiffView view;
        if (this.navigationCombo.isVisible()) {
            this.currentIndex = this.navigationCombo.getSelectedIndex();
        }
        if ((view = this.setups[this.currentIndex].getView()) != null) {
            int visibleDiffernce = view.getCurrentDifference();
            if (visibleDiffernce < view.getDifferenceCount() - 1) {
                this.currentDifferenceIndex = Math.max(this.currentDifferenceIndex, visibleDiffernce);
            }
            if (++this.currentDifferenceIndex >= view.getDifferenceCount()) {
                if (++this.currentIndex >= this.setups.length) {
                    --this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, 0);
                }
            } else {
                view.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (++this.currentIndex >= this.setups.length) {
                this.currentIndex = 0;
            }
            this.setDiffIndex(this.currentIndex, 0);
        }
        this.refreshComponents();
    }

    private void onPrevButton() {
        DiffView view = this.setups[this.currentIndex].getView();
        if (view != null) {
            if (--this.currentDifferenceIndex < 0) {
                if (--this.currentIndex < 0) {
                    ++this.currentIndex;
                } else {
                    this.setDiffIndex(this.currentIndex, -1);
                }
            } else {
                view.setCurrentDifference(this.currentDifferenceIndex);
            }
        } else {
            if (--this.currentIndex < 0) {
                this.currentIndex = this.setups.length - 1;
            }
            this.setDiffIndex(this.currentIndex, -1);
        }
        this.refreshComponents();
    }

    private void onNavigationCombo() {
        int idx = this.navigationCombo.getSelectedIndex();
        if (idx != this.currentIndex) {
            this.setDiffIndex(idx, 0);
        }
    }

    public Collection getSetups() {
        if (this.setups == null) {
            return Collections.EMPTY_SET;
        }
        return Arrays.asList(this.setups);
    }

    public String getSetupDisplayName() {
        return this.contextName;
    }

    private void refreshSetups() {
        if (this.dpt != null) {
            this.prepareTask.cancel();
        }
        switch (this.currentType) {
            case 0: {
                this.displayStatuses = 6612;
                break;
            }
            case 1: {
                this.displayStatuses = 1696;
                break;
            }
            case 2: {
                this.displayStatuses = 8180;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
            }
        }
        File[] files = DiffExecutor.getModifiedFiles(this.context, this.displayStatuses);
        Setup[] newSetups = new Setup[files.length];
        for (int i = 0; i < newSetups.length; ++i) {
            File file = files[i];
            newSetups[i] = new Setup(file, this.currentType);
        }
        Arrays.sort(newSetups, new SetupsComparator());
        this.setups = newSetups;
        this.navigationCombo.setModel(new DefaultComboBoxModel<Setup>(this.setups));
        if (this.setups.length == 0) {
            String noContentLabel;
            switch (this.currentType) {
                case 0: {
                    noContentLabel = NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_DiffPanel_NoLocalChanges");
                    break;
                }
                case 1: {
                    noContentLabel = NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_DiffPanel_NoRemoteChanges");
                    break;
                }
                case 2: {
                    noContentLabel = NbBundle.getMessage((Class)DiffMainPanel.class, (String)"MSG_DiffPanel_NoAllChanges");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown DIFF type:" + this.currentType);
                }
            }
            this.setups = null;
            this.navigationCombo.setModel(new DefaultComboBoxModel<Object>(new Object[]{noContentLabel}));
            this.navigationCombo.setEnabled(false);
            this.navigationCombo.setPreferredSize(null);
            Dimension dim = this.navigationCombo.getPreferredSize();
            this.navigationCombo.setPreferredSize(new Dimension(dim.width + 1, dim.height));
            this.removeDiffComponent();
            this.diffView = new SourcesUnavailableComponent(noContentLabel);
            this.add(this.diffView);
            this.nextAction.setEnabled(false);
            this.prevAction.setEnabled(false);
            this.revalidate();
            this.repaint();
            this.executed();
        } else {
            this.navigationCombo.setEnabled(true);
            this.navigationCombo.setPreferredSize(null);
            Dimension dim = this.navigationCombo.getPreferredSize();
            this.navigationCombo.setPreferredSize(new Dimension(dim.width + 1, dim.height));
            this.setDiffIndex(0, 0);
            this.dpt = new DiffPrepareTask(this.setups);
            this.prepareTask = RequestProcessor.getDefault().post((Runnable)this.dpt);
        }
    }

    private void onDiffTypeChanged() {
        if (this.localToggle.isSelected()) {
            if (this.currentType == 0) {
                return;
            }
            this.currentType = 0;
        } else if (this.remoteToggle.isSelected()) {
            if (this.currentType == 1) {
                return;
            }
            this.currentType = 1;
        } else if (this.allToggle.isSelected()) {
            if (this.currentType == 2) {
                return;
            }
            this.currentType = 2;
        }
        this.refreshSetups();
    }

    private void initComponents() {
        this.controlsToolbar = new JToolBar();
        this.allToggle = new JToggleButton();
        this.localToggle = new JToggleButton();
        this.remoteToggle = new JToggleButton();
        this.navigationCombo = new JComboBox();
        this.nextButton = new JButton();
        this.prevButton = new JButton();
        this.jPanel1 = new JPanel();
        this.refreshButton = new JButton();
        this.updateButton = new JButton();
        this.commitButton = new JButton();
        this.setLayout(new BorderLayout());
        this.controlsToolbar.setFloatable(false);
        this.allToggle.setText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_All"));
        this.allToggle.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_All_Tooltip"));
        this.controlsToolbar.add(this.allToggle);
        this.localToggle.setText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Local"));
        this.localToggle.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Local_Tooltip"));
        this.controlsToolbar.add(this.localToggle);
        this.remoteToggle.setText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Remote"));
        this.remoteToggle.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Remote_Tooltip"));
        this.controlsToolbar.add(this.remoteToggle);
        this.controlsToolbar.add(this.navigationCombo);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-next.png")));
        this.nextButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Next_Tooltip"));
        this.nextButton.setEnabled(false);
        this.controlsToolbar.add(this.nextButton);
        this.prevButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/diff-prev.png")));
        this.prevButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
        this.prevButton.setEnabled(false);
        this.controlsToolbar.add(this.prevButton);
        this.jPanel1.setMaximumSize(new Dimension(15, 1));
        this.jPanel1.setPreferredSize(new Dimension(15, 1));
        this.controlsToolbar.add(this.jPanel1);
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/refresh.png")));
        this.refreshButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
        this.controlsToolbar.add(this.refreshButton);
        this.updateButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/update.png")));
        this.updateButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
        this.controlsToolbar.add(this.updateButton);
        this.commitButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/versioning/system/cvss/resources/icons/commit.png")));
        this.commitButton.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/diff/Bundle").getString("CTL_DiffPanel_Prev_Tooltip"));
        this.controlsToolbar.add(this.commitButton);
        this.add((Component)this.controlsToolbar, "North");
    }

    private synchronized void executed() {
        if (this.group != null) {
            this.group.executed();
        } else {
            this.executed = true;
        }
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DiffMainPanel.this.refreshSetups();
                }
            });
        }
    }

    private static class SetupsComparator
    extends Utils.ByImportanceComparator {
        private FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();

        public int compare(Object o1, Object o2) {
            File file1 = ((Setup)o1).getBaseFile();
            File file2 = ((Setup)o2).getBaseFile();
            int cmp = super.compare(this.cache.getStatus(file1), this.cache.getStatus(file2));
            if (cmp == 0) {
                return file1.getName().compareToIgnoreCase(file2.getName());
            }
            return cmp;
        }
    }

    private class ToolbarLayout
    implements LayoutManager {
        private int TOOLBAR_HEIGHT_ADJUSTMENT = 10;
        private int TOOLBAR_SEPARATOR_MIN_WIDTH = 12;
        private int toolbarHeight = -1;
        private Dimension parentSize;
        private Set adjusted = new HashSet();

        private ToolbarLayout() {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void layoutContainer(Container parent) {
            Rectangle[] sizes = this.layout(parent);
            for (int i = 0; i < sizes.length; ++i) {
                JComponent comp = (JComponent)parent.getComponent(i);
                if (!comp.isVisible()) continue;
                comp.setBounds(sizes[i]);
            }
        }

        private Rectangle[] layout(Container parent) {
            Dimension dim = DiffMainPanel.this.getSize();
            Dimension max = parent.getSize();
            int rowOffset = 0;
            int maxHeigth = 0;
            ArrayList<Rectangle> sizes = new ArrayList<Rectangle>();
            int components = parent.getComponentCount();
            int horizont = 0;
            for (int i = 0; i < components; ++i) {
                Rectangle rect = new Rectangle();
                JComponent comp = (JComponent)parent.getComponent(i);
                if (comp.isVisible()) {
                    rect.setLocation(horizont, rowOffset);
                    if (comp instanceof AbstractButton) {
                        this.adjustToobarButton((AbstractButton)comp);
                    } else {
                        this.adjustToolbarComponentSize(comp);
                    }
                    Dimension pref = comp.getPreferredSize();
                    int width = pref.width;
                    if (comp instanceof JSeparator && dim.height - dim.width <= 0) {
                        width = Math.max(width, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                    }
                    int height = this.getToolbarHeight(dim) - 1;
                    maxHeigth = Math.max(maxHeigth, height);
                    rect.setSize(width, height);
                    if ((horizont += width) > max.width) {
                        rowOffset += maxHeigth + 2;
                        horizont = 0;
                        maxHeigth = 0;
                    }
                }
                sizes.add(rect);
            }
            return sizes.toArray(new Rectangle[sizes.size()]);
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension dim = DiffMainPanel.this.getSize();
            int height = this.getToolbarHeight(dim);
            int components = parent.getComponentCount();
            int horizont = 0;
            for (int i = 0; i < components; ++i) {
                Component comp = parent.getComponent(i);
                if (!comp.isVisible()) continue;
                if (comp instanceof AbstractButton) {
                    this.adjustToobarButton((AbstractButton)comp);
                } else {
                    this.adjustToolbarComponentSize((JComponent)comp);
                }
                Dimension pref = comp.getPreferredSize();
                int width = pref.width;
                if (comp instanceof JSeparator && dim.height - dim.width <= 0) {
                    width = Math.max(width, this.TOOLBAR_SEPARATOR_MIN_WIDTH);
                }
                horizont += width;
            }
            return new Dimension(horizont, height);
        }

        public Dimension preferredLayoutSize(Container parent) {
            Rectangle[] bounds = this.layout(parent);
            Rectangle union = new Rectangle();
            for (int i = 0; i < bounds.length; ++i) {
                union.add(bounds[i]);
            }
            return new Dimension(union.width, union.height);
        }

        private int getToolbarHeight(Dimension parent) {
            if (this.parentSize == null || !this.parentSize.equals(parent)) {
                this.parentSize = parent;
                this.toolbarHeight = -1;
            }
            if (this.toolbarHeight == -1) {
                BufferedImage image = new BufferedImage(1, 1, 10);
                Graphics2D g = image.createGraphics();
                UIDefaults def = UIManager.getLookAndFeelDefaults();
                int height = 0;
                String[] fonts = new String[]{"Label.font", "Button.font", "ToggleButton.font"};
                for (int i = 0; i < fonts.length; ++i) {
                    Font f = def.getFont(fonts[i]);
                    FontMetrics fm = g.getFontMetrics(f);
                    height = Math.max(height, fm.getHeight());
                }
                this.toolbarHeight = height + this.TOOLBAR_HEIGHT_ADJUSTMENT;
            }
            return this.toolbarHeight;
        }

        private void adjustToobarButton(final AbstractButton button) {
            if (this.adjusted.contains(button)) {
                return;
            }
            if (!(button instanceof JToggleButton)) {
                button.setContentAreaFilled(false);
                button.setMargin(new Insets(0, 3, 0, 3));
                button.setBorderPainted(false);
                button.addMouseListener(new MouseAdapter(){

                    public void mouseEntered(MouseEvent e) {
                        button.setContentAreaFilled(true);
                        button.setBorderPainted(true);
                    }

                    public void mouseExited(MouseEvent e) {
                        button.setContentAreaFilled(false);
                        button.setBorderPainted(false);
                    }
                });
            }
            this.adjustToolbarComponentSize(button);
        }

        private void adjustToolbarComponentSize(JComponent button) {
            if (this.adjusted.contains(button)) {
                return;
            }
            if (button.getBorder() instanceof CompoundBorder) {
                Dimension pref = button.getPreferredSize();
                if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
                    pref.width += 9;
                }
                button.setPreferredSize(pref);
            }
            this.adjusted.add(button);
        }
    }

    private static class SourcesUnavailableComponent
    extends JComponent {
        public SourcesUnavailableComponent(String message) {
            JLabel label = new JLabel(message);
            this.setLayout(new BorderLayout());
            label.setHorizontalAlignment(0);
            this.add((Component)label, "Center");
        }
    }

    private class DiffPrepareTask
    implements Runnable {
        private final Setup[] prepareSetups;

        public DiffPrepareTask(Setup[] prepareSetups) {
            this.prepareSetups = prepareSetups;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Diff diff = Diff.getDefault();
            try {
                for (int i = 0; i < this.prepareSetups.length; ++i) {
                    if (this.prepareSetups != DiffMainPanel.this.setups) {
                        return;
                    }
                    try {
                        this.prepareSetups[i].initSources(DiffMainPanel.this.group);
                        final int fi = i;
                        StreamSource ss1 = this.prepareSetups[fi].getFirstSource();
                        StreamSource ss2 = this.prepareSetups[fi].getSecondSource();
                        final DiffView view = diff.createDiff(ss1, ss2);
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                DiffPrepareTask.this.prepareSetups[fi].setView(view);
                                if (DiffPrepareTask.this.prepareSetups != DiffMainPanel.this.setups) {
                                    return;
                                }
                                if (DiffMainPanel.this.currentIndex == fi) {
                                    DiffMainPanel.this.setDiffIndex(fi, 0);
                                }
                            }
                        });
                        continue;
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            }
            finally {
                DiffMainPanel.this.executed();
            }
        }
    }

    private static class ColoredComboRenderer
    extends BasicComboBoxRenderer {
        private ColoredComboRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                value = ((Setup)value).getBaseFile().getName();
            }
            return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        }
    }
}

