/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import org.netbeans.lib.cvsclient.admin.Entry;

public class CvsMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String repository;
    private String root;
    private String[] entries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CvsMetadata readAndRemove(File file) throws IOException {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory");
        }
        BufferedReader r = null;
        CvsMetadata data = new CvsMetadata();
        try {
            r = new BufferedReader(new FileReader(new File(file, "CVS/Repository")));
            data.repository = r.readLine();
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        try {
            r = new BufferedReader(new FileReader(new File(file, "CVS/Root")));
            data.root = r.readLine();
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        try {
            String entry;
            r = new BufferedReader(new FileReader(new File(file, "CVS/Entries")));
            ArrayList<String> entries = new ArrayList<String>();
            while ((entry = r.readLine()) != null) {
                Entry e = new Entry(entry);
                if (!"D".equals(entry) && !e.isDirectory()) {
                    if (e.getRevision().charAt(0) != '-') {
                        e.setRevision("-" + e.getRevision());
                    }
                    e.setConflict("dummy timestamp");
                    entry = e.toString();
                }
                entries.add(entry);
            }
            data.entries = entries.toArray(new String[entries.size()]);
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File dir) throws IOException {
        dir.mkdirs();
        PrintWriter w = null;
        try {
            w = new PrintWriter(new FileWriter(new File(dir, "Repository")));
            w.println(this.repository);
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
        try {
            w = new PrintWriter(new FileWriter(new File(dir, "Root")));
            w.println(this.root);
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
        try {
            w = new PrintWriter(new FileWriter(new File(dir, "Entries")));
            for (int i = 0; i < this.entries.length; ++i) {
                w.println(this.entries[i]);
            }
        }
        finally {
            if (w != null) {
                w.close();
            }
        }
    }

    public CvsMetadata(String repository, String root, String[] entries) {
        this.repository = repository;
        this.root = root;
        this.entries = (String[])entries.clone();
    }

    public CvsMetadata() {
    }

    public String getRepository() {
        return this.repository;
    }

    public String getRoot() {
        return this.root;
    }

    public String[] getEntries() {
        return this.entries;
    }

    public Entry[] getEntryObjects() {
        Entry[] eo = new Entry[this.entries.length];
        for (int i = 0; i < this.entries.length; ++i) {
            eo[i] = new Entry(this.entries[i]);
        }
        return eo;
    }
}

