/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss;

import org.netbeans.lib.cvsclient.Client;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.connection.AuthenticationException;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

class CommandRunnable
implements Runnable,
Cancellable {
    private final Client client;
    private final GlobalOptions options;
    private final Command cmd;
    private Throwable failure;
    private boolean aborted;
    private Thread interruptibleThread;
    private ExecutorSupport support;
    private static boolean testRetry = Boolean.getBoolean("netbeans.debug.cvs.io.retry");

    public CommandRunnable(Client client, GlobalOptions options, Command cmd, ExecutorSupport support) {
        this.client = client;
        this.options = options;
        this.cmd = cmd;
        this.support = support;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        CommandRunnable commandRunnable = this;
        synchronized (commandRunnable) {
            if (this.isAborted()) {
                return;
            }
            this.support.commandStarted(this);
        }
        this.interruptibleThread = Thread.currentThread();
        Runnable worker = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CounterRunnable counterUpdater = new CounterRunnable();
                RequestProcessor.Task counterTask = RequestProcessor.getDefault().create((Runnable)counterUpdater);
                counterUpdater.initTask(counterTask);
                try {
                    counterTask.schedule(500);
                    if (testRetry && !((CommandRunnable)CommandRunnable.this).support.t9yRetryFlag) {
                        ((CommandRunnable)CommandRunnable.this).support.t9yRetryFlag = true;
                        String msg = "Testing retry logic. Retry attempt will be OK. (-Dnetbeans.debug.cvs.io.retry=true)";
                        throw new AuthenticationException(msg, msg);
                    }
                    CommandRunnable.this.client.executeCommand(CommandRunnable.this.cmd, CommandRunnable.this.options);
                }
                catch (Throwable e) {
                    CommandRunnable.this.failure = e;
                }
                finally {
                    counterTask.cancel();
                    try {
                        CommandRunnable.this.client.getConnection().close();
                    }
                    catch (Throwable e) {
                        ErrorManager.getDefault().notify(16, e);
                    }
                }
            }
        };
        Thread workerThread = new Thread(worker, "CVS I/O Worker ");
        workerThread.start();
        try {
            workerThread.join();
        }
        catch (InterruptedException e) {
            ErrorManager err = ErrorManager.getDefault();
            err.annotate((Throwable)e, "Passing interrupt to possibly uninterruptible nested thread: " + workerThread + "\nCVS command: " + this.cmd.getCVSCommand());
            workerThread.interrupt();
            err.notify(1, (Throwable)e);
        }
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public synchronized boolean isAborted() {
        return this.aborted;
    }

    public synchronized boolean cancel() {
        if (this.aborted) {
            return false;
        }
        this.aborted = true;
        this.client.abort();
        if (this.interruptibleThread != null) {
            this.interruptibleThread.interrupt();
        }
        return true;
    }

    public String toString() {
        return "CommandRunnable command=" + this.cmd.getCVSCommand();
    }

    private class CounterRunnable
    implements Runnable {
        private RequestProcessor.Task task;
        private long counter;

        private CounterRunnable() {
        }

        public void run() {
            long current = CommandRunnable.this.client.getCounter();
            long delta = current - this.counter;
            this.counter = current;
            CommandRunnable.this.support.increaseDataCounter(delta);
            this.task.schedule(500);
        }

        void initTask(RequestProcessor.Task task) {
            this.task = task;
        }
    }
}

