/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldStateChange;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.AtomicLockEvent;
import org.netbeans.editor.AtomicLockListener;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.DrawLayerFactory;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.Settings;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsChangeListener;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.WeakTimerListener;
import org.netbeans.lib.editor.util.swing.DocumentListenerPriority;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.openide.util.WeakListeners;

public class BaseCaret
implements Caret,
MouseListener,
MouseMotionListener,
PropertyChangeListener,
DocumentListener,
ActionListener,
SettingsChangeListener,
AtomicLockListener,
FoldHierarchyListener {
    public static final String BLOCK_CARET = "block-caret";
    public static final String LINE_CARET = "line-caret";
    public static final String THIN_LINE_CARET = "thin-line-caret";
    private static final boolean debugCaretFocus;
    private static final boolean debugCaretFocusExtra;
    private ListenerImpl listenerImpl;
    private Rectangle caretBounds;
    protected JTextComponent component;
    Point magicCaretPosition;
    MarkFactory.DrawMark caretMark = new MarkFactory.CaretMark();
    MarkFactory.DrawMark selectionMark = new MarkFactory.DrawMark("caret-layer", null);
    boolean caretVisible;
    boolean blinkVisible;
    boolean selectionVisible;
    protected EventListenerList listenerList = new EventListenerList();
    protected Timer flasher;
    String type;
    boolean italic;
    private int[] xPoints = new int[4];
    private int[] yPoints = new int[4];
    private Action selectWordAction;
    private Action selectLineAction;
    protected ChangeEvent changeEvent;
    protected char[] dotChar = new char[]{' '};
    private boolean overwriteMode;
    private BaseDocument listenDoc;
    protected Font afterCaretFont;
    protected Font beforeCaretFont;
    protected Color textForeColor;
    protected Color textBackColor;
    private transient FocusListener focusListener;
    private transient boolean inAtomicLock;
    private transient boolean modified;
    private transient int undoOffset = -1;
    private transient boolean afterFirstSetDot = false;
    static final long serialVersionUID = -9113841520331402768L;
    private MouseEvent dndArmedEvent = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BaseCaret() {
        this.listenerImpl = new ListenerImpl();
        Settings.addSettingsChangeListener(this);
    }

    public void settingsChange(SettingsChangeEvent evt) {
        if (evt != null && "caret-blink-rate".equals(evt.getSettingName())) {
            JTextComponent c = this.component;
            if (c == null) {
                return;
            }
            if (evt.getKitClass() != Utilities.getKitClass(c)) {
                return;
            }
            Object value = evt.getNewValue();
            if (value instanceof Integer) {
                this.setBlinkRate((Integer)value);
            }
        }
        this.updateType();
    }

    void updateType() {
        JTextComponent c = this.component;
        if (c != null) {
            Color caretColor;
            boolean newItalic;
            String newType;
            Class kitClass = Utilities.getKitClass(c);
            if (kitClass == null) {
                return;
            }
            if (this.overwriteMode) {
                newType = SettingsUtil.getString(kitClass, "caret-type-overwrite-mode", LINE_CARET);
                newItalic = SettingsUtil.getBoolean(kitClass, "caret-italic-overwrite-mode", false);
                caretColor = BaseCaret.getColor(kitClass, "caret-color-overwrite-mode", SettingsDefaults.defaultCaretColorOvwerwriteMode);
            } else {
                newType = SettingsUtil.getString(kitClass, "caret-type-insert-mode", LINE_CARET);
                newItalic = SettingsUtil.getBoolean(kitClass, "caret-italic-insert-mode", false);
                caretColor = BaseCaret.getColor(kitClass, "caret-color-insert-mode", SettingsDefaults.defaultCaretColorInsertMode);
            }
            this.type = newType;
            this.italic = newItalic;
            c.setCaretColor(caretColor);
            if (debugCaretFocusExtra) {
                System.err.println("Updating caret color:" + caretColor);
            }
            this.resetBlink();
        }
    }

    private static Color getColor(Class kitClass, String settingName, Color defaultValue) {
        Object value = Settings.getValue(kitClass, settingName);
        return value instanceof Color ? (Color)value : defaultValue;
    }

    private boolean updateCaretBounds() {
        JTextComponent c = this.component;
        if (c != null) {
            Rectangle newCaretBounds;
            int offset = this.getDot();
            try {
                newCaretBounds = c.getUI().modelToView(c, offset, Position.Bias.Forward);
                BaseDocument doc = Utilities.getDocument(c);
                if (doc != null) {
                    doc.getChars(offset, this.dotChar, 0, 1);
                }
            }
            catch (BadLocationException e) {
                newCaretBounds = null;
                Utilities.annotateLoggable(e);
            }
            if (newCaretBounds != null) {
                this.caretBounds = newCaretBounds;
                return true;
            }
        }
        return false;
    }

    public void install(JTextComponent c) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        this.component = c;
        this.blinkVisible = true;
        BaseDocument doc = Utilities.getDocument(c);
        if (doc != null) {
            this.modelChanged(null, doc);
        }
        this.updateCaretBounds();
        if (this.caretBounds == null) {
            this.component.addComponentListener(this.listenerImpl);
        }
        this.component.addPropertyChangeListener(this);
        this.component.addFocusListener(this.listenerImpl);
        this.component.addMouseListener(this);
        this.component.addMouseMotionListener(this);
        EditorUI editorUI = Utilities.getEditorUI(this.component);
        editorUI.addLayer(new DrawLayerFactory.CaretLayer(), 10000);
        this.caretMark.setEditorUI(editorUI);
        this.selectionMark.setEditorUI(editorUI);
        editorUI.addPropertyChangeListener(this);
        FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)c);
        if (hierarchy != null) {
            hierarchy.addFoldHierarchyListener((FoldHierarchyListener)this);
        }
        if (this.component.hasFocus()) {
            if (debugCaretFocus || debugCaretFocusExtra) {
                System.err.println("Component has focus, calling BaseCaret.focusGained(); doc=" + this.component.getDocument().getProperty("title"));
            }
            this.listenerImpl.focusGained(null);
        }
        this.dispatchUpdate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deinstall(JTextComponent c) {
        this.component = null;
        ListenerImpl listenerImpl = this.listenerImpl;
        synchronized (listenerImpl) {
            if (this.flasher != null) {
                this.setBlinkRate(0);
            }
        }
        Utilities.getEditorUI(c).removeLayer("caret-layer");
        c.removeMouseMotionListener(this);
        c.removeMouseListener(this);
        c.removeFocusListener(this.listenerImpl);
        c.removePropertyChangeListener(this);
        FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)c);
        if (hierarchy != null) {
            hierarchy.removeFoldHierarchyListener((FoldHierarchyListener)this);
        }
        this.modelChanged(this.listenDoc, null);
    }

    protected void modelChanged(BaseDocument oldDoc, BaseDocument newDoc) {
        if (oldDoc != null) {
            if (!$assertionsDisabled && oldDoc != this.listenDoc) {
                throw new AssertionError();
            }
            DocumentUtilities.removeDocumentListener((Document)oldDoc, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.CARET_UPDATE);
            oldDoc.removeAtomicLockListener(this);
            try {
                this.caretMark.remove();
                this.selectionMark.remove();
            }
            catch (InvalidMarkException e) {
                Utilities.annotateLoggable(e);
            }
            this.listenDoc = null;
        }
        if (newDoc != null) {
            DocumentUtilities.addDocumentListener((Document)newDoc, (DocumentListener)this, (DocumentListenerPriority)DocumentListenerPriority.CARET_UPDATE);
            this.listenDoc = newDoc;
            newDoc.addAtomicLockListener(this);
            try {
                Utilities.insertMark(newDoc, this.caretMark, 0);
                Utilities.insertMark(newDoc, this.selectionMark, 0);
            }
            catch (InvalidMarkException e) {
                Utilities.annotateLoggable(e);
            }
            catch (BadLocationException e) {
                Utilities.annotateLoggable(e);
            }
            this.settingsChange(null);
            Utilities.runInEventDispatchThread(new Runnable(){

                public void run() {
                    BaseCaret.this.updateType();
                }
            });
        }
    }

    public void paint(Graphics g) {
        JTextComponent c = this.component;
        if (c == null) {
            return;
        }
        EditorUI editorUI = Utilities.getEditorUI(c);
        if (this.caretBounds != null && this.isVisible() && this.blinkVisible) {
            this.paintCustomCaret(g);
        }
    }

    protected void paintCustomCaret(Graphics g) {
        JTextComponent c = this.component;
        if (c != null) {
            EditorUI editorUI = Utilities.getEditorUI(c);
            g.setColor(c.getCaretColor());
            if (THIN_LINE_CARET.equals(this.type)) {
                int upperX = this.caretBounds.x;
                if (this.beforeCaretFont != null && this.beforeCaretFont.isItalic() && this.italic) {
                    upperX = (int)((double)upperX + Math.tan(this.beforeCaretFont.getItalicAngle()) * (double)this.caretBounds.height);
                }
                g.drawLine(upperX, this.caretBounds.y, this.caretBounds.x, this.caretBounds.y + this.caretBounds.height - 1);
            } else if (BLOCK_CARET.equals(this.type)) {
                if (this.afterCaretFont != null) {
                    g.setFont(this.afterCaretFont);
                }
                if (this.afterCaretFont != null && this.afterCaretFont.isItalic() && this.italic) {
                    int upperX;
                    this.xPoints[0] = upperX = (int)((double)this.caretBounds.x + Math.tan(this.afterCaretFont.getItalicAngle()) * (double)this.caretBounds.height);
                    this.yPoints[0] = this.caretBounds.y;
                    this.xPoints[1] = upperX + this.caretBounds.width;
                    this.yPoints[1] = this.caretBounds.y;
                    this.xPoints[2] = this.caretBounds.x + this.caretBounds.width;
                    this.yPoints[2] = this.caretBounds.y + this.caretBounds.height - 1;
                    this.xPoints[3] = this.caretBounds.x;
                    this.yPoints[3] = this.caretBounds.y + this.caretBounds.height - 1;
                    g.fillPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    g.fillRect(this.caretBounds.x, this.caretBounds.y, this.caretBounds.width, this.caretBounds.height);
                }
                if (!Character.isWhitespace(this.dotChar[0])) {
                    g.setColor(Color.white);
                    g.drawChars(this.dotChar, 0, 1, this.caretBounds.x, this.caretBounds.y + editorUI.getLineAscent());
                }
            } else {
                int blkWidth = 2;
                if (this.beforeCaretFont != null && this.beforeCaretFont.isItalic() && this.italic) {
                    int upperX;
                    this.xPoints[0] = upperX = (int)((double)this.caretBounds.x + Math.tan(this.beforeCaretFont.getItalicAngle()) * (double)this.caretBounds.height);
                    this.yPoints[0] = this.caretBounds.y;
                    this.xPoints[1] = upperX + blkWidth;
                    this.yPoints[1] = this.caretBounds.y;
                    this.xPoints[2] = this.caretBounds.x + blkWidth;
                    this.yPoints[2] = this.caretBounds.y + this.caretBounds.height - 1;
                    this.xPoints[3] = this.caretBounds.x;
                    this.yPoints[3] = this.caretBounds.y + this.caretBounds.height - 1;
                    g.fillPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    g.fillRect(this.caretBounds.x, this.caretBounds.y, blkWidth, this.caretBounds.height - 1);
                }
            }
        }
    }

    void dispatchUpdate(final boolean scrollViewToCaret) {
        Utilities.runInEventDispatchThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                BaseDocument doc;
                JTextComponent c = BaseCaret.this.component;
                if (c != null && (doc = Utilities.getDocument(c)) != null) {
                    doc.readLock();
                    try {
                        BaseCaret.this.update(scrollViewToCaret);
                    }
                    finally {
                        doc.readUnlock();
                    }
                }
            }
        });
    }

    protected void update(boolean scrollViewToCaret) {
        JTextComponent c = this.component;
        if (c != null) {
            BaseTextUI ui = (BaseTextUI)c.getUI();
            EditorUI editorUI = ui.getEditorUI();
            BaseDocument doc = Utilities.getDocument(c);
            if (doc != null) {
                Rectangle oldCaretBounds = this.caretBounds;
                if (oldCaretBounds != null) {
                    if (this.italic) {
                        oldCaretBounds.width += oldCaretBounds.height;
                    }
                    c.repaint(oldCaretBounds);
                }
                int dot = this.getDot();
                if (this.updateCaretBounds() && scrollViewToCaret) {
                    JScrollBar hScrollBar;
                    Container scrollPane;
                    Container viewport;
                    Rectangle scrollBounds = new Rectangle(this.caretBounds);
                    if (oldCaretBounds == null && (viewport = c.getParent()) instanceof JViewport && (scrollPane = viewport.getParent()) instanceof JScrollPane && (hScrollBar = ((JScrollPane)scrollPane).getHorizontalScrollBar()) != null) {
                        int hScrollBarHeight = hScrollBar.getPreferredSize().height;
                        Dimension extentSize = ((JViewport)viewport).getExtentSize();
                        if (extentSize.height >= this.caretBounds.height + hScrollBarHeight) {
                            scrollBounds.height += hScrollBarHeight;
                        }
                    }
                    Rectangle visibleBounds = c.getVisibleRect();
                    if (this.caretBounds.y > visibleBounds.y + visibleBounds.height + this.caretBounds.height || this.caretBounds.y + this.caretBounds.height < visibleBounds.y - this.caretBounds.height) {
                        scrollBounds.y -= (visibleBounds.height - this.caretBounds.height) / 2;
                        scrollBounds.height = visibleBounds.height;
                    }
                    c.scrollRectToVisible(scrollBounds);
                    this.resetBlink();
                    c.repaint(this.caretBounds);
                }
            }
        }
    }

    private void updateSystemSelection() {
        Clipboard clip;
        if (this.getDot() != this.getMark() && this.component != null && (clip = this.getSystemSelection()) != null) {
            clip.setContents(new StringSelection(this.component.getSelectedText()), null);
        }
    }

    private Clipboard getSystemSelection() {
        return this.component.getToolkit().getSystemSelection();
    }

    private void updateJumpList() {
        JumpList.dotMoved(this.component, this.getDot());
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    protected void fireStateChanged() {
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                Object[] listeners = BaseCaret.this.listenerList.getListenerList();
                for (int i = listeners.length - 2; i >= 0; i -= 2) {
                    if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? BaseCaret.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
                    if (BaseCaret.this.changeEvent == null) {
                        BaseCaret.this.changeEvent = new ChangeEvent(BaseCaret.this);
                    }
                    ((ChangeListener)listeners[i + 1]).stateChanged(BaseCaret.this.changeEvent);
                }
            }
        });
        this.updateSystemSelection();
        this.updateJumpList();
    }

    public final boolean isVisible() {
        return this.caretVisible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setVisibleImpl(boolean v) {
        boolean visible = this.isVisible();
        BaseCaret baseCaret = this;
        synchronized (baseCaret) {
            ListenerImpl listenerImpl = this.listenerImpl;
            synchronized (listenerImpl) {
                if (this.flasher != null) {
                    if (visible) {
                        this.flasher.stop();
                    }
                    if (v) {
                        if (debugCaretFocusExtra) {
                            System.err.println("starting the caret blinking timer: visible=" + visible + ", blinkVisible=" + this.blinkVisible);
                        }
                        this.flasher.start();
                    } else {
                        if (debugCaretFocusExtra) {
                            System.err.println("stopping the caret blinking timer");
                        }
                        this.flasher.stop();
                    }
                }
            }
            this.caretVisible = v;
        }
        JTextComponent c = this.component;
        if (c != null && this.caretBounds != null) {
            Rectangle repaintRect = this.caretBounds;
            if (this.italic) {
                repaintRect = new Rectangle(repaintRect);
                repaintRect.width += repaintRect.height;
            }
            c.repaint(repaintRect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void resetBlink() {
        boolean visible = this.isVisible();
        ListenerImpl listenerImpl = this.listenerImpl;
        synchronized (listenerImpl) {
            if (this.flasher != null) {
                this.flasher.stop();
                this.blinkVisible = true;
                if (visible) {
                    if (debugCaretFocusExtra) {
                        System.err.println("Reset blinking (caret already visible) - starting the caret blinking timer: visible=" + visible + ", blinkVisible=" + this.blinkVisible);
                    }
                    this.flasher.start();
                } else if (debugCaretFocusExtra) {
                    System.err.println("Reset blinking (caret not visible) - caret blinking timer not started: visible=" + visible + ", blinkVisible=" + this.blinkVisible);
                }
            }
        }
    }

    public void setVisible(final boolean v) {
        Utilities.runInEventDispatchThread(new Runnable(){

            public void run() {
                BaseCaret.this.setVisibleImpl(v);
            }
        });
    }

    public final boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    public void setSelectionVisible(boolean v) {
        if (this.selectionVisible == v) {
            return;
        }
        JTextComponent c = this.component;
        if (c != null) {
            this.selectionVisible = v;
            if (this.selectionVisible) {
                boolean selMarkFirst;
                int caretPos = this.getDot();
                int selPos = this.getMark();
                this.selectionMark.activateLayer = selMarkFirst = selPos < caretPos;
                this.caretMark.activateLayer = !selMarkFirst && selPos != caretPos;
            } else {
                this.caretMark.activateLayer = false;
                this.selectionMark.activateLayer = false;
            }
            BaseTextUI ui = (BaseTextUI)c.getUI();
            try {
                ui.getEditorUI().repaintBlock(this.caretMark.getOffset(), this.selectionMark.getOffset());
            }
            catch (BadLocationException e) {
                Utilities.annotateLoggable(e);
            }
            catch (InvalidMarkException e) {
                Utilities.annotateLoggable(e);
            }
        }
    }

    public void setMagicCaretPosition(Point p) {
        this.magicCaretPosition = p;
    }

    public final Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBlinkRate(int rate) {
        ListenerImpl listenerImpl = this.listenerImpl;
        synchronized (listenerImpl) {
            if (this.flasher == null && rate > 0) {
                this.flasher = new Timer(rate, new WeakTimerListener(this));
            }
            if (this.flasher != null) {
                if (rate > 0) {
                    if (this.flasher.getDelay() != rate) {
                        if (debugCaretFocusExtra) {
                            System.err.println("blink rate:" + rate);
                        }
                        this.flasher.setDelay(rate);
                    }
                } else {
                    if (debugCaretFocusExtra) {
                        System.err.println("zero rate - don't blink");
                        System.err.println("setting blinkVisible to true and disabling timer");
                    }
                    this.flasher.stop();
                    this.flasher.removeActionListener(this);
                    this.flasher = null;
                    this.blinkVisible = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getBlinkRate() {
        ListenerImpl listenerImpl = this.listenerImpl;
        synchronized (listenerImpl) {
            return this.flasher != null ? this.flasher.getDelay() : 0;
        }
    }

    public int getDot() {
        if (this.component != null) {
            try {
                return this.caretMark.getOffset();
            }
            catch (InvalidMarkException invalidMarkException) {
                // empty catch block
            }
        }
        return 0;
    }

    public int getMark() {
        if (this.component != null) {
            if (this.selectionVisible) {
                try {
                    return this.selectionMark.getOffset();
                }
                catch (InvalidMarkException invalidMarkException) {
                }
            } else {
                return this.getDot();
            }
        }
        return 0;
    }

    public void setDot(int offset) {
        this.setDot(offset, this.caretBounds, 0);
    }

    public void setDot(int offset, boolean expandFold) {
        this.setDot(offset, this.caretBounds, 0, expandFold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDot(int offset, Rectangle scrollRect, int scrollPolicy, boolean expandFold) {
        this.afterFirstSetDot = true;
        JTextComponent c = this.component;
        if (c != null) {
            boolean dotChanged;
            block12: {
                this.setSelectionVisible(false);
                BaseDocument doc = (BaseDocument)c.getDocument();
                dotChanged = false;
                doc.readLock();
                try {
                    if (doc == null || offset < 0 || offset > doc.getLength()) break block12;
                    dotChanged = true;
                    try {
                        Utilities.moveMark(doc, this.caretMark, offset);
                        FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)c);
                        hierarchy.lock();
                        try {
                            Fold collapsed = null;
                            while (expandFold && (collapsed = FoldUtilities.findCollapsedFold((FoldHierarchy)hierarchy, (int)offset, (int)offset)) != null && collapsed.getStartOffset() < offset && collapsed.getEndOffset() > offset) {
                                hierarchy.expand(collapsed);
                            }
                        }
                        finally {
                            hierarchy.unlock();
                        }
                    }
                    catch (BadLocationException e) {
                        throw new IllegalStateException(e.toString());
                    }
                    catch (InvalidMarkException e) {
                        throw new IllegalStateException(e.toString());
                    }
                }
                finally {
                    doc.readUnlock();
                }
            }
            if (dotChanged) {
                this.fireStateChanged();
                this.dispatchUpdate(true);
            }
        }
    }

    public void setDot(int offset, Rectangle scrollRect, int scrollPolicy) {
        this.setDot(offset, scrollRect, scrollPolicy, true);
    }

    public void moveDot(int offset) {
        this.moveDot(offset, this.caretBounds, 1);
    }

    public void moveDot(int offset, Rectangle scrollRect, int scrollPolicy) {
        JTextComponent c = this.component;
        if (c != null) {
            BaseDocument doc = (BaseDocument)c.getDocument();
            if (doc != null && offset >= 0 && offset <= doc.getLength()) {
                try {
                    int selPos;
                    int oldCaretPos = this.getDot();
                    if (offset == oldCaretPos) {
                        return;
                    }
                    if (this.selectionVisible) {
                        selPos = this.selectionMark.getOffset();
                    } else {
                        Utilities.moveMark(doc, this.selectionMark, oldCaretPos);
                        selPos = oldCaretPos;
                    }
                    Utilities.moveMark(doc, this.caretMark, offset);
                    if (this.selectionVisible) {
                        boolean selMarkFirst;
                        this.selectionMark.activateLayer = selMarkFirst = selPos < offset;
                        this.caretMark.activateLayer = !selMarkFirst && selPos != offset;
                        Utilities.getEditorUI(c).repaintBlock(oldCaretPos, offset);
                        if (selPos == offset) {
                            this.setSelectionVisible(false);
                        }
                    } else {
                        this.setSelectionVisible(true);
                    }
                }
                catch (BadLocationException e) {
                    throw new IllegalStateException(e.toString());
                }
                catch (InvalidMarkException e) {
                    throw new IllegalStateException(e.toString());
                }
            }
            this.fireStateChanged();
            this.dispatchUpdate(true);
        }
    }

    public void insertUpdate(DocumentEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            BaseDocument doc = (BaseDocument)this.component.getDocument();
            BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
            this.undoOffset = (bevt.isInUndo() || bevt.isInRedo()) && this.component == Utilities.getLastActiveComponent() ? evt.getOffset() + evt.getLength() : -1;
            this.modified = true;
            this.modifiedUpdate();
        }
    }

    public void removeUpdate(DocumentEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            BaseDocumentEvent bevt;
            BaseDocument doc = (BaseDocument)c.getDocument();
            if (this.selectionVisible && this.getDot() == this.getMark()) {
                this.setSelectionVisible(false);
            }
            this.undoOffset = ((bevt = (BaseDocumentEvent)evt).isInUndo() || bevt.isInRedo()) && c == Utilities.getLastActiveComponent() ? evt.getOffset() : -1;
            this.modified = true;
            this.modifiedUpdate();
        }
    }

    private void modifiedUpdate() {
        if (!this.inAtomicLock) {
            JTextComponent c = this.component;
            if (this.modified && c != null) {
                if (this.undoOffset >= 0) {
                    this.setDot(this.undoOffset);
                } else {
                    this.fireStateChanged();
                    this.dispatchUpdate(c.hasFocus());
                }
                this.modified = false;
            }
        }
    }

    public void atomicLock(AtomicLockEvent evt) {
        this.inAtomicLock = true;
    }

    public void atomicUnlock(AtomicLockEvent evt) {
        this.inAtomicLock = false;
        this.modifiedUpdate();
    }

    public void changedUpdate(DocumentEvent evt) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mouseClicked(MouseEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            if (SwingUtilities.isLeftMouseButton(evt)) {
                if (evt.getClickCount() == 2) {
                    BaseTextUI ui = (BaseTextUI)c.getUI();
                    int offset = ui.viewToModel(c, evt.getX(), evt.getY());
                    FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)c);
                    Document doc = c.getDocument();
                    if (doc instanceof AbstractDocument) {
                        AbstractDocument adoc = (AbstractDocument)doc;
                        adoc.readLock();
                        try {
                            hierarchy.lock();
                            try {
                                Fold collapsed = FoldUtilities.findCollapsedFold((FoldHierarchy)hierarchy, (int)offset, (int)offset);
                                if (collapsed != null && collapsed.getStartOffset() <= offset && collapsed.getEndOffset() >= offset) {
                                    hierarchy.expand(collapsed);
                                }
                                if (this.selectWordAction == null) {
                                    this.selectWordAction = ((BaseKit)ui.getEditorKit(c)).getActionByName("select-word");
                                }
                                this.selectWordAction.actionPerformed(null);
                            }
                            finally {
                                hierarchy.unlock();
                            }
                        }
                        finally {
                            adoc.readUnlock();
                        }
                    }
                } else if (evt.getClickCount() == 3) {
                    if (this.selectLineAction == null) {
                        BaseTextUI ui = (BaseTextUI)c.getUI();
                        this.selectLineAction = ((BaseKit)ui.getEditorKit(c)).getActionByName("select-line");
                    }
                    this.selectLineAction.actionPerformed(null);
                }
            } else if (SwingUtilities.isMiddleMouseButton(evt) && evt.getClickCount() == 1) {
                if (c == null) {
                    return;
                }
                Toolkit tk = c.getToolkit();
                Clipboard buffer = this.getSystemSelection();
                if (buffer == null) {
                    return;
                }
                Transferable trans = buffer.getContents(null);
                if (trans == null) {
                    return;
                }
                BaseDocument doc = (BaseDocument)c.getDocument();
                if (doc == null) {
                    return;
                }
                int offset = ((BaseTextUI)c.getUI()).viewToModel(c, evt.getX(), evt.getY());
                try {
                    String pastingString = (String)trans.getTransferData(DataFlavor.stringFlavor);
                    if (pastingString == null) {
                        return;
                    }
                    try {
                        doc.atomicLock();
                        try {
                            doc.insertString(offset, pastingString, null);
                            this.setDot(offset + pastingString.length());
                        }
                        finally {
                            doc.atomicUnlock();
                        }
                    }
                    catch (BadLocationException exc) {}
                }
                catch (UnsupportedFlavorException ufe) {
                }
                catch (IOException ioe) {
                    // empty catch block
                }
            }
        }
    }

    private void mousePressedImpl(MouseEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            Utilities.getEditorUI(c).getWordMatch().clear();
            if (SwingUtilities.isLeftMouseButton(evt) && !evt.isPopupTrigger() && (evt.getModifiers() & 0xC) == 0 || !this.isSelectionVisible()) {
                int offset = ((BaseTextUI)c.getUI()).viewToModel(c, evt.getX(), evt.getY());
                if (offset >= 0) {
                    if ((evt.getModifiers() & 1) != 0) {
                        this.moveDot(offset);
                    } else {
                        this.setDot(offset);
                    }
                    this.setMagicCaretPosition(null);
                }
                if (c.isEnabled()) {
                    c.requestFocus();
                }
            }
        }
    }

    public void mousePressed(MouseEvent evt) {
        this.dndArmedEvent = null;
        if (this.isDragPossible(evt) && this.mapDragOperationFromModifiers(evt) != 0) {
            this.dndArmedEvent = evt;
            evt.consume();
            return;
        }
        this.mousePressedImpl(evt);
    }

    public void mouseReleased(MouseEvent evt) {
        if (this.dndArmedEvent != null) {
            this.mousePressedImpl(evt);
        }
        this.dndArmedEvent = null;
    }

    public void mouseEntered(MouseEvent evt) {
    }

    public void mouseExited(MouseEvent evt) {
    }

    protected int mapDragOperationFromModifiers(MouseEvent e) {
        int mods = e.getModifiersEx();
        if ((mods & 0x400) != 1024) {
            return 0;
        }
        return 3;
    }

    protected boolean isDragPossible(MouseEvent e) {
        int mark;
        Caret caret;
        int dot;
        JTextComponent c;
        boolean possible;
        JComponent comp = this.getEventComponent(e);
        boolean bl = comp == null ? true : (possible = comp.getTransferHandler() != null);
        if (possible && (c = (JTextComponent)this.getEventComponent(e)).getDragEnabled() && (dot = (caret = c.getCaret()).getDot()) != (mark = caret.getMark())) {
            Point p = new Point(e.getX(), e.getY());
            int pos = c.viewToModel(p);
            int p0 = Math.min(dot, mark);
            int p1 = Math.max(dot, mark);
            if (pos >= p0 && pos < p1) {
                return true;
            }
        }
        return false;
    }

    protected JComponent getEventComponent(MouseEvent e) {
        Object src = e.getSource();
        if (src instanceof JComponent) {
            JComponent c = (JComponent)src;
            return c;
        }
        return null;
    }

    public void mouseDragged(MouseEvent evt) {
        if (this.dndArmedEvent != null) {
            evt.consume();
            return;
        }
        JTextComponent c = this.component;
        if (SwingUtilities.isLeftMouseButton(evt) && c != null) {
            int offset = ((BaseTextUI)c.getUI()).viewToModel(c, evt.getX(), evt.getY());
            if (offset == -1) {
                offset = 0;
            }
            if (offset >= 0 && (evt.getModifiers() & 1) == 0) {
                this.moveDot(offset);
            }
        }
    }

    public void mouseMoved(MouseEvent evt) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        JScrollPane scrollPane;
        JScrollBar hScrollBar;
        Container parent;
        String propName = evt.getPropertyName();
        if ("document".equals(propName)) {
            BaseDocument newDoc = evt.getNewValue() instanceof BaseDocument ? (BaseDocument)evt.getNewValue() : null;
            this.modelChanged(this.listenDoc, newDoc);
        } else if ("overwriteMode".equals(propName)) {
            Boolean b = (Boolean)evt.getNewValue();
            this.overwriteMode = b != null ? b : false;
            this.updateType();
        } else if ("ancestor".equals(propName) && evt.getSource() == this.component && (parent = this.component.getParent()) instanceof JViewport && (parent = parent.getParent()) instanceof JScrollPane && (hScrollBar = (scrollPane = (JScrollPane)parent).getHorizontalScrollBar()) != null) {
            hScrollBar.addComponentListener((ComponentListener)WeakListeners.create((Class)ComponentListener.class, (EventListener)this.listenerImpl, (Object)hScrollBar));
        }
    }

    public void actionPerformed(ActionEvent evt) {
        JTextComponent c = this.component;
        if (c != null) {
            boolean bl = this.blinkVisible = !this.blinkVisible;
            if (this.caretBounds != null) {
                Rectangle repaintRect = this.caretBounds;
                if (this.italic) {
                    repaintRect = new Rectangle(repaintRect);
                    repaintRect.width += repaintRect.height;
                }
                c.repaint(repaintRect);
            }
        }
    }

    public void foldHierarchyChanged(FoldHierarchyEvent evt) {
        int caretOffset = this.getDot();
        int addedFoldCnt = evt.getAddedFoldCount();
        if (addedFoldCnt > 0) {
            FoldHierarchy hierarchy = (FoldHierarchy)evt.getSource();
            Fold collapsed = null;
            while ((collapsed = FoldUtilities.findCollapsedFold((FoldHierarchy)hierarchy, (int)caretOffset, (int)caretOffset)) != null && collapsed.getStartOffset() < caretOffset && collapsed.getEndOffset() > caretOffset) {
                hierarchy.expand(collapsed);
            }
            for (int i = 0; i < addedFoldCnt; ++i) {
                if (!evt.getAddedFold(i).isCollapsed()) continue;
                if (this.afterFirstSetDot) {
                    this.dispatchUpdate(false);
                }
                return;
            }
        } else {
            int endOffset = -1;
            if (evt.getAffectedStartOffset() <= caretOffset && evt.getAffectedEndOffset() >= caretOffset) {
                for (int i = 0; i < evt.getFoldStateChangeCount(); ++i) {
                    Fold fold;
                    FoldStateChange change = evt.getFoldStateChange(i);
                    if (!change.isCollapsedChanged() || !(fold = change.getFold()).isCollapsed() || fold.getStartOffset() > caretOffset || fold.getEndOffset() < caretOffset || fold.getEndOffset() <= endOffset) continue;
                    endOffset = fold.getEndOffset();
                }
                if (endOffset > -1) {
                    this.setDot(endOffset, false);
                }
            }
            this.dispatchUpdate(false);
        }
    }

    static {
        $assertionsDisabled = !BaseCaret.class.desiredAssertionStatus();
        debugCaretFocus = Boolean.getBoolean("netbeans.debug.editor.caret.focus");
        debugCaretFocusExtra = Boolean.getBoolean("netbeans.debug.editor.caret.focus.extra");
    }

    private class ListenerImpl
    extends ComponentAdapter
    implements FocusListener {
        ListenerImpl() {
        }

        public void focusGained(FocusEvent evt) {
            JTextComponent c;
            if (debugCaretFocus || debugCaretFocusExtra) {
                System.err.println((debugCaretFocusExtra ? "\n" : "") + "BaseCaret.focusGained(); doc=" + BaseCaret.this.component.getDocument().getProperty("title"));
            }
            if ((c = BaseCaret.this.component) != null) {
                BaseCaret.this.updateType();
                if (debugCaretFocusExtra) {
                    System.err.println("going to set caret visible to: " + c.isEnabled());
                }
                BaseCaret.this.setVisible(c.isEnabled());
            } else if (debugCaretFocusExtra) {
                System.err.println("component is null, caret will not be dislayed");
            }
        }

        public void focusLost(FocusEvent evt) {
            if (debugCaretFocus || debugCaretFocusExtra) {
                System.err.println((debugCaretFocusExtra ? "\n" : "") + "BaseCaret.focusLost(); doc=" + BaseCaret.this.component.getDocument().getProperty("title") + "\nFOCUS GAINER: " + evt.getOppositeComponent());
                if (debugCaretFocusExtra) {
                    System.err.println("FOCUS EVENT: " + evt);
                }
            }
            BaseCaret.this.setVisible(false);
        }

        public void componentShown(ComponentEvent e) {
            Component hScrollBar = e.getComponent();
            if (hScrollBar != BaseCaret.this.component) {
                Container scrollPane = hScrollBar.getParent();
                if (BaseCaret.this.caretBounds != null && scrollPane instanceof JScrollPane) {
                    Rectangle viewRect = ((JScrollPane)scrollPane).getViewport().getViewRect();
                    Rectangle hScrollBarRect = new Rectangle(viewRect.x, viewRect.y + viewRect.height, hScrollBar.getWidth(), hScrollBar.getHeight());
                    if (hScrollBarRect.intersects(BaseCaret.this.caretBounds)) {
                        BaseCaret.this.dispatchUpdate(true);
                    }
                }
            }
        }

        public void componentResized(ComponentEvent e) {
            Component c = e.getComponent();
            if (c == BaseCaret.this.component && BaseCaret.this.caretBounds == null) {
                BaseCaret.this.dispatchUpdate(true);
                if (BaseCaret.this.caretBounds != null) {
                    c.removeComponentListener(this);
                }
            }
        }
    }
}

