/*
 * DO NOT EDIT.  THIS FILE IS GENERATED FROM nsIBrowserGlue.idl
 */

#ifndef __gen_nsIBrowserGlue_h__
#define __gen_nsIBrowserGlue_h__


#ifndef __gen_nsISupports_h__
#include "nsISupports.h"
#endif

/* For IDL files that don't want to include root IDL files. */
#ifndef NS_NO_VTABLE
#define NS_NO_VTABLE
#endif
class nsIDOMWindow; /* forward declaration */


/* starting interface:    nsIBrowserGlue */
#define NS_IBROWSERGLUE_IID_STR "6d340848-9bc1-49a3-9073-99932bbc2a11"

#define NS_IBROWSERGLUE_IID \
  {0x6d340848, 0x9bc1, 0x49a3, \
    { 0x90, 0x73, 0x99, 0x93, 0x2b, 0xbc, 0x2a, 0x11 }}

/**
 * nsIBrowserGlue is a dirty and rather fluid interface to host shared utility 
 * methods used by browser UI code, but which are not local to a browser window.
 * The component implementing this interface is meant to be a singleton
 * (service) and should progressively replace some of the shared "glue" code 
 * scattered in browser/base/content (e.g. bits of utilOverlay.js, 
 * contentAreaUtils.js, globalOverlay.js, browser.js), avoiding dynamic 
 * inclusion and initialization of a ton of JS code for *each* window.
 * Dued to its nature and origin, this interface won't probably be the most
 * elegant or stable in the mozilla codebase, but its aim is rather pragmatic:
 * 1) reducing the performance overhead which affects browser window load;
 * 2) allow global hooks (e.g. startup and shutdown observers) which survive
 * browser windows to accomplish browser-related activities, such as shutdown
 * sanitization (see bug #284086)
 *
 */
class NS_NO_VTABLE nsIBrowserGlue : public nsISupports {
 public: 

  NS_DEFINE_STATIC_IID_ACCESSOR(NS_IBROWSERGLUE_IID)

  /** 
   * Deletes privacy sensitive data according to user preferences
   *
   * @param aParentWindow an optionally null window which is the parent of the 
   *        sanitization dialog (if it has to be shown per user preferences)
   *
   */
  /* void sanitize (in nsIDOMWindow aParentWindow); */
  NS_IMETHOD Sanitize(nsIDOMWindow *aParentWindow) = 0;

};

/* Use this macro when declaring classes that implement this interface. */
#define NS_DECL_NSIBROWSERGLUE \
  NS_IMETHOD Sanitize(nsIDOMWindow *aParentWindow); 

/* Use this macro to declare functions that forward the behavior of this interface to another object. */
#define NS_FORWARD_NSIBROWSERGLUE(_to) \
  NS_IMETHOD Sanitize(nsIDOMWindow *aParentWindow) { return _to Sanitize(aParentWindow); } 

/* Use this macro to declare functions that forward the behavior of this interface to another object in a safe way. */
#define NS_FORWARD_SAFE_NSIBROWSERGLUE(_to) \
  NS_IMETHOD Sanitize(nsIDOMWindow *aParentWindow) { return !_to ? NS_ERROR_NULL_POINTER : _to->Sanitize(aParentWindow); } 

#if 0
/* Use the code below as a template for the implementation class for this interface. */

/* Header file */
class nsBrowserGlue : public nsIBrowserGlue
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_NSIBROWSERGLUE

  nsBrowserGlue();

private:
  ~nsBrowserGlue();

protected:
  /* additional members */
};

/* Implementation file */
NS_IMPL_ISUPPORTS1(nsBrowserGlue, nsIBrowserGlue)

nsBrowserGlue::nsBrowserGlue()
{
  /* member initializers and constructor code */
}

nsBrowserGlue::~nsBrowserGlue()
{
  /* destructor code */
}

/* void sanitize (in nsIDOMWindow aParentWindow); */
NS_IMETHODIMP nsBrowserGlue::Sanitize(nsIDOMWindow *aParentWindow)
{
    return NS_ERROR_NOT_IMPLEMENTED;
}

/* End of implementation class template. */
#endif


#endif /* __gen_nsIBrowserGlue_h__ */
