/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.ant;

import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ant.IvyTask;
import fr.jayasoft.ivy.parser.ModuleDescriptorParserRegistry;
import fr.jayasoft.ivy.util.Message;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileList;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;

public class IvyBuildList
extends IvyTask {
    private List _buildFiles = new ArrayList();
    private String _reference;
    private boolean _haltOnError = true;
    private boolean _skipBuildWithoutIvy = false;
    private boolean _reverse = false;
    private String _ivyFilePath;
    private String _root = "*";
    private boolean _excludeRoot = false;

    public void addFileset(FileSet buildFiles) {
        this._buildFiles.add(buildFiles);
    }

    public String getReference() {
        return this._reference;
    }

    public void setReference(String reference) {
        this._reference = reference;
    }

    public String getRoot() {
        return this._root;
    }

    public void setRoot(String root) {
        this._root = root;
    }

    public boolean isExcludeRoot() {
        return this._excludeRoot;
    }

    public void setExcludeRoot(boolean root) {
        this._excludeRoot = root;
    }

    public void execute() throws BuildException {
        if (this._reference == null) {
            throw new BuildException("reference should be provided in ivy build list");
        }
        if (this._buildFiles.isEmpty()) {
            throw new BuildException("at least one nested fileset should be provided in ivy build list");
        }
        Ivy ivy = this.getIvyInstance();
        this._ivyFilePath = this.getProperty(this._ivyFilePath, ivy, "ivy.buildlist.ivyfilepath");
        Path path = new Path(this.getProject());
        HashMap<ModuleDescriptor, File> buildFiles = new HashMap<ModuleDescriptor, File>();
        Collection<ModuleDescriptor> mds = new ArrayList();
        ArrayList<File> independent = new ArrayList<File>();
        ModuleDescriptor rootModuleDescriptor = null;
        ListIterator iter = this._buildFiles.listIterator();
        while (iter.hasNext()) {
            FileSet fs = (FileSet)iter.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] builds = ds.getIncludedFiles();
            for (int i = 0; i < builds.length; ++i) {
                File buildFile = new File(ds.getBasedir(), builds[i]);
                File ivyFile = this.getIvyFileFor(buildFile);
                if (!ivyFile.exists()) {
                    if (this._skipBuildWithoutIvy) {
                        Message.debug("skipping " + buildFile + ": ivy file " + ivyFile + " doesn't exist");
                        continue;
                    }
                    Message.verbose("no ivy file for " + buildFile + ": ivyfile=" + ivyFile + ": adding it at the beginning of the path");
                    Message.verbose("\t(set skipbuildwithoutivy to true if you don't want this file to be added to the path)");
                    independent.add(buildFile);
                    continue;
                }
                try {
                    ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(ivy, ivyFile.toURL(), this.doValidate(ivy));
                    buildFiles.put(md, buildFile);
                    mds.add(md);
                    if (!this._root.equals(md.getModuleRevisionId().getName())) continue;
                    rootModuleDescriptor = md;
                    continue;
                }
                catch (Exception ex) {
                    if (this._haltOnError) {
                        throw new BuildException("impossible to parse ivy file for " + buildFile + ": ivyfile=" + ivyFile + " exception=" + ex, (Throwable)ex);
                    }
                    Message.warn("impossible to parse ivy file for " + buildFile + ": ivyfile=" + ivyFile + " exception=" + ex.getMessage());
                    Message.info("\t=> adding it at the beginning of the path");
                    independent.add(buildFile);
                }
            }
        }
        if (!"*".equals(this._root) && rootModuleDescriptor == null) {
            throw new BuildException("unable to find root module " + this._root + " in build fileset");
        }
        if (rootModuleDescriptor != null) {
            Message.info("Filtering modules based on root " + rootModuleDescriptor.getModuleRevisionId().getName());
            mds = this.filterModules(mds, rootModuleDescriptor);
        }
        List sortedModules = ivy.sortModuleDescriptors(mds);
        ListIterator iter2 = independent.listIterator();
        while (iter2.hasNext()) {
            File buildFile = (File)iter2.next();
            this.addBuildFile(path, buildFile);
        }
        if (this.isReverse()) {
            Collections.reverse(sortedModules);
        }
        StringBuffer order = new StringBuffer();
        ListIterator iter3 = sortedModules.listIterator();
        while (iter3.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)iter3.next();
            order.append(md.getModuleRevisionId().getModuleId());
            if (iter3.hasNext()) {
                order.append(", ");
            }
            File buildFile = (File)buildFiles.get(md);
            this.addBuildFile(path, buildFile);
        }
        this.getProject().addReference(this.getReference(), (Object)path);
        this.getProject().setProperty("ivy.sorted.modules", order.toString());
    }

    private Collection filterModules(Collection mds, ModuleDescriptor rootmd) {
        HashMap<ModuleId, ModuleDescriptor> moduleIdMap = new HashMap<ModuleId, ModuleDescriptor>();
        Iterator iter = mds.iterator();
        while (iter.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)iter.next();
            moduleIdMap.put(md.getModuleRevisionId().getModuleId(), md);
        }
        HashSet toKeep = new HashSet();
        this.processFilterNode(rootmd, toKeep, moduleIdMap);
        if (this._excludeRoot) {
            Message.verbose("Excluded module " + rootmd.getModuleRevisionId().getModuleId().getName());
            toKeep.remove(rootmd);
        }
        Iterator iter2 = toKeep.iterator();
        while (iter2.hasNext()) {
            ModuleDescriptor md = (ModuleDescriptor)iter2.next();
            Message.verbose("Kept module " + md.getModuleRevisionId().getModuleId().getName());
        }
        return toKeep;
    }

    private void processFilterNode(ModuleDescriptor node, Set toKeep, Map moduleIdMap) {
        toKeep.add(node);
        DependencyDescriptor[] deps = node.getDependencies();
        for (int i = 0; i < deps.length; ++i) {
            ModuleId id = deps[i].getDependencyId();
            if (moduleIdMap.get(id) == null) continue;
            this.processFilterNode((ModuleDescriptor)moduleIdMap.get(id), toKeep, moduleIdMap);
        }
    }

    private void addBuildFile(Path path, File buildFile) {
        FileList fl = new FileList();
        fl.setDir(buildFile.getParentFile());
        FileList.FileName fileName = new FileList.FileName();
        fileName.setName(buildFile.getName());
        fl.addConfiguredFile(fileName);
        path.addFilelist(fl);
    }

    private File getIvyFileFor(File buildFile) {
        return new File(buildFile.getParentFile(), this._ivyFilePath);
    }

    public boolean isHaltonerror() {
        return this._haltOnError;
    }

    public void setHaltonerror(boolean haltOnError) {
        this._haltOnError = haltOnError;
    }

    public String getIvyfilepath() {
        return this._ivyFilePath;
    }

    public void setIvyfilepath(String ivyFilePath) {
        this._ivyFilePath = ivyFilePath;
    }

    public boolean isSkipbuildwithoutivy() {
        return this._skipBuildWithoutIvy;
    }

    public void setSkipbuildwithoutivy(boolean skipBuildFilesWithoutIvy) {
        this._skipBuildWithoutIvy = skipBuildFilesWithoutIvy;
    }

    public boolean isReverse() {
        return this._reverse;
    }

    public void setReverse(boolean reverse) {
        this._reverse = reverse;
    }
}

