/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.ArtifactOrigin;
import fr.jayasoft.ivy.Configuration;
import fr.jayasoft.ivy.ConflictManager;
import fr.jayasoft.ivy.DefaultArtifact;
import fr.jayasoft.ivy.DefaultDependencyDescriptor;
import fr.jayasoft.ivy.DefaultModuleDescriptor;
import fr.jayasoft.ivy.DefaultModuleRevision;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.DependencyResolver;
import fr.jayasoft.ivy.IvyAware;
import fr.jayasoft.ivy.IvyContext;
import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.LatestStrategy;
import fr.jayasoft.ivy.MDArtifact;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleDescriptorSorter;
import fr.jayasoft.ivy.ModuleId;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.PublishingDependencyRevisionResolver;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.ResolvedModuleRevision;
import fr.jayasoft.ivy.circular.CircularDependencyStrategy;
import fr.jayasoft.ivy.circular.ErrorCircularDependencyStrategy;
import fr.jayasoft.ivy.circular.IgnoreCircularDependencyStrategy;
import fr.jayasoft.ivy.circular.WarnCircularDependencyStrategy;
import fr.jayasoft.ivy.conflict.LatestConflictManager;
import fr.jayasoft.ivy.conflict.NoConflictManager;
import fr.jayasoft.ivy.conflict.StrictConflictManager;
import fr.jayasoft.ivy.event.FilteredIvyListener;
import fr.jayasoft.ivy.event.IvyEvent;
import fr.jayasoft.ivy.event.IvyEventFilter;
import fr.jayasoft.ivy.event.IvyListener;
import fr.jayasoft.ivy.event.Trigger;
import fr.jayasoft.ivy.event.download.PrepareDownloadEvent;
import fr.jayasoft.ivy.event.resolve.EndResolveEvent;
import fr.jayasoft.ivy.event.resolve.StartResolveEvent;
import fr.jayasoft.ivy.filter.Filter;
import fr.jayasoft.ivy.filter.FilterHelper;
import fr.jayasoft.ivy.latest.LatestLexicographicStrategy;
import fr.jayasoft.ivy.latest.LatestRevisionStrategy;
import fr.jayasoft.ivy.latest.LatestTimeStrategy;
import fr.jayasoft.ivy.matcher.ExactOrRegexpPatternMatcher;
import fr.jayasoft.ivy.matcher.ExactPatternMatcher;
import fr.jayasoft.ivy.matcher.GlobPatternMatcher;
import fr.jayasoft.ivy.matcher.Matcher;
import fr.jayasoft.ivy.matcher.MatcherHelper;
import fr.jayasoft.ivy.matcher.ModuleIdMatcher;
import fr.jayasoft.ivy.matcher.PatternMatcher;
import fr.jayasoft.ivy.matcher.RegexpPatternMatcher;
import fr.jayasoft.ivy.namespace.NameSpaceHelper;
import fr.jayasoft.ivy.namespace.Namespace;
import fr.jayasoft.ivy.parser.ModuleDescriptorParser;
import fr.jayasoft.ivy.parser.ModuleDescriptorParserRegistry;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.ConfigurationResolveReport;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.report.DownloadStatus;
import fr.jayasoft.ivy.report.LogReportOutputter;
import fr.jayasoft.ivy.report.ReportOutputter;
import fr.jayasoft.ivy.report.ResolveReport;
import fr.jayasoft.ivy.report.XmlReportOutputter;
import fr.jayasoft.ivy.repository.TransferEvent;
import fr.jayasoft.ivy.repository.TransferListener;
import fr.jayasoft.ivy.repository.url.URLResource;
import fr.jayasoft.ivy.resolver.AbstractResolver;
import fr.jayasoft.ivy.resolver.CacheResolver;
import fr.jayasoft.ivy.resolver.ChainResolver;
import fr.jayasoft.ivy.resolver.DualResolver;
import fr.jayasoft.ivy.resolver.ModuleEntry;
import fr.jayasoft.ivy.resolver.OrganisationEntry;
import fr.jayasoft.ivy.resolver.RevisionEntry;
import fr.jayasoft.ivy.status.StatusManager;
import fr.jayasoft.ivy.url.URLHandlerRegistry;
import fr.jayasoft.ivy.util.FileUtil;
import fr.jayasoft.ivy.util.IvyPatternHelper;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.PropertiesFile;
import fr.jayasoft.ivy.version.ChainVersionMatcher;
import fr.jayasoft.ivy.version.ExactVersionMatcher;
import fr.jayasoft.ivy.version.LatestVersionMatcher;
import fr.jayasoft.ivy.version.SubVersionMatcher;
import fr.jayasoft.ivy.version.VersionMatcher;
import fr.jayasoft.ivy.version.VersionRangeMatcher;
import fr.jayasoft.ivy.xml.XmlIvyConfigurationParser;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorParser;
import fr.jayasoft.ivy.xml.XmlModuleDescriptorUpdater;
import fr.jayasoft.ivy.xml.XmlReportParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.event.EventListenerList;
import org.xml.sax.SAXException;

public class Ivy
implements TransferListener {
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private static final String DEFAULT_CACHE_ARTIFACT_PATTERN = "[organisation]/[module]/[type]s/[artifact]-[revision](.[ext])";
    private static final String DEFAULT_CACHE_DATA_FILE_PATTERN = "[organisation]/[module]/ivydata-[revision].properties";
    private static final String DEFAULT_CACHE_IVY_PATTERN = "[organisation]/[module]/ivy-[revision].xml";
    private static final String DEFAULT_CACHE_RESOLVED_IVY_PATTERN = "resolved-[organisation]-[module]-[revision].xml";
    private static final String DEFAULT_CACHE_RESOLVED_IVY_PROPERTIES_PATTERN = "resolved-[organisation]-[module]-[revision].properties";
    private Map _typeDefs = new HashMap();
    private Map _resolversMap = new HashMap();
    private DependencyResolver _defaultResolver;
    private DependencyResolver _dictatorResolver = null;
    private String _defaultResolverName;
    private File _defaultCache;
    private String _defaultBranch = null;
    private boolean _checkUpToDate = true;
    private Map _moduleConfigurations = new LinkedHashMap();
    private Map _conflictsManager = new HashMap();
    private Map _latestStrategies = new HashMap();
    private Map _namespaces = new HashMap();
    private Map _matchers = new HashMap();
    private Map _reportOutputters = new HashMap();
    private Map _versionMatchers = new HashMap();
    private Map _circularDependencyStrategies = new HashMap();
    private Map _variables = new HashMap();
    private String _cacheIvyPattern = "[organisation]/[module]/ivy-[revision].xml";
    private String _cacheResolvedIvyPattern = "resolved-[organisation]-[module]-[revision].xml";
    private String _cacheResolvedIvyPropertiesPattern = "resolved-[organisation]-[module]-[revision].properties";
    private String _cacheArtifactPattern = "[organisation]/[module]/[type]s/[artifact]-[revision](.[ext])";
    private String _cacheDataFilePattern = "[organisation]/[module]/ivydata-[revision].properties";
    private boolean _validate = true;
    private LatestStrategy _defaultLatestStrategy = null;
    private ConflictManager _defaultConflictManager = null;
    private CircularDependencyStrategy _circularDependencyStrategy = null;
    private List _listingIgnore = new ArrayList();
    private boolean _repositoriesConfigured;
    private boolean _useRemoteConfig = false;
    private File _defaultUserDir;
    private Set _fetchedSet = new HashSet();
    private List _classpathURLs = new ArrayList();
    private ClassLoader _classloader;
    private StatusManager _statusManager;
    private long _interruptTimeout = 2000L;
    private boolean _interrupted;
    private EventListenerList _listeners = new EventListenerList();
    private boolean _logNotConvertedExclusionRule;
    private Boolean _debugConflictResolution;
    private VersionMatcher _versionMatcher;

    public static Ivy getCurrent() {
        Ivy cur = IvyContext.getContext().getIvy();
        if (cur == null) {
            cur = new Ivy();
            IvyContext.getContext().setIvy(cur);
        }
        return cur;
    }

    public Ivy() {
        this.setVariable("ivy.default.conf.dir", Ivy.class.getResource("conf").toExternalForm(), true);
        String ivyTypeDefs = System.getProperty("ivy.typedef.files");
        if (ivyTypeDefs != null) {
            String[] files = ivyTypeDefs.split("\\,");
            for (int i = 0; i < files.length; ++i) {
                try {
                    this.typeDefs(new FileInputStream(new File(files[i].trim())), true);
                    continue;
                }
                catch (FileNotFoundException e) {
                    Message.warn("typedefs file not found: " + files[i].trim());
                    continue;
                }
                catch (IOException e) {
                    Message.warn("problem with typedef file: " + files[i].trim() + ": " + e.getMessage());
                }
            }
        } else {
            try {
                this.typeDefs(Ivy.class.getResourceAsStream("typedef.properties"), true);
            }
            catch (IOException e) {
                Message.warn("impossible to load default type defs");
            }
        }
        LatestLexicographicStrategy latestLexicographicStrategy = new LatestLexicographicStrategy();
        LatestRevisionStrategy latestRevisionStrategy = new LatestRevisionStrategy();
        LatestTimeStrategy latestTimeStrategy = new LatestTimeStrategy();
        this.addLatestStrategy("latest-revision", latestRevisionStrategy);
        this.addLatestStrategy("latest-lexico", latestLexicographicStrategy);
        this.addLatestStrategy("latest-time", latestTimeStrategy);
        this.addConflictManager("latest-revision", new LatestConflictManager("latest-revision", latestRevisionStrategy));
        this.addConflictManager("latest-time", new LatestConflictManager("latest-time", latestTimeStrategy));
        this.addConflictManager("all", new NoConflictManager());
        this.addConflictManager("strict", new StrictConflictManager());
        this.addMatcher(ExactPatternMatcher.getInstance());
        this.addMatcher(RegexpPatternMatcher.getInstance());
        this.addMatcher(ExactOrRegexpPatternMatcher.getInstance());
        this.addMatcher(GlobPatternMatcher.getInstance());
        this.addReportOutputter(new XmlReportOutputter());
        this.addReportOutputter(new LogReportOutputter());
        this.configureDefaultCircularDependencyStrategies();
        this._listingIgnore.add(".cvsignore");
        this._listingIgnore.add("CVS");
        this._listingIgnore.add(".svn");
        this.addSystemProperties();
        this.addTransferListener(new TransferListener(){

            public void transferProgress(TransferEvent evt) {
                switch (evt.getEventType()) {
                    case 3: {
                        Message.progress();
                        break;
                    }
                    case 2: {
                        Message.endProgress(" (" + evt.getTotalLength() / 1024L + "kB)");
                        break;
                    }
                }
            }
        });
        IvyContext.getContext().setIvy(this);
    }

    private void addSystemProperties() {
        this.addAllVariables(System.getProperties());
    }

    public void configureRepositories(boolean remote) {
        IvyContext.getContext().setIvy(this);
        if (!this._repositoriesConfigured) {
            Properties props = new Properties();
            boolean configured = false;
            if (this._useRemoteConfig && remote) {
                try {
                    URL url = new URL("http://www.jayasoft.org/ivy/repository.properties");
                    Message.verbose("configuring repositories with " + url);
                    props.load(URLHandlerRegistry.getDefault().openStream(url));
                    configured = true;
                }
                catch (Exception ex) {
                    Message.verbose("unable to use remote repository configuration: " + ex.getMessage());
                    props = new Properties();
                }
            }
            if (!configured) {
                try {
                    props.load(Ivy.class.getResourceAsStream("repository.properties"));
                }
                catch (IOException e) {
                    Message.error("unable to use internal repository configuration: " + e.getMessage());
                }
            }
            this.addAllVariables(props, false);
            this._repositoriesConfigured = true;
        }
    }

    public void typeDefs(InputStream stream) throws IOException {
        this.typeDefs(stream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void typeDefs(InputStream stream, boolean silentFail) throws IOException {
        IvyContext.getContext().setIvy(this);
        try {
            Properties p = new Properties();
            p.load(stream);
            this.typeDefs(p, silentFail);
        }
        finally {
            stream.close();
        }
    }

    public void typeDefs(Properties p) {
        this.typeDefs(p, false);
    }

    public void typeDefs(Properties p, boolean silentFail) {
        IvyContext.getContext().setIvy(this);
        Iterator<Object> iter = p.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            this.typeDef(name, p.getProperty(name), silentFail);
        }
    }

    public void configure(File configurationFile) throws ParseException, IOException {
        IvyContext.getContext().setIvy(this);
        Message.info(":: configuring :: file = " + configurationFile);
        long start = System.currentTimeMillis();
        this.setConfigurationVariables(configurationFile);
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(new File(this.getVariable("ivy.default.ivy.user.dir")));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.getDefaultCache();
        this.loadDefaultProperties();
        try {
            new XmlIvyConfigurationParser(this).parse(configurationFile.toURL());
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException("given file cannot be transformed to url: " + configurationFile);
            iae.initCause(e);
            throw iae;
        }
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        Message.verbose("configuration done (" + (System.currentTimeMillis() - start) + "ms)");
        this.dumpConfig();
    }

    public void configure(URL configurationURL) throws ParseException, IOException {
        IvyContext.getContext().setIvy(this);
        Message.info(":: configuring :: url = " + configurationURL);
        long start = System.currentTimeMillis();
        this.setConfigurationVariables(configurationURL);
        if (this.getVariable("ivy.default.ivy.user.dir") != null) {
            this.setDefaultIvyUserDir(new File(this.getVariable("ivy.default.ivy.user.dir")));
        } else {
            this.getDefaultIvyUserDir();
        }
        this.getDefaultCache();
        this.loadDefaultProperties();
        new XmlIvyConfigurationParser(this).parse(configurationURL);
        this.setVariable("ivy.default.ivy.user.dir", this.getDefaultIvyUserDir().getAbsolutePath(), false);
        Message.verbose("configuration done (" + (System.currentTimeMillis() - start) + "ms)");
        this.dumpConfig();
    }

    private void loadDefaultProperties() throws IOException {
        this.loadProperties(Ivy.class.getResource("ivy.properties"), false);
    }

    public void configureDefault() throws ParseException, IOException {
        this.configure(Ivy.getDefaultConfigurationURL());
    }

    public void setConfigurationVariables(File configurationFile) {
        IvyContext.getContext().setIvy(this);
        try {
            this.setVariable("ivy.conf.dir", new File(configurationFile.getAbsolutePath()).getParent());
            this.setVariable("ivy.conf.file", configurationFile.getAbsolutePath());
            this.setVariable("ivy.conf.url", configurationFile.toURL().toExternalForm());
        }
        catch (MalformedURLException e) {
            IllegalArgumentException iae = new IllegalArgumentException("given file cannot be transformed to url: " + configurationFile);
            iae.initCause(e);
            throw iae;
        }
    }

    public void setConfigurationVariables(URL configurationURL) {
        IvyContext.getContext().setIvy(this);
        String confURL = configurationURL.toExternalForm();
        this.setVariable("ivy.conf.url", confURL);
        int slashIndex = confURL.lastIndexOf(47);
        if (slashIndex != -1) {
            this.setVariable("ivy.conf.dir", confURL.substring(0, slashIndex));
        } else {
            Message.warn("configuration url does not contain any slash (/): ivy.conf.dir variable not set");
        }
    }

    private void dumpConfig() {
        Iterator<Object> iter;
        Message.verbose("\tdefault cache: " + this.getDefaultCache());
        Message.verbose("\tdefault resolver: " + this.getDefaultResolver());
        Message.debug("\tdefault latest strategy: " + this.getDefaultLatestStrategy());
        Message.debug("\tdefault conflict manager: " + this.getDefaultConflictManager());
        Message.debug("\tcircular dependency strategy: " + this.getCircularDependencyStrategy());
        Message.debug("\tvalidate: " + this.doValidate());
        Message.debug("\tcheck up2date: " + this.isCheckUpToDate());
        Message.debug("\tcache ivy pattern: " + this.getCacheIvyPattern());
        Message.debug("\tcache artifact pattern: " + this.getCacheArtifactPattern());
        if (!this._classpathURLs.isEmpty()) {
            Message.verbose("\t-- " + this._classpathURLs.size() + " custom classpath urls:");
            iter = this._classpathURLs.iterator();
            while (iter.hasNext()) {
                Message.debug("\t\t" + iter.next());
            }
        }
        Message.verbose("\t-- " + this._resolversMap.size() + " resolvers:");
        iter = this._resolversMap.values().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            resolver.dumpConfig();
        }
        if (!this._moduleConfigurations.isEmpty()) {
            Message.debug("\tmodule configurations:");
            iter = this._moduleConfigurations.keySet().iterator();
            while (iter.hasNext()) {
                ModuleIdMatcher midm = (ModuleIdMatcher)iter.next();
                ModuleSettings s = (ModuleSettings)this._moduleConfigurations.get(midm);
                Message.debug("\t\t" + midm + " -> " + s);
            }
        }
    }

    public void loadProperties(URL url) throws IOException {
        this.loadProperties(url, true);
    }

    public void loadProperties(URL url, boolean overwrite) throws IOException {
        Properties properties = new Properties();
        properties.load(url.openStream());
        this.addAllVariables(properties, overwrite);
    }

    public void loadProperties(File file) throws IOException {
        this.loadProperties(file, true);
    }

    public void loadProperties(File file, boolean overwrite) throws IOException {
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        this.addAllVariables(properties, overwrite);
    }

    public void setVariable(String varName, String value) {
        this.setVariable(varName, value, true);
    }

    public void setVariable(String varName, String value, boolean overwrite) {
        if (overwrite || !this._variables.containsKey(varName)) {
            Message.debug("setting '" + varName + "' to '" + value + "'");
            this._variables.put(varName, this.substitute(value));
        } else {
            Message.debug("'" + varName + "' already set: discarding '" + value + "'");
        }
    }

    public void addAllVariables(Map variables) {
        this.addAllVariables(variables, true);
    }

    public void addAllVariables(Map variables, boolean overwrite) {
        Iterator iter = variables.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String val = (String)variables.get(key);
            this.setVariable(key, val, overwrite);
        }
    }

    public String substitute(String str) {
        return IvyPatternHelper.substituteVariables(str, this.getVariables());
    }

    public Map getVariables() {
        return this._variables;
    }

    public Class typeDef(String name, String className) {
        return this.typeDef(name, className, false);
    }

    public Class typeDef(String name, String className, boolean silentFail) {
        Class clazz = this.classForName(className, silentFail);
        if (clazz != null) {
            this._typeDefs.put(name, clazz);
        }
        return clazz;
    }

    private Class classForName(String className, boolean silentFail) {
        try {
            return this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (silentFail) {
                Message.info("impossible to define new type: class not found: " + className + " in " + this._classpathURLs + " nor Ivy classloader");
                return null;
            }
            throw new RuntimeException("impossible to define new type: class not found: " + className + " in " + this._classpathURLs + " nor Ivy classloader");
        }
    }

    private ClassLoader getClassLoader() {
        if (this._classloader == null) {
            this._classloader = this._classpathURLs.isEmpty() ? Ivy.class.getClassLoader() : new URLClassLoader(this._classpathURLs.toArray(new URL[this._classpathURLs.size()]), Ivy.class.getClassLoader());
        }
        return this._classloader;
    }

    public void addClasspathURL(URL url) {
        this._classpathURLs.add(url);
        this._classloader = null;
    }

    public Map getTypeDefs() {
        return this._typeDefs;
    }

    public Class getTypeDef(String name) {
        return (Class)this._typeDefs.get(name);
    }

    public void addConfigured(DependencyResolver resolver) {
        this.addResolver(resolver);
    }

    public void addConfigured(ModuleDescriptorParser parser) {
        ModuleDescriptorParserRegistry.getInstance().addParser(parser);
    }

    public void addResolver(DependencyResolver resolver) {
        if (resolver == null) {
            throw new NullPointerException("null resolver");
        }
        if (resolver instanceof IvyAware) {
            ((IvyAware)((Object)resolver)).setIvy(this);
        }
        this._resolversMap.put(resolver.getName(), resolver);
        if (resolver instanceof ChainResolver) {
            List subresolvers = ((ChainResolver)resolver).getResolvers();
            Iterator iter = subresolvers.iterator();
            while (iter.hasNext()) {
                DependencyResolver dr = (DependencyResolver)iter.next();
                this.addResolver(dr);
            }
        } else if (resolver instanceof DualResolver) {
            DependencyResolver artifactResolver;
            DependencyResolver ivyResolver = ((DualResolver)resolver).getIvyResolver();
            if (ivyResolver != null) {
                this.addResolver(ivyResolver);
            }
            if ((artifactResolver = ((DualResolver)resolver).getArtifactResolver()) != null) {
                this.addResolver(artifactResolver);
            }
        }
    }

    public void setDefaultCache(File cacheDirectory) {
        this._defaultCache = cacheDirectory;
    }

    public void setDefaultResolver(String resolverName) {
        this.checkResolverName(resolverName);
        this._defaultResolverName = resolverName;
    }

    private void checkResolverName(String resolverName) {
        if (resolverName != null && !this._resolversMap.containsKey(resolverName)) {
            throw new IllegalArgumentException("no resolver found called " + resolverName + ": check your configuration");
        }
    }

    public void addModuleConfiguration(ModuleId mid, PatternMatcher matcher, String resolverName, String branch, String conflictManager) {
        this.checkResolverName(resolverName);
        this._moduleConfigurations.put(new ModuleIdMatcher(mid, matcher), new ModuleSettings(resolverName, branch, conflictManager));
    }

    public File getDefaultIvyUserDir() {
        if (this._defaultUserDir == null) {
            if (this.getVariable("ivy.home") != null) {
                this.setDefaultIvyUserDir(new File(this.getVariable("ivy.home")));
                Message.verbose("using ivy.default.ivy.user.dir variable for default ivy user dir: " + this._defaultUserDir);
            } else {
                this.setDefaultIvyUserDir(new File(System.getProperty("user.home"), ".ivy"));
                Message.verbose("no default ivy user dir defined: set to " + this._defaultUserDir);
            }
        }
        return this._defaultUserDir;
    }

    public void setDefaultIvyUserDir(File defaultUserDir) {
        this._defaultUserDir = defaultUserDir;
        this.setVariable("ivy.default.ivy.user.dir", this._defaultUserDir.getAbsolutePath());
        this.setVariable("ivy.home", this._defaultUserDir.getAbsolutePath());
    }

    public File getDefaultCache() {
        if (this._defaultCache == null) {
            this._defaultCache = new File(this.getDefaultIvyUserDir(), "cache");
            Message.verbose("no default cache defined: set to " + this._defaultCache);
        }
        return this._defaultCache;
    }

    public DependencyResolver getResolver(ModuleId moduleId) {
        if (this._dictatorResolver != null) {
            return this._dictatorResolver;
        }
        String resolverName = this.getResolverName(moduleId);
        return this.getResolver(resolverName);
    }

    public DependencyResolver getResolver(String resolverName) {
        if (this._dictatorResolver != null) {
            return this._dictatorResolver;
        }
        DependencyResolver resolver = (DependencyResolver)this._resolversMap.get(resolverName);
        if (resolver == null) {
            Message.error("unknown resolver " + resolverName);
        }
        return resolver;
    }

    public DependencyResolver getDefaultResolver() {
        if (this._dictatorResolver != null) {
            return this._dictatorResolver;
        }
        if (this._defaultResolver == null) {
            this._defaultResolver = (DependencyResolver)this._resolversMap.get(this._defaultResolverName);
        }
        return this._defaultResolver;
    }

    public String getResolverName(ModuleId moduleId) {
        Iterator iter = this._moduleConfigurations.keySet().iterator();
        while (iter.hasNext()) {
            ModuleSettings ms;
            ModuleIdMatcher midm = (ModuleIdMatcher)iter.next();
            if (!midm.matches(moduleId) || (ms = (ModuleSettings)this._moduleConfigurations.get(midm)).getResolverName() == null) continue;
            return ms.getResolverName();
        }
        return this._defaultResolverName;
    }

    public String getDefaultBranch(ModuleId moduleId) {
        Iterator iter = this._moduleConfigurations.keySet().iterator();
        while (iter.hasNext()) {
            ModuleSettings ms;
            ModuleIdMatcher midm = (ModuleIdMatcher)iter.next();
            if (!midm.matches(moduleId) || (ms = (ModuleSettings)this._moduleConfigurations.get(midm)).getBranch() == null) continue;
            return ms.getBranch();
        }
        return this.getDefaultBranch();
    }

    public String getDefaultBranch() {
        return this._defaultBranch;
    }

    public void setDefaultBranch(String defaultBranch) {
        this._defaultBranch = defaultBranch;
    }

    public ConflictManager getConflictManager(ModuleId moduleId) {
        Iterator iter = this._moduleConfigurations.keySet().iterator();
        while (iter.hasNext()) {
            ModuleSettings ms;
            ModuleIdMatcher midm = (ModuleIdMatcher)iter.next();
            if (!midm.matches(moduleId) || (ms = (ModuleSettings)this._moduleConfigurations.get(midm)).getConflictManager() == null) continue;
            ConflictManager cm = this.getConflictManager(ms.getConflictManager());
            if (cm == null) {
                throw new IllegalStateException("ivy badly configured: unknown conflict manager " + ms.getConflictManager());
            }
            return cm;
        }
        return this.getDefaultConflictManager();
    }

    public void addConfigured(ConflictManager cm) {
        this.addConflictManager(cm.getName(), cm);
    }

    public ConflictManager getConflictManager(String name) {
        if ("default".equals(name)) {
            return this.getDefaultConflictManager();
        }
        return (ConflictManager)this._conflictsManager.get(name);
    }

    public void addConflictManager(String name, ConflictManager cm) {
        if (cm instanceof IvyAware) {
            ((IvyAware)((Object)cm)).setIvy(this);
        }
        this._conflictsManager.put(name, cm);
    }

    public void addConfigured(LatestStrategy latest) {
        this.addLatestStrategy(latest.getName(), latest);
    }

    public LatestStrategy getLatestStrategy(String name) {
        if ("default".equals(name)) {
            return this.getDefaultLatestStrategy();
        }
        return (LatestStrategy)this._latestStrategies.get(name);
    }

    public void addLatestStrategy(String name, LatestStrategy latest) {
        if (latest instanceof IvyAware) {
            ((IvyAware)((Object)latest)).setIvy(this);
        }
        this._latestStrategies.put(name, latest);
    }

    public void addConfigured(Namespace ns) {
        this.addNamespace(ns);
    }

    public Namespace getNamespace(String name) {
        if ("system".equals(name)) {
            return this.getSystemNamespace();
        }
        return (Namespace)this._namespaces.get(name);
    }

    public Namespace getSystemNamespace() {
        return Namespace.SYSTEM_NAMESPACE;
    }

    public void addNamespace(Namespace ns) {
        if (ns instanceof IvyAware) {
            ((IvyAware)((Object)ns)).setIvy(this);
        }
        this._namespaces.put(ns.getName(), ns);
    }

    public void addConfigured(PatternMatcher m) {
        this.addMatcher(m);
    }

    public PatternMatcher getMatcher(String name) {
        return (PatternMatcher)this._matchers.get(name);
    }

    public void addMatcher(PatternMatcher m) {
        if (m instanceof IvyAware) {
            ((IvyAware)((Object)m)).setIvy(this);
        }
        this._matchers.put(m.getName(), m);
    }

    public void addConfigured(ReportOutputter outputter) {
        this.addReportOutputter(outputter);
    }

    public ReportOutputter getReportOutputter(String name) {
        return (ReportOutputter)this._reportOutputters.get(name);
    }

    public void addReportOutputter(ReportOutputter outputter) {
        if (outputter instanceof IvyAware) {
            ((IvyAware)((Object)outputter)).setIvy(this);
        }
        this._reportOutputters.put(outputter.getName(), outputter);
    }

    public ReportOutputter[] getReportOutputters() {
        return this._reportOutputters.values().toArray(new ReportOutputter[this._reportOutputters.size()]);
    }

    public void addConfigured(VersionMatcher vmatcher) {
        this.addVersionMatcher(vmatcher);
    }

    public VersionMatcher getVersionMatcher(String name) {
        return (VersionMatcher)this._versionMatchers.get(name);
    }

    public void addVersionMatcher(VersionMatcher vmatcher) {
        if (vmatcher instanceof IvyAware) {
            ((IvyAware)((Object)vmatcher)).setIvy(this);
        }
        this._versionMatchers.put(vmatcher.getName(), vmatcher);
        if (this._versionMatcher == null) {
            this._versionMatcher = new ChainVersionMatcher();
            this.addVersionMatcher(new ExactVersionMatcher());
        }
        if (this._versionMatcher instanceof ChainVersionMatcher) {
            ChainVersionMatcher chain = (ChainVersionMatcher)this._versionMatcher;
            chain.add(vmatcher);
        }
    }

    public VersionMatcher[] getVersionMatchers() {
        return this._versionMatchers.values().toArray(new VersionMatcher[this._versionMatchers.size()]);
    }

    public VersionMatcher getVersionMatcher() {
        if (this._versionMatcher == null) {
            this.configureDefaultVersionMatcher();
        }
        return this._versionMatcher;
    }

    public void configureDefaultVersionMatcher() {
        this.addVersionMatcher(new LatestVersionMatcher());
        this.addVersionMatcher(new SubVersionMatcher());
        this.addVersionMatcher(new VersionRangeMatcher());
    }

    public CircularDependencyStrategy getCircularDependencyStrategy() {
        if (this._circularDependencyStrategy == null) {
            this._circularDependencyStrategy = this.getCircularDependencyStrategy("default");
        }
        return this._circularDependencyStrategy;
    }

    public CircularDependencyStrategy getCircularDependencyStrategy(String name) {
        if ("default".equals(name)) {
            name = "warn";
        }
        return (CircularDependencyStrategy)this._circularDependencyStrategies.get(name);
    }

    public void setCircularDependencyStrategy(CircularDependencyStrategy strategy) {
        this._circularDependencyStrategy = strategy;
    }

    public void addConfigured(CircularDependencyStrategy strategy) {
        this.addCircularDependencyStrategy(strategy);
    }

    private void addCircularDependencyStrategy(CircularDependencyStrategy strategy) {
        this._circularDependencyStrategies.put(strategy.getName(), strategy);
    }

    private void configureDefaultCircularDependencyStrategies() {
        this.addCircularDependencyStrategy(WarnCircularDependencyStrategy.getInstance());
        this.addCircularDependencyStrategy(ErrorCircularDependencyStrategy.getInstance());
        this.addCircularDependencyStrategy(IgnoreCircularDependencyStrategy.getInstance());
    }

    public boolean check(URL ivyFile, String resolvername) {
        try {
            IvyContext.getContext().setIvy(this);
            boolean result = true;
            ModuleDescriptor md = ModuleDescriptorParserRegistry.getInstance().parseDescriptor(this, ivyFile, this.doValidate());
            if (resolvername != null) {
                DependencyResolver resolver = this.getResolver(resolvername);
                String[] confs = md.getConfigurationsNames();
                HashSet<Artifact> artifacts = new HashSet<Artifact>();
                for (int i = 0; i < confs.length; ++i) {
                    artifacts.addAll(Arrays.asList(md.getArtifacts(confs[i])));
                }
                Iterator iter = artifacts.iterator();
                while (iter.hasNext()) {
                    Artifact art = (Artifact)iter.next();
                    if (resolver.exists(art)) continue;
                    Message.info("declared publication not found: " + art);
                    result = false;
                }
            }
            DependencyDescriptor[] dds = md.getDependencies();
            ResolveData data = new ResolveData(this, this.getDefaultCache(), new Date(), null, true);
            for (int i = 0; i < dds.length; ++i) {
                String[] masterConfs = dds[i].getModuleConfigurations();
                for (int j = 0; j < masterConfs.length; ++j) {
                    if ("*".equals(masterConfs[j].trim()) || md.getConfiguration(masterConfs[j]) != null) continue;
                    Message.info("dependency required in non existing conf for " + ivyFile + " \n\tin " + dds[i].getDependencyRevisionId() + ": " + masterConfs[j]);
                    result = false;
                }
                DependencyResolver resolver = this.getResolver(dds[i].getDependencyId());
                ResolvedModuleRevision rmr = resolver.getDependency(dds[i], data);
                if (rmr == null) {
                    Message.info("dependency not found in " + ivyFile + ":\n\t" + dds[i]);
                    result = false;
                    continue;
                }
                String[] depConfs = dds[i].getDependencyConfigurations(md.getConfigurationsNames());
                for (int j = 0; j < depConfs.length; ++j) {
                    if (!Arrays.asList(rmr.getDescriptor().getConfigurationsNames()).contains(depConfs[j])) {
                        Message.info("dependency configuration is missing for " + ivyFile + "\n\tin " + dds[i].getDependencyRevisionId() + ": " + depConfs[j]);
                        result = false;
                    }
                    Artifact[] arts = rmr.getDescriptor().getArtifacts(depConfs[j]);
                    for (int k = 0; k < arts.length; ++k) {
                        if (resolver.exists(arts[k])) continue;
                        Message.info("dependency artifact is missing for " + ivyFile + "\n\t in " + dds[i].getDependencyRevisionId() + ": " + arts[k]);
                        result = false;
                    }
                }
            }
            return result;
        }
        catch (ParseException e) {
            Message.info("parse problem on " + ivyFile + ": " + e);
            return false;
        }
        catch (IOException e) {
            Message.info("io problem on " + ivyFile + ": " + e);
            return false;
        }
        catch (Exception e) {
            Message.info("problem on " + ivyFile + ": " + e);
            return false;
        }
    }

    public ResolvedModuleRevision findModule(ModuleRevisionId id) {
        DependencyResolver r = this.getResolver(id.getModuleId());
        if (r == null) {
            throw new IllegalStateException("no resolver found for " + id.getModuleId());
        }
        DefaultModuleDescriptor md = DefaultModuleDescriptor.newCallerInstance(id, new String[]{"*"}, false, false);
        try {
            return r.getDependency(new DefaultDependencyDescriptor(id, true), new ResolveData(this, this.getDefaultCache(), null, new ConfigurationResolveReport(this, md, "default", null, this.getDefaultCache()), false));
        }
        catch (ParseException e) {
            throw new RuntimeException("problem whle parsing repository module descriptor for " + id + ": " + e, e);
        }
    }

    public ResolveReport resolve(File ivySource) throws ParseException, IOException {
        return this.resolve(ivySource.toURL());
    }

    public ResolveReport resolve(URL ivySource) throws ParseException, IOException {
        return this.resolve(ivySource, null, new String[]{"*"}, null, null, true);
    }

    public ResolveReport resolve(URL ivySource, String revision, String[] confs, File cache, Date date, boolean validate) throws ParseException, IOException {
        return this.resolve(ivySource, revision, confs, cache, date, validate, false);
    }

    public ResolveReport resolve(URL ivySource, String revision, String[] confs, File cache, Date date, boolean validate, boolean useCacheOnly) throws ParseException, IOException {
        return this.resolve(ivySource, revision, confs, cache, date, validate, useCacheOnly, FilterHelper.NO_FILTER);
    }

    public ResolveReport resolve(ModuleRevisionId mrid, String[] confs) throws ParseException, IOException {
        return this.resolve(mrid, confs, true, false, null, null, true, false, FilterHelper.NO_FILTER);
    }

    public ResolveReport resolve(ModuleRevisionId mrid, String[] confs, boolean transitive, boolean changing, File cache, Date date, boolean validate, boolean useCacheOnly, Filter artifactFilter) throws ParseException, IOException {
        return this.resolve(mrid, confs, transitive, changing, cache, date, validate, useCacheOnly, false, artifactFilter);
    }

    public ResolveReport resolve(final ModuleRevisionId mrid, String[] confs, boolean transitive, boolean changing, File cache, Date date, boolean validate, boolean useCacheOnly, boolean useOrigin, Filter artifactFilter) throws ParseException, IOException {
        DefaultModuleDescriptor md;
        if (confs.length == 1 && confs[0].equals("*")) {
            ResolvedModuleRevision rmr = this.findModule(mrid);
            if (rmr == null) {
                DefaultModuleDescriptor md2 = DefaultModuleDescriptor.newCallerInstance(mrid, confs, transitive, changing);
                return new ResolveReport(md2){

                    public boolean hasError() {
                        return true;
                    }

                    public List getProblemMessages() {
                        return Arrays.asList("module not found: " + mrid);
                    }
                };
            }
            confs = rmr.getDescriptor().getConfigurationsNames();
            md = DefaultModuleDescriptor.newCallerInstance(ModuleRevisionId.newInstance(mrid, rmr.getId().getRevision()), confs, transitive, changing);
        } else {
            md = DefaultModuleDescriptor.newCallerInstance(mrid, confs, transitive, changing);
        }
        return this.resolve(md, new String[]{"*"}, cache, date, validate, useCacheOnly, true, useOrigin, true, true, artifactFilter);
    }

    public ResolveReport resolve(URL ivySource, String revision, String[] confs, File cache, Date date, boolean validate, boolean useCacheOnly, Filter artifactFilter) throws ParseException, IOException {
        return this.resolve(ivySource, revision, confs, cache, date, validate, useCacheOnly, true, artifactFilter);
    }

    public ResolveReport resolve(URL ivySource, String revision, String[] confs, File cache, Date date, boolean validate, boolean useCacheOnly, boolean transitive, Filter artifactFilter) throws ParseException, IOException {
        return this.resolve(ivySource, revision, confs, cache, date, validate, useCacheOnly, transitive, false, artifactFilter);
    }

    public ResolveReport resolve(URL ivySource, String revision, String[] confs, File cache, Date date, boolean validate, boolean useCacheOnly, boolean transitive, boolean useOrigin, Filter artifactFilter) throws ParseException, IOException {
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        URLResource res = new URLResource(ivySource);
        ModuleDescriptorParser parser = ModuleDescriptorParserRegistry.getInstance().getParser(res);
        Message.verbose("using " + parser + " to parse " + ivySource);
        ModuleDescriptor md = parser.parseDescriptor(this, ivySource, validate);
        if (revision == null && md.getResolvedModuleRevisionId().getRevision() == null) {
            revision = "working@" + Ivy.getLocalHostName();
        }
        if (revision != null) {
            md.setResolvedModuleRevisionId(ModuleRevisionId.newInstance(md.getModuleRevisionId(), revision));
        }
        return this.resolve(md, confs, cache, date, validate, useCacheOnly, transitive, useOrigin, true, true, artifactFilter);
    }

    public ResolveReport resolve(ModuleDescriptor md, String[] confs, File cache, Date date, boolean validate, boolean useCacheOnly, Filter artifactFilter) throws ParseException, IOException, FileNotFoundException {
        return this.resolve(md, confs, cache, date, validate, useCacheOnly, true, artifactFilter);
    }

    public ResolveReport resolve(ModuleDescriptor md, String[] confs, File cache, Date date, boolean validate, boolean useCacheOnly, boolean transitive, Filter artifactFilter) throws ParseException, IOException, FileNotFoundException {
        return this.resolve(md, confs, cache, date, validate, useCacheOnly, transitive, true, true, artifactFilter);
    }

    public ResolveReport resolve(ModuleDescriptor md, String[] confs, File cache, Date date, boolean validate, boolean useCacheOnly, boolean transitive, boolean download, boolean outputReport, Filter artifactFilter) throws ParseException, IOException, FileNotFoundException {
        return this.resolve(md, confs, cache, date, validate, useCacheOnly, transitive, false, download, outputReport, artifactFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveReport resolve(ModuleDescriptor md, String[] confs, File cache, Date date, boolean validate, boolean useCacheOnly, boolean transitive, boolean useOrigin, boolean download, boolean outputReport, Filter artifactFilter) throws ParseException, IOException, FileNotFoundException {
        IvyContext.getContext().setIvy(this);
        DependencyResolver oldDictator = this.getDictatorResolver();
        if (useCacheOnly) {
            this.setDictatorResolver(new CacheResolver(this));
        }
        try {
            if (cache == null) {
                cache = this.getDefaultCache();
                IvyContext.getContext().setCache(cache);
            }
            if (artifactFilter == null) {
                artifactFilter = FilterHelper.NO_FILTER;
            }
            if (confs.length == 1 && confs[0].equals("*")) {
                confs = md.getConfigurationsNames();
            }
            this.fireIvyEvent(new StartResolveEvent(this, md, confs));
            long start = System.currentTimeMillis();
            Message.info(":: resolving dependencies :: " + md.getResolvedModuleRevisionId() + (transitive ? "" : " [not transitive]"));
            Message.info("\tconfs: " + Arrays.asList(confs));
            Message.verbose("\tvalidate = " + validate);
            ResolveReport report = new ResolveReport(md);
            IvyNode[] dependencies = this.getDependencies(md, confs, cache, date, report, validate, transitive);
            report.setDependencies(Arrays.asList(dependencies), artifactFilter);
            File ivyFileInCache = this.getResolvedIvyFileInCache(cache, md.getResolvedModuleRevisionId());
            md.toIvyFile(ivyFileInCache);
            File ivyPropertiesInCache = this.getResolvedIvyPropertiesInCache(cache, md.getResolvedModuleRevisionId());
            Properties props = new Properties();
            if (dependencies.length > 0) {
                IvyNode root = dependencies[0].getRoot();
                for (int i = 0; i < dependencies.length; ++i) {
                    DependencyDescriptor dd;
                    if (dependencies[i].isCompletelyEvicted() || dependencies[i].hasProblem() || (dd = dependencies[i].getDependencyDescriptor(root)) == null) continue;
                    String rev = dependencies[i].getResolvedId().getRevision();
                    String status = dependencies[i].getDescriptor().getStatus();
                    props.put(dd.getDependencyRevisionId().encodeToString(), rev + " " + status);
                }
            }
            props.store(new FileOutputStream(ivyPropertiesInCache), md.getResolvedModuleRevisionId() + " resolved revisions");
            Message.verbose("\tresolved ivy file produced in " + ivyFileInCache);
            report.setResolveTime(System.currentTimeMillis() - start);
            if (download) {
                Message.verbose(":: downloading artifacts ::");
                this.downloadArtifacts(report, cache, useOrigin, artifactFilter);
            }
            if (outputReport) {
                this.outputReport(report, cache);
            }
            this.fireIvyEvent(new EndResolveEvent(this, md, confs, report));
            ResolveReport resolveReport = report;
            return resolveReport;
        }
        finally {
            this.setDictatorResolver(oldDictator);
        }
    }

    public void outputReport(ResolveReport report, File cache) {
        Message.info(":: resolution report ::");
        report.setProblemMessages(Message.getProblems());
        report.output(this.getReportOutputters(), cache);
        Message.verbose("\tresolve done (" + report.getResolveTime() + "ms resolve - " + report.getDownloadTime() + "ms download)");
        Message.sumupProblems();
    }

    public void downloadArtifacts(ResolveReport report, File cache, boolean useOrigin, Filter artifactFilter) {
        long start = System.currentTimeMillis();
        IvyNode[] dependencies = report.getDependencies().toArray(new IvyNode[report.getDependencies().size()]);
        this.fireIvyEvent(new PrepareDownloadEvent(this, report.getArtifacts().toArray(new Artifact[report.getArtifacts().size()])));
        for (int i = 0; i < dependencies.length; ++i) {
            this.checkInterrupted();
            if (dependencies[i].isCompletelyEvicted() || dependencies[i].hasProblem()) continue;
            DependencyResolver resolver = dependencies[i].getModuleRevision().getArtifactResolver();
            Artifact[] selectedArtifacts = dependencies[i].getSelectedArtifacts(artifactFilter);
            DownloadReport dReport = resolver.download(selectedArtifacts, this, cache, useOrigin);
            ArtifactDownloadReport[] adrs = dReport.getArtifactsReports();
            for (int j = 0; j < adrs.length; ++j) {
                if (adrs[j].getDownloadStatus() != DownloadStatus.FAILED) continue;
                Message.warn("\t[NOT FOUND  ] " + adrs[j].getArtifact());
                resolver.reportFailure(adrs[j].getArtifact());
            }
            String[] dconfs = dependencies[i].getRootModuleConfigurations();
            for (int j = 0; j < dconfs.length; ++j) {
                if (dependencies[i].isEvicted(dconfs[j])) {
                    report.getConfigurationReport(dconfs[j]).addDependency(dependencies[i]);
                    continue;
                }
                report.getConfigurationReport(dconfs[j]).addDependency(dependencies[i], dReport);
            }
        }
        report.setDownloadTime(System.currentTimeMillis() - start);
    }

    public void checkInterrupted() {
        if (this.isInterrupted()) {
            Message.info("operation interrupted");
            throw new RuntimeException("operation interrupted");
        }
    }

    public ArtifactDownloadReport download(Artifact artifact, File cache) {
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        if (cache == null) {
            cache = this.getDefaultCache();
        }
        DependencyResolver resolver = this.getResolver(artifact.getModuleRevisionId().getModuleId());
        DownloadReport r = resolver.download(new Artifact[]{artifact}, this, cache, false);
        return r.getArtifactReport(artifact);
    }

    public IvyNode[] getDependencies(URL ivySource, String[] confs, File cache, Date date, boolean validate) throws ParseException, IOException {
        return this.getDependencies(ModuleDescriptorParserRegistry.getInstance().parseDescriptor(this, ivySource, validate), confs, cache, date, null, validate);
    }

    public IvyNode[] getDependencies(ModuleDescriptor md, String[] confs, File cache, Date date, ResolveReport report, boolean validate) {
        return this.getDependencies(md, confs, cache, date, report, validate, true);
    }

    public IvyNode[] getDependencies(ModuleDescriptor md, String[] confs, File cache, Date date, ResolveReport report, boolean validate, boolean transitive) {
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        if (md == null) {
            throw new NullPointerException("module descriptor must not be null");
        }
        if (cache == null) {
            cache = this.getDefaultCache();
        }
        if (confs.length == 1 && confs[0].equals("*")) {
            confs = md.getConfigurationsNames();
        }
        LinkedHashMap dependenciesMap = new LinkedHashMap();
        Date reportDate = new Date();
        ResolveData data = new ResolveData(this, cache, date, null, validate, transitive, dependenciesMap);
        IvyNode rootNode = new IvyNode(data, md);
        for (int i = 0; i < confs.length; ++i) {
            this._fetchedSet.clear();
            Configuration configuration = md.getConfiguration(confs[i]);
            if (configuration == null) {
                Message.error("asked configuration not found in " + md.getModuleRevisionId() + ": " + confs[i]);
                continue;
            }
            ConfigurationResolveReport confReport = null;
            if (report != null && (confReport = report.getConfigurationReport(confs[i])) == null) {
                confReport = new ConfigurationResolveReport(this, md, confs[i], reportDate, cache);
                report.addReport(confs[i], confReport);
            }
            data.setReport(confReport);
            rootNode.setRootModuleConf(confs[i]);
            rootNode.setRequestedConf(confs[i]);
            rootNode.updateConfsToFetch(Collections.singleton(confs[i]));
            this.fetchDependencies(rootNode, confs[i], false);
        }
        LinkedHashSet<IvyNode> dependencies = new LinkedHashSet<IvyNode>(dependenciesMap.size());
        Iterator iter = dependenciesMap.values().iterator();
        while (iter.hasNext()) {
            IvyNode dep = (IvyNode)iter.next();
            if (dep == null) continue;
            dependencies.add(dep);
        }
        List sortedDependencies = this.sortNodes(dependencies);
        Collections.reverse(sortedDependencies);
        ListIterator iter2 = sortedDependencies.listIterator();
        while (iter2.hasNext()) {
            IvyNode node = (IvyNode)iter2.next();
            if (node.isCompletelyEvicted()) continue;
            for (int i = 0; i < confs.length; ++i) {
                IvyNode.Caller[] callers = node.getCallers(confs[i]);
                if (this.debugConflictResolution()) {
                    Message.debug("checking if " + node.getId() + " is transitively evicted in " + confs[i]);
                }
                boolean allEvicted = callers.length > 0;
                for (int j = 0; j < callers.length; ++j) {
                    if (callers[j].getModuleRevisionId().equals(md.getModuleRevisionId())) {
                        allEvicted = false;
                        break;
                    }
                    IvyNode callerNode = (IvyNode)dependenciesMap.get(callers[j].getModuleRevisionId());
                    if (callerNode == null) {
                        Message.warn("ivy internal error: no node found for " + callers[j].getModuleRevisionId() + ": looked in " + dependenciesMap.keySet() + " and root module id was " + md.getModuleRevisionId());
                        continue;
                    }
                    if (!callerNode.isEvicted(confs[i])) {
                        allEvicted = false;
                        break;
                    }
                    if (!this.debugConflictResolution()) continue;
                    Message.debug("caller " + callerNode.getId() + " of " + node.getId() + " is evicted");
                }
                if (allEvicted) {
                    Message.verbose("all callers are evicted for " + node + ": evicting too");
                    node.markEvicted(confs[i], null, null, null);
                    continue;
                }
                if (!this.debugConflictResolution()) continue;
                Message.debug(node.getId() + " isn't transitively evicted, at least one caller was not evicted");
            }
        }
        return dependencies.toArray(new IvyNode[dependencies.size()]);
    }

    private void fetchDependencies(IvyNode node, String conf, boolean shouldBePublic) {
        IvyNode.EvictionData ed;
        int i;
        String[] confs;
        this.checkInterrupted();
        long start = System.currentTimeMillis();
        if (this.debugConflictResolution()) {
            Message.debug(node.getId() + " => resolving dependencies in " + conf);
        }
        this.resolveConflict(node, node.getParent());
        if (node.loadData(conf, shouldBePublic)) {
            node = node.getRealNode(true);
            this.resolveConflict(node, node.getParent());
            if (!node.isEvicted(node.getRootModuleConf())) {
                confs = node.getRealConfs(conf);
                for (i = 0; i < confs.length; ++i) {
                    this.doFetchDependencies(node, confs[i]);
                }
            }
        } else if (!node.hasProblem() && !node.isEvicted(node.getRootModuleConf())) {
            confs = node.getRealConfs(conf);
            for (i = 0; i < confs.length; ++i) {
                this.doFetchDependencies(node, confs[i]);
            }
        }
        if (node.isEvicted(node.getRootModuleConf()) && (ed = node.getEvictedData(node.getRootModuleConf())).getSelected() != null) {
            Iterator iter = ed.getSelected().iterator();
            while (iter.hasNext()) {
                IvyNode selected = (IvyNode)iter.next();
                this.fetchDependencies(selected, conf, true);
            }
        }
        if (this.debugConflictResolution()) {
            Message.debug(node.getId() + " => dependencies resolved in " + conf + " (" + (System.currentTimeMillis() - start) + "ms)");
        }
    }

    private void doFetchDependencies(IvyNode node, String conf) {
        String[] extendedConfs;
        Configuration c = node.getConfiguration(conf);
        if (c == null) {
            Message.warn("configuration not found '" + conf + "' in " + node.getResolvedId() + ": ignoring");
            if (node.getParent() != null) {
                Message.warn("it was required from " + node.getParent().getResolvedId());
            }
            return;
        }
        boolean requestedConfSet = false;
        if (node.getRequestedConf() == null) {
            node.setRequestedConf(conf);
            requestedConfSet = true;
        }
        if ((extendedConfs = c.getExtends()).length > 0) {
            node.updateConfsToFetch(Arrays.asList(extendedConfs));
        }
        for (int i = 0; i < extendedConfs.length; ++i) {
            this.fetchDependencies(node, extendedConfs[i], false);
        }
        DependencyDescriptor dd = node.getDependencyDescriptor(node.getParent());
        if (!this.isDependenciesFetched(node, conf) && (dd == null || node.isTransitive())) {
            Collection dependencies = node.getDependencies(conf, true);
            Iterator iter = dependencies.iterator();
            while (iter.hasNext()) {
                int i;
                IvyNode dep = (IvyNode)iter.next();
                dep = dep.getRealNode();
                node.traverse(conf, dep);
                if (dep.isCircular()) continue;
                String[] confs = dep.getRequiredConfigurations(node, conf);
                for (i = 0; i < confs.length; ++i) {
                    this.fetchDependencies(dep, confs[i], true);
                }
                confs = dep.getConfsToFetch();
                for (i = 0; i < confs.length; ++i) {
                    this.fetchDependencies(dep, confs[i], true);
                }
            }
        }
        if (requestedConfSet) {
            node.setRequestedConf(null);
        }
    }

    private boolean isDependenciesFetched(IvyNode node, String conf) {
        ModuleId moduleId = node.getModuleId();
        ModuleRevisionId moduleRevisionId = node.getResolvedId();
        String key = moduleId.getOrganisation() + "|" + moduleId.getName() + "|" + moduleRevisionId.getRevision() + "|" + conf;
        if (this._fetchedSet.contains(key)) {
            return true;
        }
        this._fetchedSet.add(key);
        return false;
    }

    private void resolveConflict(IvyNode node, IvyNode parent) {
        this.resolveConflict(node, parent, Collections.EMPTY_SET);
    }

    private void resolveConflict(IvyNode node, IvyNode parent, Collection toevict) {
        if (parent == null || node == parent) {
            return;
        }
        if (this.checkConflictSolved(node, parent)) {
            return;
        }
        HashSet resolvedNodes = new HashSet(parent.getResolvedNodes(node.getModuleId(), node.getRootModuleConf()));
        Collection conflicts = this.computeConflicts(node, parent, toevict, resolvedNodes);
        if (this.debugConflictResolution()) {
            Message.debug("found conflicting revisions for " + node + " in " + parent + ": " + conflicts);
        }
        Collection resolved = parent.getConflictManager(node.getModuleId()).resolveConflicts(parent, conflicts);
        if (this.debugConflictResolution()) {
            Message.debug("selected revisions for " + node + " in " + parent + ": " + resolved);
        }
        if (resolved.contains(node)) {
            toevict = resolvedNodes;
            toevict.removeAll(resolved);
            Iterator iter = toevict.iterator();
            while (iter.hasNext()) {
                IvyNode te = (IvyNode)iter.next();
                te.markEvicted(node.getRootModuleConf(), parent, parent.getConflictManager(node.getModuleId()), resolved);
                if (!this.debugConflictResolution()) continue;
                Message.debug("evicting " + te + " by " + te.getEvictedData(node.getRootModuleConf()));
            }
            parent.setResolvedNodes(node.getModuleId(), node.getRootModuleConf(), resolved);
            HashSet evicted = new HashSet(parent.getEvictedNodes(node.getModuleId(), node.getRootModuleConf()));
            evicted.removeAll(resolved);
            evicted.addAll(toevict);
            parent.setEvictedNodes(node.getModuleId(), node.getRootModuleConf(), evicted);
            this.resolveConflict(node, parent.getParent(), toevict);
        } else {
            Collection prevResolved;
            if (resolved.isEmpty() && this.debugConflictResolution()) {
                Message.verbose("conflict manager '" + parent.getConflictManager(node.getModuleId()) + "' evicted all revisions among " + conflicts);
            }
            HashSet evicted = new HashSet(parent.getEvictedNodes(node.getModuleId(), node.getRootModuleConf()));
            toevict.removeAll(resolved);
            evicted.removeAll(resolved);
            evicted.addAll(toevict);
            evicted.add(node);
            parent.setEvictedNodes(node.getModuleId(), node.getRootModuleConf(), evicted);
            node.markEvicted(node.getRootModuleConf(), parent, parent.getConflictManager(node.getModuleId()), resolved);
            if (this.debugConflictResolution()) {
                Message.debug("evicting " + node + " by " + node.getEvictedData(node.getRootModuleConf()));
            }
            if (!((Object)(prevResolved = parent.getResolvedNodes(node.getModuleId(), node.getRootModuleConf()))).equals(resolved)) {
                parent.setResolvedNodes(node.getModuleId(), node.getRootModuleConf(), resolved);
                Iterator iter = resolved.iterator();
                while (iter.hasNext()) {
                    IvyNode sel = (IvyNode)iter.next();
                    if (prevResolved.contains(sel)) continue;
                    this.resolveConflict(sel, parent.getParent(), toevict);
                }
            }
        }
    }

    private Collection computeConflicts(IvyNode node, IvyNode parent, Collection toevict, Collection resolvedNodes) {
        HashSet<IvyNode> conflicts = new HashSet<IvyNode>();
        if (resolvedNodes.removeAll(toevict)) {
            conflicts.add(node);
            Collection deps = parent.getDependencies(parent.getRequiredConfigurations());
            Iterator iter = deps.iterator();
            while (iter.hasNext()) {
                IvyNode dep = (IvyNode)iter.next();
                conflicts.addAll(dep.getResolvedNodes(node.getModuleId(), node.getRootModuleConf()));
            }
        } else if (resolvedNodes.isEmpty() && node.getParent() != parent) {
            conflicts.add(node);
            DependencyDescriptor[] dds = parent.getDescriptor().getDependencies();
            for (int i = 0; i < dds.length; ++i) {
                IvyNode n;
                if (!dds[i].getDependencyId().equals(node.getModuleId()) || (n = node.findNode(dds[i].getDependencyRevisionId())) == null) continue;
                conflicts.add(n);
                break;
            }
        } else {
            conflicts.add(node);
            conflicts.addAll(resolvedNodes);
        }
        return conflicts;
    }

    private boolean checkConflictSolved(IvyNode node, IvyNode parent) {
        if (parent.getResolvedRevisions(node.getModuleId(), node.getRootModuleConf()).contains(node.getResolvedId())) {
            IvyNode.EvictionData evictionData;
            if (this.debugConflictResolution()) {
                Message.debug("conflict resolution already done for " + node + " in " + parent);
            }
            if ((evictionData = node.getEvictionDataInRoot(node.getRootModuleConf(), parent)) != null) {
                if (this.debugConflictResolution()) {
                    Message.debug(node + " was previously evicted in root module conf " + node.getRootModuleConf());
                }
                node.markEvicted(evictionData);
                if (this.debugConflictResolution()) {
                    Message.debug("evicting " + node + " by " + evictionData);
                }
            }
            return true;
        }
        if (parent.getEvictedRevisions(node.getModuleId(), node.getRootModuleConf()).contains(node.getResolvedId())) {
            if (this.debugConflictResolution()) {
                Message.debug("conflict resolution already done for " + node + " in " + parent);
            }
            return true;
        }
        return false;
    }

    public ResolvedModuleRevision findModuleInCache(ModuleRevisionId mrid, File cache, boolean validate) {
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        if (!this.getVersionMatcher().isDynamic(mrid)) {
            File ivyFile = this.getIvyFileInCache(cache, mrid);
            if (ivyFile.exists()) {
                try {
                    DependencyResolver artResolver;
                    ModuleDescriptor depMD = XmlModuleDescriptorParser.getInstance().parseDescriptor(this, ivyFile.toURL(), validate);
                    String resolverName = this.getSavedResolverName(cache, depMD);
                    String artResolverName = this.getSavedArtResolverName(cache, depMD);
                    DependencyResolver resolver = (DependencyResolver)this._resolversMap.get(resolverName);
                    if (resolver == null) {
                        Message.debug("\tresolver not found: " + resolverName + " => trying to use the one configured for " + mrid);
                        resolver = this.getResolver(depMD.getResolvedModuleRevisionId().getModuleId());
                        if (resolver != null) {
                            Message.debug("\tconfigured resolver found for " + depMD.getResolvedModuleRevisionId() + ": " + resolver.getName() + ": saving this data");
                            this.saveResolver(cache, depMD, resolver.getName());
                        }
                    }
                    if ((artResolver = (DependencyResolver)this._resolversMap.get(artResolverName)) == null) {
                        artResolver = resolver;
                    }
                    if (resolver != null) {
                        Message.debug("\tfound ivy file in cache for " + mrid + " (resolved by " + resolver.getName() + "): " + ivyFile);
                        return new DefaultModuleRevision(resolver, artResolver, depMD, false, false, ivyFile.toURL());
                    }
                    Message.debug("\tresolver not found: " + resolverName + " => cannot use cached ivy file for " + mrid);
                }
                catch (Exception e) {
                    Message.debug("\tproblem while parsing cached ivy file for: " + mrid + ": " + e.getMessage());
                }
            } else {
                Message.debug("\tno ivy file in cache for " + mrid + ": tried " + ivyFile);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveReport install(ModuleRevisionId mrid, String from, String to, boolean transitive, boolean validate, boolean overwrite, Filter artifactFilter, File cache, String matcherName) throws IOException {
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        if (cache == null) {
            cache = this.getDefaultCache();
        }
        if (artifactFilter == null) {
            artifactFilter = FilterHelper.NO_FILTER;
        }
        DependencyResolver fromResolver = this.getResolver(from);
        DependencyResolver toResolver = this.getResolver(to);
        if (fromResolver == null) {
            throw new IllegalArgumentException("unknown resolver " + from + ". Available resolvers are: " + this._resolversMap.keySet());
        }
        if (toResolver == null) {
            throw new IllegalArgumentException("unknown resolver " + to + ". Available resolvers are: " + this._resolversMap.keySet());
        }
        PatternMatcher matcher = this.getMatcher(matcherName);
        if (matcher == null) {
            throw new IllegalArgumentException("unknown matcher " + matcherName + ". Available matchers are: " + this._matchers.keySet());
        }
        Message.info(":: installing " + mrid + " ::");
        DependencyResolver oldDicator = this.getDictatorResolver();
        boolean log = this.logNotConvertedExclusionRule();
        try {
            this.setLogNotConvertedExclusionRule(true);
            this.setDictatorResolver(fromResolver);
            DefaultModuleDescriptor md = new DefaultModuleDescriptor(ModuleRevisionId.newInstance("jayasoft", "ivy-install", "1.0"), this.getStatusManager().getDefaultStatus(), new Date());
            md.addConfiguration(new Configuration("default"));
            md.addConflictManager(new ModuleId("*", "*"), ExactPatternMatcher.getInstance(), new NoConflictManager());
            if (MatcherHelper.isExact(matcher, mrid)) {
                DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(md, mrid, false, false, transitive);
                dd.addDependencyConfiguration("default", "*");
                md.addDependency(dd);
            } else {
                Collection mrids = this.findModuleRevisionIds(fromResolver, mrid, matcher);
                Iterator iter = mrids.iterator();
                while (iter.hasNext()) {
                    ModuleRevisionId foundMrid = (ModuleRevisionId)iter.next();
                    Message.info("\tfound " + foundMrid + " to install: adding to the list");
                    DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(md, foundMrid, false, false, transitive);
                    dd.addDependencyConfiguration("default", "*");
                    md.addDependency(dd);
                }
            }
            ResolveReport report = new ResolveReport(md);
            Message.info(":: resolving dependencies ::");
            IvyNode[] dependencies = this.getDependencies(md, new String[]{"default"}, cache, null, report, validate);
            report.setDependencies(Arrays.asList(dependencies), artifactFilter);
            Message.info(":: downloading artifacts to cache ::");
            this.downloadArtifacts(report, cache, false, artifactFilter);
            Message.info(":: installing in " + to + " ::");
            for (int i = 0; i < dependencies.length; ++i) {
                ModuleDescriptor depmd = dependencies[i].getDescriptor();
                if (depmd == null) continue;
                Message.verbose("installing " + depmd.getModuleRevisionId());
                this.publish(depmd, toResolver, cache.getAbsolutePath() + "/" + this.getCacheArtifactPattern(), cache.getAbsolutePath() + "/" + this.getCacheIvyPattern(), null, overwrite);
            }
            Message.info(":: install resolution report ::");
            report.output(this.getReportOutputters(), cache);
            ResolveReport resolveReport = report;
            return resolveReport;
        }
        finally {
            this.setDictatorResolver(oldDicator);
            this.setLogNotConvertedExclusionRule(log);
        }
    }

    public Collection findModuleRevisionIds(DependencyResolver resolver, ModuleRevisionId pattern, PatternMatcher matcher) {
        IvyContext.getContext().setIvy(this);
        ArrayList<ModuleRevisionId> mrids = new ArrayList<ModuleRevisionId>();
        String resolverName = resolver.getName();
        Message.verbose("looking for modules matching " + pattern + " using " + matcher.getName());
        Namespace fromNamespace = resolver instanceof AbstractResolver ? ((AbstractResolver)resolver).getNamespace() : null;
        ArrayList<ModuleEntry> modules = new ArrayList<ModuleEntry>();
        OrganisationEntry[] orgs = resolver.listOrganisations();
        if (orgs == null || orgs.length == 0) {
            String org = pattern.getOrganisation();
            if (fromNamespace != null) {
                org = NameSpaceHelper.transform(pattern.getModuleId(), fromNamespace.getFromSystemTransformer()).getOrganisation();
            }
            modules.addAll(Arrays.asList(resolver.listModules(new OrganisationEntry(resolver, org))));
        } else {
            Matcher orgMatcher = matcher.getMatcher(pattern.getOrganisation());
            for (int i = 0; i < orgs.length; ++i) {
                String org;
                String systemOrg = org = orgs[i].getOrganisation();
                if (fromNamespace != null) {
                    systemOrg = NameSpaceHelper.transformOrganisation(org, fromNamespace.getToSystemTransformer());
                }
                if (!orgMatcher.matches(systemOrg)) continue;
                modules.addAll(Arrays.asList(resolver.listModules(new OrganisationEntry(resolver, org))));
            }
        }
        Message.debug("found " + modules.size() + " modules for " + pattern.getOrganisation() + " on " + resolverName);
        boolean foundModule = false;
        Iterator iter = modules.iterator();
        while (iter.hasNext()) {
            ModuleId foundMid;
            ModuleEntry mEntry = (ModuleEntry)iter.next();
            ModuleId systemMid = foundMid = new ModuleId(mEntry.getOrganisation(), mEntry.getModule());
            if (fromNamespace != null) {
                systemMid = NameSpaceHelper.transform(foundMid, fromNamespace.getToSystemTransformer());
            }
            if (!MatcherHelper.matches(matcher, pattern.getModuleId(), systemMid)) continue;
            foundModule = true;
            RevisionEntry[] rEntries = resolver.listRevisions(mEntry);
            Message.debug("found " + rEntries.length + " revisions for [" + mEntry.getOrganisation() + ", " + mEntry.getModule() + "] on " + resolverName);
            boolean foundRevision = false;
            for (int j = 0; j < rEntries.length; ++j) {
                ModuleRevisionId foundMrid;
                RevisionEntry rEntry = rEntries[j];
                ModuleRevisionId systemMrid = foundMrid = ModuleRevisionId.newInstance(mEntry.getOrganisation(), mEntry.getModule(), rEntry.getRevision());
                if (fromNamespace != null) {
                    systemMrid = fromNamespace.getToSystemTransformer().transform(foundMrid);
                }
                if (!MatcherHelper.matches(matcher, pattern, systemMrid)) continue;
                foundRevision = true;
                mrids.add(systemMrid);
            }
            if (foundRevision) continue;
            Message.debug("no revision found matching " + pattern + " in [" + mEntry.getOrganisation() + "," + mEntry.getModule() + "] using " + resolverName);
        }
        if (!foundModule) {
            Message.debug("no module found matching " + pattern + " using " + resolverName);
        }
        return mrids;
    }

    public int retrieve(ModuleId moduleId, String[] confs, File cache, String destFilePattern) {
        return this.retrieve(moduleId, confs, cache, destFilePattern, null);
    }

    public int retrieve(ModuleId moduleId, String[] confs, File cache, String destFilePattern, String destIvyPattern) {
        return this.retrieve(moduleId, confs, cache, destFilePattern, destIvyPattern, FilterHelper.NO_FILTER);
    }

    public int retrieve(ModuleId moduleId, String[] confs, File cache, String destFilePattern, String destIvyPattern, Filter artifactFilter) {
        return this.retrieve(moduleId, confs, cache, destFilePattern, destIvyPattern, artifactFilter, false, false);
    }

    public int retrieve(ModuleId moduleId, String[] confs, File cache, String destFilePattern, String destIvyPattern, Filter artifactFilter, boolean sync, boolean useOrigin) {
        if (artifactFilter == null) {
            artifactFilter = FilterHelper.NO_FILTER;
        }
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        Message.info(":: retrieving :: " + moduleId + (sync ? " [sync]" : ""));
        Message.info("\tconfs: " + Arrays.asList(confs));
        long start = System.currentTimeMillis();
        destFilePattern = IvyPatternHelper.substituteVariables(destFilePattern, this.getVariables());
        destIvyPattern = IvyPatternHelper.substituteVariables(destIvyPattern, this.getVariables());
        try {
            Map artifactsToCopy = this.determineArtifactsToCopy(moduleId, confs, cache, destFilePattern, destIvyPattern, artifactFilter);
            File fileRetrieveRoot = new File(IvyPatternHelper.getTokenRoot(destFilePattern));
            File ivyRetrieveRoot = destIvyPattern == null ? null : new File(IvyPatternHelper.getTokenRoot(destIvyPattern));
            HashSet targetArtifactsStructure = new HashSet();
            HashSet targetIvysStructure = new HashSet();
            int targetsCopied = 0;
            int targetsUpToDate = 0;
            Iterator iter = artifactsToCopy.keySet().iterator();
            while (iter.hasNext()) {
                Artifact artifact = (Artifact)iter.next();
                File archive = "ivy".equals(artifact.getType()) ? this.getIvyFileInCache(cache, artifact.getModuleRevisionId()) : this.getArchiveFileInCache(cache, artifact, this.getSavedArtifactOrigin(cache, artifact), useOrigin);
                Set dest = (Set)artifactsToCopy.get(artifact);
                Message.verbose("\tretrieving " + archive);
                Iterator it2 = dest.iterator();
                while (it2.hasNext()) {
                    this.checkInterrupted();
                    File destFile = new File((String)it2.next());
                    if (!this._checkUpToDate || !this.upToDate(archive, destFile)) {
                        Message.verbose("\t\tto " + destFile);
                        FileUtil.copy(archive, destFile, null);
                        ++targetsCopied;
                    } else {
                        Message.verbose("\t\tto " + destFile + " [NOT REQUIRED]");
                        ++targetsUpToDate;
                    }
                    if ("ivy".equals(artifact.getType())) {
                        targetIvysStructure.addAll(FileUtil.getPathFiles(ivyRetrieveRoot, destFile));
                        continue;
                    }
                    targetArtifactsStructure.addAll(FileUtil.getPathFiles(fileRetrieveRoot, destFile));
                }
            }
            if (sync) {
                Collection existingIvys;
                Message.verbose("\tsyncing...");
                Collection existingArtifacts = FileUtil.listAll(fileRetrieveRoot);
                Collection collection = existingIvys = ivyRetrieveRoot == null ? null : FileUtil.listAll(ivyRetrieveRoot);
                if (fileRetrieveRoot.equals(ivyRetrieveRoot)) {
                    HashSet target = targetArtifactsStructure;
                    target.addAll(targetIvysStructure);
                    Collection existing = existingArtifacts;
                    existing.addAll(existingIvys);
                    this.sync(target, existing);
                } else {
                    this.sync(targetArtifactsStructure, existingArtifacts);
                    if (existingIvys != null) {
                        this.sync(targetIvysStructure, existingIvys);
                    }
                }
            }
            Message.info("\t" + targetsCopied + " artifacts copied, " + targetsUpToDate + " already retrieved");
            Message.verbose("\tretrieve done (" + (System.currentTimeMillis() - start) + "ms)");
            return targetsCopied;
        }
        catch (Exception ex) {
            throw new RuntimeException("problem during retrieve of " + moduleId + ": " + ex, ex);
        }
    }

    private void sync(Collection target, Collection existing) {
        File file;
        HashSet<File> toRemove = new HashSet<File>();
        Iterator iter = existing.iterator();
        while (iter.hasNext()) {
            file = (File)iter.next();
            toRemove.add(file.getAbsoluteFile());
        }
        iter = target.iterator();
        while (iter.hasNext()) {
            file = (File)iter.next();
            toRemove.remove(file.getAbsoluteFile());
        }
        iter = toRemove.iterator();
        while (iter.hasNext()) {
            file = (File)iter.next();
            if (!file.exists()) continue;
            Message.verbose("\t\tdeleting " + file);
            FileUtil.forceDelete(file);
        }
    }

    public Map determineArtifactsToCopy(ModuleId moduleId, String[] confs, File cache, String destFilePattern, String destIvyPattern) throws ParseException, IOException {
        return this.determineArtifactsToCopy(moduleId, confs, cache, destFilePattern, destIvyPattern, FilterHelper.NO_FILTER);
    }

    public Map determineArtifactsToCopy(ModuleId moduleId, String[] confs, File cache, String destFilePattern, String destIvyPattern, Filter artifactFilter) throws ParseException, IOException {
        Set dest;
        Collection<Artifact> artifacts;
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        if (artifactFilter == null) {
            artifactFilter = FilterHelper.NO_FILTER;
        }
        HashMap artifactsToCopy = new HashMap();
        HashMap<String, HashSet<Artifact>> conflictsMap = new HashMap<String, HashSet<Artifact>>();
        HashMap conflictsConfMap = new HashMap();
        XmlReportParser parser = new XmlReportParser();
        for (int i = 0; i < confs.length; ++i) {
            String conf = confs[i];
            artifacts = new ArrayList<Artifact>(Arrays.asList(parser.getArtifacts(moduleId, conf, cache)));
            if (destIvyPattern != null) {
                ModuleRevisionId[] mrids = parser.getRealDependencyRevisionIds(moduleId, conf, cache);
                for (int j = 0; j < mrids.length; ++j) {
                    artifacts.add(DefaultArtifact.newIvyArtifact(mrids[j], null));
                }
            }
            Iterator<Artifact> iter = artifacts.iterator();
            while (iter.hasNext()) {
                String destPattern;
                Artifact artifact = iter.next();
                String string = destPattern = "ivy".equals(artifact.getType()) ? destIvyPattern : destFilePattern;
                if (!"ivy".equals(artifact.getType()) && !artifactFilter.accept(artifact)) continue;
                String destFileName = IvyPatternHelper.substitute(destPattern, artifact, conf);
                dest = (HashSet<String>)artifactsToCopy.get(artifact);
                if (dest == null) {
                    dest = new HashSet<String>();
                    artifactsToCopy.put(artifact, dest);
                }
                String copyDest = new File(destFileName).getAbsolutePath();
                dest.add(copyDest);
                HashSet<Artifact> conflicts = (HashSet<Artifact>)conflictsMap.get(copyDest);
                HashSet<String> conflictsConf = (HashSet<String>)conflictsConfMap.get(copyDest);
                if (conflicts == null) {
                    conflicts = new HashSet<Artifact>();
                    conflictsMap.put(copyDest, conflicts);
                }
                if (conflictsConf == null) {
                    conflictsConf = new HashSet<String>();
                    conflictsConfMap.put(copyDest, conflictsConf);
                }
                conflicts.add(artifact);
                conflictsConf.add(conf);
            }
        }
        Iterator iter = conflictsMap.keySet().iterator();
        while (iter.hasNext()) {
            String copyDest = (String)iter.next();
            artifacts = (Set)conflictsMap.get(copyDest);
            Set conflictsConfs = (Set)conflictsConfMap.get(copyDest);
            if (artifacts.size() <= 1) continue;
            ArrayList<Artifact> artifactsList = new ArrayList<Artifact>(artifacts);
            Collections.sort(artifactsList, this.getConflictResolvingPolicy());
            Message.info("\tconflict on " + copyDest + " in " + conflictsConfs + ": " + ((Artifact)artifactsList.get(artifactsList.size() - 1)).getModuleRevisionId().getRevision() + " won");
            for (int i = artifactsList.size() - 2; i >= 0; --i) {
                Artifact looser = (Artifact)artifactsList.get(i);
                Message.verbose("\t\tremoving conflict looser artifact: " + looser);
                dest = (Set)artifactsToCopy.get(looser);
                dest.remove(copyDest);
                if (!dest.isEmpty()) continue;
                artifactsToCopy.remove(looser);
            }
        }
        return artifactsToCopy;
    }

    private boolean upToDate(File source, File target) {
        if (!target.exists()) {
            return false;
        }
        return source.lastModified() <= target.lastModified();
    }

    private Comparator getConflictResolvingPolicy() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                Artifact a1 = (Artifact)o1;
                Artifact a2 = (Artifact)o2;
                if (a1.getPublicationDate().after(a2.getPublicationDate())) {
                    return 1;
                }
                if (a1.getPublicationDate().before(a2.getPublicationDate())) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public void deliver(ModuleRevisionId mrid, String revision, File cache, String destIvyPattern, String status, Date pubdate, PublishingDependencyRevisionResolver pdrResolver, boolean validate) throws IOException, ParseException {
        this.deliver(mrid, revision, cache, destIvyPattern, status, pubdate, pdrResolver, validate, true);
    }

    public void deliver(ModuleRevisionId mrid, String revision, File cache, String destIvyPattern, String status, Date pubdate, PublishingDependencyRevisionResolver pdrResolver, boolean validate, boolean resolveDynamicRevisions) throws IOException, ParseException {
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        Message.info(":: delivering :: " + mrid + " :: " + revision + " :: " + status + " :: " + pubdate);
        Message.verbose("\tvalidate = " + validate);
        long start = System.currentTimeMillis();
        destIvyPattern = this.substitute(destIvyPattern);
        File ivyFile = this.getResolvedIvyFileInCache(cache, mrid);
        if (!ivyFile.exists()) {
            throw new IllegalStateException("ivy file not found in cache for " + mrid + ": please resolve dependencies before publishing (" + ivyFile + ")");
        }
        ModuleDescriptor md = null;
        URL ivyFileURL = null;
        try {
            ivyFileURL = ivyFile.toURL();
            md = XmlModuleDescriptorParser.getInstance().parseDescriptor(this, ivyFileURL, validate);
            md.setResolvedModuleRevisionId(ModuleRevisionId.newInstance(mrid, revision));
            md.setResolvedPublicationDate(pubdate);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("malformed url obtained for file " + ivyFile);
        }
        catch (ParseException e) {
            throw new IllegalStateException("bad ivy file in cache for " + mrid + ": please clean and resolve again");
        }
        HashMap<ModuleRevisionId, String> resolvedRevisions = new HashMap<ModuleRevisionId, String>();
        HashMap<ModuleRevisionId, String> dependenciesStatus = new HashMap<ModuleRevisionId, String>();
        File ivyProperties = this.getResolvedIvyPropertiesInCache(cache, mrid);
        if (!ivyProperties.exists()) {
            throw new IllegalStateException("ivy properties not found in cache for " + mrid + ": please resolve dependencies before publishing (" + ivyFile + ")");
        }
        Properties props = new Properties();
        props.load(new FileInputStream(ivyProperties));
        Iterator<Object> iter = props.keySet().iterator();
        while (iter.hasNext()) {
            String depMridStr = (String)iter.next();
            String[] parts = props.getProperty(depMridStr).split(" ");
            ModuleRevisionId decodedMrid = ModuleRevisionId.decode(depMridStr);
            if (resolveDynamicRevisions) {
                resolvedRevisions.put(decodedMrid, parts[0]);
            }
            dependenciesStatus.put(decodedMrid, parts[1]);
        }
        HashMap<ModuleRevisionId, String> resolvedDependencies = new HashMap<ModuleRevisionId, String>();
        DependencyDescriptor[] dependencies = md.getDependencies();
        for (int i = 0; i < dependencies.length; ++i) {
            String rev = (String)resolvedRevisions.get(dependencies[i].getDependencyRevisionId());
            if (rev == null) {
                rev = dependencies[i].getDependencyRevisionId().getRevision();
            }
            String depStatus = (String)dependenciesStatus.get(dependencies[i].getDependencyRevisionId());
            resolvedDependencies.put(dependencies[i].getDependencyRevisionId(), pdrResolver.resolve(md, status, ModuleRevisionId.newInstance(dependencies[i].getDependencyRevisionId(), rev), depStatus));
        }
        String publishedIvy = IvyPatternHelper.substitute(destIvyPattern, md.getResolvedModuleRevisionId());
        Message.info("\tdelivering ivy file to " + publishedIvy);
        try {
            XmlModuleDescriptorUpdater.update(this, ivyFileURL, new File(publishedIvy), resolvedDependencies, status, revision, pubdate, null, true);
        }
        catch (SAXException ex) {
            throw new IllegalStateException("bad ivy file in cache for " + mrid + ": please clean and resolve again");
        }
        Message.verbose("\tdeliver done (" + (System.currentTimeMillis() - start) + "ms)");
    }

    public Collection publish(ModuleRevisionId mrid, String pubrevision, File cache, String srcArtifactPattern, String resolverName, String srcIvyPattern, boolean validate) throws IOException {
        return this.publish(mrid, pubrevision, cache, srcArtifactPattern, resolverName, srcIvyPattern, validate, false);
    }

    public Collection publish(ModuleRevisionId mrid, String pubrevision, File cache, String srcArtifactPattern, String resolverName, String srcIvyPattern, boolean validate, boolean overwrite) throws IOException {
        return this.publish(mrid, pubrevision, cache, srcArtifactPattern, resolverName, srcIvyPattern, null, null, null, validate, overwrite, false);
    }

    public Collection publish(ModuleRevisionId mrid, String pubrevision, File cache, String srcArtifactPattern, String resolverName, String srcIvyPattern, String status, Date pubdate, Artifact[] extraArtifacts, boolean validate, boolean overwrite, boolean update) throws IOException {
        ModuleDescriptor md;
        long start;
        block12: {
            File ivyFile;
            IvyContext.getContext().setIvy(this);
            IvyContext.getContext().setCache(cache);
            Message.info(":: publishing :: " + mrid.getModuleId());
            Message.verbose("\tvalidate = " + validate);
            start = System.currentTimeMillis();
            srcArtifactPattern = this.substitute(srcArtifactPattern);
            srcIvyPattern = this.substitute(srcIvyPattern);
            ModuleRevisionId pubmrid = ModuleRevisionId.newInstance(mrid, pubrevision);
            if (srcIvyPattern != null) {
                ivyFile = new File(IvyPatternHelper.substitute(srcIvyPattern, DefaultArtifact.newIvyArtifact(pubmrid, new Date())));
                if (!ivyFile.exists()) {
                    throw new IllegalArgumentException("ivy file to publish not found for " + mrid + ": call deliver before (" + ivyFile + ")");
                }
            } else {
                ivyFile = this.getResolvedIvyFileInCache(cache, mrid);
                if (!ivyFile.exists()) {
                    throw new IllegalStateException("ivy file not found in cache for " + mrid + ": please resolve dependencies before publishing (" + ivyFile + ")");
                }
            }
            md = null;
            URL ivyFileURL = null;
            try {
                ivyFileURL = ivyFile.toURL();
                md = XmlModuleDescriptorParser.getInstance().parseDescriptor(this, ivyFileURL, false);
                if (srcIvyPattern != null) {
                    if (pubrevision.equals(md.getModuleRevisionId().getRevision())) break block12;
                    if (update) {
                        File tmp = File.createTempFile("ivy", ".xml");
                        tmp.deleteOnExit();
                        try {
                            XmlModuleDescriptorUpdater.update(this, ivyFileURL, tmp, new HashMap(), status == null ? md.getStatus() : status, pubrevision, pubdate == null ? new Date() : pubdate, null, true);
                            ivyFile = tmp;
                            md = XmlModuleDescriptorParser.getInstance().parseDescriptor(this, ivyFile.toURL(), false);
                            srcIvyPattern = ivyFile.getAbsolutePath();
                            break block12;
                        }
                        catch (SAXException e) {
                            throw new IllegalStateException("bad ivy file for " + mrid + ": " + ivyFile + ": " + e);
                        }
                    }
                    throw new IllegalArgumentException("cannot publish " + ivyFile + " as " + pubrevision + ": bad revision found in ivy file. Use deliver before.");
                }
                md.setResolvedModuleRevisionId(pubmrid);
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("malformed url obtained for file " + ivyFile);
            }
            catch (ParseException e) {
                throw new IllegalStateException("bad ivy file for " + mrid + ": " + ivyFile + ": " + e);
            }
        }
        DependencyResolver resolver = this.getResolver(resolverName);
        if (resolver == null) {
            throw new IllegalArgumentException("unknown resolver " + resolverName);
        }
        Collection missing = this.publish(md, resolver, srcArtifactPattern, srcIvyPattern, extraArtifacts, overwrite);
        Message.verbose("\tpublish done (" + (System.currentTimeMillis() - start) + "ms)");
        return missing;
    }

    private Collection publish(ModuleDescriptor md, DependencyResolver resolver, String srcArtifactPattern, String srcIvyPattern, Artifact[] extraArtifacts, boolean overwrite) throws IOException {
        Artifact artifact;
        int i;
        ArrayList<Artifact> missing = new ArrayList<Artifact>();
        HashSet<Artifact> artifactsSet = new HashSet<Artifact>();
        String[] confs = md.getConfigurationsNames();
        for (i = 0; i < confs.length; ++i) {
            Artifact[] artifacts = md.getArtifacts(confs[i]);
            for (int j = 0; j < artifacts.length; ++j) {
                artifactsSet.add(artifacts[j]);
            }
        }
        if (extraArtifacts != null) {
            for (i = 0; i < extraArtifacts.length; ++i) {
                artifactsSet.add(new MDArtifact(md, extraArtifacts[i].getName(), extraArtifacts[i].getType(), extraArtifacts[i].getExt(), extraArtifacts[i].getUrl(), extraArtifacts[i].getExtraAttributes()));
            }
        }
        Iterator iter = artifactsSet.iterator();
        while (iter.hasNext()) {
            Artifact artifact2 = (Artifact)iter.next();
            if (this.publish(artifact2, srcArtifactPattern, resolver, overwrite)) continue;
            missing.add(artifact2);
        }
        if (srcIvyPattern != null && !this.publish(artifact = MDArtifact.newIvyArtifact(md), srcIvyPattern, resolver, overwrite)) {
            missing.add(artifact);
        }
        return missing;
    }

    private boolean publish(Artifact artifact, String srcArtifactPattern, DependencyResolver resolver, boolean overwrite) throws IOException {
        this.checkInterrupted();
        File src = new File(IvyPatternHelper.substitute(srcArtifactPattern, artifact));
        if (src.exists()) {
            resolver.publish(artifact, src, overwrite);
            return true;
        }
        Message.info("missing artifact " + artifact + ": " + src + " file does not exist");
        return false;
    }

    public List sortNodes(Collection nodes) {
        IvyContext.getContext().setIvy(this);
        return ModuleDescriptorSorter.sortNodes(this.getVersionMatcher(), nodes);
    }

    public List sortModuleDescriptors(Collection moduleDescriptors) {
        IvyContext.getContext().setIvy(this);
        return ModuleDescriptorSorter.sortModuleDescriptors(this.getVersionMatcher(), moduleDescriptors);
    }

    public File getResolvedIvyFileInCache(File cache, ModuleRevisionId mrid) {
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        return new File(cache, IvyPatternHelper.substitute(this._cacheResolvedIvyPattern, mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), "ivy", "ivy", "xml"));
    }

    public File getResolvedIvyPropertiesInCache(File cache, ModuleRevisionId mrid) {
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        return new File(cache, IvyPatternHelper.substitute(this._cacheResolvedIvyPropertiesPattern, mrid.getOrganisation(), mrid.getName(), mrid.getRevision(), "ivy", "ivy", "xml"));
    }

    public File getIvyFileInCache(File cache, ModuleRevisionId mrid) {
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        return new File(cache, IvyPatternHelper.substitute(this._cacheIvyPattern, DefaultArtifact.newIvyArtifact(mrid, null)));
    }

    public File getArchiveFileInCache(File cache, Artifact artifact) {
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        ArtifactOrigin origin = this.getSavedArtifactOrigin(cache, artifact);
        return this.getArchiveFileInCache(cache, artifact, origin);
    }

    public File getArchiveFileInCache(File cache, Artifact artifact, ArtifactOrigin origin) {
        File original;
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        File archive = new File(cache, this.getArchivePathInCache(artifact, origin));
        if (!archive.exists() && origin != null && origin.isLocal() && (original = new File(origin.getLocation())).exists()) {
            return original;
        }
        return archive;
    }

    public File getArchiveFileInCache(File cache, Artifact artifact, ArtifactOrigin origin, boolean useOrigin) {
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        if (useOrigin && origin != null && origin.isLocal()) {
            return new File(origin.getLocation());
        }
        return new File(cache, this.getArchivePathInCache(artifact, origin));
    }

    public File getArchiveFileInCache(File cache, String organisation, String module, String revision, String artifact, String type, String ext) {
        IvyContext.getContext().setIvy(this);
        IvyContext.getContext().setCache(cache);
        return new File(cache, this.getArchivePathInCache(organisation, module, revision, artifact, type, ext));
    }

    public String getArchivePathInCache(Artifact artifact) {
        IvyContext.getContext().setIvy(this);
        return IvyPatternHelper.substitute(this._cacheArtifactPattern, artifact);
    }

    public String getArchivePathInCache(Artifact artifact, ArtifactOrigin origin) {
        IvyContext.getContext().setIvy(this);
        return IvyPatternHelper.substitute(this._cacheArtifactPattern, artifact, origin);
    }

    public String getArchivePathInCache(String organisation, String module, String revision, String artifact, String type, String ext) {
        IvyContext.getContext().setIvy(this);
        return this.getArchivePathInCache(new DefaultArtifact(ModuleRevisionId.newInstance(organisation, module, revision), new Date(), artifact, type, ext));
    }

    public void interrupt() {
        Thread operatingThread = IvyContext.getContext().getOperatingThread();
        this.interrupt(operatingThread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt(Thread operatingThread) {
        if (operatingThread != null && operatingThread.isAlive()) {
            if (operatingThread == Thread.currentThread()) {
                throw new IllegalStateException("cannot call interrupt from ivy operating thread");
            }
            Message.verbose("interrupting operating thread...");
            operatingThread.interrupt();
            Ivy ivy = this;
            synchronized (ivy) {
                this._interrupted = true;
            }
            try {
                Message.verbose("waiting clean interruption of operating thread");
                operatingThread.join(this._interruptTimeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (operatingThread.isAlive()) {
                Message.warn("waited clean interruption for too long: stopping operating thread");
                operatingThread.stop();
            }
            ivy = this;
            synchronized (ivy) {
                this._interrupted = false;
            }
        }
    }

    public static String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public String[] listTokenValues(String token, Map otherTokenValues) {
        ArrayList<String> r = new ArrayList<String>();
        Iterator iter = this._resolversMap.values().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            r.addAll(Arrays.asList(resolver.listTokenValues(token, otherTokenValues)));
        }
        return r.toArray(new String[r.size()]);
    }

    public OrganisationEntry[] listOrganisationEntries() {
        ArrayList<OrganisationEntry> entries = new ArrayList<OrganisationEntry>();
        Iterator iter = this._resolversMap.values().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            entries.addAll(Arrays.asList(resolver.listOrganisations()));
        }
        return entries.toArray(new OrganisationEntry[entries.size()]);
    }

    public String[] listOrganisations() {
        HashSet<String> orgs = new HashSet<String>();
        Iterator iter = this._resolversMap.values().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            OrganisationEntry[] entries = resolver.listOrganisations();
            if (entries == null) continue;
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i] == null) continue;
                orgs.add(entries[i].getOrganisation());
            }
        }
        return orgs.toArray(new String[orgs.size()]);
    }

    public ModuleEntry[] listModuleEntries(OrganisationEntry org) {
        ArrayList<ModuleEntry> entries = new ArrayList<ModuleEntry>();
        Iterator iter = this._resolversMap.values().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            entries.addAll(Arrays.asList(resolver.listModules(org)));
        }
        return entries.toArray(new ModuleEntry[entries.size()]);
    }

    public String[] listModules(String org) {
        ArrayList<String> mods = new ArrayList<String>();
        Iterator iter = this._resolversMap.values().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            ModuleEntry[] entries = resolver.listModules(new OrganisationEntry(resolver, org));
            if (entries == null) continue;
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i] == null) continue;
                mods.add(entries[i].getModule());
            }
        }
        return mods.toArray(new String[mods.size()]);
    }

    public RevisionEntry[] listRevisionEntries(ModuleEntry module) {
        ArrayList<RevisionEntry> entries = new ArrayList<RevisionEntry>();
        Iterator iter = this._resolversMap.values().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            entries.addAll(Arrays.asList(resolver.listRevisions(module)));
        }
        return entries.toArray(new RevisionEntry[entries.size()]);
    }

    public String[] listRevisions(String org, String module) {
        ArrayList<String> revs = new ArrayList<String>();
        Iterator iter = this._resolversMap.values().iterator();
        while (iter.hasNext()) {
            DependencyResolver resolver = (DependencyResolver)iter.next();
            RevisionEntry[] entries = resolver.listRevisions(new ModuleEntry(new OrganisationEntry(resolver, org), module));
            if (entries == null) continue;
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i] == null) continue;
                revs.add(entries[i].getRevision());
            }
        }
        return revs.toArray(new String[revs.size()]);
    }

    public boolean listingIgnore(String name) {
        return this._listingIgnore.contains(name);
    }

    public void filterIgnore(Collection names) {
        names.removeAll(this._listingIgnore);
    }

    public boolean isCheckUpToDate() {
        return this._checkUpToDate;
    }

    public void setCheckUpToDate(boolean checkUpToDate) {
        this._checkUpToDate = checkUpToDate;
    }

    public String getCacheArtifactPattern() {
        return this._cacheArtifactPattern;
    }

    public void setCacheArtifactPattern(String cacheArtifactPattern) {
        this._cacheArtifactPattern = cacheArtifactPattern;
    }

    public String getCacheIvyPattern() {
        return this._cacheIvyPattern;
    }

    public void setCacheIvyPattern(String cacheIvyPattern) {
        this._cacheIvyPattern = cacheIvyPattern;
    }

    public boolean doValidate() {
        return this._validate;
    }

    public void setValidate(boolean validate) {
        this._validate = validate;
    }

    public String getVariable(String name) {
        String val = (String)this._variables.get(name);
        return val == null ? val : this.substitute(val);
    }

    public ConflictManager getDefaultConflictManager() {
        if (this._defaultConflictManager == null) {
            this._defaultConflictManager = new LatestConflictManager(this.getDefaultLatestStrategy());
        }
        return this._defaultConflictManager;
    }

    public void setDefaultConflictManager(ConflictManager defaultConflictManager) {
        this._defaultConflictManager = defaultConflictManager;
    }

    public LatestStrategy getDefaultLatestStrategy() {
        if (this._defaultLatestStrategy == null) {
            this._defaultLatestStrategy = new LatestRevisionStrategy();
        }
        return this._defaultLatestStrategy;
    }

    public void setDefaultLatestStrategy(LatestStrategy defaultLatestStrategy) {
        this._defaultLatestStrategy = defaultLatestStrategy;
    }

    public void addTransferListener(TransferListener listener) {
        this._listeners.add(TransferListener.class, listener);
    }

    public void removeTransferListener(TransferListener listener) {
        this._listeners.remove(TransferListener.class, listener);
    }

    public boolean hasTransferListener(TransferListener listener) {
        return Arrays.asList(this._listeners.getListeners(TransferListener.class)).contains(listener);
    }

    protected void fireTransferEvent(TransferEvent evt) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$fr$jayasoft$ivy$repository$TransferListener == null ? Ivy.class$("fr.jayasoft.ivy.repository.TransferListener") : class$fr$jayasoft$ivy$repository$TransferListener)) continue;
            ((TransferListener)listeners[i + 1]).transferProgress(evt);
        }
    }

    public void addTrigger(Trigger trigger) {
        this.addIvyListener((IvyListener)trigger, trigger.getEventFilter());
    }

    public void addConfigured(Trigger trigger) {
        this.addTrigger(trigger);
    }

    public void addIvyListener(IvyListener listener) {
        this._listeners.add(IvyListener.class, listener);
    }

    public void addIvyListener(IvyListener listener, String eventName) {
        this.addIvyListener(listener, new IvyEventFilter(eventName, null, null));
    }

    public void addIvyListener(IvyListener listener, Filter filter) {
        this._listeners.add(IvyListener.class, new FilteredIvyListener(listener, filter));
    }

    public void removeIvyListener(IvyListener listener) {
        this._listeners.remove(IvyListener.class, listener);
        IvyListener[] listeners = (IvyListener[])this._listeners.getListeners(IvyListener.class);
        for (int i = 0; i < listeners.length; ++i) {
            if (!(listeners[i] instanceof FilteredIvyListener) || !listener.equals(((FilteredIvyListener)listeners[i]).getIvyListener())) continue;
            this._listeners.remove(class$fr$jayasoft$ivy$event$IvyListener == null ? Ivy.class$("fr.jayasoft.ivy.event.IvyListener") : class$fr$jayasoft$ivy$event$IvyListener, listeners[i]);
        }
    }

    public boolean hasIvyListener(IvyListener listener) {
        return Arrays.asList(this._listeners.getListeners(IvyListener.class)).contains(listener);
    }

    public void fireIvyEvent(IvyEvent evt) {
        Object[] listeners = this._listeners.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$fr$jayasoft$ivy$event$IvyListener == null ? Ivy.class$("fr.jayasoft.ivy.event.IvyListener") : class$fr$jayasoft$ivy$event$IvyListener)) continue;
            ((IvyListener)listeners[i + 1]).progress(evt);
        }
    }

    public void transferProgress(TransferEvent evt) {
        this.fireTransferEvent(evt);
        this.fireIvyEvent(evt);
    }

    public boolean isUseRemoteConfig() {
        return this._useRemoteConfig;
    }

    public void setUseRemoteConfig(boolean useRemoteConfig) {
        this._useRemoteConfig = useRemoteConfig;
    }

    public DependencyResolver getDictatorResolver() {
        return this._dictatorResolver;
    }

    public void setDictatorResolver(DependencyResolver dictatorResolver) {
        this._dictatorResolver = dictatorResolver;
    }

    public void setVariables(Map variables) {
        if (variables == null) {
            throw new NullPointerException("variables shouldn't be null");
        }
        this._variables = variables;
    }

    public static URL getDefaultConfigurationURL() {
        return Ivy.class.getResource("conf/ivyconf.xml");
    }

    public void saveResolver(File cache, ModuleDescriptor md, String name) {
        PropertiesFile cdf = this.getCachedDataFile(cache, md);
        cdf.setProperty("resolver", name);
        cdf.save();
    }

    public void saveArtResolver(File cache, ModuleDescriptor md, String name) {
        PropertiesFile cdf = this.getCachedDataFile(cache, md);
        cdf.setProperty("artifact.resolver", name);
        cdf.save();
    }

    public void saveArtifactOrigin(File cache, Artifact artifact, ArtifactOrigin origin) {
        PropertiesFile cdf = this.getCachedDataFile(cache, artifact.getModuleRevisionId());
        cdf.setProperty("artifact." + artifact.getName() + "#" + artifact.getExt() + ".is-local", String.valueOf(origin.isLocal()));
        cdf.setProperty("artifact." + artifact.getName() + "#" + artifact.getExt() + ".location", origin.getLocation());
        cdf.save();
    }

    public ArtifactOrigin getSavedArtifactOrigin(File cache, Artifact artifact) {
        PropertiesFile cdf = this.getCachedDataFile(cache, artifact.getModuleRevisionId());
        String location = cdf.getProperty("artifact." + artifact.getName() + "#" + artifact.getExt() + ".location");
        boolean isLocal = Boolean.valueOf(cdf.getProperty("artifact." + artifact.getName() + "#" + artifact.getExt() + ".is-local"));
        if (location == null) {
            return null;
        }
        return new ArtifactOrigin(isLocal, location);
    }

    public void removeSavedArtifactOrigin(File cache, Artifact artifact) {
        PropertiesFile cdf = this.getCachedDataFile(cache, artifact.getModuleRevisionId());
        cdf.remove("artifact." + artifact.getName() + "#" + artifact.getExt() + ".location");
        cdf.remove("artifact." + artifact.getName() + "#" + artifact.getExt() + ".is-local");
        cdf.save();
    }

    private String getSavedResolverName(File cache, ModuleDescriptor md) {
        PropertiesFile cdf = this.getCachedDataFile(cache, md);
        return cdf.getProperty("resolver");
    }

    private String getSavedArtResolverName(File cache, ModuleDescriptor md) {
        PropertiesFile cdf = this.getCachedDataFile(cache, md);
        return cdf.getProperty("artifact.resolver");
    }

    private PropertiesFile getCachedDataFile(File cache, ModuleDescriptor md) {
        return this.getCachedDataFile(cache, md.getResolvedModuleRevisionId());
    }

    private PropertiesFile getCachedDataFile(File cache, ModuleRevisionId mRevId) {
        return new PropertiesFile(new File(cache, IvyPatternHelper.substitute(this.getCacheDataFilePattern(), mRevId)), "ivy cached data file for " + mRevId);
    }

    public String getCacheDataFilePattern() {
        return this._cacheDataFilePattern;
    }

    public boolean logModuleWhenFound() {
        String var = this.getVariable("ivy.log.module.when.found");
        return var == null || Boolean.valueOf(var) != false;
    }

    public boolean logResolvedRevision() {
        String var = this.getVariable("ivy.log.resolved.revision");
        return var == null || Boolean.valueOf(var) != false;
    }

    public boolean debugConflictResolution() {
        if (this._debugConflictResolution == null) {
            String var = this.getVariable("ivy.log.conflict.resolution");
            this._debugConflictResolution = var != null && Boolean.valueOf(var) != false;
        }
        return this._debugConflictResolution;
    }

    public boolean logNotConvertedExclusionRule() {
        return this._logNotConvertedExclusionRule;
    }

    public void setLogNotConvertedExclusionRule(boolean logNotConvertedExclusionRule) {
        this._logNotConvertedExclusionRule = logNotConvertedExclusionRule;
    }

    public StatusManager getStatusManager() {
        if (this._statusManager == null) {
            this._statusManager = StatusManager.newDefaultInstance();
        }
        return this._statusManager;
    }

    public void setStatusManager(StatusManager statusManager) {
        this._statusManager = statusManager;
    }

    public synchronized boolean isInterrupted() {
        return this._interrupted;
    }

    public ModuleId[] listModules(ModuleId criteria, PatternMatcher matcher) {
        ArrayList<ModuleId> ret = new ArrayList<ModuleId>();
        Matcher orgMatcher = matcher.getMatcher(criteria.getOrganisation());
        Matcher modMatcher = matcher.getMatcher(criteria.getName());
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        String[] orgs = this.listTokenValues("organisation", tokenValues);
        for (int i = 0; i < orgs.length; ++i) {
            if (!orgMatcher.matches(orgs[i])) continue;
            tokenValues.put("organisation", orgs[i]);
            String[] mods = this.listTokenValues("module", tokenValues);
            for (int j = 0; j < mods.length; ++j) {
                if (!modMatcher.matches(mods[j])) continue;
                ret.add(new ModuleId(orgs[i], mods[j]));
            }
        }
        return ret.toArray(new ModuleId[ret.size()]);
    }

    public ModuleRevisionId[] listModules(ModuleRevisionId criteria, PatternMatcher matcher) {
        ArrayList<ModuleRevisionId> ret = new ArrayList<ModuleRevisionId>();
        Matcher orgMatcher = matcher.getMatcher(criteria.getOrganisation());
        Matcher modMatcher = matcher.getMatcher(criteria.getName());
        Matcher branchMatcher = matcher.getMatcher(criteria.getBranch());
        Matcher revMatcher = matcher.getMatcher(criteria.getRevision());
        HashMap<String, Object> tokenValues = new HashMap<String, Object>();
        String[] orgs = this.listTokenValues("organisation", tokenValues);
        for (int i = 0; i < orgs.length; ++i) {
            if (!orgMatcher.matches(orgs[i])) continue;
            tokenValues.put("organisation", orgs[i]);
            String[] mods = this.listTokenValues("module", tokenValues);
            for (int j = 0; j < mods.length; ++j) {
                if (!modMatcher.matches(mods[j])) continue;
                tokenValues.put("module", mods[j]);
                String[] branches = this.listTokenValues("branch", tokenValues);
                if (branches == null || branches.length == 0) {
                    branches = new String[]{this.getDefaultBranch(new ModuleId(orgs[i], mods[j]))};
                }
                for (int k = 0; k < branches.length; ++k) {
                    if (!branchMatcher.matches(branches[k])) continue;
                    tokenValues.put("branch", tokenValues);
                    String[] revs = this.listTokenValues("revision", tokenValues);
                    for (int l = 0; l < revs.length; ++l) {
                        if (!revMatcher.matches(revs[l])) continue;
                        ret.add(ModuleRevisionId.newInstance(orgs[i], mods[j], branches[k], revs[l]));
                    }
                }
            }
        }
        return ret.toArray(new ModuleRevisionId[ret.size()]);
    }

    private static class ModuleSettings {
        private String _resolverName;
        private String _branch;
        private String _conflictManager;

        public ModuleSettings(String resolverName, String branch, String conflictManager) {
            this._resolverName = resolverName;
            this._branch = branch;
            this._conflictManager = conflictManager;
        }

        public String toString() {
            return this._resolverName != null ? "resolver: " + this._resolverName : ("" + this._branch != null ? "branch: " + this._branch : "");
        }

        public String getBranch() {
            return this._branch;
        }

        public String getResolverName() {
            return this._resolverName;
        }

        protected String getConflictManager() {
            return this._conflictManager;
        }
    }
}

