%% Generated by the Erlang ASN.1 BER_V2-compiler version, utilizing bit-syntax:1.4.4.12
%% Purpose: encoder and decoder to the types in mod DSS

-module('DSS').
-include("DSS.hrl").
-define('RT_BER',asn1rt_ber_bin_v2).
-export([encoding_rule/0]).
-export([
'enc_DSAPrivateKey'/2
]).

-export([
'dec_DSAPrivateKey'/2
]).

-export([info/0]).


-export([encode/2,decode/2,encode_disp/2,decode_disp/2]).

encoding_rule() ->
   ber_bin_v2.

encode(Type,Data) ->
case catch encode_disp(Type,Data) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  {Bytes,_Len} ->
    {ok,Bytes};
  Bytes ->
    {ok,Bytes}
end.

decode(Type,Data) ->
case catch decode_disp(Type,element(1,?RT_BER:decode(Data))
) of
  {'EXIT',{error,Reason}} ->
    {error,Reason};
  {'EXIT',Reason} ->
    {error,{asn1,Reason}};
  Result ->
    {ok,Result}
end.

encode_disp('DSAPrivateKey',Data) -> 'enc_DSAPrivateKey'(Data);
encode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).


decode_disp('DSAPrivateKey',Data) -> 'dec_DSAPrivateKey'(Data);
decode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).





info() ->
  [{vsn,'1.4.4.12'},   {module,'DSS'},   {options,[ber_bin_v2,
 report_errors,
 {cwd,"/usr/obj/i386/erlang-11b.3/otp_src_R11B-3/lib/ssh/src"},
 {outdir,"/usr/obj/i386/erlang-11b.3/otp_src_R11B-3/lib/ssh/src"},
 noobj,
 optimize,
 compact_bit_string,
 der,
 {i,"."},
 {i,"/usr/obj/i386/erlang-11b.3/otp_src_R11B-3/lib/ssh/src"}]}].


%%================================
%%  DSAPrivateKey
%%================================
'enc_DSAPrivateKey'(Val) ->
    'enc_DSAPrivateKey'(Val, [<<48>>]).

'enc_DSAPrivateKey'(Val, TagIn) ->
{_,Cindex1, Cindex2, Cindex3, Cindex4, Cindex5, Cindex6} = Val,

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = ?RT_BER:encode_integer([], Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute p(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = ?RT_BER:encode_integer([], Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute q(3) with type INTEGER
%%-------------------------------------------------
   {EncBytes3,EncLen3} = ?RT_BER:encode_integer([], Cindex3, [<<2>>]),

%%-------------------------------------------------
%% attribute g(4) with type INTEGER
%%-------------------------------------------------
   {EncBytes4,EncLen4} = ?RT_BER:encode_integer([], Cindex4, [<<2>>]),

%%-------------------------------------------------
%% attribute y(5) with type INTEGER
%%-------------------------------------------------
   {EncBytes5,EncLen5} = ?RT_BER:encode_integer([], Cindex5, [<<2>>]),

%%-------------------------------------------------
%% attribute x(6) with type INTEGER
%%-------------------------------------------------
   {EncBytes6,EncLen6} = ?RT_BER:encode_integer([], Cindex6, [<<2>>]),

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4, EncBytes5, EncBytes6],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4 + EncLen5 + EncLen6,
?RT_BER:encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_DSAPrivateKey'(Tlv) ->
   'dec_DSAPrivateKey'(Tlv, [16]).

'dec_DSAPrivateKey'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = ?RT_BER:match_tags(Tlv,TagIn), 

%%-------------------------------------------------
%% attribute version(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = ?RT_BER:decode_integer(V1,[],[2]),

%%-------------------------------------------------
%% attribute p(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = ?RT_BER:decode_integer(V2,[],[2]),

%%-------------------------------------------------
%% attribute q(3) with type INTEGER
%%-------------------------------------------------
[V3|Tlv4] = Tlv3, 
Term3 = ?RT_BER:decode_integer(V3,[],[2]),

%%-------------------------------------------------
%% attribute g(4) with type INTEGER
%%-------------------------------------------------
[V4|Tlv5] = Tlv4, 
Term4 = ?RT_BER:decode_integer(V4,[],[2]),

%%-------------------------------------------------
%% attribute y(5) with type INTEGER
%%-------------------------------------------------
[V5|Tlv6] = Tlv5, 
Term5 = ?RT_BER:decode_integer(V5,[],[2]),

%%-------------------------------------------------
%% attribute x(6) with type INTEGER
%%-------------------------------------------------
[V6|Tlv7] = Tlv6, 
Term6 = ?RT_BER:decode_integer(V6,[],[2]),

case Tlv7 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv7}}}) % extra fields not allowed
end,
   {'DSAPrivateKey', Term1, Term2, Term3, Term4, Term5, Term6}.

