/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import javax.servlet.jsp.tagext.TagInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.TagConstants;
import org.apache.jasper.compiler.TagLibraryInfoImpl;
import org.apache.jasper.compiler.TldLocationsCache;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class JspDocumentParser
extends DefaultHandler
implements LexicalHandler,
TagConstants {
    private static final String XMLNS = "xmlns:";
    private static final String XMLNS_JSP = "xmlns:jsp";
    private static final String JSP_VERSION = "version";
    private static final String URN_JSPTLD = "urn:jsptld:";
    private static final String LEXICAL_HANDLER_PROPERTY = "http://xml.org/sax/properties/lexical-handler";
    private ParserController parserController;
    private JspCompilationContext ctxt;
    private InputSource inputSource;
    private String path;
    private Node current;
    private Locator locator;
    private Hashtable taglibs;
    private boolean inDTD;
    private ErrorDispatcher err;

    public JspDocumentParser(ParserController pc, String path, InputStreamReader reader) {
        this.parserController = pc;
        this.ctxt = pc.getJspCompilationContext();
        this.taglibs = pc.getCompiler().getPageInfo().getTagLibraries();
        this.err = pc.getCompiler().getErrorDispatcher();
        this.path = path;
        this.inputSource = new InputSource(reader);
    }

    public static Node.Nodes parse(ParserController pc, String path, InputStreamReader reader, Node parent) throws JasperException {
        JspDocumentParser handler = new JspDocumentParser(pc, path, reader);
        handler.current = parent;
        Node.Nodes pageNodes = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setProperty(LEXICAL_HANDLER_PROPERTY, handler);
            xmlReader.setErrorHandler(handler);
            saxParser.parse(handler.inputSource, (DefaultHandler)handler);
            pageNodes = parent == null ? new Node.Nodes((Node.JspRoot)handler.current) : parent.getBody();
        }
        catch (IOException ioe) {
            handler.err.jspError("jsp.error.data.file.read", path, ioe);
        }
        catch (Exception e) {
            handler.err.jspError(e);
        }
        return pageNodes;
    }

    public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
        Mark start = new Mark(this.path, this.locator.getLineNumber(), this.locator.getColumnNumber());
        AttributesImpl attrsCopy = new AttributesImpl(attrs);
        Node node = null;
        if (qName.equals("jsp:root")) {
            node = new Node.JspRoot(attrsCopy, start, this.current);
            try {
                this.addCustomTagLibraries(attrsCopy);
            }
            catch (JasperException je) {
                throw new SAXException((Exception)((Object)je));
            }
        } else if (qName.equals("jsp:directive.page")) {
            node = new Node.PageDirective(attrsCopy, start, this.current);
            String imports = attrs.getValue("import");
            if (imports != null) {
                ((Node.PageDirective)node).addImport(imports);
            }
        } else if (qName.equals("jsp:directive.include")) {
            node = new Node.IncludeDirective(attrsCopy, start, this.current);
            String file = attrsCopy.getValue("file");
            try {
                this.parserController.parse(file, node);
            }
            catch (FileNotFoundException fnfe) {
                throw new SAXParseException(this.err.getString("jsp.error.file.not.found", file), this.locator, fnfe);
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        } else if (qName.equals("jsp:declaration")) {
            node = new Node.Declaration(start, this.current);
        } else if (qName.equals("jsp:scriptlet")) {
            node = new Node.Scriptlet(start, this.current);
        } else if (qName.equals("jsp:expression")) {
            node = new Node.Expression(start, this.current);
        } else if (qName.equals("jsp:useBean")) {
            node = new Node.UseBean(attrsCopy, start, this.current);
        } else if (qName.equals("jsp:setProperty")) {
            node = new Node.SetProperty(attrsCopy, start, this.current);
        } else if (qName.equals("jsp:getProperty")) {
            node = new Node.GetProperty(attrsCopy, start, this.current);
        } else if (qName.equals("jsp:include")) {
            node = new Node.IncludeAction(attrsCopy, start, this.current);
        } else if (qName.equals("jsp:forward")) {
            node = new Node.ForwardAction(attrsCopy, start, this.current);
        } else if (qName.equals("jsp:param")) {
            node = new Node.ParamAction(attrsCopy, start, this.current);
        } else if (qName.equals("jsp:params")) {
            node = new Node.ParamsAction(start, this.current);
        } else if (qName.equals("jsp:plugin")) {
            node = new Node.PlugIn(attrsCopy, start, this.current);
        } else if (qName.equals("jsp:text")) {
            node = new Node.JspText(start, this.current);
        } else if (qName.equals("jsp:fallback")) {
            node = new Node.FallBackAction(start, this.current);
        } else {
            node = this.getCustomTag(qName, attrsCopy, start, this.current);
            if (node == null) {
                node = new Node.UninterpretedTag(attrsCopy, start, qName, this.current);
            }
        }
        this.current = node;
    }

    public void characters(char[] buf, int offset, int len) throws SAXException {
        boolean isAllSpace = true;
        if (!(this.current instanceof Node.JspText)) {
            for (int i = offset; i < offset + len; ++i) {
                if (Character.isSpace(buf[i])) continue;
                isAllSpace = false;
                break;
            }
        }
        if (this.current instanceof Node.JspText || !isAllSpace) {
            Mark start = new Mark(this.path, this.locator.getLineNumber(), this.locator.getColumnNumber());
            char[] bufCopy = new char[len];
            System.arraycopy(buf, offset, bufCopy, 0, len);
            new Node.TemplateText(bufCopy, start, this.current);
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (this.current instanceof Node.ScriptingElement) {
            this.checkScriptingBody(this.current.getBody());
        }
        if (this.current.getParent() != null) {
            this.current = this.current.getParent();
        }
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void comment(char[] buf, int offset, int len) throws SAXException {
        if (!this.inDTD) {
            Mark start = new Mark(this.path, this.locator.getLineNumber(), this.locator.getColumnNumber());
            char[] bufCopy = new char[len];
            System.arraycopy(buf, offset, bufCopy, 0, len);
            new Node.Comment(bufCopy, start, this.current);
        }
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void startEntity(String name) throws SAXException {
    }

    public void endEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.inDTD = true;
    }

    public void endDTD() throws SAXException {
        this.inDTD = false;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    private Node getCustomTag(String qName, Attributes attrs, Mark start, Node parent) throws SAXException {
        int colon = qName.indexOf(58);
        if (colon == -1) {
            return null;
        }
        String prefix = qName.substring(0, colon);
        String shortName = qName.substring(colon + 1);
        if (shortName.length() == 0) {
            return null;
        }
        TagLibraryInfo tagLibInfo = (TagLibraryInfo)this.taglibs.get(prefix);
        if (tagLibInfo == null) {
            return null;
        }
        TagInfo tagInfo = tagLibInfo.getTag(shortName);
        if (tagInfo == null) {
            throw new SAXException(this.err.getString("jsp.error.bad_tag", shortName, prefix));
        }
        Class<?> tagHandlerClass = null;
        try {
            tagHandlerClass = this.ctxt.getClassLoader().loadClass(tagInfo.getTagClassName());
        }
        catch (Exception e) {
            throw new SAXException(this.err.getString("jsp.error.unable.loadclass", shortName, prefix));
        }
        return new Node.CustomTag(attrs, start, qName, prefix, shortName, tagInfo, tagHandlerClass, parent);
    }

    private void addCustomTagLibraries(Attributes attrs) throws JasperException {
        int len = attrs.getLength();
        for (int i = 0; i < len; ++i) {
            TldLocationsCache cache;
            TagLibraryInfo tl;
            String qName = attrs.getQName(i);
            if (qName.startsWith(XMLNS_JSP) || qName.startsWith(JSP_VERSION)) continue;
            String prefix = null;
            try {
                prefix = qName.substring(XMLNS.length());
            }
            catch (StringIndexOutOfBoundsException e) {
                continue;
            }
            String uri = attrs.getValue(i);
            if (uri.startsWith(URN_JSPTLD)) {
                uri = uri.substring(URN_JSPTLD.length());
            }
            if ((tl = (cache = this.ctxt.getOptions().getTldLocationsCache()).getTagLibraryInfo(uri)) == null) {
                String[] location = this.ctxt.getTldLocation(uri);
                tl = new TagLibraryInfoImpl(this.ctxt, prefix, uri, location, this.err);
            }
            this.taglibs.put(prefix, tl);
        }
    }

    private void checkScriptingBody(Node.Nodes body) throws SAXException {
        if (body != null) {
            int size = body.size();
            for (int i = 0; i < size; ++i) {
                Node n = body.getNode(i);
                if (n instanceof Node.TemplateText) continue;
                String msg = this.err.getString("jsp.error.parse.xml.scripting.invalid.body");
                throw new SAXException(msg);
            }
        }
    }
}

