/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.core.IModelProviderListener;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginPathFinder;

public class ExternalModelManager {
    private Vector fListeners = new Vector();
    private IPluginModelBase[] fModels = new IPluginModelBase[0];

    public static String computeDefaultPlatformPath() {
        URL installURL = Platform.getInstallLocation().getURL();
        IPath ppath = new Path(installURL.getFile()).removeTrailingSeparator();
        return ExternalModelManager.getCorrectPath(ppath.toOSString());
    }

    public static boolean isTargetEqualToHost(String platformPath) {
        return ExternalModelManager.arePathsEqual((IPath)new Path(platformPath), (IPath)new Path(ExternalModelManager.computeDefaultPlatformPath()));
    }

    /*
     * Unable to fully structure code
     */
    private static String getCorrectPath(String path) {
        buf = new StringBuffer();
        i = 0;
        while (i < path.length()) {
            block3: {
                c = path.charAt(i);
                if (Platform.getOS().equals("win32") && i == 0 && c == '/') break block3;
                if (c != '%' || i + 2 >= path.length()) ** GOTO lbl-1000
                c1 = path.charAt(i + 1);
                c2 = path.charAt(i + 2);
                if (c1 == '2' && c2 == '0') {
                    i += 2;
                    buf.append(" ");
                } else lbl-1000:
                // 2 sources

                {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static IPath getEclipseHome() {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        return new Path(preferences.getString("platform_path"));
    }

    public static boolean arePathsEqual(IPath path1, IPath path2) {
        String device = path1.getDevice();
        if (device != null) {
            path1 = path1.setDevice(device.toUpperCase());
        }
        if ((device = path2.getDevice()) != null) {
            path2 = path2.setDevice(device.toUpperCase());
        }
        return path1.equals((Object)path2);
    }

    public void addModelProviderListener(IModelProviderListener listener) {
        this.fListeners.add(listener);
    }

    private Vector createSavedList(String saved) {
        Vector<String> result = new Vector<String>();
        StringTokenizer stok = new StringTokenizer(saved);
        while (stok.hasMoreTokens()) {
            result.add(stok.nextToken());
        }
        return result;
    }

    private void enableAll() {
        int i = 0;
        while (i < this.fModels.length) {
            this.fModels[i].setEnabled(true);
            ++i;
        }
    }

    public void fireModelProviderEvent(IModelProviderEvent e) {
        for (IModelProviderListener listener : this.fListeners) {
            listener.modelsChanged(e);
        }
    }

    protected IPluginModelBase[] getAllModels() {
        return this.fModels;
    }

    protected void initializeModels(IPluginModelBase[] models) {
        this.fModels = models;
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        String saved = pref.getString("checkedPlugins");
        if (saved.equals("[savedAll]")) {
            this.enableAll();
        } else if (!saved.equals("[savedNone]")) {
            Vector list = this.createSavedList(saved);
            int i = 0;
            while (i < this.fModels.length) {
                this.fModels[i].setEnabled(!list.contains(this.fModels[i].getPluginBase().getId()));
                ++i;
            }
        }
    }

    public void setModels(IPluginModelBase[] models) {
        this.fModels = models;
    }

    public static URL[] getPluginPaths() {
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        URL[] base = PluginPathFinder.getPluginPaths(pref.getString("platform_path"));
        String value = pref.getString("additional_locations");
        StringTokenizer tokenizer = new StringTokenizer(value, ",");
        if (tokenizer.countTokens() == 0) {
            return base;
        }
        File[] extraLocations = new File[tokenizer.countTokens()];
        int i = 0;
        while (i < extraLocations.length) {
            String location = tokenizer.nextToken();
            File dir = new File(location, "plugins");
            if (!dir.exists() || !dir.isDirectory()) {
                dir = new File(location);
            }
            extraLocations[i] = dir;
            ++i;
        }
        URL[] additional = PluginPathFinder.scanLocations(extraLocations);
        if (additional.length == 0) {
            return base;
        }
        URL[] result = new URL[base.length + additional.length];
        System.arraycopy(base, 0, result, 0, base.length);
        System.arraycopy(additional, 0, result, base.length, additional.length);
        return result;
    }

    public void removeModelProviderListener(IModelProviderListener listener) {
        this.fListeners.remove(listener);
    }

    public void shutdown() {
        int disabled = 0;
        StringBuffer saved = new StringBuffer();
        int i = 0;
        while (i < this.fModels.length) {
            IPluginModelBase model = this.fModels[i];
            if (!model.isEnabled()) {
                ++disabled;
                if (saved.length() > 0) {
                    saved.append(" ");
                }
                saved.append(model.getPluginBase().getId());
            }
            ++i;
        }
        Preferences pref = PDECore.getDefault().getPluginPreferences();
        if (disabled == 0) {
            pref.setValue("checkedPlugins", "[savedAll]");
        } else if (disabled == this.fModels.length) {
            pref.setValue("checkedPlugins", "[savedNone]");
        } else {
            pref.setValue("checkedPlugins", saved.toString());
        }
        PDECore.getDefault().savePluginPreferences();
    }
}

