/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.presentations;

import java.util.ArrayList;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.internal.presentations.AbstractTableInformationControl;
import org.eclipse.ui.internal.presentations.defaultpresentation.DefaultTabItem;
import org.eclipse.ui.internal.presentations.util.AbstractTabItem;
import org.eclipse.ui.internal.presentations.util.PresentablePartFolder;
import org.eclipse.ui.presentations.IPresentablePart;
import org.eclipse.ui.presentations.IStackPresentationSite;

public class BasicPartList
extends AbstractTableInformationControl {
    private boolean hiddenTabsBold = true;
    private PresentablePartFolder folder;
    private IStackPresentationSite site;

    public BasicPartList(Shell parent, int shellStyle, int treeStyle, IStackPresentationSite site, PresentablePartFolder folder) {
        super(parent, shellStyle, treeStyle);
        this.site = site;
        this.folder = folder;
    }

    protected TableViewer createTableViewer(Composite parent, int style) {
        Table table = new Table(parent, 4 | style & 0xFFFFFFFD);
        table.setLayoutData((Object)new GridData(2));
        TableViewer tableViewer = new TableViewer(table){

            protected void internalRefresh(Object element) {
                boolean usingMotif = "motif".equals(SWT.getPlatform());
                try {
                    if (usingMotif) {
                        this.getTable().setRedraw(false);
                    }
                    super.internalRefresh(element);
                }
                finally {
                    if (usingMotif) {
                        this.getTable().setRedraw(true);
                    }
                }
            }
        };
        tableViewer.addFilter((ViewerFilter)new AbstractTableInformationControl.NamePatternFilter());
        tableViewer.setContentProvider((IContentProvider)new BasicStackListContentProvider());
        tableViewer.setSorter((ViewerSorter)new BasicStackListViewerSorter());
        tableViewer.setLabelProvider((IBaseLabelProvider)new BasicStackListLabelProvider());
        return tableViewer;
    }

    public void setInput(Object information) {
        PresentablePartFolder newFolder = (PresentablePartFolder)information;
        this.inputChanged(newFolder, newFolder.getCurrent());
    }

    protected void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        this.dispose();
        if (selectedElement instanceof IPresentablePart) {
            this.site.selectPart((IPresentablePart)selectedElement);
        }
    }

    protected boolean deleteSelectedElements() {
        IStructuredSelection structuredSelection = this.getSelectedElements();
        if (structuredSelection != null) {
            ArrayList<IPresentablePart> list = new ArrayList<IPresentablePart>(structuredSelection.size());
            for (IPresentablePart presentablePart : structuredSelection) {
                list.add(presentablePart);
            }
            this.site.close(list.toArray(new IPresentablePart[list.size()]));
        }
        if (this.folder.isDisposed()) {
            this.fComposite.dispose();
            return true;
        }
        return false;
    }

    private class BasicStackListContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (BasicPartList.this.folder == null) {
                return new IPresentablePart[0];
            }
            return BasicPartList.this.folder.getPartList();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            BasicPartList.this.folder = (PresentablePartFolder)newInput;
        }
    }

    private class BasicStackListLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private Font boldFont = null;

        public String getText(Object element) {
            IPresentablePart presentablePart = (IPresentablePart)element;
            if (presentablePart.isDirty()) {
                return String.valueOf(DefaultTabItem.DIRTY_PREFIX) + presentablePart.getName();
            }
            return presentablePart.getName();
        }

        public Image getImage(Object element) {
            IPresentablePart presentablePart = (IPresentablePart)element;
            return presentablePart.getTitleImage();
        }

        public Font getFont(Object element) {
            IPresentablePart presentablePart = (IPresentablePart)element;
            AbstractTabItem item = BasicPartList.this.folder.getTab(presentablePart);
            if (item != null && item.isShowing() || !BasicPartList.this.hiddenTabsBold) {
                return BasicPartList.this.folder.getTabFolder().getControl().getFont();
            }
            if (this.boldFont == null) {
                Control control = BasicPartList.this.folder.getTabFolder().getControl();
                Font originalFont = control.getFont();
                FontData[] fontData = originalFont.getFontData();
                int i = 0;
                while (i < fontData.length) {
                    fontData[i].setStyle(fontData[i].getStyle() | 1);
                    ++i;
                }
                this.boldFont = new Font((Device)control.getDisplay(), fontData);
            }
            return this.boldFont;
        }

        public void dispose() {
            super.dispose();
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
        }
    }

    private class BasicStackListViewerSorter
    extends ViewerSorter {
        public int compare(Viewer viewer, Object e1, Object e2) {
            String name2;
            String name1;
            int cat2;
            int cat1 = this.category(e1);
            if (cat1 != (cat2 = this.category(e2))) {
                return cat1 - cat2;
            }
            if (viewer == null || !(viewer instanceof ContentViewer)) {
                name1 = e1.toString();
                name2 = e2.toString();
            } else {
                IBaseLabelProvider prov = ((ContentViewer)viewer).getLabelProvider();
                if (prov instanceof ILabelProvider) {
                    ILabelProvider lprov = (ILabelProvider)prov;
                    name1 = lprov.getText(e1);
                    name2 = lprov.getText(e2);
                    String prefix = DefaultTabItem.DIRTY_PREFIX;
                    if (name1.startsWith(prefix)) {
                        name1 = name1.substring(prefix.length());
                    }
                    if (name2.startsWith(prefix)) {
                        name2 = name2.substring(prefix.length());
                    }
                } else {
                    name1 = e1.toString();
                    name2 = e2.toString();
                }
            }
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.collator.compare(name1, name2);
        }

        public int category(Object element) {
            IPresentablePart part = (IPresentablePart)element;
            AbstractTabItem tabItem = BasicPartList.this.folder.getTab(part);
            if (tabItem != null && tabItem.isShowing()) {
                return 1;
            }
            return 0;
        }
    }
}

