/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaPatternBreakpoint;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaTargetPatternBreakpoint;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class JavaBreakpointWorkbenchAdapterFactory
implements IAdapterFactory {
    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adapterType != IWorkbenchAdapter.class || !(adaptableObject instanceof IJavaBreakpoint)) {
            return null;
        }
        return new IWorkbenchAdapter(){
            private JavaElementLabelProvider fJavaLabelProvider;

            public Object[] getChildren(Object o) {
                return null;
            }

            public ImageDescriptor getImageDescriptor(Object object) {
                return null;
            }

            public String getLabel(Object o) {
                if (!(o instanceof IJavaBreakpoint)) {
                    return null;
                }
                IJavaBreakpoint breakpoint = (IJavaBreakpoint)o;
                StringBuffer label = new StringBuffer();
                try {
                    String type = breakpoint.getTypeName();
                    if (type != null) {
                        label.append(type);
                    }
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.log(e);
                }
                if (breakpoint instanceof IJavaPatternBreakpoint) {
                    try {
                        label.append(((IJavaPatternBreakpoint)breakpoint).getSourceName());
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                } else if (breakpoint instanceof IJavaTargetPatternBreakpoint) {
                    try {
                        label.append(((IJavaTargetPatternBreakpoint)breakpoint).getSourceName());
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                } else if (breakpoint instanceof IJavaStratumLineBreakpoint) {
                    try {
                        label.append(((IJavaStratumLineBreakpoint)breakpoint).getSourceName());
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                }
                if (breakpoint instanceof IJavaLineBreakpoint) {
                    IJavaLineBreakpoint lineBreakpoint = (IJavaLineBreakpoint)breakpoint;
                    try {
                        int lineNumber = lineBreakpoint.getLineNumber();
                        if (lineNumber != -1) {
                            label.append(DebugUIMessages.JavaBreakpointWorkbenchAdapterFactory_1);
                            label.append(lineNumber);
                            label.append(']');
                        }
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                    try {
                        IMember member = BreakpointUtils.getMember(lineBreakpoint);
                        if (member != null) {
                            label.append(" - ");
                            label.append(this.getJavaLabelProvider().getText((Object)member));
                        }
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                }
                return label.toString();
            }

            public Object getParent(Object o) {
                return null;
            }

            protected JavaElementLabelProvider getJavaLabelProvider() {
                if (this.fJavaLabelProvider == null) {
                    this.fJavaLabelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
                }
                return this.fJavaLabelProvider;
            }
        };
    }

    public Class[] getAdapterList() {
        return new Class[]{IWorkbenchAdapter.class};
    }
}

