/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.provisional;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.IncludedFeatureReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.model.DefaultSiteParser;
import org.eclipse.update.core.model.FeatureModel;
import org.eclipse.update.core.model.FeatureModelFactory;
import org.eclipse.update.core.model.ImportModel;
import org.eclipse.update.core.model.PluginEntryModel;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.internal.core.ExtendedSiteURLFactory;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.jarprocessor.JarProcessor;
import org.eclipse.update.internal.jarprocessor.Main;
import org.xml.sax.SAXException;

public class SiteOptimizerApplication
implements IPlatformRunnable {
    public static final Integer EXIT_ERROR = new Integer(1);
    public static final String JAR_PROCESSOR = "-jarProcessor";
    public static final String DIGEST_BUILDER = "-digestBuilder";
    public static final String INPUT = "input";
    public static final String OUTPUT_DIR = "-outputDir";
    public static final String VERBOSE = "-verbose";
    public static final String JAR_PROCESSOR_PACK = "-pack";
    public static final String JAR_PROCESSOR_UNPACK = "-unpack";
    public static final String JAR_PROCESSOR_REPACK = "-repack";
    public static final String JAR_PROCESSOR_SIGN = "-sign";
    public static final String JAR_PROCESSOR_PROCESS_ALL = "-processAll";
    public static final String SITE_XML = "-siteXML";
    public static final String SITE_ATTRIBUTES_FILE = "siteAttributes.txt";
    public static final String DIGEST_OUTPUT_DIR = "-digestOutputDir";

    private Map parseCmdLine(String[] args) {
        HashMap<String, String> cmds = new HashMap<String, String>();
        int i = 0;
        while (i < args.length) {
            if (i == args.length - 1 && !args[i].startsWith("-")) {
                cmds.put(INPUT, args[i]);
            } else {
                String key = args[i];
                String val = null;
                if (i < args.length - 2 && !args[i + 1].startsWith("-")) {
                    val = args[++i];
                }
                if (key.startsWith(SITE_XML)) {
                    val = key.substring(key.indexOf("=") + 1);
                    cmds.put(SITE_XML, val);
                } else if (key.startsWith(DIGEST_OUTPUT_DIR)) {
                    val = key.substring(key.indexOf("=") + 1);
                    cmds.put(DIGEST_OUTPUT_DIR, val);
                } else {
                    cmds.put(key, val);
                }
            }
            ++i;
        }
        return cmds;
    }

    private boolean runJarProcessor(Map params) {
        Main.Options options = new Main.Options();
        options.pack = params.containsKey(JAR_PROCESSOR_PACK);
        options.unpack = params.containsKey(JAR_PROCESSOR_UNPACK);
        options.repack = params.containsKey(JAR_PROCESSOR_REPACK);
        options.processAll = params.containsKey(JAR_PROCESSOR_PROCESS_ALL);
        options.verbose = params.containsKey(VERBOSE);
        options.signCommand = (String)params.get(JAR_PROCESSOR_SIGN);
        options.outputDir = (String)params.get(OUTPUT_DIR);
        String problem = null;
        String input = (String)params.get(INPUT);
        if (input == null) {
            problem = Messages.SiteOptimizer_inputNotSpecified;
        } else {
            File inputFile = new File(input);
            if (inputFile.exists()) {
                options.input = inputFile;
            } else {
                problem = NLS.bind((String)Messages.SiteOptimizer_inputFileNotFound, (Object[])new String[]{input});
            }
        }
        if (options.unpack) {
            if (!JarProcessor.canPerformUnpack()) {
                problem = Messages.JarProcessor_unpackNotFound;
            } else if (options.pack || options.repack || options.signCommand != null) {
                problem = Messages.JarProcessor_noPackUnpack;
            }
        } else if ((options.pack || options.repack) && !JarProcessor.canPerformPack()) {
            problem = Messages.JarProcessor_packNotFound;
        }
        if (problem != null) {
            System.out.println(problem);
            return false;
        }
        Main.runJarProcessor(options);
        return true;
    }

    private boolean runDigestBuilder(Map params) {
        List featureList = this.getFeatureList(params);
        if (featureList == null || featureList.isEmpty()) {
            System.out.println("no features to process");
            return false;
        }
        HashMap perFeatureLocales = new HashMap();
        Map availableLocales = this.getAvailableLocales(featureList, perFeatureLocales);
        try {
            this.openInputStremas(availableLocales);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            System.out.println("Can not create file in output direcotry");
            return false;
        }
        int i = 0;
        while (i < featureList.size()) {
            String featureJarFileName = (String)featureList.get(i);
            if (!featureJarFileName.endsWith("jar")) {
                System.out.println("Skipping... " + featureJarFileName);
            } else {
                System.out.println("Processing... " + featureJarFileName);
                JarFile featureJar = null;
                try {
                    featureJar = new JarFile(featureJarFileName);
                }
                catch (IOException e) {
                    System.out.println("Problem with openning jar: " + featureJarFileName);
                    e.printStackTrace();
                    return false;
                }
                FeatureModelFactory fmf = new FeatureModelFactory();
                try {
                    ZipEntry featureXMLEntry = featureJar.getEntry("feature.xml");
                    Map featureProperties = this.loadProperties(featureJar, featureJarFileName, perFeatureLocales);
                    FeatureModel featureModel = fmf.parseFeature(featureJar.getInputStream(featureXMLEntry));
                    featureList = this.addFeaturesToList((String)params.get(SITE_XML), featureList, featureModel.getFeatureIncluded(), availableLocales, perFeatureLocales);
                    Iterator availableLocalesIterator = availableLocales.values().iterator();
                    while (availableLocalesIterator.hasNext()) {
                        ((AvailableLocale)availableLocalesIterator.next()).writeFeatureDigests(featureModel, featureProperties);
                    }
                }
                catch (SAXException e) {
                    e.printStackTrace();
                    return false;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            ++i;
        }
        Iterator availableLocalesIterator = availableLocales.values().iterator();
        String outputDirectory = (String)params.get(DIGEST_OUTPUT_DIR);
        if (!(outputDirectory = outputDirectory.substring(outputDirectory.indexOf("=") + 1)).endsWith(File.separator)) {
            outputDirectory = String.valueOf(outputDirectory) + File.separator;
        }
        while (availableLocalesIterator.hasNext()) {
            try {
                ((AvailableLocale)availableLocalesIterator.next()).finishDigest(outputDirectory);
            }
            catch (IOException e) {
                System.out.println("Can not write in digest output directory: " + outputDirectory);
                e.printStackTrace();
                return false;
            }
        }
        System.out.println("Done");
        return true;
    }

    private List addFeaturesToList(String siteXML, List featureList, IIncludedFeatureReference[] iIncludedFeatureReferences, Map availableLocales, Map perFeatureLocales) throws CoreException {
        String directoryName = new File(siteXML).getParent();
        if (!directoryName.endsWith(File.separator)) {
            directoryName = String.valueOf(directoryName) + File.separator;
        }
        directoryName = String.valueOf(directoryName) + "features" + File.separator;
        int i = 0;
        while (i < iIncludedFeatureReferences.length) {
            block6: {
                String featureURL = String.valueOf(directoryName) + iIncludedFeatureReferences[i].getVersionedIdentifier() + ".jar";
                if (!this.isFeatureAlreadyInList(featureList, featureURL)) {
                    try {
                        System.out.println("Extracting locales from inlcuded feature " + featureURL);
                        this.processLocalesInJar(availableLocales, featureURL, perFeatureLocales, true);
                    }
                    catch (IOException e) {
                        if (!iIncludedFeatureReferences[i].isOptional()) {
                            System.out.println("Error while extracting locales from inlcuded feature " + featureURL);
                            e.printStackTrace();
                            throw new CoreException((IStatus)new Status(4, "", 0, "Error while extracting locales from inlcuded feature " + featureURL, (Throwable)e));
                        }
                        break block6;
                    }
                    featureList.add(featureURL);
                }
            }
            ++i;
        }
        return featureList;
    }

    private boolean isFeatureAlreadyInList(List featureList, String featureURL) {
        int i = 0;
        while (i < featureList.size()) {
            String currentFeatureURL = (String)featureList.get(i);
            if (currentFeatureURL.equals(featureURL)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Map loadProperties(JarFile featureJar, String featureJarFileName, Map perFeatureLocales) {
        Iterator it = ((List)perFeatureLocales.get(featureJarFileName)).iterator();
        HashMap<String, Properties> result = new HashMap<String, Properties>();
        while (it.hasNext()) {
            String propertyFileName = (String)it.next();
            ZipEntry featurePropertiesEntry = featureJar.getEntry(propertyFileName);
            Properties featureProperties = new Properties();
            if (featurePropertiesEntry == null) continue;
            try {
                featureProperties.load(featureJar.getInputStream(featurePropertiesEntry));
                String localeString = null;
                localeString = propertyFileName.endsWith("feature.properties") ? "" : propertyFileName.substring(8, propertyFileName.indexOf(46));
                result.put(localeString, featureProperties);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    private void openInputStremas(Map availableLocales) throws IOException {
        for (AvailableLocale availableLocale : availableLocales.values()) {
            availableLocale.openLocalizedOutputStream();
        }
    }

    private Map getAvailableLocales(List featureList, Map perFeatureLocales) {
        Iterator features = featureList.iterator();
        HashMap locales = new HashMap();
        while (features.hasNext()) {
            String feature = (String)features.next();
            try {
                System.out.println("Extracting locales from " + feature);
                this.processLocalesInJar(locales, feature, perFeatureLocales, false);
            }
            catch (IOException e) {
                System.out.println("Error while extracting locales from " + feature);
                e.printStackTrace();
                return null;
            }
        }
        return locales;
    }

    private void processLocalesInJar(Map locales, String feature, Map perFeatureLocales, boolean ignoreNewLocales) throws IOException {
        JarFile jar = new JarFile(feature);
        Enumeration<JarEntry> files = jar.entries();
        ArrayList<String> localesTemp = new ArrayList<String>();
        perFeatureLocales.put(feature, localesTemp);
        while (files.hasMoreElements()) {
            ZipEntry file = files.nextElement();
            String localeString = null;
            String name = file.getName();
            if (!name.startsWith("feature") || !name.endsWith(".properties")) continue;
            localesTemp.add(name);
            localeString = name.endsWith("feature.properties") ? "" : name.substring(8, name.indexOf(46));
            if (!ignoreNewLocales && !locales.containsKey(localeString)) {
                locales.put(localeString, new AvailableLocale(localeString));
            }
            if (!locales.containsKey(localeString)) continue;
            AvailableLocale currentLocale = (AvailableLocale)locales.get(localeString);
            currentLocale.addFeatures(feature);
        }
    }

    private List getFeatureList(Map params) {
        if (params.containsKey(SITE_XML) && this.fileExists((String)params.get(SITE_XML))) {
            return this.getFeatureListFromSiteXML((String)params.get(SITE_XML));
        }
        if (params.containsKey(INPUT) && this.isDirectory((String)params.get(INPUT))) {
            return this.getFeatureListFromDirectory((String)params.get(INPUT));
        }
        return null;
    }

    private boolean fileExists(String fileName) {
        File file = new File(fileName);
        return file != null && file.exists();
    }

    private List getFeatureListFromDirectory(String directoryName) {
        ArrayList<String> featuresURLs = new ArrayList<String>();
        File directory = new File(directoryName);
        String[] featureJarFileNames = directory.list();
        int i = 0;
        while (i < featureJarFileNames.length) {
            featuresURLs.add(String.valueOf(directoryName) + File.separator + featureJarFileNames[i]);
            ++i;
        }
        return featuresURLs;
    }

    private boolean isDirectory(String fileName) {
        File directory = new File(fileName);
        return directory != null && directory.exists() && directory.isDirectory();
    }

    private List getFeatureListFromSiteXML(String siteXML) {
        ArrayList<String> featuresURLs = new ArrayList<String>();
        String directoryName = new File(siteXML).getParent();
        if (!directoryName.endsWith(File.separator)) {
            directoryName = String.valueOf(directoryName) + File.separator;
        }
        DefaultSiteParser siteParser = new DefaultSiteParser();
        siteParser.init(new ExtendedSiteURLFactory());
        try {
            SiteModel site = siteParser.parse(new FileInputStream(siteXML));
            site.getFeatureReferenceModels()[1].getURLString();
            SiteFeatureReferenceModel[] featureReferenceModel = site.getFeatureReferenceModels();
            int i = 0;
            while (i < featureReferenceModel.length) {
                featuresURLs.add(String.valueOf(directoryName) + featureReferenceModel[i].getURLString());
                ++i;
            }
            return featuresURLs;
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found: " + e.getMessage());
            e.printStackTrace();
        }
        catch (SAXException e) {
            System.out.println("Parsing problem: " + e.getMessage());
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println("Problem while parsing: " + e.getMessage());
            e.printStackTrace();
        }
        return null;
    }

    public Object run(Object args) throws Exception {
        Platform.endSplash();
        if (args == null) {
            return EXIT_ERROR;
        }
        if (args instanceof String[]) {
            Map params = this.parseCmdLine((String[])args);
            if (params.containsKey(JAR_PROCESSOR) && !this.runJarProcessor(params)) {
                return EXIT_ERROR;
            }
            if (params.containsKey(DIGEST_BUILDER) && !this.runDigestBuilder(params)) {
                return EXIT_ERROR;
            }
        }
        return IPlatformRunnable.EXIT_OK;
    }

    public static void writeFeatureDigest(PrintStream digest, FeatureModel featureModel, Properties featureProperties) {
        String label = null;
        String provider = null;
        String description = null;
        String license = null;
        String copyright = null;
        label = featureProperties != null && featureModel.getLabel().startsWith("%") ? featureProperties.getProperty(featureModel.getLabel().substring(1)) : featureModel.getLabel();
        description = featureProperties != null && featureModel.getDescriptionModel() != null && featureModel.getDescriptionModel().getAnnotation().startsWith("%") ? featureProperties.getProperty(featureModel.getDescriptionModel().getAnnotation().substring(1)) : featureModel.getDescriptionModel().getAnnotation();
        provider = featureProperties != null && featureModel.getProvider().startsWith("%") ? featureProperties.getProperty(featureModel.getProvider().substring(1)) : featureModel.getProvider();
        copyright = featureProperties != null && featureModel.getCopyrightModel() != null && featureModel.getCopyrightModel().getAnnotation().startsWith("%") ? featureProperties.getProperty(featureModel.getCopyrightModel().getAnnotation().substring(1)) : (featureModel.getCopyrightModel() != null ? featureModel.getCopyrightModel().getAnnotation() : null);
        license = featureProperties != null && featureModel.getLicenseModel() != null && featureModel.getLicenseModel().getAnnotation().startsWith("%") ? featureProperties.getProperty(featureModel.getLicenseModel().getAnnotation().substring(1)) : featureModel.getLicenseModel().getAnnotation();
        digest.print("<feature ");
        digest.print("label=\"" + label + "\" ");
        digest.print("provider-name=\"" + provider + "\" ");
        digest.print("id=\"" + featureModel.getFeatureIdentifier() + "\" ");
        digest.print("version=\"" + featureModel.getFeatureVersion() + "\" ");
        if (featureModel.getOS() != null) {
            digest.print("os=\"" + featureModel.getOS() + "\" ");
        }
        if (featureModel.getNL() != null) {
            digest.print("nl=\"" + featureModel.getNL() + "\" ");
        }
        if (featureModel.getWS() != null) {
            digest.print("ws=\"" + featureModel.getWS() + "\" ");
        }
        if (featureModel.getOSArch() != null) {
            digest.print("arch=\"" + featureModel.getOSArch() + "\" ");
        }
        if (featureModel.isExclusive()) {
            digest.print("exclusive=\"" + featureModel.isExclusive() + "\" ");
        }
        if (!(featureModel.getImportModels() != null && featureModel.getImportModels().length != 0 || featureModel.getDescriptionModel() != null && featureModel.getDescriptionModel().getAnnotation() != null && featureModel.getDescriptionModel().getAnnotation().trim().length() != 0 || featureModel.getCopyrightModel() != null && featureModel.getCopyrightModel().getAnnotation() != null && featureModel.getCopyrightModel().getAnnotation().trim().length() != 0 || featureModel.getLicenseModel() != null && featureModel.getLicenseModel().getAnnotation() != null && featureModel.getLicenseModel().getAnnotation().trim().length() != 0 || featureModel.getFeatureIncluded() != null && featureModel.getFeatureIncluded().length != 0)) {
            digest.println("/> ");
        } else {
            IIncludedFeatureReference[] inlcudedFeatures;
            PluginEntryModel[] plugins;
            digest.println("> ");
            if (featureModel.getImportModels().length > 0) {
                digest.println("\t<requires> ");
                ImportModel[] imports = featureModel.getImportModels();
                int j = 0;
                while (j < imports.length) {
                    digest.print("\t\t<import ");
                    if (imports[j].isFeatureImport()) {
                        digest.print("feature=\"");
                    } else {
                        digest.print("plugin=\"");
                    }
                    digest.print(String.valueOf(imports[j].getIdentifier()) + "\" ");
                    digest.print("version=\"");
                    digest.print(String.valueOf(imports[j].getVersion()) + "\" ");
                    digest.print("match=\"");
                    digest.print(String.valueOf(imports[j].getMatchingRuleName()) + "\" ");
                    if (imports[j].isPatch()) {
                        digest.print("patch=\"true\" ");
                    }
                    digest.println(" />");
                    ++j;
                }
                digest.println("\t</requires>");
            }
            if (featureModel.getDescriptionModel() != null && featureModel.getDescriptionModel().getAnnotation() != null && featureModel.getDescriptionModel().getAnnotation().trim().length() != 0) {
                digest.println("\t<description>");
                digest.println("\t\t" + UpdateManagerUtils.getWritableXMLString(description));
                digest.println("\t</description>");
            }
            if (featureModel.getCopyrightModel() != null && featureModel.getCopyrightModel().getAnnotation() != null) {
                digest.println("\t<copyright>");
                digest.println("\t\t" + UpdateManagerUtils.getWritableXMLString(copyright));
                digest.println("\t</copyright>");
            }
            if (featureModel.getLicenseModel() != null && featureModel.getLicenseModel().getAnnotation() != null && featureModel.getDescriptionModel().getAnnotation().trim().length() != 0) {
                digest.println("\t<license>");
                digest.println("\t\t" + UpdateManagerUtils.getWritableXMLString(license));
                digest.println("\t</license>");
            }
            if ((plugins = featureModel.getPluginEntryModels()) != null && plugins.length != 0) {
                int i = 0;
                while (i < plugins.length) {
                    digest.print("\t<plugin ");
                    digest.print("id=\"" + plugins[i].getPluginIdentifier() + "\" ");
                    digest.print("version=\"" + plugins[i].getPluginVersion() + "\" ");
                    if (plugins[i].getOS() != null) {
                        digest.print("os=\"" + plugins[i].getOS() + "\" ");
                    }
                    if (plugins[i].getNL() != null) {
                        digest.print("nl=\"" + plugins[i].getNL() + "\" ");
                    }
                    if (plugins[i].getWS() != null) {
                        digest.print("ws=\"" + plugins[i].getWS() + "\" ");
                    }
                    if (plugins[i].getOSArch() != null) {
                        digest.print("arch=\"" + plugins[i].getOSArch() + "\" ");
                    }
                    if (plugins[i].getDownloadSize() > 0L) {
                        digest.print("download-size=\"" + plugins[i].getDownloadSize() + "\" ");
                    }
                    if (plugins[i].getInstallSize() > 0L) {
                        digest.print("install-size=\"" + plugins[i].getInstallSize() + "\" ");
                    }
                    if (!plugins[i].isUnpack()) {
                        digest.print("unpack=\"" + plugins[i].isUnpack() + "\" ");
                    }
                    digest.println("/> ");
                    ++i;
                }
            }
            if ((inlcudedFeatures = featureModel.getFeatureIncluded()) != null && inlcudedFeatures.length != 0) {
                int i = 0;
                while (i < inlcudedFeatures.length) {
                    try {
                        digest.print("\t<includes ");
                        digest.print("id=\"" + inlcudedFeatures[i].getVersionedIdentifier().getIdentifier() + "\" ");
                        digest.print("version=\"" + inlcudedFeatures[i].getVersionedIdentifier().getVersion() + "\" ");
                        if (inlcudedFeatures[i].getOS() != null) {
                            digest.print("os=\"" + inlcudedFeatures[i].getOS() + "\" ");
                        }
                        if (inlcudedFeatures[i].getNL() != null) {
                            digest.print("nl=\"" + inlcudedFeatures[i].getNL() + "\" ");
                        }
                        if (inlcudedFeatures[i].getWS() != null) {
                            digest.print("ws=\"" + inlcudedFeatures[i].getWS() + "\" ");
                        }
                        if (inlcudedFeatures[i].getOSArch() != null) {
                            digest.print("arch=\"" + inlcudedFeatures[i].getOSArch() + "\" ");
                        }
                        if (inlcudedFeatures[i] instanceof IncludedFeatureReference && ((IncludedFeatureReference)inlcudedFeatures[i]).getLabel() != null) {
                            digest.print("name=\"" + inlcudedFeatures[i].getName() + "\" ");
                        }
                        if (inlcudedFeatures[i].isOptional()) {
                            digest.print("optional=\"true\"");
                        }
                        digest.print("search-location=\"" + inlcudedFeatures[i].getSearchLocation() + "\" ");
                        digest.println("/> ");
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    ++i;
                }
            }
            digest.println("</feature>");
        }
    }

    private class AvailableLocale {
        private String PREFIX = "temp";
        private String locale;
        private Map features = new HashMap();
        private PrintStream localizedPrintStream;
        private File tempDigestDirectory;
        public Map availableLocales;

        public Map getAvailableLocales() {
            return this.availableLocales;
        }

        public void finishDigest(String outputDirectory) throws IOException {
            this.localizedPrintStream.println("</digest>");
            if (this.localizedPrintStream != null) {
                this.localizedPrintStream.close();
            }
            File digest = new File(String.valueOf(outputDirectory) + File.separator + "digest" + this.locale + ".zip");
            System.out.println(digest.getAbsolutePath());
            System.out.println(digest.getName());
            if (digest.exists()) {
                digest.delete();
            }
            digest.createNewFile();
            FileOutputStream os = new FileOutputStream(digest);
            JarOutputStream jos = new JarOutputStream(os);
            jos.putNextEntry(new ZipEntry("digest.xml"));
            FileInputStream is = new FileInputStream(this.tempDigestDirectory);
            byte[] b = new byte[4096];
            int bytesRead = 0;
            do {
                if ((bytesRead = ((InputStream)is).read(b)) <= 0) continue;
                jos.write(b, 0, bytesRead);
            } while (bytesRead > 0);
            jos.closeEntry();
            jos.close();
            ((OutputStream)os).close();
            ((InputStream)is).close();
            this.tempDigestDirectory.delete();
        }

        public void setAvailableLocales(Map availableLocales) {
            this.availableLocales = availableLocales;
        }

        public AvailableLocale(String locale) {
            this.locale = locale;
        }

        public Map getFeatures() {
            return this.features;
        }

        public void addFeatures(String feature) {
            this.features.put(feature, feature);
        }

        public String getLocale() {
            return this.locale;
        }

        public PrintStream getLocalizedPrintStream() {
            return this.localizedPrintStream;
        }

        public void openLocalizedOutputStream() throws IOException {
            this.tempDigestDirectory = File.createTempFile(this.PREFIX, null);
            FileOutputStream fstream = new FileOutputStream(this.tempDigestDirectory);
            this.localizedPrintStream = new PrintStream(fstream);
            this.localizedPrintStream.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n <digest>");
            this.tempDigestDirectory.deleteOnExit();
        }

        public int hashCode() {
            return this.locale.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AvailableLocale other = (AvailableLocale)obj;
            return !(this.locale == null ? other.locale != null : !this.locale.equals(other.locale));
        }

        public void writeFeatureDigests(FeatureModel featureModel, Map featureProperties) {
            if (this.locale.equals("")) {
                SiteOptimizerApplication.writeFeatureDigest(this.localizedPrintStream, featureModel, (Properties)featureProperties.get(""));
                return;
            }
            Properties temp = new Properties();
            if (this.locale.indexOf("_") < 0) {
                temp = this.combineProperties((Properties)featureProperties.get(""), (Properties)featureProperties.get(this.locale), temp);
                SiteOptimizerApplication.writeFeatureDigest(this.localizedPrintStream, featureModel, temp);
            } else {
                temp = this.combineProperties((Properties)featureProperties.get(this.locale.substring(this.locale.indexOf("_") + 1)), (Properties)featureProperties.get(this.locale), temp);
                SiteOptimizerApplication.writeFeatureDigest(this.localizedPrintStream, featureModel, temp);
            }
        }

        private Properties combineProperties(Properties properties, Properties properties2, Properties properties3) {
            return new CombinedProperties(properties3, properties2, properties);
        }
    }

    private class CombinedProperties
    extends Properties {
        private Properties properties1;
        private Properties properties2;
        private Properties properties3;
        private static final long serialVersionUID = 1L;

        public CombinedProperties(Properties properties1, Properties properties2, Properties properties3) {
            this.properties1 = properties1;
            this.properties2 = properties2;
            this.properties3 = properties3;
        }

        public String getProperty(String key) {
            String result = null;
            if (this.properties3 != null) {
                result = this.properties3.getProperty(key);
            }
            if (this.properties2 != null) {
                result = this.properties2.getProperty(key);
            }
            if (this.properties1 != null) {
                result = this.properties1.getProperty(key);
            }
            return result;
        }
    }
}

