/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.core.VersionedIdentifier;
import org.osgi.framework.BundleException;

public class BundleManifest {
    private PluginEntry pluginEntry;
    private IOException exception;

    public BundleManifest(File manifest) {
        if (manifest.exists() && !manifest.isDirectory()) {
            FileInputStream fos = null;
            try {
                try {
                    fos = new FileInputStream(manifest);
                    this.parse(fos);
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public BundleManifest(InputStream input) {
        if (input != null) {
            this.parse(input);
        }
    }

    private void parse(InputStream in) {
        try {
            String id;
            Manifest m = new Manifest(in);
            Attributes a = m.getMainAttributes();
            String symbolicName = a.getValue("Bundle-SymbolicName");
            if (symbolicName == null) {
                return;
            }
            try {
                ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)symbolicName);
                id = elements[0].getValue();
            }
            catch (BundleException be) {
                throw new IOException(be.getMessage());
            }
            String version = a.getValue("Bundle-Version");
            if (version == null) {
                return;
            }
            String hostPlugin = a.getValue("Fragment-Host");
            this.pluginEntry = new PluginEntry();
            this.pluginEntry.setVersionedIdentifier(new VersionedIdentifier(id, version));
            this.pluginEntry.isFragment(hostPlugin != null && hostPlugin.length() > 0);
        }
        catch (IOException ioe) {
            this.exception = ioe;
        }
    }

    public boolean exists() {
        return this.exception != null || this.pluginEntry != null;
    }

    public PluginEntry getPluginEntry() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.pluginEntry;
    }
}

