/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.env;

import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.MirroredTypesException;
import com.sun.mirror.type.TypeMirror;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jdt.apt.core.internal.declaration.AnnotationMirrorImpl;
import org.eclipse.jdt.apt.core.internal.declaration.EclipseMirrorType;
import org.eclipse.jdt.apt.core.internal.util.Factory;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;

public class AnnotationInvocationHandler
implements InvocationHandler {
    private static final String JAVA_LANG_CLASS = "java.lang.Class";
    private final AnnotationMirrorImpl _instance;
    private final Class _clazz;

    public AnnotationInvocationHandler(AnnotationMirrorImpl annotation, Class clazz) {
        this._instance = annotation;
        this._clazz = clazz;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        if (args == null || args.length == 0) {
            if (methodName.equals("hashCode")) {
                return new Integer(this._instance.hashCode());
            }
            if (methodName.equals("toString")) {
                return this._instance.toString();
            }
            if (methodName.equals("annotationType")) {
                return this._clazz;
            }
        } else if (args.length == 1 && methodName.equals("equals")) {
            return new Boolean(this._instance.equals(args[0]));
        }
        if (args != null && args.length != 0) {
            throw new NoSuchMethodException("method " + method.getName() + this.formatArgs(args) + " does not exists");
        }
        String c_methodName = method.getName();
        IMethodBinding methodBinding = this._instance.getMethodBinding(c_methodName);
        if (methodBinding == null) {
            throw new NoSuchMethodException("method " + method.getName() + "() does not exists");
        }
        ITypeBinding retType = methodBinding.getReturnType();
        if (retType == null) {
            return null;
        }
        String qName = retType.getTypeDeclaration().getQualifiedName();
        if (retType.isClass() && JAVA_LANG_CLASS.equals(qName)) {
            ITypeBinding[] classTypes = this._instance.getMemberValueTypeBinding(c_methodName);
            TypeMirror mirrorType = null;
            if (classTypes != null && classTypes.length > 0) {
                mirrorType = Factory.createTypeMirror(classTypes[0], this._instance.getEnvironment());
            }
            if (mirrorType == null) {
                mirrorType = Factory.createErrorClassType(classTypes[0]);
            }
            throw new MirroredTypeException(mirrorType);
        }
        if (retType.isArray()) {
            ITypeBinding leafType = retType.getElementType();
            String leafQName = leafType.getTypeDeclaration().getQualifiedName();
            if (leafType.isClass() && JAVA_LANG_CLASS.equals(leafQName)) {
                ArrayList<EclipseMirrorType> mirrorTypes;
                ITypeBinding[] classTypes = this._instance.getMemberValueTypeBinding(c_methodName);
                if (classTypes == null || classTypes.length == 0) {
                    mirrorTypes = (ArrayList<EclipseMirrorType>)Collections.emptyList();
                } else {
                    mirrorTypes = new ArrayList<EclipseMirrorType>(classTypes.length);
                    ITypeBinding[] iTypeBindingArray = classTypes;
                    int n = 0;
                    int n2 = iTypeBindingArray.length;
                    while (n < n2) {
                        ITypeBinding type = iTypeBindingArray[n];
                        EclipseMirrorType mirror = Factory.createTypeMirror(type, this._instance.getEnvironment());
                        if (mirror == null) {
                            mirrorTypes.add(Factory.createTypeMirror(type, this._instance.getEnvironment()));
                        } else {
                            mirrorTypes.add(mirror);
                        }
                        ++n;
                    }
                }
                throw new MirroredTypesException((Collection<TypeMirror>)mirrorTypes);
            }
        }
        Object sourceValue = this._instance.getValue(c_methodName);
        return this.getReflectionValueWithTypeConversion(sourceValue, method.getReturnType());
    }

    private Object getReflectionValueWithTypeConversion(Object domValue, Class expectedType) {
        Object actualValue = this._getReflectionValue(domValue, expectedType);
        return this.performNecessaryTypeConversion(expectedType, actualValue);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object _getReflectionValue(Object domValue, Class expectedType) {
        if (expectedType == null) return null;
        if (domValue == null) {
            return null;
        }
        if (domValue instanceof IVariableBinding) {
            IVariableBinding varBinding = (IVariableBinding)domValue;
            ITypeBinding declaringClass = varBinding.getDeclaringClass();
            if (declaringClass == null) return null;
            try {
                Field returnedField = expectedType.getField(varBinding.getName());
                if (returnedField == null) {
                    return null;
                }
                Object object = returnedField.get(null);
                return object;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                return null;
            }
            catch (IllegalAccessException illegalAccessException) {
                return null;
            }
        }
        if (domValue instanceof Object[]) {
            Object[] elements = (Object[])domValue;
            if (!expectedType.isArray()) {
                return null;
            }
            Class<?> componentType = expectedType.getComponentType();
            int length = elements.length;
            Object array = Array.newInstance(componentType, length);
            int i = 0;
            while (i < length) {
                Object returnObj = this.getReflectionValueWithTypeConversion(elements[i], componentType);
                if (componentType.isPrimitive()) {
                    if (componentType == Boolean.TYPE) {
                        Boolean bool = (Boolean)returnObj;
                        Array.setBoolean(array, i, bool);
                    } else if (componentType == Byte.TYPE) {
                        Byte b = (Byte)returnObj;
                        Array.setByte(array, i, b);
                    } else if (componentType == Character.TYPE) {
                        Character c = (Character)returnObj;
                        Array.setChar(array, i, c.charValue());
                    } else if (componentType == Double.TYPE) {
                        Double d = (Double)returnObj;
                        Array.setDouble(array, i, d);
                    } else if (componentType == Float.TYPE) {
                        Float f = (Float)returnObj;
                        Array.setFloat(array, i, f.floatValue());
                    } else if (componentType == Integer.TYPE) {
                        Integer integer = (Integer)returnObj;
                        Array.setInt(array, i, integer);
                    } else if (componentType == Long.TYPE) {
                        Long l = (Long)returnObj;
                        Array.setLong(array, i, l);
                    } else {
                        if (componentType != Short.TYPE) throw new IllegalStateException("unrecognized primitive type: " + componentType);
                        Short s = (Short)returnObj;
                        Array.setShort(array, i, s);
                    }
                } else {
                    Array.set(array, i, returnObj);
                }
                ++i;
            }
            return array;
        }
        if (domValue instanceof ITypeBinding) {
            throw new IllegalStateException("sourceValue is a type binding.");
        }
        if (!(domValue instanceof IAnnotationBinding)) return domValue;
        if (expectedType.isPrimitive()) return domValue;
        if (expectedType == String.class) {
            return domValue;
        }
        AnnotationMirrorImpl annoMirror = (AnnotationMirrorImpl)Factory.createAnnotationMirror((IAnnotationBinding)domValue, this._instance.getAnnotatedDeclaration(), this._instance.getEnvironment());
        AnnotationInvocationHandler handler = new AnnotationInvocationHandler(annoMirror, expectedType);
        return Proxy.newProxyInstance(expectedType.getClassLoader(), new Class[]{expectedType}, (InvocationHandler)handler);
    }

    private Object performNecessaryTypeConversion(Class expectedType, Object actualValue) {
        if (actualValue == null) {
            return Factory.getMatchingDummyValue(expectedType);
        }
        if (expectedType.isPrimitive()) {
            return Factory.performNecessaryPrimitiveTypeConversion(expectedType, actualValue, true);
        }
        if (expectedType.isAssignableFrom(actualValue.getClass())) {
            return actualValue;
        }
        if (expectedType.isArray()) {
            actualValue = this.performNecessaryTypeConversion(expectedType.getComponentType(), actualValue);
            return this.arrayify(expectedType, actualValue);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object arrayify(Class expectedType, Object actualValue) {
        assert (expectedType.isArray()) : "expected type must be an array";
        assert (!(actualValue instanceof Object[])) : "actual value cannot be of type Object[]";
        Class<?> componentType = expectedType.getComponentType();
        Object array = Array.newInstance(componentType, 1);
        if (componentType.isPrimitive()) {
            if (componentType == Boolean.TYPE) {
                Boolean bool = (Boolean)actualValue;
                Array.setBoolean(array, 0, bool);
                return array;
            } else if (componentType == Byte.TYPE) {
                Byte b = (Byte)actualValue;
                Array.setByte(array, 0, b);
                return array;
            } else if (componentType == Character.TYPE) {
                Character c = (Character)actualValue;
                Array.setChar(array, 0, c.charValue());
                return array;
            } else if (componentType == Double.TYPE) {
                Double d = (Double)actualValue;
                Array.setDouble(array, 0, d);
                return array;
            } else if (componentType == Float.TYPE) {
                Float f = (Float)actualValue;
                Array.setFloat(array, 0, f.floatValue());
                return array;
            } else if (componentType == Integer.TYPE) {
                Integer integer = (Integer)actualValue;
                Array.setInt(array, 0, integer);
                return array;
            } else if (componentType == Long.TYPE) {
                Long l = (Long)actualValue;
                Array.setLong(array, 0, l);
                return array;
            } else {
                if (componentType != Short.TYPE) throw new IllegalStateException("unrecognized primitive type: " + componentType);
                Short s = (Short)actualValue;
                Array.setShort(array, 0, s);
            }
            return array;
        } else {
            Array.set(array, 0, actualValue);
        }
        return array;
    }

    private String formatArgs(Object[] args) {
        StringBuilder builder = new StringBuilder(args.length * 8 + 2);
        builder.append('(');
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(args[i].getClass().getName());
            ++i;
        }
        builder.append(')');
        return builder.toString();
    }
}

