/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeGroupDefinition;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.w3c.dom.Element;

public class TypesHelper {
    XSDSchema xsdSchema;
    Vector list = new Vector();

    public TypesHelper(XSDSchema xsdSchema) {
        this.xsdSchema = xsdSchema;
    }

    private void updateExternalImportGlobals() {
        if (this.xsdSchema != null) {
            Iterator contents = this.xsdSchema.getContents().iterator();
            while (contents.hasNext()) {
                XSDSchemaContent content = (XSDSchemaContent)contents.next();
                if (!(content instanceof XSDImportImpl)) continue;
                XSDImportImpl anImport = (XSDImportImpl)content;
                try {
                    if (anImport.getSchemaLocation() == null) continue;
                    anImport.importSchema();
                }
                catch (Exception exception) {}
            }
        }
    }

    public List getBuiltInTypeNamesList() {
        Vector items = new Vector();
        if (this.xsdSchema != null) {
            String prefix = this.xsdSchema.getSchemaForSchemaQNamePrefix();
            prefix = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" : "";
            ArrayList<String> result = new ArrayList<String>();
            if (this.xsdSchema != null) {
                XSDSchema schemaForSchema = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
                Iterator i = schemaForSchema.getSimpleTypeIdMap().values().iterator();
                while (i.hasNext()) {
                    XSDTypeDefinition td = (XSDTypeDefinition)i.next();
                    String localName = td.getName();
                    String prefixedName = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + localName : localName;
                    result.add(prefixedName);
                }
            }
        }
        return items;
    }

    public List getBuiltInTypeNamesList2() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.xsdSchema != null) {
            List prefixes = this.getPrefixesForNamespace(this.xsdSchema.getSchemaForSchemaNamespace());
            XSDSchema schemaForSchema = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
            Iterator i = schemaForSchema.getSimpleTypeIdMap().values().iterator();
            while (i.hasNext()) {
                XSDTypeDefinition td = (XSDTypeDefinition)i.next();
                String localName = td.getName();
                String prefix = prefixes.size() > 0 ? (String)prefixes.get(0) : null;
                String prefixedName = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + localName : localName;
                result.add(prefixedName);
            }
        }
        return result;
    }

    public List getUserSimpleTypeNamesList() {
        Vector items = new Vector();
        if (this.xsdSchema != null) {
            this.updateExternalImportGlobals();
            Iterator i = this.xsdSchema.getTypeDefinitions().iterator();
            while (i.hasNext()) {
                XSDTypeDefinition typeDefinition = (XSDTypeDefinition)i.next();
                if (!(typeDefinition instanceof XSDSimpleTypeDefinition)) continue;
                items.addAll(this.getPrefixedNames(typeDefinition.getTargetNamespace(), typeDefinition.getName()));
            }
            items = (Vector)TypesHelper.sortList(items);
        }
        return items;
    }

    public List getUserComplexTypeNamesList() {
        Vector items = new Vector();
        if (this.xsdSchema != null) {
            this.updateExternalImportGlobals();
            Iterator i = this.xsdSchema.getTypeDefinitions().iterator();
            while (i.hasNext()) {
                XSDTypeDefinition typeDefinition = (XSDTypeDefinition)i.next();
                if (!(typeDefinition instanceof XSDComplexTypeDefinition)) continue;
                items.addAll(this.getPrefixedNames(typeDefinition.getTargetNamespace(), typeDefinition.getName()));
            }
            items = (Vector)TypesHelper.sortList(items);
        }
        return items;
    }

    public List getUserSimpleTypes() {
        Vector<XSDTypeDefinition> items = new Vector<XSDTypeDefinition>();
        if (this.xsdSchema != null) {
            this.updateExternalImportGlobals();
            Iterator i = this.xsdSchema.getTypeDefinitions().iterator();
            while (i.hasNext()) {
                XSDTypeDefinition typeDefinition = (XSDTypeDefinition)i.next();
                if (!(typeDefinition instanceof XSDSimpleTypeDefinition)) continue;
                items.add(typeDefinition);
            }
        }
        return items;
    }

    public String getPrefix(String ns, boolean withColon) {
        String key = "";
        if (this.xsdSchema != null) {
            Map map = this.xsdSchema.getQNamePrefixToNamespaceMap();
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                Object keyObj = iter.next();
                Object value = map.get(keyObj);
                if (value == null || !value.toString().equals(ns)) continue;
                if (keyObj != null) {
                    key = keyObj.toString();
                    break;
                }
                key = "";
                break;
            }
            if (!key.equals("") && withColon) {
                key = String.valueOf(key) + ":";
            }
        }
        return key;
    }

    public List getGlobalElements() {
        Vector items = new Vector();
        if (this.xsdSchema != null) {
            this.updateExternalImportGlobals();
            if (this.xsdSchema.getElementDeclarations() != null) {
                Iterator i = this.xsdSchema.getElementDeclarations().iterator();
                while (i.hasNext()) {
                    XSDElementDeclaration elementDeclaration = (XSDElementDeclaration)i.next();
                    String name = elementDeclaration.getQName((XSDConcreteComponent)this.xsdSchema);
                    if (name == null) continue;
                    items.add(name);
                }
            }
            items = (Vector)TypesHelper.sortList(items);
        }
        return items;
    }

    public List getGlobalAttributes() {
        Vector items = new Vector();
        if (this.xsdSchema != null) {
            this.updateExternalImportGlobals();
            if (this.xsdSchema.getAttributeDeclarations() != null) {
                Iterator i = this.xsdSchema.getAttributeDeclarations().iterator();
                while (i.hasNext()) {
                    String name;
                    XSDAttributeDeclaration attributeDeclaration = (XSDAttributeDeclaration)i.next();
                    if (attributeDeclaration.getTargetNamespace() != null && (attributeDeclaration.getTargetNamespace() == null || attributeDeclaration.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema-instance")) || (name = attributeDeclaration.getQName((XSDConcreteComponent)this.xsdSchema)) == null) continue;
                    items.add(name);
                }
            }
            items = (Vector)TypesHelper.sortList(items);
        }
        return items;
    }

    public List getGlobalAttributeGroups() {
        Vector items = new Vector();
        if (this.xsdSchema != null) {
            this.updateExternalImportGlobals();
            if (this.xsdSchema.getAttributeGroupDefinitions() != null) {
                Iterator i = this.xsdSchema.getAttributeGroupDefinitions().iterator();
                while (i.hasNext()) {
                    XSDAttributeGroupDefinition attributeGroupDefinition = (XSDAttributeGroupDefinition)i.next();
                    String name = attributeGroupDefinition.getQName((XSDConcreteComponent)this.xsdSchema);
                    if (name == null) continue;
                    items.add(name);
                }
            }
            items = (Vector)TypesHelper.sortList(items);
        }
        return items;
    }

    public List getModelGroups() {
        Vector items = new Vector();
        if (this.xsdSchema != null) {
            this.updateExternalImportGlobals();
            if (this.xsdSchema.getModelGroupDefinitions() != null) {
                Iterator i = this.xsdSchema.getModelGroupDefinitions().iterator();
                while (i.hasNext()) {
                    XSDModelGroupDefinition modelGroupDefinition = (XSDModelGroupDefinition)i.next();
                    String name = modelGroupDefinition.getQName((XSDConcreteComponent)this.xsdSchema);
                    if (name == null) continue;
                    items.add(name);
                }
            }
            items = (Vector)TypesHelper.sortList(items);
        }
        return items;
    }

    public static List sortList(List types) {
        try {
            Collections.sort(types);
        }
        catch (Exception exception) {}
        return types;
    }

    public void updateMapAfterDelete(XSDImport deletedNode) {
        String ns = deletedNode.getNamespace();
        if (ns != null) {
            String xmlnsAttr;
            String prefix = this.getPrefix(ns, false);
            if (prefix != null) {
                prefix = prefix.trim();
            }
            String string = xmlnsAttr = prefix == "" ? "xmlns" : "xmlns:" + prefix;
            if (prefix == "") {
                prefix = null;
            }
            if (this.xsdSchema != null) {
                Map map = this.xsdSchema.getQNamePrefixToNamespaceMap();
                map.remove(prefix);
                Element schemaElement = this.xsdSchema.getElement();
                schemaElement.removeAttribute(xmlnsAttr);
            }
        }
    }

    public List getPrefixedNames(String namespace, String localName) {
        ArrayList<String> list = new ArrayList<String>();
        if (namespace == null) {
            namespace = "";
        }
        if (this.xsdSchema != null && localName != null) {
            List prefixes = this.getPrefixesForNamespace(namespace);
            Iterator i = prefixes.iterator();
            while (i.hasNext()) {
                String prefix = (String)i.next();
                if (prefix == null) {
                    prefix = "";
                }
                String prefixedName = prefix.length() > 0 ? String.valueOf(prefix) + ":" + localName : localName;
                list.add(prefixedName);
            }
            if (prefixes.size() == 0) {
                list.add(localName);
            }
        }
        return list;
    }

    protected List getPrefixesForNamespace(String namespace) {
        ArrayList<String> list = new ArrayList<String>();
        Map map = this.xsdSchema.getQNamePrefixToNamespaceMap();
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            Object value = map.get(prefix);
            if (value == null || !value.toString().equals(namespace)) continue;
            list.add(prefix);
        }
        return list;
    }
}

