/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.design.editparts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.IAnnotationProvider;
import org.eclipse.wst.xsd.ui.internal.adt.design.editparts.BaseFieldEditPart;
import org.eclipse.wst.xsd.ui.internal.adt.design.figures.IFieldFigure;
import org.eclipse.wst.xsd.ui.internal.adt.facade.IField;
import org.eclipse.wst.xsd.ui.internal.adt.outline.ITreeElement;
import org.eclipse.wst.xsd.ui.internal.design.editpolicies.DragAndDropEditPolicy;
import org.eclipse.wst.xsd.ui.internal.design.editpolicies.SelectionHandlesEditPolicyImpl;

public class XSDBaseFieldEditPart
extends BaseFieldEditPart {
    protected SelectionHandlesEditPolicyImpl selectionHandlesEditPolicy = new SelectionHandlesEditPolicyImpl();

    protected void refreshVisuals() {
        IFieldFigure figure = this.getFieldFigure();
        IField field = (IField)this.getModel();
        figure.getNameLabel().setText(field.getName());
        figure.getTypeLabel().setText(field.getTypeName());
        figure.refreshVisuals(this.getModel());
        if (field.isReadOnly()) {
            figure.setForegroundColor(ColorConstants.darkGray);
        } else {
            figure.setForegroundColor(ColorConstants.black);
        }
        String occurrenceDescription = "";
        if (field instanceof IAnnotationProvider) {
            occurrenceDescription = ((IAnnotationProvider)((Object)field)).getNameAnnotationString();
        }
        figure.getNameAnnotationLabel().setText(occurrenceDescription);
        figure.recomputeLayout();
        if (this.getModel() instanceof ITreeElement) {
            figure.getNameLabel().setIcon(((ITreeElement)this.getModel()).getImage());
        }
        if (this.getRoot() != null) {
            ((GraphicalEditPart)this.getRoot()).getFigure().invalidateTree();
        }
    }

    public void addNotify() {
        super.addNotify();
        this.getFieldFigure().editPartAttached((EditPart)this);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.adtDirectEditPolicy);
        this.installEditPolicy("Selection Feedback", (EditPolicy)this.selectionHandlesEditPolicy);
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new DragAndDropEditPolicy(this.getViewer(), this.selectionHandlesEditPolicy));
    }
}

