/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.wst.validation.internal.IProjectValidationHelper;
import org.eclipse.wst.validation.internal.ResourceHandler;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorFilter;
import org.eclipse.wst.validation.internal.ValidatorNameFilter;
import org.eclipse.wst.validation.internal.delegates.ValidatorDelegatesRegistry;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchContext;
import org.eclipse.wst.validation.internal.plugin.ValidationHelperRegistryReader;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.IValidatorJob;
import org.osgi.framework.Bundle;

public class ValidatorMetaData {
    private ValidatorFilter[] _filters = null;
    private ValidatorNameFilter[] _projectNatureFilters = null;
    private String[] facetFilters = null;
    private IValidator _validator = null;
    private IWorkbenchContext _helper = null;
    private String _validatorDisplayName = null;
    private String _validatorUniqueName = null;
    private String[] _aggregatedValidators = null;
    private String[] _validatorNames = null;
    private String _pluginId = null;
    private boolean _supportsIncremental = true;
    private boolean _supportsFullBuild = true;
    private Logger _logger = null;
    private boolean _isEnabledByDefault = true;
    private MigrationMetaData _migrationMetaData = null;
    private int _ruleGroup = 1;
    private boolean _async = false;
    private boolean dependentValidator = false;
    private String[] markerIds = null;
    private String _helperClassName = null;
    private IConfigurationElement _helperClassElement = null;
    private IConfigurationElement _validatorClassElement = null;
    private boolean _cannotLoad = false;
    private boolean manualValidation = true;
    private boolean buildValidation = true;
    private Map helpers = Collections.synchronizedMap(new HashMap());
    private Expression enablementExpression = null;

    ValidatorMetaData() {
    }

    void addAggregatedValidatorNames(String[] val) {
        this._aggregatedValidators = val;
    }

    void addFilters(ValidatorFilter[] filters) {
        this._filters = filters;
    }

    void addProjectNatureFilters(ValidatorNameFilter[] filters) {
        this._projectNatureFilters = filters;
    }

    protected void addFacetFilters(String[] filters) {
        this.facetFilters = filters;
    }

    protected String[] getFacetFilters() {
        return this.facetFilters;
    }

    public List getNameFilters() {
        ArrayList<String> nameFilters = new ArrayList<String>();
        if (this._filters != null && this._filters.length > 0) {
            int i = 0;
            while (i < this._filters.length) {
                ValidatorFilter filter = this._filters[i];
                ValidatorNameFilter nameFilter = filter.get_nameFilter();
                if (nameFilter != null) {
                    nameFilters.add(nameFilter.getNameFilter());
                }
                ++i;
            }
        }
        return nameFilters;
    }

    public String[] getValidatorNames() {
        if (this._validatorNames == null) {
            int aLength = this._aggregatedValidators == null ? 0 : this._aggregatedValidators.length;
            this._validatorNames = new String[aLength + 1];
            this._validatorNames[0] = this.getValidatorUniqueName();
            if (this._aggregatedValidators != null) {
                System.arraycopy(this._aggregatedValidators, 0, this._validatorNames, 1, aLength);
            }
        }
        return this._validatorNames;
    }

    public String[] getAggregatedValidatorNames() {
        return this._aggregatedValidators;
    }

    public ValidatorFilter[] getFilters() {
        return this._filters;
    }

    public boolean isActive() {
        if (this._helperClassElement != null) {
            return false;
        }
        if (this._validatorClassElement != null) {
            return false;
        }
        Bundle bundle = Platform.getBundle((String)this._pluginId);
        if (bundle != null) {
            return bundle.getState() == 32;
        }
        return false;
    }

    public IWorkbenchContext getHelper(IProject project) throws InstantiationException {
        if (this._helper == null) {
            this._helper = ValidationRegistryReader.createHelper(this._helperClassElement, this._helperClassName);
            if (this._helper == null) {
                this._helper = new WorkbenchContext();
            }
        }
        if (this._helper.getProject() == null || !this._helper.getProject().equals((Object)project)) {
            this._helper.setProject(project);
        }
        return this._helper;
    }

    private void setCannotLoad() {
        this._cannotLoad = true;
    }

    public boolean cannotLoad() {
        return this._cannotLoad;
    }

    public Logger getMsgLogger() {
        if (this._logger == null) {
            this._logger = ValidationPlugin.getPlugin().getMsgLogger();
        }
        return this._logger;
    }

    public MigrationMetaData getMigrationMetaData() {
        return this._migrationMetaData;
    }

    public int getRuleGroup() {
        return this._ruleGroup;
    }

    ValidatorNameFilter[] getProjectNatureFilters() {
        return this._projectNatureFilters;
    }

    public IValidator getValidator() throws InstantiationException {
        if (this._validator == null) {
            this._validator = ValidationRegistryReader.createValidator(this._validatorClassElement, this.getValidatorUniqueName());
            if (this._validator == null) {
                this.setCannotLoad();
                throw new InstantiationException(ResourceHandler.getExternalizedMessage("VBF_EXC_DISABLEV", new String[]{this.getValidatorUniqueName()}));
            }
        }
        return this._validator;
    }

    public String getValidatorDisplayName() {
        return this._validatorDisplayName;
    }

    public String getValidatorUniqueName() {
        return this._validatorUniqueName;
    }

    public boolean isApplicableTo(IResource resource) {
        return this.isApplicableTo(resource, 7);
    }

    public boolean isApplicableTo(IResource resource, int resourceDelta) {
        if (this._filters == null) {
            return true;
        }
        return this.isApplicableTo(resource, resourceDelta, this._filters);
    }

    boolean isApplicableTo(IResource resource, int resourceDelta, ValidatorFilter[] filters) {
        int i = 0;
        while (i < filters.length) {
            ValidatorFilter filter = filters[i];
            if (this.checkIfValidSourceFile(resource) && filter.isApplicableType(resource) && filter.isApplicableName(resource) && filter.isApplicableAction(resourceDelta)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean checkIfValidSourceFile(IResource file) {
        if (file.getType() == 1) {
            IProjectValidationHelper helper = ValidationHelperRegistryReader.getInstance().getValidationHelper();
            IProject project = file.getProject();
            if (helper == null || project == null) {
                return true;
            }
            IContainer[] outputContainers = helper.getOutputContainers(project);
            IContainer[] sourceContainers = helper.getSourceContainers(project);
            int i = 0;
            while (i < outputContainers.length) {
                String outputPath = outputContainers[i].getProjectRelativePath().makeAbsolute().toString();
                int j = 0;
                while (j < sourceContainers.length) {
                    String sourceContainerPath = sourceContainers[j].getProjectRelativePath().makeAbsolute().toString();
                    if (outputPath.equals(sourceContainerPath)) {
                        // empty if block
                    }
                    ++j;
                }
                String filePath = file.getProjectRelativePath().makeAbsolute().toString();
                if (filePath.startsWith(outputPath)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    ValidatorNameFilter findProjectNature(String projId) {
        if (projId == null) {
            return null;
        }
        if (this._projectNatureFilters == null) {
            return null;
        }
        int i = 0;
        while (i < this._projectNatureFilters.length) {
            ValidatorNameFilter filter = this._projectNatureFilters[i];
            String projectNatureID = filter.getNameFilter();
            if (projId.equals(projectNatureID)) {
                return filter;
            }
            ++i;
        }
        return null;
    }

    public boolean isConfiguredOnProject(IProject project) {
        return ValidationRegistryReader.getReader().isConfiguredOnProject(this, project);
    }

    public boolean isEnabledByDefault() {
        return this._isEnabledByDefault;
    }

    public boolean isIncremental() {
        return this._supportsIncremental;
    }

    public boolean isFullBuild() {
        return this._supportsFullBuild;
    }

    public boolean isAsync() {
        return this._async;
    }

    void setHelperClass(IConfigurationElement element, String helperClassName) {
        this._helperClassElement = element;
        this._helperClassName = helperClassName;
    }

    void setEnabledByDefault(boolean enabledByDefault) {
        this._isEnabledByDefault = enabledByDefault;
    }

    void setIncremental(boolean isIncremental) {
        this._supportsIncremental = isIncremental;
    }

    void setFullBuild(boolean fullBuild) {
        this._supportsFullBuild = fullBuild;
    }

    void setAsync(boolean isAsync) {
        this._async = isAsync;
    }

    void setMigrationMetaData(MigrationMetaData mmd) {
        this._migrationMetaData = mmd;
    }

    void setRuleGroup(int ruleGroup) {
        this._ruleGroup = ruleGroup;
    }

    void setValidatorClass(IConfigurationElement element) {
        this._validatorClassElement = element;
    }

    void setValidatorDisplayName(String validatorName) {
        this._validatorDisplayName = validatorName;
    }

    void setValidatorUniqueName(String validatorUniqueName) {
        this._validatorUniqueName = validatorUniqueName;
    }

    void setPluginId(String validatorPluginId) {
        this._pluginId = validatorPluginId;
    }

    public String toString() {
        return this.getValidatorUniqueName();
    }

    public void addDependentValidator(boolean b) {
        this.dependentValidator = b;
    }

    public boolean isDependentValidator() {
        return this.dependentValidator;
    }

    public String[] getMarkerIds() {
        return this.markerIds;
    }

    public void setMarkerIds(String[] markerId) {
        this.markerIds = markerId;
    }

    public boolean isBuildValidation() {
        return this.buildValidation;
    }

    public void setBuildValidation(boolean buildValidation) {
        this.buildValidation = buildValidation;
    }

    public boolean isManualValidation() {
        return this.manualValidation;
    }

    public void setManualValidation(boolean manualValidation) {
        this.manualValidation = manualValidation;
    }

    public boolean isDelegating() {
        String targetID = this.getValidatorUniqueName();
        return ValidatorDelegatesRegistry.getInstance().hasDelegates(targetID);
    }

    public IValidator createValidator() throws InstantiationException {
        return ValidationRegistryReader.createValidator(this._validatorClassElement, this.getValidatorUniqueName());
    }

    public IWorkbenchContext createHelper(IProject project) throws InstantiationException {
        IWorkbenchContext helper = ValidationRegistryReader.createHelper(this._helperClassElement, this._helperClassName);
        if (helper == null) {
            helper = new WorkbenchContext();
        }
        helper.setProject(project);
        return helper;
    }

    public void addHelper(IValidatorJob validator, IWorkbenchContext helper) {
        this.helpers.put(validator, helper);
    }

    public void removeHelper(IValidatorJob validator) {
        this.helpers.remove(validator);
    }

    private IWorkbenchContext getHelper(IValidatorJob validator) {
        return (IWorkbenchContext)this.helpers.get(validator);
    }

    public IWorkbenchContext getHelper(IProject project, IValidator validator) {
        if (validator instanceof IValidatorJob) {
            return this.getHelper((IValidatorJob)validator);
        }
        try {
            IWorkbenchContext helper = this.getHelper(project);
            return helper;
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Expression getEnablementExpresion() {
        return this.enablementExpression;
    }

    public void setEnablementElement(Expression enablementElement) {
        this.enablementExpression = enablementElement;
    }

    public class MigrationMetaData {
        private Set _ids = null;

        public void addId(String oldId, String newId) {
            if (oldId == null) {
                return;
            }
            if (newId == null) {
                return;
            }
            String[] ids = new String[]{oldId, newId};
            this.getIds().add(ids);
        }

        public Set getIds() {
            if (this._ids == null) {
                this._ids = new HashSet();
            }
            return this._ids;
        }
    }
}

