/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.rubypeople.rdt.ui.text.RubySourceViewerConfiguration;

class RubySourcePreviewerUpdater {
    RubySourcePreviewerUpdater(final SourceViewer sourceViewer, final RubySourceViewerConfiguration rubySourceViewerConfiguration, final IPreferenceStore iPreferenceStore) {
        Assert.isNotNull((Object)sourceViewer);
        Assert.isNotNull((Object)((Object)rubySourceViewerConfiguration));
        Assert.isNotNull((Object)iPreferenceStore);
        final IPropertyChangeListener iPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getProperty().equals("org.rubypeople.rdt.ui.editors.textfont")) {
                    Font font = JFaceResources.getFont((String)"org.rubypeople.rdt.ui.editors.textfont");
                    sourceViewer.getTextWidget().setFont(font);
                }
            }
        };
        final IPropertyChangeListener iPropertyChangeListener2 = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (rubySourceViewerConfiguration.affectsTextPresentation(propertyChangeEvent)) {
                    rubySourceViewerConfiguration.handlePropertyChangeEvent(propertyChangeEvent);
                    sourceViewer.invalidateTextPresentation();
                }
            }
        };
        sourceViewer.getTextWidget().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                iPreferenceStore.removePropertyChangeListener(iPropertyChangeListener2);
                JFaceResources.getFontRegistry().removeListener(iPropertyChangeListener);
            }
        });
        JFaceResources.getFontRegistry().addListener(iPropertyChangeListener);
        iPreferenceStore.addPropertyChangeListener(iPropertyChangeListener2);
    }
}

