/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.adapters.jdom;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.internal.adapters.jdom.JDOMAdaptor;
import org.eclipse.jem.internal.adapters.jdom.JavaClassJDOMAdaptor;
import org.eclipse.jem.internal.java.adapters.nls.ResourceHandler;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.internal.impl.FieldImpl;

public class JavaFieldJDOMAdaptor
extends JDOMAdaptor {
    private static final String BEGIN_COMMENT = "/*";
    private static final String END_COMMENT = "*/";
    protected IField sourceField = null;
    protected IType parentType = null;

    public JavaFieldJDOMAdaptor(Notifier target, IJavaProject workingProject) {
        super(target, workingProject);
    }

    protected void clearSource() {
        this.sourceField = null;
    }

    protected boolean flushReflectedValues(boolean clearCachedModelObject) {
        if (clearCachedModelObject) {
            this.clearSource();
        }
        FieldImpl field = this.getTargetField();
        field.setInitializer(null);
        field.setFinal(false);
        field.setStatic(false);
        field.setTransient(false);
        field.setVolatile(false);
        field.setJavaVisibility(JavaVisibilityKind.PUBLIC_LITERAL);
        field.setEType(null);
        return true;
    }

    protected void postFlushReflectedValuesIfNecessary(boolean isExisting) {
        this.getTargetField().setReflected(false);
        super.postFlushReflectedValuesIfNecessary(isExisting);
    }

    protected String getFieldInitializerSource() {
        IOpenable openable = this.getSourceField().getOpenable();
        try {
            int start = -1;
            int length = 0;
            IBuffer buffer = openable.getBuffer();
            if (buffer == null) {
                return "";
            }
            ISourceRange nameRange = this.getSourceField().getNameRange();
            start = nameRange.getOffset() + nameRange.getLength();
            if (start != -1) {
                ISourceRange sourceRange = this.getSourceField().getSourceRange();
                if (sourceRange.getOffset() != -1) {
                    length = sourceRange.getOffset() + sourceRange.getLength() - start;
                }
                return buffer.getText(start, length);
            }
            return null;
        }
        catch (JavaModelException javaModelException) {
            return "";
        }
    }

    protected String getFieldInitializerSourceWithoutComments() {
        String s = this.getFieldInitializerSource();
        int start = 0;
        int startComment = -1;
        int endComment = -1;
        while (start < s.length()) {
            startComment = s.indexOf(BEGIN_COMMENT, start);
            if (startComment > 0) {
                endComment = s.indexOf(END_COMMENT, start);
                String newString = s.substring(start, startComment);
                s = String.valueOf(newString) + s.substring(endComment + END_COMMENT.length(), s.length());
                start = 0;
                startComment = -1;
                endComment = -1;
                continue;
            }
            start = s.length();
        }
        return s;
    }

    protected String getFieldInitializerString() {
        String result = null;
        try {
            if (!this.getParentType().isBinary()) {
                String source = this.getFieldInitializerSourceWithoutComments();
                if (source != null && source.length() != 0) {
                    int equalsPos = source.indexOf(61);
                    int endPos = source.indexOf(44);
                    if (endPos == -1) {
                        endPos = source.length() - 1;
                    }
                    if (equalsPos != -1) {
                        result = source.substring(equalsPos + 1, endPos);
                        result = result.trim();
                    }
                }
            } else {
                Object constantValue = this.getSourceField().getConstant();
                if (constantValue != null) {
                    result = constantValue.toString();
                    if (constantValue instanceof String) {
                        result = "\"" + result + "\"";
                    }
                }
            }
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }

    protected IType getParentType() {
        JavaClassJDOMAdaptor pa;
        Field targetField;
        JavaClass parentJavaClass;
        if (this.parentType == null && (parentJavaClass = (targetField = (Field)this.getTarget()).getJavaClass()) != null && (pa = (JavaClassJDOMAdaptor)EcoreUtil.getAdapter((List)parentJavaClass.eAdapters(), (Object)"JavaReflection")) != null) {
            this.parentType = pa.getSourceType();
        }
        return this.parentType;
    }

    public Object getReflectionSource() {
        return this.getSourceField();
    }

    public boolean hasCachedReflectionSource() {
        return this.sourceField != null;
    }

    public void setSourceField(IField field) {
        this.sourceField = field;
    }

    protected IField getSourceField() {
        IType parent;
        if (!(this.sourceField != null && this.sourceField.exists() || (parent = this.getParentType()) == null)) {
            this.sourceField = parent.getField(((Field)this.getTarget()).getName());
        }
        return this.sourceField;
    }

    public FieldImpl getTargetField() {
        return (FieldImpl)this.getTarget();
    }

    protected IType getType() {
        return this.getParentType();
    }

    protected Map getTypeResolutionCache() {
        JDOMAdaptor classAdaptor;
        JavaClass javaClass;
        FieldImpl field = this.getTargetField();
        if (field != null && (javaClass = field.getJavaClass()) != null && (classAdaptor = (JDOMAdaptor)JavaFieldJDOMAdaptor.retrieveAdaptorFrom((EObject)javaClass)) != null) {
            return classAdaptor.getTypeResolutionCache();
        }
        return null;
    }

    public Object getValueIn(EObject object, EObject attribute) {
        return super.getValueIn(object, attribute);
    }

    public boolean reflectValues() {
        super.reflectValues();
        if (this.isResourceLoaded() && this.getSourceProject() != null && this.getSourceField() != null) {
            this.setModifiers();
            this.setType();
            return true;
        }
        return false;
    }

    protected void setModifiers() {
        Field javaFieldTarget = (Field)this.getTarget();
        try {
            String initializer = this.getFieldInitializerString();
            if (initializer != null) {
                javaFieldTarget.setInitializer(this.createBlock(javaFieldTarget.getName(), initializer));
            }
            int flags = this.getSourceField().getFlags();
            javaFieldTarget.setFinal(Flags.isFinal((int)flags));
            javaFieldTarget.setStatic(Flags.isStatic((int)flags));
            javaFieldTarget.setTransient(Flags.isTransient((int)flags));
            javaFieldTarget.setVolatile(Flags.isVolatile((int)flags));
            if (Flags.isPublic((int)flags)) {
                javaFieldTarget.setJavaVisibility(JavaVisibilityKind.PUBLIC_LITERAL);
            } else if (Flags.isPrivate((int)flags)) {
                javaFieldTarget.setJavaVisibility(JavaVisibilityKind.PRIVATE_LITERAL);
            } else if (Flags.isProtected((int)flags)) {
                javaFieldTarget.setJavaVisibility(JavaVisibilityKind.PROTECTED_LITERAL);
            } else {
                javaFieldTarget.setJavaVisibility(JavaVisibilityKind.PACKAGE_LITERAL);
            }
        }
        catch (JavaModelException npe) {
            System.out.println(ResourceHandler.getString((String)"Error_Introspecting_Flags_ERROR_", (Object[])new Object[]{((XMIResource)javaFieldTarget.eResource()).getID((EObject)javaFieldTarget), npe.getMessage()}));
        }
    }

    protected void setNaming() {
        Field javaFieldTarget = (Field)this.getTarget();
        JavaClass parent = javaFieldTarget.getContainingJavaClass();
        ((XMIResource)javaFieldTarget.eResource()).setID((EObject)javaFieldTarget, String.valueOf(parent.getName()) + "_" + javaFieldTarget.getName());
    }

    protected void setType() {
        String typeName = null;
        try {
            typeName = this.typeNameFromSignature(this.getSourceField().getTypeSignature());
        }
        catch (JavaModelException javaModelException) {}
        this.setFieldType((Field)this.getTargetField(), typeName);
    }
}

