/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix.util;

import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.FieldDeclarationNotFoundException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.MethodDeclarationNotFoundException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.StatementNotFoundException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.TypeDeclarationNotFoundException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ConditionCheck;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ASTUtil {
    private static Map<String, Class<?>> primitiveTypes;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$util$ASTUtil;

    public static TypeDeclaration getTypeDeclaration(CompilationUnit compilationUnit, ClassAnnotation classAnno) throws TypeDeclarationNotFoundException {
        ConditionCheck.checkForNull(classAnno, "class annotation");
        return ASTUtil.getTypeDeclaration(compilationUnit, classAnno.getClassName());
    }

    public static TypeDeclaration getTypeDeclaration(CompilationUnit compilationUnit, String typeName) throws TypeDeclarationNotFoundException {
        String packageName;
        ConditionCheck.checkForNull(compilationUnit, "compilation unit");
        ConditionCheck.checkForNull(typeName, "class name");
        int index = typeName.lastIndexOf(46);
        String string = packageName = index > 0 ? typeName.substring(0, index) : "";
        if (!ASTUtil.matchesPackage(compilationUnit.getPackage(), packageName)) {
            throw new TypeDeclarationNotFoundException(compilationUnit, typeName, new StringBuffer().append("The package '").append(packageName).append("' doesn't match the package of the compilation unit.").toString());
        }
        TypeDeclaration type = ASTUtil.searchTypeDeclaration(compilationUnit.types(), typeName.substring(index + 1));
        if (type == null) {
            throw new TypeDeclarationNotFoundException(compilationUnit, typeName);
        }
        return type;
    }

    public static FieldDeclaration getFieldDeclaration(TypeDeclaration type, FieldAnnotation fieldAnno) throws FieldDeclarationNotFoundException {
        ConditionCheck.checkForNull(fieldAnno, "field annotation");
        return ASTUtil.getFieldDeclaration(type, fieldAnno.getFieldName());
    }

    public static FieldDeclaration getFieldDeclaration(TypeDeclaration type, String fieldName) throws FieldDeclarationNotFoundException {
        ConditionCheck.checkForNull(type, "type declaration");
        ConditionCheck.checkForNull(fieldName, "field name");
        for (FieldDeclaration field : type.getFields()) {
            List fragments = field.fragments();
            for (VariableDeclarationFragment fragment : fragments) {
                if (!fieldName.equals(fragment.getName().getIdentifier())) continue;
                return field;
            }
        }
        throw new FieldDeclarationNotFoundException(type, fieldName);
    }

    public static MethodDeclaration getMethodDeclaration(TypeDeclaration type, MethodAnnotation methodAnno) throws MethodDeclarationNotFoundException {
        ConditionCheck.checkForNull(methodAnno, "method annotation");
        return ASTUtil.getMethodDeclaration(type, methodAnno.getMethodName(), methodAnno.getMethodSignature());
    }

    public static MethodDeclaration getMethodDeclaration(TypeDeclaration type, String methodName, String methodSignature) throws MethodDeclarationNotFoundException {
        ConditionCheck.checkForNull(type, "type declaration");
        ConditionCheck.checkForNull(methodName, "method name");
        ConditionCheck.checkForNull(methodSignature, "method signature");
        MethodDeclaration method = ASTUtil.searchMethodDeclaration(type.getAST(), type.getMethods(), methodName, methodSignature);
        if (method == null) {
            throw new MethodDeclarationNotFoundException(type, methodName, methodSignature);
        }
        return method;
    }

    public static Statement getStatement(CompilationUnit compilationUnit, MethodDeclaration method, SourceLineAnnotation sourceLineAnno) throws StatementNotFoundException {
        ConditionCheck.checkForNull(sourceLineAnno, "source line annotation");
        return ASTUtil.getStatement(compilationUnit, method, sourceLineAnno.getStartLine(), sourceLineAnno.getEndLine());
    }

    public static Statement getStatement(CompilationUnit compilationUnit, MethodDeclaration method, int startLine, int endLine) throws StatementNotFoundException {
        ConditionCheck.checkForNull(compilationUnit, "compilation unit");
        ConditionCheck.checkForNull(method, "method declaration");
        Statement statement = ASTUtil.searchStatement(compilationUnit, method.getBody().statements(), startLine, endLine);
        if (statement == null) {
            throw new StatementNotFoundException(compilationUnit, startLine, endLine);
        }
        return statement;
    }

    @CheckForNull
    protected static TypeDeclaration searchTypeDeclaration(List<? extends BodyDeclaration> declarations, String typeName) {
        if (!$assertionsDisabled && declarations == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && typeName == null) {
            throw new AssertionError();
        }
        int index = typeName.indexOf(36);
        String innerClassName = null;
        if (index >= 0) {
            innerClassName = typeName.substring(index + 1);
            typeName = typeName.substring(0, index);
        }
        for (BodyDeclaration bodyDeclaration : declarations) {
            TypeDeclaration type;
            if (!(bodyDeclaration instanceof TypeDeclaration) || !typeName.equals((type = (TypeDeclaration)bodyDeclaration).getName().getFullyQualifiedName())) continue;
            if (index < 0) {
                return type;
            }
            return ASTUtil.searchTypeDeclaration(type.bodyDeclarations(), innerClassName);
        }
        return null;
    }

    @CheckForNull
    protected static MethodDeclaration searchMethodDeclaration(AST ast, MethodDeclaration[] methods, String methodName, String methodSignature) {
        if (!$assertionsDisabled && methods == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && methodName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && methodSignature == null) {
            throw new AssertionError();
        }
        String[] parameters = ASTUtil.parseParameters(methodSignature);
        for (MethodDeclaration method : methods) {
            if (!methodName.equals(method.getName().getFullyQualifiedName()) || !ASTUtil.matchesParams(method.parameters(), parameters)) continue;
            return method;
        }
        return null;
    }

    @CheckForNull
    protected static Statement searchStatement(CompilationUnit compilationUnit, List<Statement> statements, int startLine, int endLine) {
        if (!$assertionsDisabled && compilationUnit == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && statements == null) {
            throw new AssertionError();
        }
        for (Statement statement : statements) {
            int lineNumber = compilationUnit.getLineNumber(statement.getStartPosition());
            if (startLine > lineNumber || lineNumber > endLine) continue;
            return statement;
        }
        return null;
    }

    protected static String[] parseParameters(String methodSignature) {
        int rightParenthesis;
        if (!$assertionsDisabled && methodSignature == null) {
            throw new AssertionError();
        }
        int leftParenthesis = methodSignature.indexOf(40);
        if ((methodSignature = methodSignature.substring(leftParenthesis + 1, rightParenthesis = methodSignature.indexOf(41))).length() == 0) {
            return new String[0];
        }
        String[] parameters = methodSignature.split(";");
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = ASTUtil.normalizeParameter(parameters[i]);
        }
        return parameters;
    }

    protected static String normalizeParameter(String parameter) {
        if (!$assertionsDisabled && parameter == null) {
            throw new AssertionError();
        }
        Class<?> primitiveClass = primitiveTypes.get(parameter);
        if (primitiveClass != null) {
            return primitiveClass.getName();
        }
        if (parameter.startsWith("L")) {
            return parameter.substring(1).replaceAll("[/$]", ".");
        }
        if (parameter.startsWith("[")) {
            return new StringBuffer().append(ASTUtil.normalizeParameter(parameter.substring(1))).append("[]").toString();
        }
        throw new IllegalStateException(new StringBuffer().append("Unknown parameter type '").append(parameter).append("'.").toString());
    }

    private static boolean matchesPackage(PackageDeclaration apackage, String packageName) {
        return apackage != null && packageName.equals(apackage.getName().getFullyQualifiedName()) || packageName.length() == 0;
    }

    private static boolean matchesParams(List<SingleVariableDeclaration> methodParams, String[] paramTypeNames) {
        return ASTUtil.matchesParams(methodParams.toArray(new SingleVariableDeclaration[methodParams.size()]), paramTypeNames);
    }

    private static boolean matchesParams(SingleVariableDeclaration[] methodParams, String[] paramTypeNames) {
        if (methodParams.length != paramTypeNames.length) {
            return false;
        }
        for (int i = 0; i < methodParams.length; ++i) {
            String typeName = ASTUtil.getPrettyTypeName(methodParams[i].getType());
            if (typeName.equals(paramTypeNames[i])) continue;
            return false;
        }
        return true;
    }

    private static String getPrettyTypeName(Type type) {
        if (type.isArrayType()) {
            return ASTUtil.getPrettyTypeName((ArrayType)type);
        }
        if (type.isParameterizedType()) {
            return ASTUtil.getPrettyTypeName((ParameterizedType)type);
        }
        if (type.isPrimitiveType()) {
            return ASTUtil.getPrettyTypeName((PrimitiveType)type);
        }
        if (type.isQualifiedType()) {
            return ASTUtil.getPrettyTypeName((QualifiedType)type);
        }
        if (type.isSimpleType()) {
            return ASTUtil.getPrettyTypeName((SimpleType)type);
        }
        return "";
    }

    private static String getPrettyTypeName(ArrayType type) {
        return new StringBuffer().append(ASTUtil.getPrettyTypeName(type.getComponentType())).append("[]").toString();
    }

    private static String getPrettyTypeName(PrimitiveType type) {
        return type.getPrimitiveTypeCode().toString();
    }

    private static String getPrettyTypeName(ParameterizedType type) {
        String typeName = type.resolveBinding().getQualifiedName();
        return typeName.substring(0, typeName.indexOf(60));
    }

    private static String getPrettyTypeName(QualifiedType type) {
        return type.resolveBinding().getQualifiedName();
    }

    private static String getPrettyTypeName(SimpleType type) {
        return type.resolveBinding().getQualifiedName();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$util$ASTUtil == null ? (class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$util$ASTUtil = ASTUtil.class$("edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil")) : class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$util$ASTUtil).desiredAssertionStatus();
        primitiveTypes = new HashMap();
        primitiveTypes.put("B", Byte.TYPE);
        primitiveTypes.put("C", Character.TYPE);
        primitiveTypes.put("S", Short.TYPE);
        primitiveTypes.put("I", Integer.TYPE);
        primitiveTypes.put("J", Long.TYPE);
        primitiveTypes.put("F", Float.TYPE);
        primitiveTypes.put("D", Double.TYPE);
    }
}

