/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.TigerSubstitutes;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import java.util.List;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDoPrivilegedBlockResolution
extends BugResolution {
    private boolean updateImports = true;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$CreateDoPrivilegedBlockResolution;
    static /* synthetic */ Class class$java$security$AccessController;
    static /* synthetic */ Class class$java$security$PrivilegedAction;
    static /* synthetic */ Class class$java$lang$ClassLoader;

    public boolean isUpdateImports() {
        return this.updateImports;
    }

    public void setUpdateImports(boolean updateImports) {
        this.updateImports = updateImports;
    }

    @Override
    protected boolean resolveBindings() {
        return true;
    }

    @Override
    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        if (!$assertionsDisabled && rewrite == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && workingUnit == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bug == null) {
            throw new AssertionError();
        }
        TypeDeclaration type = ASTUtil.getTypeDeclaration(workingUnit, bug.getPrimaryClass());
        MethodDeclaration method = ASTUtil.getMethodDeclaration(type, bug.getPrimaryMethod());
        Statement statement = ASTUtil.getStatement(workingUnit, method, bug.getPrimarySourceLineAnnotation());
        ClassInstanceCreation classLoaderCreation = this.findClassLoaderCreation(statement);
        if (classLoaderCreation == null) {
            throw new BugResolutionException("No matching class loader creation found at the specified source line.");
        }
        MethodInvocation doPrivilegedInvocation = this.createDoPrivilegedInvocation(rewrite, classLoaderCreation);
        rewrite.replace((ASTNode)classLoaderCreation, (ASTNode)doPrivilegedInvocation, null);
        if (this.isUpdateImports()) {
            this.updateImportDeclarations(rewrite, workingUnit);
        }
    }

    protected void updateImportDeclarations(ASTRewrite rewrite, CompilationUnit compilationUnit) {
        if (!$assertionsDisabled && rewrite == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && compilationUnit == null) {
            throw new AssertionError();
        }
        ListRewrite importRewrite = rewrite.getListRewrite((ASTNode)compilationUnit, CompilationUnit.IMPORTS_PROPERTY);
        this.updateImportDeclaration(importRewrite, class$java$security$AccessController == null ? (class$java$security$AccessController = CreateDoPrivilegedBlockResolution.class$("java.security.AccessController")) : class$java$security$AccessController);
        this.updateImportDeclaration(importRewrite, class$java$security$PrivilegedAction == null ? (class$java$security$PrivilegedAction = CreateDoPrivilegedBlockResolution.class$("java.security.PrivilegedAction")) : class$java$security$PrivilegedAction);
    }

    protected void updateImportDeclaration(ListRewrite importRewrite, Class<?> importType) {
        if (!$assertionsDisabled && importRewrite == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && importType == null) {
            throw new AssertionError();
        }
        AST ast = importRewrite.getASTRewrite().getAST();
        ImportDeclaration importDeclaration = this.createImportDeclaration(ast, importType);
        List imports = importRewrite.getRewrittenList();
        int index = this.searchImportPosition(imports, importDeclaration);
        if (index >= 0 && index <= imports.size()) {
            importRewrite.insertAt((ASTNode)importDeclaration, index, null);
        }
    }

    private int searchImportPosition(List<ImportDeclaration> imports, ImportDeclaration importDeclaration) {
        String fullyQualifiedName = importDeclaration.getName().getFullyQualifiedName();
        int index = 0;
        for (ImportDeclaration impDec : imports) {
            String fqn = impDec.getName().getFullyQualifiedName();
            if (fqn.equals(fullyQualifiedName)) {
                return -1;
            }
            if (fqn.compareTo(fullyQualifiedName) >= 0) continue;
            ++index;
        }
        return index;
    }

    protected ImportDeclaration createImportDeclaration(AST ast, Class<?> importType) {
        ImportDeclaration importDeclaration = ast.newImportDeclaration();
        importDeclaration.setName(ast.newName(importType.getName()));
        return importDeclaration;
    }

    protected MethodInvocation createDoPrivilegedInvocation(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        MethodInvocation doPrivilegedInvocation = ast.newMethodInvocation();
        ClassInstanceCreation privilegedActionCreation = this.createPrivilegedActionCreation(rewrite, classLoaderCreation);
        List arguments = doPrivilegedInvocation.arguments();
        Object accessControllerName = this.isUpdateImports() ? ast.newSimpleName(TigerSubstitutes.getSimpleName((Class)(class$java$security$AccessController == null ? (class$java$security$AccessController = CreateDoPrivilegedBlockResolution.class$("java.security.AccessController")) : class$java$security$AccessController))) : ast.newName((class$java$security$AccessController == null ? (class$java$security$AccessController = CreateDoPrivilegedBlockResolution.class$("java.security.AccessController")) : class$java$security$AccessController).getName());
        doPrivilegedInvocation.setExpression((Expression)accessControllerName);
        doPrivilegedInvocation.setName(ast.newSimpleName("doPrivileged"));
        arguments.add(privilegedActionCreation);
        return doPrivilegedInvocation;
    }

    private ClassInstanceCreation createPrivilegedActionCreation(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        ClassInstanceCreation privilegedActionCreation = ast.newClassInstanceCreation();
        ParameterizedType privilegedActionType = this.createPrivilegedActionType(rewrite, classLoaderCreation);
        AnonymousClassDeclaration anonymousClassDeclaration = this.createAnonymousClassDeclaration(rewrite, classLoaderCreation);
        privilegedActionCreation.setType((Type)privilegedActionType);
        privilegedActionCreation.setAnonymousClassDeclaration(anonymousClassDeclaration);
        return privilegedActionCreation;
    }

    private ParameterizedType createPrivilegedActionType(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        Object privilegedActionName = this.isUpdateImports() ? ast.newSimpleName(TigerSubstitutes.getSimpleName((Class)(class$java$security$PrivilegedAction == null ? (class$java$security$PrivilegedAction = CreateDoPrivilegedBlockResolution.class$("java.security.PrivilegedAction")) : class$java$security$PrivilegedAction))) : ast.newName((class$java$security$PrivilegedAction == null ? (class$java$security$PrivilegedAction = CreateDoPrivilegedBlockResolution.class$("java.security.PrivilegedAction")) : class$java$security$PrivilegedAction).getName());
        SimpleType rawPrivilegedActionType = ast.newSimpleType((Name)privilegedActionName);
        ParameterizedType privilegedActionType = ast.newParameterizedType((Type)rawPrivilegedActionType);
        Type typeArgument = (Type)rewrite.createCopyTarget((ASTNode)classLoaderCreation.getType());
        List typeArguments = privilegedActionType.typeArguments();
        typeArguments.add(typeArgument);
        return privilegedActionType;
    }

    private AnonymousClassDeclaration createAnonymousClassDeclaration(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        AnonymousClassDeclaration anonymousClassDeclaration = ast.newAnonymousClassDeclaration();
        MethodDeclaration runMethodDeclaration = this.createRunMethodDeclaration(rewrite, classLoaderCreation);
        List bodyDeclarations = anonymousClassDeclaration.bodyDeclarations();
        bodyDeclarations.add(runMethodDeclaration);
        return anonymousClassDeclaration;
    }

    private MethodDeclaration createRunMethodDeclaration(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        MethodDeclaration methodDeclaration = ast.newMethodDeclaration();
        SimpleName methodName = ast.newSimpleName("run");
        Type returnType = (Type)rewrite.createCopyTarget((ASTNode)classLoaderCreation.getType());
        Block methodBody = this.createRunMethodBody(rewrite, classLoaderCreation);
        List modifiers = methodDeclaration.modifiers();
        modifiers.add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
        methodDeclaration.setName(methodName);
        methodDeclaration.setReturnType2(returnType);
        methodDeclaration.setBody(methodBody);
        return methodDeclaration;
    }

    private Block createRunMethodBody(ASTRewrite rewrite, ClassInstanceCreation classLoaderCreation) {
        AST ast = rewrite.getAST();
        Block methodBody = ast.newBlock();
        ReturnStatement returnStatement = ast.newReturnStatement();
        List statements = methodBody.statements();
        statements.add(returnStatement);
        returnStatement.setExpression((Expression)((ClassInstanceCreation)rewrite.createCopyTarget((ASTNode)classLoaderCreation)));
        return methodBody;
    }

    @CheckForNull
    protected ClassInstanceCreation findClassLoaderCreation(Statement statement) {
        if (!$assertionsDisabled && statement == null) {
            throw new AssertionError();
        }
        switch (statement.getNodeType()) {
            case 60: {
                if (this.isClassLoader(((VariableDeclarationStatement)statement).getType())) {
                    List fragments = ((VariableDeclarationStatement)statement).fragments();
                    for (VariableDeclarationFragment fragment : fragments) {
                        Expression exp = fragment.getInitializer();
                        ClassInstanceCreation creation = this.findClassLoaderCreation(exp);
                        if (creation == null) continue;
                        return creation;
                    }
                }
                return null;
            }
            case 21: {
                return this.findClassLoaderCreation(((ExpressionStatement)statement).getExpression());
            }
        }
        return null;
    }

    @CheckForNull
    private ClassInstanceCreation findClassLoaderCreation(Expression expression) {
        switch (expression.getNodeType()) {
            case 7: {
                return this.findClassLoaderCreation(((Assignment)expression).getRightHandSide());
            }
            case 14: {
                if (!this.isClassLoaderCreation((ClassInstanceCreation)expression)) break;
                return (ClassInstanceCreation)expression;
            }
        }
        return null;
    }

    private boolean isClassLoaderCreation(ClassInstanceCreation classInstanceCreation) {
        return this.isClassLoader(classInstanceCreation.getType());
    }

    private boolean isClassLoader(Type type) {
        return this.isClassLoader(type.resolveBinding());
    }

    private boolean isClassLoader(ITypeBinding typeBinding) {
        if (typeBinding.getQualifiedName().equals((class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = CreateDoPrivilegedBlockResolution.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getName())) {
            return true;
        }
        ITypeBinding superclass = typeBinding.getSuperclass();
        return superclass != null && this.isClassLoader(superclass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }

    static {
        $assertionsDisabled = !(class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$CreateDoPrivilegedBlockResolution == null ? (class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$CreateDoPrivilegedBlockResolution = CreateDoPrivilegedBlockResolution.class$("edu.umd.cs.findbugs.plugin.eclipse.quickfix.CreateDoPrivilegedBlockResolution")) : class$edu$umd$cs$findbugs$plugin$eclipse$quickfix$CreateDoPrivilegedBlockResolution).desiredAssertionStatus();
    }
}

