/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindSelfComparison
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    OpcodeStack stack = new OpcodeStack();
    int whichRegister;
    int registerLoadCount;

    public FindSelfComparison(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(JavaClass obj) {
    }

    public void visit(Method obj) {
    }

    public void visit(Code obj) {
        this.whichRegister = -1;
        this.registerLoadCount = 0;
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        super.visit(obj);
    }

    public void sawOpcode(int seen) {
        this.stack.mergeJumps((DismantleBytecode)this);
        switch (seen) {
            case 182: 
            case 185: {
                String sig;
                SignatureParser parser;
                String name;
                if (this.getClassName().toLowerCase().indexOf("test") >= 0 || this.getMethodName().toLowerCase().indexOf("test") >= 0 || this.getSuperclassName().toLowerCase().indexOf("test") >= 0 || !(name = this.getNameConstantOperand()).equals("equals") && !name.equals("compareTo") || (parser = new SignatureParser(sig = this.getSigConstantOperand())).getNumParameters() != 1 || (!name.equals("equals") || !sig.endsWith(";)Z")) && (!name.equals("compareTo") || !sig.endsWith(";)I"))) break;
                this.checkForSelfOperation(seen, "COMPARISON");
                break;
            }
            case 100: 
            case 101: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                this.checkForSelfOperation(seen, "COMPUTATION");
                break;
            }
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                break;
            }
            case 148: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: {
                this.checkForSelfOperation(seen, "COMPARISON");
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        if (this.isRegisterLoad() && seen != 132) {
            if (this.getRegisterOperand() == this.whichRegister) {
                ++this.registerLoadCount;
            } else {
                this.whichRegister = this.getRegisterOperand();
                this.registerLoadCount = 1;
            }
        } else {
            this.whichRegister = -1;
            this.registerLoadCount = 0;
        }
    }

    private void checkForSelfOperation(int opCode, String op) {
        OpcodeStack.Item item0 = this.stack.getStackItem(0);
        OpcodeStack.Item item1 = this.stack.getStackItem(1);
        if (item0.getSignature().equals("D") || item0.getSignature().equals("F")) {
            return;
        }
        if (item1.getSignature().equals("D") || item1.getSignature().equals("F")) {
            return;
        }
        XField field0 = item0.getXField();
        XField field1 = item1.getXField();
        int fr0 = item0.getFieldLoadedFromRegister();
        int fr1 = item1.getFieldLoadedFromRegister();
        if (field0 != null && field0.equals(field1) && fr0 != -1 && fr0 == fr1) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SA_FIELD_SELF_" + op, 2).addClassAndMethod((PreorderVisitor)this).addField(field0).addSourceLine((BytecodeScanningDetector)this));
        } else if (opCode == 100 && this.registerLoadCount >= 2) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "SA_LOCAL_SELF_" + op, opCode == 100 || opCode == 101 || opCode == 185 || opCode == 182 ? 2 : 1).addClassAndMethod((PreorderVisitor)this).add((BugAnnotation)LocalVariableAnnotation.getLocalVariableAnnotation((Method)this.getMethod(), (int)this.whichRegister, (int)this.getPC(), (int)(this.getPC() - 1))).addSourceLine((BytecodeScanningDetector)this));
        }
    }
}

