/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.visitclass.DismantleBytecode;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import org.apache.bcel.Repository;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;

public class FindPuzzlers
extends BytecodeScanningDetector {
    BugReporter bugReporter;
    int imul_constant;
    int imul_distance;
    boolean imul_operand_is_parameter;
    int prevOpcodeIncrementedRegister;
    int valueOfConstantArgumentToShift;
    int best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG;
    boolean constantArgumentToShift;
    int badlyComputingOddState;
    int prevOpCode;
    OpcodeStack stack = new OpcodeStack();

    public FindPuzzlers(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Code obj) {
        this.prevOpcodeIncrementedRegister = -1;
        this.best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG = 4;
        this.prevOpCode = 0;
        this.stack.resetForMethodEntry((DismantleBytecode)this);
        this.badlyComputingOddState = 0;
        this.resetIMulCastLong();
        this.imul_distance = 10000;
        super.visit(obj);
    }

    private void resetIMulCastLong() {
        this.imul_constant = 1;
        this.imul_operand_is_parameter = false;
    }

    private int adjustPriority(int factor, int priority) {
        if (factor <= 4) {
            return 5;
        }
        if (factor <= 10000) {
            return priority + 1;
        }
        if (factor <= 3600000) {
            return priority;
        }
        return priority - 1;
    }

    private int adjustMultiplier(Object constant, int mul) {
        if (!(constant instanceof Integer)) {
            return mul;
        }
        return Math.abs((Integer)constant) * mul;
    }

    public void sawOpcode(int seen) {
        int v;
        OpcodeStack.Item item;
        Object o;
        OpcodeStack.Item index;
        String clazz;
        this.stack.mergeJumps((DismantleBytecode)this);
        if (seen == 104) {
            if (this.imul_distance != 1) {
                this.resetIMulCastLong();
            }
            this.imul_distance = 0;
            if (this.stack.getStackDepth() > 1) {
                OpcodeStack.Item item0 = this.stack.getStackItem(0);
                OpcodeStack.Item item1 = this.stack.getStackItem(1);
                this.imul_constant = this.adjustMultiplier(item0.getConstant(), this.imul_constant);
                this.imul_constant = this.adjustMultiplier(item1.getConstant(), this.imul_constant);
                if (item0.isInitialParameter() || item1.isInitialParameter()) {
                    this.imul_operand_is_parameter = true;
                }
            }
        } else {
            ++this.imul_distance;
        }
        if (this.prevOpCode == 104 && seen == 133) {
            int priority = this.adjustPriority(this.imul_constant, 2);
            if (priority >= 3 && this.imul_operand_is_parameter) {
                priority = 2;
            }
            if (priority <= this.best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG) {
                this.best_priority_for_ICAST_INTEGER_MULTIPLY_CAST_TO_LONG = priority;
                this.bugReporter.reportBug(new BugInstance((Detector)this, "ICAST_INTEGER_MULTIPLY_CAST_TO_LONG", priority).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        if (this.getMethodName().equals("<clinit>") && (seen == 179 || seen == 178 || seen == 184) && !(clazz = this.getClassConstantOperand()).equals(this.getClassName())) {
            try {
                JavaClass targetClass = Repository.lookupClass((String)clazz);
                if (Repository.instanceOf((JavaClass)targetClass, (JavaClass)this.getThisClass())) {
                    int priority = 2;
                    if (seen == 178) {
                        --priority;
                    }
                    if (!targetClass.isPublic()) {
                        ++priority;
                    }
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION", priority).addClassAndMethod((PreorderVisitor)this).addClass(this.getDottedClassConstantOperand()).addSourceLine((BytecodeScanningDetector)this));
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if ((seen >= 46 && seen <= 53 || seen >= 79 && seen <= 86) && (index = this.stack.getStackItem(0)).getSpecialKind() == 6) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "IM_AVERAGE_COMPUTATION_COULD_OVERFLOW", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if (!(seen != 153 && seen != 154 || this.getPrevOpcode(1) != 104 || this.getPrevOpcode(2) != 17 && this.getPrevOpcode(2) != 16 || this.getPrevOpcode(3) != 112)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "IM_MULTIPLYING_RESULT_OF_IREM", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if (seen == 147 && this.getPrevOpcode(1) == 124 && (!this.constantArgumentToShift || this.valueOfConstantArgumentToShift % 16 != 0) || seen == 145 && this.getPrevOpcode(1) == 124 && (!this.constantArgumentToShift || this.valueOfConstantArgumentToShift % 8 != 0)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "ICAST_QUESTIONABLE_UNSIGNED_RIGHT_SHIFT", 3).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        this.constantArgumentToShift = false;
        if (seen == 124 || seen == 122 || seen == 120) {
            if (this.stack.getStackDepth() <= 1) {
                this.constantArgumentToShift = true;
                this.valueOfConstantArgumentToShift = 8;
            } else {
                Object rightHandSide = this.stack.getStackItem(0).getConstant();
                Object leftHandSide = this.stack.getStackItem(1).getConstant();
                if (rightHandSide instanceof Integer) {
                    this.constantArgumentToShift = true;
                    this.valueOfConstantArgumentToShift = (Integer)rightHandSide;
                    if (this.valueOfConstantArgumentToShift < 0 || this.valueOfConstantArgumentToShift >= 32) {
                        this.bugReporter.reportBug(new BugInstance((Detector)this, "ICAST_BAD_SHIFT_AMOUNT", this.valueOfConstantArgumentToShift < 0 ? 3 : 1).addClassAndMethod((PreorderVisitor)this).addInt(this.valueOfConstantArgumentToShift).addSourceLine((BytecodeScanningDetector)this));
                    }
                }
                if (leftHandSide != null && leftHandSide instanceof Integer && (Integer)leftHandSide > 0) {
                    this.constantArgumentToShift = true;
                    this.valueOfConstantArgumentToShift = 8;
                }
            }
        }
        if (seen == 182 && this.stack.getStackDepth() > 0 && this.getClassConstantOperand().equals("java/util/Date") && this.getNameConstantOperand().equals("setMonth") && this.getSigConstantOperand().equals("(I)V") && (o = (item = this.stack.getStackItem(0)).getConstant()) != null && o instanceof Integer && ((v = ((Integer)o).intValue()) < 0 || v > 11)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_BAD_MONTH", 2).addClassAndMethod((PreorderVisitor)this).addInt(v).addCalledMethod((DismantleBytecode)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if ((seen == 182 && this.stack.getStackDepth() > 1 && this.getClassConstantOperand().equals("java/util/Calendar") && this.getNameConstantOperand().equals("set") && this.getSigConstantOperand().equals("(III)V") || seen == 183 && this.stack.getStackDepth() > 1 && this.getClassConstantOperand().equals("java/util/GregorianCalendar") && this.getNameConstantOperand().equals("<init>") && this.getSigConstantOperand().equals("(III)V")) && (o = (item = this.stack.getStackItem(1)).getConstant()) != null && o instanceof Integer && ((v = ((Integer)o).intValue()) < 0 || v > 11)) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_BAD_MONTH", 2).addClassAndMethod((PreorderVisitor)this).addInt(v).addCalledMethod((DismantleBytecode)this).addSourceLine((BytecodeScanningDetector)this));
        }
        if (this.isRegisterStore() && (seen == 54 || seen == 59 || seen == 60 || seen == 61 || seen == 62) && this.getRegisterOperand() == this.prevOpcodeIncrementedRegister) {
            this.bugReporter.reportBug(new BugInstance((Detector)this, "DLS_OVERWRITTEN_INCREMENT", 1).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
        }
        this.prevOpcodeIncrementedRegister = seen == 132 ? this.getRegisterOperand() : -1;
        switch (this.badlyComputingOddState) {
            case 0: {
                if (seen != 5) break;
                ++this.badlyComputingOddState;
                break;
            }
            case 1: {
                if (seen == 112) {
                    ++this.badlyComputingOddState;
                    break;
                }
                this.badlyComputingOddState = 0;
                break;
            }
            case 2: {
                if (seen == 4) {
                    ++this.badlyComputingOddState;
                    break;
                }
                this.badlyComputingOddState = 0;
                break;
            }
            case 3: {
                if (seen == 159 || seen == 160) {
                    this.bugReporter.reportBug(new BugInstance((Detector)this, "IM_BAD_CHECK_FOR_ODD", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
                }
                this.badlyComputingOddState = 0;
            }
        }
        if (seen == 182 && this.stack.getStackDepth() > 0 && (this.getNameConstantOperand().equals("toString") && this.getSigConstantOperand().equals("()Ljava/lang/String;") || this.getNameConstantOperand().equals("append") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Ljava/lang/StringBuilder;") && this.getClassConstantOperand().equals("java/lang/StringBuilder") || this.getNameConstantOperand().equals("append") && this.getSigConstantOperand().equals("(Ljava/lang/Object;)Ljava/lang/StringBuffer;") && this.getClassConstantOperand().equals("java/lang/StringBuffer"))) {
            String classConstants = this.getClassConstantOperand();
            OpcodeStack.Item item2 = this.stack.getStackItem(0);
            String signature = item2.getSignature();
            if (signature != null && signature.startsWith("[")) {
                this.bugReporter.reportBug(new BugInstance((Detector)this, "DMI_INVOKING_TOSTRING_ON_ARRAY", 2).addClassAndMethod((PreorderVisitor)this).addSourceLine((BytecodeScanningDetector)this));
            }
        }
        this.stack.sawOpcode((DismantleBytecode)this, seen);
        this.prevOpCode = seen;
    }
}

