/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.SourceFinder;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;

public class SourceSearcher {
    HashSet<String> sourceFound = new HashSet();
    HashSet<String> sourceNotFound = new HashSet();
    SourceFinder sourceFinder = new SourceFinder();

    public SourceSearcher(Project project) {
        this.sourceFinder.setSourceBaseList(project.getSourceDirList());
    }

    public boolean findSource(SourceLineAnnotation srcLine) {
        if (srcLine == null) {
            return false;
        }
        String sourceFile = srcLine.getSourceFile();
        if (sourceFile != null && !sourceFile.equals("<Unknown>")) {
            String cName = srcLine.getClassName();
            if (this.sourceFound.contains(cName)) {
                return true;
            }
            if (this.sourceNotFound.contains(cName)) {
                return false;
            }
            try {
                InputStream in = this.sourceFinder.openSource(srcLine.getPackageName(), sourceFile);
                in.close();
                this.sourceFound.add(cName);
                return true;
            }
            catch (IOException e) {
                this.sourceNotFound.add(cName);
            }
        }
        return false;
    }
}

