/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;

public class LaunchBrowser {
    @CheckForNull
    private static final Method jnlpShowMethod;
    private static final Object jnlpShowObject;

    public static boolean showDocument(URL url) {
        if (jnlpShowMethod != null) {
            try {
                Object result = jnlpShowMethod.invoke(jnlpShowObject, url);
                return Boolean.TRUE.equals(result);
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return LaunchBrowser.showViaExec(url.toString());
    }

    public static boolean showDocument(String url) {
        URL wrapper = null;
        if (jnlpShowMethod != null) {
            try {
                wrapper = new URL(url);
            }
            catch (MalformedURLException mue) {
                wrapper = null;
            }
        }
        if (wrapper != null) {
            try {
                Object result = jnlpShowMethod.invoke(jnlpShowObject, url);
                System.out.println("jnlp result is " + result);
                return Boolean.TRUE.equals(result);
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return LaunchBrowser.showViaExec(url);
    }

    private static boolean showViaExec(String url) {
        return false;
    }

    static {
        Method showMethod = null;
        Object showObject = null;
        try {
            Class<?> serviceManagerClass = Class.forName("javax.jnlp.ServiceManager");
            Method lookupMethod = serviceManagerClass.getMethod("lookup", String.class);
            showObject = lookupMethod.invoke(null, "javax.jnlp.BasicService");
            showMethod = showObject.getClass().getMethod("showDocument", URL.class);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        jnlpShowMethod = showMethod;
        jnlpShowObject = showObject;
    }
}

