/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.deref;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFactory;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnconditionalValueDerefSet {
    private int numValueNumbersInMethod;
    private BitSet valueNumberSet;
    private Map<ValueNumber, Set<Location>> derefLocationSetMap;
    boolean resultsFromBackEdge = false;
    int backEdgeUpdateCount = 0;
    private int lastUpdateTimestamp;

    public UnconditionalValueDerefSet(int numValueNumbersInMethod) {
        this.numValueNumbersInMethod = numValueNumbersInMethod;
        this.valueNumberSet = new BitSet();
        this.derefLocationSetMap = new HashMap<ValueNumber, Set<Location>>();
    }

    public boolean isBottom() {
        return this.valueNumberSet.get(this.numValueNumbersInMethod);
    }

    public void setIsBottom() {
        this.clear();
        this.valueNumberSet.set(this.numValueNumbersInMethod);
    }

    public boolean isTop() {
        return this.valueNumberSet.get(this.numValueNumbersInMethod + 1);
    }

    public void setIsTop() {
        this.clear();
        this.valueNumberSet.set(this.numValueNumbersInMethod + 1);
        this.lastUpdateTimestamp = 0;
    }

    void clear() {
        this.valueNumberSet.clear();
        this.derefLocationSetMap.clear();
    }

    public void makeSameAs(UnconditionalValueDerefSet source) {
        this.valueNumberSet.clear();
        this.valueNumberSet.or(source.valueNumberSet);
        this.lastUpdateTimestamp = source.lastUpdateTimestamp;
        this.derefLocationSetMap.clear();
        for (Map.Entry<ValueNumber, Set<Location>> sourceEntry : source.derefLocationSetMap.entrySet()) {
            HashSet derefLocationSet = new HashSet();
            derefLocationSet.addAll(sourceEntry.getValue());
            this.derefLocationSetMap.put(sourceEntry.getKey(), derefLocationSet);
        }
    }

    public boolean isSameAs(UnconditionalValueDerefSet otherFact) {
        return this.valueNumberSet.equals(otherFact.valueNumberSet) && ((Object)this.derefLocationSetMap).equals(otherFact.derefLocationSetMap);
    }

    public void mergeWith(UnconditionalValueDerefSet fact, @CheckForNull ValueNumber skipMe, ValueNumberFactory valueNumberFactory) {
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            System.out.println(new StringBuffer().append("merge update of # ").append(System.identityHashCode(this)).append(" from ").append(System.identityHashCode(fact)).toString());
            System.out.println(new StringBuffer().append("update ").append(this).toString());
            System.out.println(new StringBuffer().append("with ").append(fact).toString());
        }
        boolean resultForSkippedValue = false;
        if (skipMe != null) {
            resultForSkippedValue = this.valueNumberSet.get(skipMe.getNumber());
        }
        this.valueNumberSet.and(fact.valueNumberSet);
        if (skipMe != null) {
            this.valueNumberSet.set(skipMe.getNumber(), resultForSkippedValue);
        }
        for (int i = 0; i < this.numValueNumbersInMethod; ++i) {
            ValueNumber vn = valueNumberFactory.forNumber(i);
            if (vn.equals(skipMe)) continue;
            if (this.valueNumberSet.get(i)) {
                Set<Location> derefLocationSet = this.derefLocationSetMap.get(vn);
                derefLocationSet.addAll((Collection<Location>)fact.derefLocationSetMap.get(vn));
                continue;
            }
            this.derefLocationSetMap.remove(vn);
        }
    }

    public void unionWith(UnconditionalValueDerefSet fact, ValueNumberFactory valueNumberFactory) {
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            System.out.println(new StringBuffer().append("union update of # ").append(System.identityHashCode(this)).append(" from ").append(System.identityHashCode(fact)).toString());
        }
        this.valueNumberSet.or(fact.valueNumberSet);
        for (int i = 0; i < this.numValueNumbersInMethod; ++i) {
            ValueNumber vn = valueNumberFactory.forNumber(i);
            if (fact.valueNumberSet.get(i)) {
                Set<Location> derefLocationSet = this.derefLocationSetMap.get(vn);
                if (derefLocationSet == null) {
                    derefLocationSet = new HashSet<Location>();
                    this.derefLocationSetMap.put(vn, derefLocationSet);
                }
                derefLocationSet.addAll((Collection<Location>)fact.derefLocationSetMap.get(vn));
                continue;
            }
            this.derefLocationSetMap.put(vn, new HashSet<Location>(fact.getDerefLocationSet(vn)));
        }
    }

    public void addDeref(ValueNumber vn, Location location) {
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            System.out.println(new StringBuffer().append("Adding dereference of ").append(vn).append(" to # ").append(System.identityHashCode(this)).append(" @ ").append(location).toString());
        }
        this.valueNumberSet.set(vn.getNumber());
        Set<Location> derefLocationSet = this.getDerefLocationSet(vn);
        derefLocationSet.add(location);
    }

    public void setDerefSet(ValueNumber vn, Set<Location> derefSet) {
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            System.out.println(new StringBuffer().append("Adding dereference of ").append(vn).append(" for # ").append(System.identityHashCode(this)).append(" to ").append(derefSet).toString());
        }
        this.valueNumberSet.set(vn.getNumber());
        Set<Location> derefLocationSet = this.getDerefLocationSet(vn);
        derefLocationSet.clear();
        derefLocationSet.addAll(derefSet);
    }

    public void clearDerefSet(ValueNumber value) {
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            System.out.println(new StringBuffer().append("Clearing dereference of ").append(value).append(" for # ").append(System.identityHashCode(this)).toString());
        }
        this.valueNumberSet.clear(value.getNumber());
        this.derefLocationSetMap.remove(value);
    }

    private Set<Location> getDerefLocationSet(ValueNumber vn) {
        Set<Location> derefLocationSet = this.derefLocationSetMap.get(vn);
        if (derefLocationSet == null) {
            derefLocationSet = new HashSet<Location>();
            this.derefLocationSetMap.put(vn, derefLocationSet);
        }
        return derefLocationSet;
    }

    public boolean isUnconditionallyDereferenced(ValueNumber vn) {
        return this.valueNumberSet.get(vn.getNumber());
    }

    public Set<ValueNumber> getValueNumbersThatAreUnconditionallyDereferenced() {
        HashSet<ValueNumber> result = new HashSet<ValueNumber>();
        for (Map.Entry<ValueNumber, Set<Location>> e : this.derefLocationSetMap.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            result.add(e.getKey());
        }
        return result;
    }

    public void retainOnlyTheseValueNumbers(Set<ValueNumber> valueNumbers) {
        Iterator<ValueNumber> i = this.derefLocationSetMap.keySet().iterator();
        while (i.hasNext()) {
            ValueNumber v = i.next();
            if (valueNumbers.contains(v)) continue;
            i.remove();
            this.valueNumberSet.clear(v.getNumber());
        }
    }

    public Set<Location> getUnconditionalDerefLocationSet(ValueNumber vn) {
        Set derefLocationSet = this.derefLocationSetMap.get(vn);
        if (derefLocationSet == null) {
            derefLocationSet = Collections.EMPTY_SET;
        }
        return derefLocationSet;
    }

    public String toString() {
        if (this.isTop()) {
            return "[TOP]";
        }
        if (this.isBottom()) {
            return "[BOTTOM]";
        }
        StringBuffer buf = new StringBuffer();
        buf.append('[');
        boolean firstVN = true;
        for (int i = 0; i < this.numValueNumbersInMethod; ++i) {
            if (!this.valueNumberSet.get(i)) continue;
            if (firstVN) {
                firstVN = false;
            } else {
                buf.append(',');
            }
            buf.append('{');
            buf.append(i);
            buf.append(':');
            TreeSet<Location> derefLocationSet = new TreeSet<Location>();
            derefLocationSet.addAll(this.getDerefLocationSet(i));
            boolean firstLoc = true;
            for (Location location : derefLocationSet) {
                if (firstLoc) {
                    firstLoc = false;
                } else {
                    buf.append(',');
                }
                buf.append(new StringBuffer().append("(").append(location.getBasicBlock().getId()).append(":").append(location.getHandle().getPosition()).append(")").toString());
            }
            buf.append('}');
        }
        buf.append(']');
        buf.append(" # ");
        buf.append(System.identityHashCode(this));
        return buf.toString();
    }

    private Set<Location> getDerefLocationSet(int vn) {
        for (Map.Entry<ValueNumber, Set<Location>> entry : this.derefLocationSetMap.entrySet()) {
            if (entry.getKey().getNumber() != vn) continue;
            return Collections.unmodifiableSet(entry.getValue());
        }
        return new HashSet<Location>();
    }

    public void cleanDerefSet(@CheckForNull Location location, ValueNumberFrame vnaFrame) {
        HashSet<ValueNumber> valueNumbers = new HashSet<ValueNumber>(vnaFrame.allSlots());
        valueNumbers.addAll(vnaFrame.valueNumbersForLoads());
        if (UnconditionalValueDerefAnalysis.DEBUG) {
            for (ValueNumber v : this.getValueNumbersThatAreUnconditionallyDereferenced()) {
                if (valueNumbers.contains(v)) continue;
                System.out.println(new StringBuffer().append("\nWhy is ").append(v).append(" unconditionally dereferenced in #").append(System.identityHashCode(this)).toString());
                System.out.println(new StringBuffer().append("VN: ").append(vnaFrame).toString());
                System.out.println(new StringBuffer().append("UD: ").append(this).toString());
                System.out.println(new StringBuffer().append("Location: ").append(location).toString());
                System.out.println();
            }
        }
        this.retainOnlyTheseValueNumbers(valueNumbers);
    }

    public void setLastUpdateTimestamp(int lastUpdateTimestamp) {
        this.lastUpdateTimestamp = lastUpdateTimestamp;
    }

    public int getLastUpdateTimestamp() {
        return this.lastUpdateTimestamp;
    }
}

